(setq Grafo '(
      (v1 v7 1)   (v4 v5 17)
      (v3 v4 3)   (v1 v2 20)
      (v2 v7 4)   (v1 v6 23)
      (v3 v7 4)   (v1 v6 23)
      (v3 v7 9)   (v5 v7 25)
      (v2 v3 15)  (v5 v6 28)
      (v4 v7 16)  (v6 v7 36)
      )
)

;---------------------------------------------------
(defun kruskal (UmGrafo)
  ; Inicializaoes
  (setq ConjuntoDeVertices '())
  (setq Arvore '())
  ; Ordene as arestas do grafo por custo e ponha em uma fila de prioridade
  (setq FilaDePrioridade 
        (sort UmGrafo 
              #'(lambda (aresta1 aresta2)(< (nth 2 aresta1) (nth 2 aresta2)))))
  ; Para cada vertice v adicione {v} ao conjunto de vertices.
  (dolist (umaAresta FilaDePrioridade)
    (setf ConjuntoDeVertices
          (adjoin (list (nth 0 umaAresta)) ConjuntoDeVertices :test #'equal))
    ; Adiciona um conj.unitario com o primeiro vertice de cada aresta 
    ; ao conjunto de vertices, caso ainda nao pertena.
    (setf ConjuntoDeVertices
          (adjoin (list (nth 1 umaAresta)) ConjuntoDeVertices :test #'equal))
    ; Faz o mesmo com o segundo vertice.
  ) ;fim para
  (loop 
    ; Repita enquanto ConjuntoDeVertices nao for um conjunto unitario.
    (when (equal (cdr ConjuntoDeVertices) nil) (return))
    ; Retire a proxima aresta (v,w) do conjunto de arestas
    (setq proximaAresta (pop FilaDePrioridade))
    ; Determine os conjuntos w1 e w2 aos quais v e w pertencem.
    (setq w1 nil) (setq w2 nil) 
    (dolist (umGrupo ConjuntoDeVertices) 
      ; Olhe se v e w sao elementos de cada um dos grupos de vertices.
      (when (member (nth 0 proximaAresta) umGrupo) (setf w1 umGrupo))
      (when (member (nth 1 proximaAresta) umGrupo) (setf w2 umGrupo))
    ) ; fim para
    (when (not (equal w1 w2))
      (progn
        ; Retire w1 e w2 do conjunto de conjuntos de vertices.
        (setf ConjuntoDeVertices
              (set-difference ConjuntoDeVertices (list w1 w2) :test #'equal))
        ; Inclua w1 uniao w2 ao conjunto.
        (push (union w1 w2) ConjuntoDeVertices)
        ; Adicione a aresta aa arvore.
        (push proximaAresta Arvore)
      )
    ) ; fim se
  ) ;fim enquanto
  Arvore
)








