/*
 * OsSystem.java
 *
 * Created on July 28, 2002, 8:36 PM
 */

package Install;

import java.io.*;
import IDE.Utilities.*;
import IDE.Interaction.*;
/**
 * Contains various OS specific routines to seperate the OS specific stuff from the rest of the install code
 * All the methods in this class are static.
 * @author  marc
 */
public class OsSystem
{
    /** Indicate we are running in the Windows environment */
    public static final int OS_WINDOWS=0;
    /** Indicate we are running in a UNIX like environment */
    public static final int OS_UNIX=1;
    /** Get the proposed installation directory */
    public static String getDefaultInstallDir()
    {
        if (getOsVariant()==OS_WINDOWS)
            return String.valueOf(getRootDrive())+":\\Program Files\\Jabberwocky";
        else
            return "/usr/local/Jabberwocky";
        
    }
    /** Get the proposed directory for the startup file */
    public static String getStartupDirectory()
    {
        if (getOsVariant()==OS_WINDOWS)
            return String.valueOf(getRootDrive())+":\\Program Files\\Jabberwocky";
        else
            return "/usr/local/bin";
    }
    /** Get the startup file name */
    protected static String getStartupFile()
    {
        if (getOsVariant()==OS_WINDOWS)
            return "Jabberwocky.bat";
        else
            return "Jabberwocky";
    }
    /** Get the sourcedirectory */
    public static String getSourceDirectory()
    {
        return System.getProperty("user.dir");
    }
    /** Get the cmucl command */
    public static String getCmuclCommand()
    {
        if (getOsVariant()==OS_WINDOWS)
            return "";
        else
            return "lisp";
    }
    /** Get the gcl command */
    public static String getGclCommand()
    {
    	return "gcl";
    }
    /** Get the sbcl command */
    public static String getSbclCommand()
    {
        if (getOsVariant()==OS_WINDOWS)
            return "";
        else
            return "sbcl";
    }
    /** Get the clisp command */
    public static String getClispCommand()
    {
        if (getOsVariant()==OS_WINDOWS)
        {
			return getClispCommandWindows();
        }
        else
        {
            return "clisp";
        }
    }
    /** 
     * Create the command to start CLISP
     *
     * "C:\CLISP\clisp-2.30\lisp.exe" -B "C:/CLISP/clisp-2.30/" -M "C:\CLISP\clisp-2.30\lispinit.mem" %1 %2 %3
%4 %5 %6 %7 %8 %9
     */
    public static String retrieveClispCommand(File lispexe)
    {
        if (lispexe==null)
            return null;
        String dirstr=Util.getCanonicalFileName(lispexe.getParentFile());
        return "\""+dirstr+File.separator+"lisp.exe\" -B \""+dirstr.replace('\\','/')+"/\" -M \""+dirstr+File.separator+"lispinit.mem";
    }
    /* Load install.lisp in acl */
    public static void compileAcl(String command)
    {
    	if (getOsVariant()==OS_WINDOWS)
    		Install.startCommand(command,new String[]
    		{"-L","install.lisp"},true);
    	else
			Install.startCommand(command,new String[]
			{"+s","install.lisp"},true);
    }
    /** Get the acl command, to start acl in console mode */
    public static String getAclCommand()
    {
        if (getOsVariant()==OS_WINDOWS)
            return getACLCommandWindows();
        else 
            return "mlisp";
    }
	/** Get the command to start acl in windows mode */
	public static String getAclMlispCommand()
	{
		if (getOsVariant()!=OS_WINDOWS)
			return "";
		String output=getRegistryValue("HKEY_CLASSES_ROOT\\ACL.ImageFile\\Shell\\open\\command",null);
		String args[]=InteractionCommands.parseCommandString(output);
		if (args.length==0)
			return "";
		return new File(args[0]).getParent()+File.separator+"mlisp.exe";
	}

    /** Get the ant command */
    public static String getAntCommand()
    {
        if (getOsVariant()==OS_WINDOWS)
            //return new File(new File(System.getProperty("user.home")).getParentFile().getAbsolutePath(),
            //"All Users\\Desktop\\Ant.bat").getAbsolutePath();
        	return "ant.bat";
        else
            return "ant";
    }    
    /** Get the root drive (only usefull in Windows */
    private static char getRootDrive()
    {
        String rootdir=execCommand("cmd /c echo %SystemRoot%");
        if (rootdir.length()==0)
            return 'C';
        else
            return rootdir.charAt(0);
    }
    /** Register Jabberwocky at the OS */
    public static void registerJabberwocky()
    {
        if (getOsVariant()==OS_UNIX)
            registerJabberwockyUnix();
        else
            registerJabberwockyWindows();
    }
    /** Register Jabberwocky in the Unix KDE environment */
    private static void registerJabberwockyUnix()
    {
        setRights(new File(Install.getInstallbinDir(),getStartupFile()));
    }
    /** Register Jabberwocky in the Windows environment */
    private static void registerJabberwockyWindows()
    {
        if (System.getProperty("os.name").indexOf("95") == -1 &&
            System.getProperty("os.name").indexOf("98") == -1 &&
            System.getProperty("os.name").indexOf("Me") == -1)
        {
            registerJabberwockyWindowsNT();
        }
        else
        {
            registerJabberwockyWindows9x();
        }
   	}
    
    private static void registerJabberwockyWindowsNT()
    {
        BufferedWriter writer;
        // Batch command to register Jabberwocky
        File register=new File(getSourceDirectory()+File.separator+"register.bat");
        // Batch command to uninstall Jabberwocky
        File uninstall=new File(Install.getInstallDir()+File.separator+"uninstall.bat");
        // Get the Start Menu directoru
        String menudir=new File(new File(System.getProperty("user.home")).getParentFile().getAbsolutePath(),
                "All Users\\Start Menu\\Programs\\Jabberwocky").getAbsolutePath();
        try
        {
            // Create the batch command to register Jabberwocky
            if (register.exists())
                register.delete();
            writer=new BufferedWriter(new FileWriter(register));
            writer.write("REM Generated code to register Jabberwocky in Windows\r\n");
            writer.write("REM Adding menu entry\r\n");
            writer.write("mkdir \""+menudir+"\"\r\n");
            writer.write("copy \""+Install.getInstallbinDir()+File.separator+"jabberwocky.bat\" \""+menudir+"\"\r\n");
            writer.write("REM Adding undo information\r\n");
            writer.write("REG ADD HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\Jabberwocky\r\n");
            writer.write("REG ADD HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\Jabberwocky /f /v DisplayName /t REG_SZ /d \"Jabberwocky Uninstall\"\r\n");
            writer.write("REG ADD HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\Jabberwocky /f /v UninstallString /t REG_SZ /d \""+uninstall.getAbsolutePath()+"\"\r\n");
            writer.write("exit");
            writer.close();
            // Create the batch command to uninstall Jabberwocky
            if (uninstall.exists())
                uninstall.delete();
            writer=new BufferedWriter(new FileWriter(uninstall));
            writer.write("REM Generated code to uninstall Jabberwocky in Windows\r\n");
            writer.write("REM Removing registry entries\r\n");
            writer.write("REG DELETE HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\Jabberwocky /va /f\r\n");
            writer.write("REG DELETE HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\Jabberwocky /f\r\n");
            writer.write("REM Remove the menu entries\r\n");
            writer.write("RMDIR /S /Q \""+menudir+"\"\r\n");
            writer.write("REM Delete the Jabberwocky bin directory\r\n");
            writer.write("RMDIR /S /Q \""+Install.getInstallbinDir()+"\"\r\n");            
            writer.write("REM Delete the Jabberwocky installation dir\r\n");
            writer.write("RMDIR /S /Q \""+Install.getInstallDir()+"\"\r\n");
            writer.write("exit");
            writer.close();
            // Excute the register batch program
            Install.startCommand(register.getAbsolutePath(),new String[0],true);
        }
        catch (Exception e)
        {
        }
    }
    
    private static void registerJabberwockyWindows9x()
    {
        BufferedWriter writer;
        // Batch command to register Jabberwocky
        File register=new File(getSourceDirectory()+File.separator+"register.bat");
        // File containing registry info
        File registerInfo=new File(getSourceDirectory()+File.separator+"registerInfo.txt");
        File unregisterInfo=new File(getSourceDirectory()+File.separator+"unregisterInfo.txt");
        // Batch command to uninstall Jabberwocky
        File uninstall=new File(Install.getInstallDir()+File.separator+"uninstall.bat");
        // Get the Start Menu directoru
        String menudir=new File(new File(System.getProperty("user.home")).getParentFile().getAbsolutePath(),
                "\\Windows\\Start Menu\\Programs\\Jabberwocky").getAbsolutePath();        
        try
        {
            // Create the file with the registry info, to be imported into the registry
            // XXXXX Is there a simpler method under Windows 9x?
            
            writer=new BufferedWriter(new FileWriter(registerInfo));
            writer.write("REGEDIT4\r\n");
            writer.write("\r\n");
            writer.write("[HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\Jabberwocky]\r\n");
            writer.write("\"UninstallString\"=\""+new String(uninstall.getAbsolutePath().replaceAll("\\\\","\\\\\\\\"))+"\"\r\n");
			writer.write("\"DisplayName\"=\"Jabberwocky Uninstall\"\r\n");
			writer.flush();
			writer.close();
			
            // Create the file to delete the registry key, to be imported into the registry
            writer=new BufferedWriter(new FileWriter(unregisterInfo));
            writer.write("REGEDIT4\r\n");
            writer.write("\r\n");
            writer.write("[-HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\Jabberwocky]\r\n");
            writer.flush();
            writer.close();
            
            // Create the batch command to register Jabberwocky
            if (register.exists())
                register.delete();
            writer=new BufferedWriter(new FileWriter(register));
            writer.write("REM Generated code to register Jabberwocky in Windows\r\n");
            writer.write("REM Adding menu entry\r\n");
            writer.write("mkdir \""+menudir+"\"\r\n");
            writer.write("copy \""+Install.getInstallbinDir()+File.separator+"jabberwocky.bat\" \""+menudir+"\"\r\n");
            writer.write("REM Adding undo information\r\n");
            writer.write("regedit /s registerInfo.txt\r\n");
            writer.write("REM copying unregister information to installation directory\r\n");
            writer.write("copy unregisterInfo.txt \""+Install.getInstallDir()+"\"\r\n");
            writer.write("exit");
            writer.close();
            // Create the batch command to uninstall Jabberwocky
            if (uninstall.exists())
                uninstall.delete();
            writer=new BufferedWriter(new FileWriter(uninstall));
            writer.write("REM Generated code to uninstall Jabberwocky in Windows\r\n");
            writer.write("REM Remove the menu entries\r\n");
            writer.write("deltree /Y \""+menudir+"\"\r\n");
            writer.write("REM Removing registry entries\r\n");
            writer.write("regedit /s \""+Install.getInstallDir()+"\\unregisterInfo.txt\"\r\n");
            writer.write("REM Delete the Jabberwocky bin directory\r\n");
            writer.write("deltree /Y \""+Install.getInstallbinDir()+"\"\r\n");
            writer.write("REM Delete the Jabberwocky installation dir\r\n");
            writer.write("deltree /Y \""+Install.getInstallDir()+"\"\r\n");
            writer.write("exit");
            writer.close();
            // Excute the register batch program
            Install.startCommand(register.getAbsolutePath(),new String[0],true);
        }
        catch (Exception e)
        {
        }
    }    
    /** Execute a command and return everything send to standard output as a string
     * (with the exception of last white spaces)  */
    private static String execCommand(String cmd)
    {
        try
        {
            StringBuffer buffer=new StringBuffer();
            InputStream strm=Runtime.getRuntime().exec(cmd).getInputStream();
            int c;
            while ((c=strm.read())!=-1)
                buffer.append((char) c);
            for (int i=buffer.length()-1;i>=0 && buffer.charAt(i)=='\n' || buffer.charAt(i)=='\r' || buffer.charAt(i)==' ';i--)
                buffer.deleteCharAt(i);
            return buffer.toString();
        }
        catch (Exception e)
        {
            return "";
        }
    }
    /** Replace the \ by to \\ to do correct escaping for this stupid windows fileseparator */
    private static String escapeString(String str)
    {
        StringBuffer buffer=new StringBuffer();
        for (int i=0;i<str.length();i++)
        {
            if (str.charAt(i)=='\\')
                buffer.append('\\');
            buffer.append(str.charAt(i));
        };
        return buffer.toString();
    }
    /** Change the permission on a file */
    private static boolean setRights(File file)
    {
        // Change the rights
        if (getOsVariant()==OS_UNIX)
        {
            try
            {
                Runtime runtime=Runtime.getRuntime();
                Process process=runtime.exec("chmod a+rx "+file.getAbsolutePath());
                process.waitFor();
                if (process.exitValue()!=0)
                    return false;
                else
                    return true;
            }
            catch (Exception e)
            {
                return false;
            }
        }
        else
        {
            return true;
        }
    }
	/** Look in the registry for the command to start ACL */
	private static String getACLCommandWindows()
	{
		String output=getRegistryValue("HKEY_CLASSES_ROOT\\ACL.ImageFile\\Shell\\open\\command",null);
		String args[]=InteractionCommands.parseCommandString(output);
		if (args.length==0)
			return "";
		return new File(args[0]).getParent()+File.separator+"build.exe -I mlisp8.dxl";
	}
    /** Look in the registry for the command to start CLISP */
    private static String getClispCommandWindows()
    {
		String output=getRegistryValue("HKEY_CLASSES_ROOT\\fasfile\\Shell\\Load_into_CLISP\\command",null);
    	// Skip last 2 arguments
    	String args[]=InteractionCommands.parseCommandString(output);
 		if (args.length<1)
 			return "";
 		return retrieveClispCommand(new File(args[0].replaceAll("\"","")));
    }
    /** Retrieve the value of a Registry value */
    private static String getRegistryValue(String key,String value)
    {
    	String output;
    	if (value==null)
    		output=Install.startCommand("reg",new String[]{"query",key,"/ve"},false);
    	else
    		output=Install.startCommand("reg",new String[]{"query",key,"/v",value},false);
    	if (output==null)
    		return ""; // Command reg not found
    	int i=output.lastIndexOf(key);
    	if (i<0)
    		return ""; // Nothing found
    	i=i+key.length();
    	// Skipp all the white spaces
    	for(;i<output.length()&& isWhite(output.charAt(i));i++);
    	// Skipp the next word
		for(;i<output.length()&& !isWhite(output.charAt(i));i++);
    	// Skipp the white spaces
		for(;i<output.length()&& isWhite(output.charAt(i));i++);
		// Skipp the next word
		for(;i<output.length()&& !isWhite(output.charAt(i));i++);
		// Skipp the white spaces
		for(;i<output.length()&& isWhite(output.charAt(i));i++);
		// Skipp the next word
		for(;i<output.length()&& !isWhite(output.charAt(i));i++);
		// Skipp the white spaces
		for(;i<output.length()&& isWhite(output.charAt(i));i++);
		// Found the key value
		return output.substring(i);		
    }
    private static boolean isWhite(char c)
    {
    	return c==' ' || c=='\n' || c=='\t' || c=='\r' || c=='\n';
    }
    /** Get the users home directory */
    public static String getHomeDir()
    {
        return System.getProperty("user.home");
    }
    /** Get the OS variant */
    public static int getOsVariant()
    {
        if (System.getProperty("os.name").startsWith("Windows"))
            return OS_WINDOWS;
        else
            return OS_UNIX;
    }
    /** Correct the back slashes for a file name */
    /*
    private static String correctBackslashes(String filename)
    {
        StringBuffer buffer=new StringBuffer();
        for (int i=0;i<filename.length();i++)
            if (filename.charAt(i)=='\\')
                buffer.append("\\\\");
            else
                buffer.append(filename.charAt(i));
        return buffer.toString();
    }
    */
    /** Correct a pathname for the windows system */
    public static String correctPathName(String pathname)
    {
        if (getOsVariant()==OS_WINDOWS)
            return Util.normalize(pathname);
        else
            return pathname;
    }
    /** Inidicate if setXORMode works correctly or not (for me this is a bug in the java implementation for windows) */
    public static boolean setXORModeHasBug()
    {
        return getOsVariant()==OS_WINDOWS && System.getProperty("java.version").compareTo("1.4.1")<0;
    }
    /** Check if we can do process managment, really impossible in WINDOWS */
    public static boolean processManagmentIsPossible()
    {
        return getOsVariant()==OS_UNIX;
    }
    /** Test the code */
    public static void main(String[] args)
    {
		System.out.println(getRegistryValue("HKEY_CLASSES_ROOT\\fasfile\\Shell\\Load_into_CLISP\\command",null));
		System.out.println(getClispCommandWindows());
		System.out.println(getACLCommandWindows());
    }
}
