(defun test-mapc ()
  (mapc #'(lambda (x) (list x)) (list 1 2 3 4))
  (mapc #'(lambda (x y) (list (list x y))) '(1 2 3) '(a b c)))

(defun test-mapcar ()
  (mapcar #'(lambda (x) (list x)) (list 1 2 3 4))
  (mapcar #'(lambda (x y) (list (list x y))) '(1 2 3) '(a b c)))

(defun test-mapcan ()
  (mapcan #'(lambda (x) (list x)) (list 1 2 3 4))
  (mapcan #'(lambda (x y) (list (list x y))) '(1 2 3) '(a b c)))

(defun test-mapl ()
  (mapl #'(lambda (x) (list x)) (list 1 2 3 4))
  (mapl #'(lambda (x y) (list (list x y))) '(1 2 3) '(a b c)))

(defun test-maplist ()
  (maplist #'(lambda (x) (list x)) (list 1 2 3 4))
  (maplist #'(lambda (x y) (list (list x y))) '(1 2 3) '(a b c)))

(defun test-mapcon ()
  (mapcon #'(lambda (x) (list x)) (list 1 2 3 4))
  (mapcon #'(lambda (x y) (list (list x y))) '(1 2 3) '(a b c)))

(defun test-map ()
  (map 'list #'(lambda (x) (list x)) (list 1 2 3 4))
  (map 'list #'(lambda (x y) (list (list x y))) '(1 2 3) '(a b c)))

(defun test-map-into ()
  (let ((a '(1 2 3)))
    (map-into a #'(lambda (x) (list x x)) (list 'a 'b 'c))))

(defun test-maphash ()
  (let ((ht (make-hash-table)))
    (setf (gethash 'a ht) 10)
    (setf (gethash 'b ht) 100)
    (maphash #'(lambda (x y) (princ (list x y))) ht)))


(defun test()
  (test-mapc)
  (test-mapcar)
  (test-mapcan)
  (test-mapl)
  (test-maplist)
  (test-mapcon)
  (test-map)
  (test-map-into)
  (test-maphash))





