;; *****************************************************************************
;; *****************************************************************************
;; Define the package so that there are no problems for the compilation
;; *****************************************************************************

(make-package "DEBUGGER")
(make-package "JABBERWOCKY")

;; *****************************************************************************
;; Compile java.lisp
;;         debugger.lisp
;;         jabberwocky.lisp
;;         cmu.lisp (for cmucl)
;;         clisp.lisp (for clisp)
;; ****************************************************************************

;;(compile-file "java.lisp")
(compile-file "debugger.lisp")
;;(compile-file "jabberwocky.lisp")
(quit)

(BLOCK #:G9139
  (LET ((#:G9140 NIL))
    (DECLARE (IGNORABLE #:G9140))
    (TAGBODY
      (HANDLER-BIND
       ((ERROR
         #'(LAMBDA (CONDITIONS::TEMP)
             (DECLARE (IGNORE CONDITIONS::TEMP))
             (GO #:G9141))))
       (RETURN-FROM #:G9139 (MULTIPLE-VALUE-PROG1 A (KERNEL:FLOAT-WAIT))))
     #:G9141
      (RETURN-FROM #:G9139 10))))

(block a)

(block exit (handler-bind ((unbound-variable #'(lambda (condition)
                                                       (setf count (1+ count))
                                                       (when (> count 2) (return-from exit)))))
                          (progn (princ b) (princ c))))

(defun test ()
(defmacro var (n) `(block exit (handler-bind ((unbound-variable #'(lambda (c) (return-from exit NIL)))) ,n))))

(defun add-debug-point (exp variables position source)
  (let ((b-e (gethash exp position)))
    (cond ((and b-e (listp exp) (not (null exp))) ;; Breakpoint must have source info and must be a functioncall
           (set-possible-breakpoint source (first b-e) (1+ (rest b-e)))
           (list 'progn
                 (list 'debug-point
                       source ;;(list 'quote source)               ;; Source id
                       (first b-e)     ;; begin-pos in source , number if defined else nil
                       (if b-e (1+ (rest  b-e)) nil)     ;; end-pos in source , number if defined else nil
                       (list 'list)) 
                 ;;    (list 'ds (add-code exp variables position source))))
                 (ds (add-code exp variables position source)))) 
          (t exp))))


(defmacro  get-binding (&rest var-lst)
  (let ((binding nil))
    (mapc #'(lambda (var) (handler-case var )))))
(defmacro test (var) 
  (handler-case var (error () 10)))


(defmacro get-lexical-binding (vars &environment env)
  (let ((environment (gensym))
        (result (cons 'list
                      (mapcar #'(lambda (var)
                                        (list (list 'quote var)))
                              vars))))
    `(let ((,environment (C::LEXENV-VARIABLES ,env)))
       )))

(defmacro hook (&environment env)
  (if env
      (cons 'list (mapcar #'(lambda (s-v)
                        (list (list 'quote (first s-v)) (first s-v)))
                    (C::LEXENV-VARIABLES env)))
      NIL))

(let ((hook 10))
  (macrolet ((hook (&environment env)
                   (if env
                       (cons 'list (mapcar #'(lambda (s-v)
                                                     (list 'list (list 'quote (first s-v)) (first s-v)))
                                           (C::LEXENV-VARIABLES env)))
                     NIL)))
            (hook)))

(defun get-lexical-binding ()
  '(macrolet ((hook (&environment env)
                    (if env
                        (cons 'list (mapcar #'(lambda (s-v)
                                                      (list 'cons (list 'quote 
                                                                        (first s-v)) 
                                                            (first s-v)))
                                            (C::LEXENV-VARIABLES env)))
                      NIL)))
            (hook)))

(defun get-lexical-binding ()
  `(clisp-env (EXT::THE-ENVIRONMENT)))

(defun clisp-env (env)
  (let ((result nil))
    (do ((i 0 (1+ i))
         (l (length env)))
      ((or (>= i l) (null (aref env i))) result)
      (cond ((typep (aref env i) 'SIMPLE-VECTOR)
             (setf result (append result (clisp-env (aref env i)))))
            ((aref env i)
             (push (cons (aref env i) (aref env (1+ i)))
                   result)
             (setf i (1+ i)))))))


(defun test (n)
  #')





