;;; ****************************************************************************
;;; Is a seed file containing LISP code that automatically gets added to the
;;; automatically generated LISP code that allow you from LISP calls all the
;;; IDE actions and QUESTIONS
;;; ****************************************************************************

;;; ****************************************************************************
;;; All symbols reside in the JABBERWOCKY package
;;; ****************************************************************************

(when (not (find-package "JABBERWOCKY")) (make-package "JABBERWOCKY"))
(in-package "JABBERWOCKY")

;;; ****************************************************************************
;;; Return the current editor (if no argument) or the editor containing the
;;; content of the file with filename filename
;;; ****************************************************************************

(defun get-editor (&optional (filename ""))
  (declare (string filename))
  (if (not (string= filename ""))
      (DEBUGGER::call-java-method DEBUGGER::**connection**
                                  "IDE.LispScripting.LispIDEMethods"
                                  "getEditorByName"
                                  filename)
    (DEBUGGER::call-java-method DEBUGGER::**connection**
                                "IDE.LispScripting.LispIDEMethods"
                                "getCurrentEditor")))

;;; ***************************************************************************
;;; Set the cursor position in the given editor to position
;;; ***************************************************************************

(defun set-cursor (editor position)
  (DEBUGGER::call-java-method-swing DEBUGGER::**connection**
                                    "IDE.LispScripting.LispIDEMethods"
                                    "setCursor"
                                    editor
                                    position))

;;; ***************************************************************************
;;; Get the cursor position in the given editor
;;; ***************************************************************************

(defun get-cursor-offset (editor)
  (DEBUGGER::call-java-method DEBUGGER::**connection**
                              "IDE.LispScripting.LispIDEMethods"
                              "getCursorOffset"
                              editor))

;;; ***************************************************************************
;;; Call a AbstractManagedAction from the IDE with the given name
;;; ***************************************************************************

(defun execute-action (actionname)
  (declare (string actionname))
  (DEBUGGER::call-java-method DEBUGGER::**connection**
                              "IDE.LispScripting.LispIDEMethods"
                              "executeAction"
                              actionname))

;;; ****************************************************************************
;;; Ask a string question via the interaction field
;;; ****************************************************************************

(defun ask-string-question (guidetext callback)
  (declare (string guidetext))
  (DEBUGGER::call-java-method-swing DEBUGGER::**connection**
                                    "IDE.LispScripting.LispIDEMethods"
                                    "askStringQuestion"
                                    guidetext
                                    callback))

;;; ****************************************************************************
;;; Ask a numeric question via the interaction field
;;; ****************************************************************************

(defun ask-number-question (guidetext callback)
  (declare (string guidetext))
  (DEBUGGER::call-java-method-swing DEBUGGER::**connection**
                                    "IDE.LispScripting.LispIDEMethods"
                                    "askNumberQuestion"
                                    guidetext
                                    callback))


;;; ****************************************************************************
;;; For a given editor, get the text from poisition pos with length length
;;; ****************************************************************************

(defun get-text (editor position length)
  (declare (fixnum position length))
  (DEBUGGER::call-java-method DEBUGGER::**connection**
                              "IDE.LispScripting.LispIDEMethods"
                              "getText"
                              editor
                              position
                              length))


;;; ****************************************************************************
;;; Create a action with name,shortdescription.longdescription and lisp callback
;;; function (a function with no arguments)
;;; ****************************************************************************

(defun create-action (name short long function &optional (icon nil))
  (declare (string short long) (function function))
  (if icon
      (DEBUGGER::call-java-method-swing DEBUGGER::**connection**
                                        "IDE.LispScripting.LispIDEMethods"
                                        "createAction"
                                        name
                                        short
                                        long
                                        icon
                                        function)
    (DEBUGGER::call-java-method-swing DEBUGGER::**connection**
                                      "IDE.LispScripting.LispIDEMethods"
                                      "createAction"
                                      name
                                      short
                                      long
                                      function)))

;;; ****************************************************************************
;;; Create a copy of a mode give it name name and returns it
;;; ****************************************************************************

(defun copy-mode (mode name)
  (declare (string mode name))
  (DEBUGGER::call-java-method DEBUGGER::**connection**
                              "IDE.LispScripting.LispIDEMethods"
                              "copyMode"
                              mode
                              name))

;;; ****************************************************************************
;;; Add a action (identified by its name) to a menu for a certain mode
;;; ****************************************************************************

(defun add-action-to-menu (mode action menu)
  (declare (string mode menu action))
  (DEBUGGER::call-java-method-swing DEBUGGER::**connection**
                                    "IDE.LispScripting.LispIDEMethods"
                                    "addActionToMenu"
                                    mode
                                    action
                                    menu))

;;; ****************************************************************************
;;; Add a separator to a menu for a certain mode
;;; ****************************************************************************

(defun add-separator-to-menu (mode menu)
  (declare (string mode menu))
  (DEBUGGER::call-java-method-swing DEBUGGER::**connection**
                                    "IDE.LispScripting.LispIDEMethods"
                                    "addSeparatorToMenu"
                                    mode
                                    menu))

;;; ****************************************************************************
;;; Add a checkbox to a menu for a certain action for a given mode
;;; ****************************************************************************

(defun add-checkbox-to-menu (mode action menu enabled)
  (declare (string mode action menu) (boolean enabled))
  (DEBUGGER::call-java-method-swing DEBUGGER::**connection**
                                    "IDE.LispScripting.LispIDEMethods"
                                    "addCheckBoxToMenu"
                                    mode
                                    action
                                    menu
                                    enabled))

;;; ***************************************************************************
;;; Add a separator to a popupmenu for a given mode
;;; ***************************************************************************


(defun add-separator-to-popup-menu (mode menu)
  (declare (string mode menu))
  (DEBUGGER::call-java-method-swing DEBUGGER::**connection**
                                    "IDE.LispScripting.LispIDEMethods"
                                    "addSeparatorToPopupMenu"
                                    mode
                                    menu))
;;; ***************************************************************************
;;; Add a action to a popupmenu for a given mode
;;; ***************************************************************************


(defun add-action-to-popup-menu (mode menu action)
  (declare (string mode menu action))
  (DEBUGGER::call-java-method-swing DEBUGGER::**connection**
                                    "IDE.LispScripting.LispIDEMethods"
                                    "addActionToPopupMenu"
                                    mode
                                    action
                                    menu))

;;; *************************************************************************
;;; Creates a key sequence based on a list of the form
;;; keycode modifiers keycode modifiers ....
;;; *************************************************************************

(defun create-key-sequence (&rest keys)
  (cond ((not (listp keys)) (DEBUGGER::message
                             "Wrong arguments for create-key-sequence"
                             :warn
                             T)
                            nil)
        ((not (evenp (length keys)))
         (DEBUGGER::message
          "Argument list is no of the form keycode modifiers ..."
          :warn
          T)
         nil)
        (T (do ((array (make-array (/ (length keys) 2))) 
                (i 0 (1+ i))
                (keystroke (make-array 2) (make-array 2)))
               ((= i (length array)) (DEBUGGER::call-java-method
                                      DEBUGGER::**connection**
                                      "IDE.LispScripting.LispIDEMethods"
                                      "createKeySequence"
                                      array))
             (setf (aref keystroke 0) (pop keys))
             (setf (aref keystroke 1) (pop keys))
             (setf (aref array i) keystroke)))))



;;; ***************************************************************************
;;; Bind a action to a key for a certain mode
;;; ***************************************************************************


(defun bind-action-to-key-sequence (mode action keysequence)
  (declare (string mode action))
  (DEBUGGER::call-java-method DEBUGGER::**connection**
                              "IDE.LispScripting.LispIDEMethods"
                              "bindActionToKeySequence"
                              mode
                              action
                              keysequence))


;;; ************************************************************************
;;; Create a button in the button panel for a mode and action
;;; ************************************************************************

(defun add-button (mode action)
  (declare (string mode action))
  (DEBUGGER::call-java-method-swing DEBUGGER::**connection**
                                    "IDE.LispScripting.LispIDEMethods"
                                    "addButton"
                                    mode
                                    action))

;;; ************************************************************************
;;; Make the given editor the current editor
;;; ************************************************************************

(defun set-current-editor (editor)
  (DEBUGGER::call-java-method-swing DEBUGGER::**connection**
                                    "IDE.LispScripting.LispIDEMethods"
                                    "setCurrentEditor"
                                    editor))

;;; ***********************************************************************
;;; Create a editor (if file name is given load the file with the filename
;;; in the editor
;;; ***********************************************************************

(defun create-editor (&optional (filename ""))
  (declare (string filename))
  (if (not (string= filename ""))
      (DEBUGGER::call-java-method-swing DEBUGGER::**connection**
                                        "IDE.LispScripting.LispIDEMethods"
                                        "createEditor"
                                        filename)
    (DEBUGGER::call-java-method-swing DEBUGGER::**connection**
                                      "IDE.LispScripting.LispIDEMethods"
                                      "createEditor")))
    

;;; ***************************************************************************
;;; Create a icon for the given file name 
;;; ***************************************************************************

(defun create-icon (filename)
  (declare (string filename))
  (DEBUGGER::call-java-method-swing DEBUGGER::**connection**
                                    "IDE.LispScripting.LispIDEMethods"
                                    "createIcon"
                                    filename))

;;; ***************************************************************************
;;; Insert a text in editor at the given position
;;; ***************************************************************************

(defun insert-text (editor position text)
  (declare (string text) (fixnum position))
  (DEBUGGER::call-java-method-swing DEBUGGER::**connection**
                                    "IDE.LispScripting.LispIDEMethods"
                                    "insertText"
                                    editor
                                    position
                                    text))

;;; ***************************************************************************
;;; Remove a piece of text from a editor with length length and starting at 
;;; position position
;;; ***************************************************************************

(defun remove-text (editor position length)
  (declare (fixnum position))
  (DEBUGGER::call-java-method-swing DEBUGGER::**connection**
                                    "IDE.LispScripting.LispIDEMethods"
                                    "removeText"
                                    editor
                                    position
                                    length))

;;; **************************************************************************
;;; Do a search for a regular expression in the text (case sensitive or no) and
;;; returns the position (or -1 if not found) and a matcher which can be used 
;;; for the next search
;;; ***************************************************************************

(defun search-text (editor regexp case position)
  (declare (string regexp) (boolean case) (fixnum position))
  (let ((matcher (DEBUGGER::call-java-method-swing DEBUGGER::**connection**
                                                   "IDE.LispScripting.LispIDEMethods"
                                                   "regularExpressionSearch"
                                                   editor
                                                   regexp
                                                   case)))
    (values (DEBUGGER::call-java-method DEBUGGER::**connection**
                  "IDE.LispScripting.LispIDEMethods"
                  "matcherFind"
                           matcher
                  position)
         matcher)))
;;; ******************************************************************************
;;; Search for the next occurance of the regular expression
;;; ******************************************************************************

(defun search-next (matcher &optional (position -1))
  (declare (fixnum position))
  (if (>= position 0)
      (DEBUGGER::call-java-method DEBUGGER::**connection**
                                      "IDE.LispScripting.LispIDEMethods"
                                      "matcherFind"
                                      matcher
                                      position)
    (DEBUGGER::call-java-method DEBUGGER::**connection**
                                "IDE.LispScripting.LispIDEMethods"
                                "matcherFind"
                                matcher)))




