;; *************************************************************************************** ;;
;; Jabberwocky  : Programming envioronment for LISP                                        ;;
;; Copyright (C) 1998 Marc Mertens                                                         ;;
;;                                                                                         ;;
;;     This program is free software; you can redistribute it and/or modify                ;;
;;    it under the terms of the GNU General Public License as published by                 ;;
;;    the Free Software Foundation; either version 2 of the License, or                    ;;
;;    (at your option) any later version.                                                  ;;
;;                                                                                         ;;
;;    This program is distributed in the hope that it will be useful,                      ;;
;;    but WITHOUT ANY WARRANTY; without even the implied warranty of                       ;;
;;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                        ;;
;;    GNU General Public License for more details.                                         ;;
;;                                                                                         ;;
;;    You should have received a copy of the GNU General Public License                    ;;
;;    along with this program; if not, write to the Free Software                          ;;
;;    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA            ;;
;;                                                                                         ;;
;; Contact me on mmertens@vt4.net                                                          ;;
;; *************************************************************************************** ;;
;; *****************************************************************************
;; Lisp code install LISP part of Jabberwocky
;; *****************************************************************************
;; *****************************************************************************
;; Define the package so that there are no problems for the compilation
;; *****************************************************************************

(make-package "DEBUGGER")
(make-package "JABBERWOCKY")

;; *****************************************************************************
;; Compile java.lisp
;;         debugger.lisp
;;         jabberwocky.lisp
;;         cmu.lisp (for cmucl)
;;         clisp.lisp (for clisp)
;; ****************************************************************************

(compile-file "java.lisp")
(compile-file "debugger.lisp")
(compile-file "jabberwocky.lisp")
#+:CMU
(compile-file "cmu.lisp")
#+CLISP
(compile-file "clisp.lisp")

;; ****************************************************************************
;; Load the compiled code so we can generate the syntax definitions
;; ****************************************************************************

#+:CMU
(load "debugger.x86f")
#+CLISP
(load "debugger.fas")

;; ****************************************************************************
;; Generate the syntax analyzers
;; ****************************************************************************

(DEBUGGER::process-definition-file "lispsyntax")
(DEBUGGER::process-definition-file-to-java "lispsyntax")

;; ****************************************************************************
;; Exits
;; ****************************************************************************


(quit)
