;;; ****************************************************************************
;;; Tests for the loop package
;;; ****************************************************************************

;; Simple loop
(defun loop001 ()
  (let ((i 0))
    (loop
      (when (> i 3) (return 10))
      (princ i)
      (incf i))))

;; for-as-arithmetic
(defun loop002 ()
    (loop
      for i from 1 to 3
      do (print i))
    (loop
      for i from 10 downto 1  by 3
      do (print i))
    (loop
      for i below 1
      do (print i)))

;; for-as-in-list
(defun loop003 ()
  (loop
    for item in '(1 2 3)
    do (print item))
  (loop
    for item in '(1 2 3 4) by #'cddr
    do (print item))
  (loop
    for (item . x) of-type (t . fixnum) in '((A . 1) (B . 2) (C . 3))
    do (print item)))

;; for-as-on-list

(defun loop004 ()
  (loop for sublist on '(a b c d)
        collect sublist))

(defun loop005 ()
  (loop for (item) on '(1 2 3)
        do (print item)))

;; for-as-equals

(defun loop006 ()
  (loop for item = 1 then (+ item 10)
        for iteration from 1 to 5
        do (print item)
        collect item))

;; for-as-across

(defun loop007 ()
  (loop for char across #(1 2 3)
        do (princ char)))

;; for-as-package

(defun loop006()
  (let ((package (make-package "TEST")))
    (in-package "TEST")
    (read-from-string "(this is a test)")
    (export (intern "THIS"))
    (in-package "USER")
    (loop for x being each present-symbol of package
          do (print x))))

;; local variable initialization

(defun loop007 ()
  (loop with a = 1
        with b = (+ a 2)
        with c = (+ b 3)
        return (list a b c)))

(defun loop008 ()
  (loop with a = 1
        and b = 2
        and c = 3
        return (list a b c)))

;; collect and append

(defun loop009 ()
  (loop for name in '(fred sue alice joe june)
        for kids in '((bob ken) () (kri s sunshine) ())
        collect name
        append kids))

(defun loop010 ()
  (loop for i from 1 to 10
        if (oddp i) collect i))

(defun loop011 ()
  (loop for i in '(a b c d) by #'cddr
        collect i into my-list
        finally (print my-list)))

;; append and nconc

(defun loop012 ()
  (loop for x in '((a) (b) ((c)))
        append x))

(defun loop013 ()
  (loop for i upfrom 0
        as x in '(a b c)
        nconc (if (evenp i) (list x) nil)))

;; count

(defun loop014 ()
  (loop for i in '(a b c nil d e)
        count i))

;; maximaize and minimize

(defun loop015 ()
  (loop for i in '(2 1 5 3 4)
        maximize i))

(defun loop016 ()
  (loop for i in '(2 1 5 3 4)
        minimize i))

(defun loop017 ()
  (loop for i in '(1.2 4.3 5.7)
        maximize (round v) of-type fixnum))

(defun loop018 ()
  (loop for v of-type float in '(1.2 4.3 5.7)
        minimize (round v) into result of-type fixnum))

;; sum

(defun loop019 ()
  (loop for i of-type fixnum in '(1 2 3 4 5)
        sum i))


(defun loop020 ()
  (loop for v in '(1.2 4.3 5.7)
        sum (* 2.0 v)))

;; repeat

(defun loop021 ()
  (loop repeat 3
        do (print "Ok")))

;; always 

(defun loop022 ()
  (loop for i from 0 to 10
        always (< i 11)))

;; never

(defun loop023 ()
  (loop for i from 0 to 10
        never (> i 11)))

;; theris

(defun loop024 ()
  (loop for i from 0
        theris (when (> i 0) i)))

;; finally

(defun loop025 ()
  (loop for i from 0 to 10
        always (< i 9)
        finally (print "You wan't see this")))

(defun loop026 ()
  (loop never t
        finally (print "You wan't see this")))

(defun loop027 ()
  (loop thereis "Here is my value"
        finally (print "You wan't see this")))

(defun loop028 ()
  (loop for i from 1 to 10
        thereis (> i 11)
        finally (princ "Got here")))

;; while 

(defun loop029 ()
  (let ((stack '(a b c d e f)))
    (loop for item = (length stack) then (pop stack)
          collect item
          while stack)))

(defun loop030 ()
  (loop for i fixnum from 3
        when (oddp i) collect i
        while (< i 5)))

;; until

(defun loop031 ()
  (loop for i fixnum from 3
        when (oddp i) collect i
        until (>= i 5)))

;; named

(defun loop032 ()
  (loop named max
        for i from 1 to 10
        do (print i)
        do (return-from max 'done)))

;; and

(defun loop033 ()
  (loop for x from 1 to 10
        and y = nil then x
        collect (list x y)))

;; clause grouping

(defun loop034 ()
  (loop  for i in '(1 324 2345 323 2 4 235 252)
         when (oddp i)
         do (print i)
         and collect i into odd-numbers
         and do (terpri)
         else 
         collect i into even-numbers
         finally (return (values odd-numbers even-numbers))))


(defun testloop ()
  (loop001)
  (loop002)
  (loop003)
  (loop004)
  (loop005)
  (loop006)
  (loop007)
  (loop008)
  (loop009)
  (loop010)
  (loop011)
  (loop012)
  (loop013)
  (loop014)
  (loop015)
  (loop016)
  (loop017)
  (loop018)
  (loop019)
  (loop020)
  (loop022)
  (loop023)
  (loop024)
  (loop025)
  (loop026)
  (loop027)
  (loop028)
  (loop001)
  )

