/*
 * OsSystem.java
 *
 * Created on July 28, 2002, 8:36 PM
 */

package Install;

import java.io.*;

/**
 * Contains various OS specific routines to seperate the OS specific stuff from the rest of the install code
 * All the methods in this class are static.
 * @author  marc
 */
public class OsSystem
{
    /** Indicate we are running in the Windows environment */
    private static final int OS_WINDOWS=0;
    /** Indicate we are running in a UNIX like environment */
    private static final int OS_UNIX=1;
    /** Get the proposed installation directory */
    public static String getDefaultInstallDir()
    {
        if (getOsVariant()==OS_WINDOWS)
            return String.valueOf(getRootDrive())+":\\Program Files\\Jabberwocky";
        else
            return "/usr/local/Jabberwocky";
        
    }
    /** Get the proposed directory for the startup file */
    public static String getStartupDirectory()
    {
        if (getOsVariant()==OS_WINDOWS)
            return String.valueOf(getRootDrive())+":\\Program Files\\Jabberwocky";
        else
            return "/usr/local/bin";
    }
    /** Get the startup file name */
    protected static String getStartupFile()
    {
        if (getOsVariant()==OS_WINDOWS)
            return "Jabberwocky.bat";
        else
            return "Jabberwocky";
    }
    /** Get the sourcedirectory */
    public static String getSourceDirectory()
    {
        return System.getProperty("user.dir");
    }
    /** Get the cmucl command */
    public static String getCmuclCommand()
    {
        if (getOsVariant()==OS_WINDOWS)
            return "";
        else
            return "lisp";
    }
    /** Get the clisp command */
    public static String getClispCommand()
    {
        if (getOsVariant()==OS_WINDOWS)
            return new File(new File(System.getProperty("user.home")).getParentFile().getAbsolutePath(),
            "All Users\\Desktop\\Clisp.bat").getAbsolutePath();
        else
            return "clisp";
    }
    /** Get the acl command */
    public static String getAclCommand()
    {
        if (getOsVariant()==OS_WINDOWS)
            return "";
        else 
            return "mlisp";
    }
    /** Get the ant command */
    public static String getAntCommand()
    {
        if (getOsVariant()==OS_WINDOWS)
            return new File(new File(System.getProperty("user.home")).getParentFile().getAbsolutePath(),
            "All Users\\Desktop\\Ant.bat").getAbsolutePath();
        else
            return "ant";
    }    
    /** Get the root drive (only usefull in Windows */
    private static char getRootDrive()
    {
        String rootdir=execCommand("cmd /c echo %SystemRoot%");
        if (rootdir.length()==0)
            return 'C';
        else
            return rootdir.charAt(0);
    }
    /** Register Jabberwocky at the OS */
    public static void registerJabberwocky()
    {
        if (getOsVariant()==OS_UNIX)
            registerJabberwockyUnix();
        else
            registerJabberwockyWindows();
    }
    /** Register Jabberwocky in the Unix KDE environment */
    private static void registerJabberwockyUnix()
    {
        setRights(new File(Install.getInstallbinDir(),getStartupFile()));
    }
    /** Register Jabberwocky in the Windows environment */
    private static void registerJabberwockyWindows()
    {
        if (System.getProperty("os.name").indexOf("95") == -1 &&
            System.getProperty("os.name").indexOf("98") == -1 &&
            System.getProperty("os.name").indexOf("Me") == -1)
        {
            registerJabberwockyWindowsNT();
        }
        else
        {
            registerJabberwockyWindows9x();
        }
   	}
    
    private static void registerJabberwockyWindowsNT()
    {
        BufferedWriter writer;
        // Batch command to register Jabberwocky
        File register=new File(getSourceDirectory()+File.separator+"register.bat");
        // Batch command to uninstall Jabberwocky
        File uninstall=new File(Install.getInstallDir()+File.separator+"uninstall.bat");
        // Get the Start Menu directoru
        String menudir=new File(new File(System.getProperty("user.home")).getParentFile().getAbsolutePath(),
                "All Users\\Start Menu\\Programs\\Jabberwocky").getAbsolutePath();
        try
        {
            // Create the batch command to register Jabberwocky
            if (register.exists())
                register.delete();
            writer=new BufferedWriter(new FileWriter(register));
            writer.write("REM Generated code to register Jabberwocky in Windows\r\n");
            writer.write("REM Adding menu entry\r\n");
            writer.write("mkdir \""+menudir+"\"\r\n");
            writer.write("copy jabberwocky.bat \""+menudir+"\"\r\n");
            writer.write("REM Adding undo information\r\n");
            writer.write("REG ADD HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\Jabberwocky\r\n");
            writer.write("REG ADD HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\Jabberwocky /f /v DisplayName /t REG_SZ /d \"Jabberwocky Uninstall\"\r\n");
            writer.write("REG ADD HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\Jabberwocky /f /v UninstallString /t REG_SZ /d \""+uninstall.getAbsolutePath()+"\"\r\n");
            writer.write("exit");
            writer.close();
            // Create the batch command to uninstall Jabberwocky
            if (uninstall.exists())
                uninstall.delete();
            writer=new BufferedWriter(new FileWriter(uninstall));
            writer.write("REM Generated code to uninstall Jabberwocky in Windows\r\n");
            writer.write("REM Removing registry entries\r\n");
            writer.write("REG DELETE HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\Jabberwocky /va /f\r\n");
            writer.write("REG DELETE HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\Jabberwocky /f\r\n");
            writer.write("REM Remove the menu entries\r\n");
            writer.write("RMDIR /S /Q \""+menudir+"\"\r\n");
            writer.write("REM Delete the Jabberwocky bin directory\r\n");
            writer.write("RMDIR /S /Q \""+Install.getInstallbinDir()+"\"\r\n");            
            writer.write("REM Delete the Jabberwocky installation dir\r\n");
            writer.write("RMDIR /S /Q \""+Install.getInstallDir()+"\"\r\n");
            writer.write("exit");
            writer.close();
            // Excute the register batch program
            Install.startCommand(register.getAbsolutePath(),new String[0],true);
        }
        catch (Exception e)
        {
        }
    }
    
    private static void registerJabberwockyWindows9x()
    {
        BufferedWriter writer;
        // Batch command to register Jabberwocky
        File register=new File(getSourceDirectory()+File.separator+"register.bat");
        // File containing registry info
        File registerInfo=new File(getSourceDirectory()+File.separator+"registerInfo.txt");
        File unregisterInfo=new File(getSourceDirectory()+File.separator+"unregisterInfo.txt");
        // Batch command to uninstall Jabberwocky
        File uninstall=new File(Install.getInstallDir()+File.separator+"uninstall.bat");
        // Get the Start Menu directoru
        String menudir=new File(new File(System.getProperty("user.home")).getParentFile().getAbsolutePath(),
                "\\Windows\\Start Menu\\Programs\\Jabberwocky").getAbsolutePath();        
        try
        {
            // Create the file with the registry info, to be imported into the registry
            // XXXXX Is there a simpler method under Windows 9x?
            
            writer=new BufferedWriter(new FileWriter(registerInfo));
            writer.write("REGEDIT4\r\n");
            writer.write("\r\n");
            writer.write("[HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\Jabberwocky]\r\n");
            writer.write("\"UninstallString\"=\""+new String(uninstall.getAbsolutePath().replaceAll("\\\\","\\\\\\\\"))+"\"\r\n");
			writer.write("\"DisplayName\"=\"Jabberwocky Uninstall\"\r\n");
			writer.flush();
			writer.close();
			
            // Create the file to delete the registry key, to be imported into the registry
            writer=new BufferedWriter(new FileWriter(unregisterInfo));
            writer.write("REGEDIT4\r\n");
            writer.write("\r\n");
            writer.write("[-HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\Jabberwocky]\r\n");
            writer.flush();
            writer.close();
            
            // Create the batch command to register Jabberwocky
            if (register.exists())
                register.delete();
            writer=new BufferedWriter(new FileWriter(register));
            writer.write("REM Generated code to register Jabberwocky in Windows\r\n");
            writer.write("REM Adding menu entry\r\n");
            writer.write("mkdir \""+menudir+"\"\r\n");
            writer.write("copy jabberwocky.bat \""+menudir+"\"\r\n");
            writer.write("REM Adding undo information\r\n");
            writer.write("regedit /s registerInfo.txt\r\n");
            writer.write("REM copying unregister information to installation directory\r\n");
            writer.write("copy unregisterInfo.txt \""+Install.getInstallDir()+"\"\r\n");
            writer.write("exit");
            writer.close();
            // Create the batch command to uninstall Jabberwocky
            if (uninstall.exists())
                uninstall.delete();
            writer=new BufferedWriter(new FileWriter(uninstall));
            writer.write("REM Generated code to uninstall Jabberwocky in Windows\r\n");
            writer.write("REM Remove the menu entries\r\n");
            writer.write("deltree /Y \""+menudir+"\"\r\n");
            writer.write("REM Removing registry entries\r\n");
            writer.write("regedit /s \""+Install.getInstallDir()+"\\unregisterInfo.txt\"\r\n");
            writer.write("REM Delete the Jabberwocky bin directory\r\n");
            writer.write("deltree /Y \""+Install.getInstallbinDir()+"\"\r\n");
            writer.write("REM Delete the Jabberwocky installation dir\r\n");
            writer.write("deltree /Y \""+Install.getInstallDir()+"\"\r\n");
            writer.write("exit");
            writer.close();
            // Excute the register batch program
            Install.startCommand(register.getAbsolutePath(),new String[0],true);
        }
        catch (Exception e)
        {
        }
    }    
    /** Execute a command and return everything send to standard output as a string
     * (with the exception of last white spaces)  */
    private static String execCommand(String cmd)
    {
        try
        {
            StringBuffer buffer=new StringBuffer();
            InputStream strm=Runtime.getRuntime().exec(cmd).getInputStream();
            int c;
            while ((c=strm.read())!=-1)
                buffer.append((char) c);
            for (int i=buffer.length()-1;i>=0 && buffer.charAt(i)=='\n' || buffer.charAt(i)=='\r' || buffer.charAt(i)==' ';i--)
                buffer.deleteCharAt(i);
            return buffer.toString();
        }
        catch (Exception e)
        {
            return "";
        }
    }
    /** Replace the \ by to \\ to do correct escaping for this stupid windows fileseparator */
    private static String escapeString(String str)
    {
        StringBuffer buffer=new StringBuffer();
        for (int i=0;i<str.length();i++)
        {
            if (str.charAt(i)=='\\')
                buffer.append('\\');
            buffer.append(str.charAt(i));
        };
        return buffer.toString();
    }
    /** Change the permission on a file */
    private static boolean setRights(File file)
    {
        // Change the rights
        if (getOsVariant()==OS_UNIX)
        {
            try
            {
                Runtime runtime=Runtime.getRuntime();
                Process process=runtime.exec("chmod a+rx "+file.getAbsolutePath());
                process.waitFor();
                if (process.exitValue()!=0)
                    return false;
                else
                    return true;
            }
            catch (Exception e)
            {
                return false;
            }
        }
        else
        {
            return true;
        }
    }
    /** Get the users home directory */
    public static String getHomeDir()
    {
        return System.getProperty("user.home");
    }
    /** Get the OS variant */
    private static int getOsVariant()
    {
        if (System.getProperty("os.name").startsWith("Windows"))
            return OS_WINDOWS;
        else
            return OS_UNIX;
    }
    /** Correct the back slashes for a file name */
    private static String correctBackslashes(String filename)
    {
        StringBuffer buffer=new StringBuffer();
        for (int i=0;i<filename.length();i++)
            if (filename.charAt(i)=='\\')
                buffer.append("\\\\");
            else
                buffer.append(filename.charAt(i));
        return buffer.toString();
    }
    /** Correct a pathname for the windows system */
    public static String correctPathName(String pathname)
    {
        if (getOsVariant()==OS_WINDOWS)
            return correctBackslashes(pathname);
        else
            return pathname;
    }
    /** Inidicate if setXORMode works correctly or not (for me this is a bug in the java implementation for windows) */
    public static boolean setXORModeHasBug()
    {
        return getOsVariant()==OS_WINDOWS && System.getProperty("java.version").compareTo("1.4.1")<0;
    }
    /** Check if we can do process managment, really impossible in WINDOWS */
    public static boolean processManagmentIsPossible()
    {
        return getOsVariant()==OS_UNIX;
    }
    /** Test the code */
    public static void main(String[] args)
    {
        System.out.println(getDefaultInstallDir());
        System.out.println(getHomeDir());
    }
}
