package Install;

/*
 * Install.java
 * Class to install Jabberwocky
 * Created on January 27, 2002, 1:05 PM
 */

/**
 * Contains the installation code of Jabberwocky
 * @author  marc
 */
import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;

public class Install extends WindowAdapter
{
    /** Expirimental support for ACL */
    private static boolean TestACL=false;
    /** Indicates if we must compile the sources or just install the runtime */
    private static boolean compilejava=true;
    /** Counter for the progressbar */
    private static int counter=0;
    /** Install log textarea */
    private static JTextArea installog;
    /** Components of the window */
    private static JCheckBox cmuclok;
    private static JCheckBox clispok;
    private static JCheckBox aclok;
    private static JCheckBox antok;
    private static JTextField installbin;
    private static JTextField installdir;
    private static JTextField cmuclfield;
    private static JTextField clispfield;
    private static JTextField aclfield;
    private static JTextField antfield;
    private static JButton install;
    protected static JProgressBar progressbar;
    /** Creates a new instance of Install */
    public Install()
    {
        
    }
    /** Get the install directory */
    public static String getInstallDir()
    {
        return installdir.getText();
    }
    
    /** Get the installbin directory */
    public static String getInstallbinDir()
    {
        return installbin.getText();
    }
    /**
     * Main function to do the installation
     */
    public static void main(String args[])
    {
        // Check if we must compile java
        if (args.length==0 || !(args[0].compareTo("-compile")==0 || args[0].compareTo("-nocompile")==0))
            showMessage("Argument must be either -compile or -nocompile",true,-1);
        else if (args[0].compareTo("-compile")==0)
            compilejava=true;
        else
            compilejava=false;
        // Build the install window
        JLabel lblInstallDir=new JLabel("Install directory:");
        lblInstallDir.setForeground(Color.black);
        JLabel lblInstallBin=new JLabel("Install directory Jabberwocky script");
        lblInstallBin.setForeground(Color.black);
        JTextArea poem=new JTextArea();
        poem.setForeground(Color.BLUE);
        poem.setMargin(new Insets(20,20,0,0));
        poem.setEditable(false);
        poem.setFont(new Font("Calligula",Font.ITALIC,10));
        poem.insert("'Twas brillig, and the slithy toves\n Did gyre and gimble in the wabe:\nAll mimsy were the borogoves,\n And the mome raths outgrabe.\n\nBeware the Jabberwock, my son!\n The jaws that bite, the claws that catch!\nBeware the Jubjub bird, and shun\n The frumious Bandersnatch!\n\nHe took his vorpal sword in hand:\n Long time the maxome foe he sought--\nSo rested he by the Tumtum tree,\n And stood awhile in thought.\n\nAnd, as in uffish thought he stood,\n The Jabberwock, with eyes of flame,\nCame whiffling through the tulgey wood,\n And burbled as it came!\n\nOne, two! One, two And through and through\n The vorpal blade went snicker-snack!\nHe left it dead, and with its head\n He went galumphing back.\n\n\"And hast thou slain the Jabberwock?\n Come to my arms, my beamish boy!\nO frabjous day! Callooh! Callay!\"\n He chortled in his joy.\n\n'Twas brillig, and the slithy toves\n Did gyre and gimble in the wabe:\nAll mimsy were the borogoves,\n And the mome raths outgrabe.",0);
        JDialog installdialog=new JDialog();
        installdialog.setTitle("Install log");
        installdialog.setModal(false);
        installog=new JTextArea();
        JScrollPane scrollpane=new JScrollPane(installog);
        installdialog.setSize(700,500);
        installdialog.setContentPane(scrollpane);
        installdialog.addWindowListener(new Install());
        JFrame frame=new JFrame("Installation of Jabberwocky");
        JPanel content=new JPanel();
        content.setLayout(new BoxLayout(content,BoxLayout.Y_AXIS));
        progressbar=new JProgressBar(JProgressBar.HORIZONTAL,0,735);
        progressbar.setValue(0);
        JLabel imagelabel=new JLabel(new ImageIcon("jabberwocky.jpg"));
        GridBagLayout gridbag=new GridBagLayout();
        GridBagConstraints gridconstraints=new GridBagConstraints();
        gridconstraints.fill=GridBagConstraints.BOTH;
        gridconstraints.weightx=0.5;
        JPanel lispchoices=new JPanel(gridbag);
        lispchoices.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
        cmuclok=new JCheckBox(new AbstractAction("CMUCL")
        {
            public void actionPerformed(ActionEvent ev)
            {checkCommands(true);}
        });
        if (!System.getProperty("os.name").startsWith("Windows"))
            cmuclok.setSelected(true);
        clispok=new JCheckBox(new AbstractAction("CLISP")
        {
            public void actionPerformed(ActionEvent ev)
            {checkCommands(true);}
        });
        clispok.setSelected(true);
        aclok=new JCheckBox(new AbstractAction("ACL")
        {
            public void actionPerformed(ActionEvent ev)
            {checkCommands(true);}
        });
        aclok.setSelected(true);
        antok=new JCheckBox(new AbstractAction("Ant")
        {
            public void actionPerformed(ActionEvent ev)
            {checkCommands(true);}
        });
        antok.setSelected(true);
        
        installdir=new JTextField(OsSystem.getDefaultInstallDir());
        installdir.setEditable(false);
        installdir.setBackground(Color.lightGray);
        installdir.setOpaque(true);
        installbin=new JTextField(OsSystem.getStartupDirectory());
        installbin.setEditable(false);
        installbin.setBackground(Color.lightGray);
        installbin.setOpaque(true);
        cmuclfield=new JTextField(OsSystem.getCmuclCommand());
        cmuclfield.setEditable(false);
        cmuclfield.setBackground(Color.lightGray);
        cmuclfield.setOpaque(true);
        clispfield=new JTextField(OsSystem.getClispCommand());
        clispfield.setEditable(false);
        clispfield.setBackground(Color.lightGray);
        clispfield.setOpaque(true);
        aclfield=new JTextField(OsSystem.getAclCommand());
        aclfield.setEditable(false);
        aclfield.setBackground(Color.lightGray);
        aclfield.setOpaque(true);
        antfield=new JTextField(OsSystem.getAntCommand());
        antfield.setEditable(false);
        antfield.setBackground(Color.lightGray);
        antfield.setOpaque(true);
        JButton changeinstalldir=new JButton(new AbstractAction("...")
        {
            public void actionPerformed(ActionEvent ev)
            {
                JFileChooser chooser=new JFileChooser();
                chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
                chooser.setSelectedFile(new File(installdir.getText()));
                chooser.setApproveButtonText("Select");
                chooser.setApproveButtonToolTipText("Installation directory Jabberwocky");
                if (chooser.showSaveDialog(null)==JFileChooser.APPROVE_OPTION)
                {
                    installdir.setText(chooser.getSelectedFile().getAbsolutePath());
                };
            }
        });
        JButton changeinstallbin=new JButton(new AbstractAction("...")
        {
            public void actionPerformed(ActionEvent ev)
            {
                JFileChooser chooser=new JFileChooser();
                chooser.setSelectedFile(new File(installbin.getText()));
                chooser.setApproveButtonText("Select");
                chooser.setApproveButtonToolTipText("Directory to install Jabberwocky script");
                chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
                if (chooser.showSaveDialog(null)==JFileChooser.APPROVE_OPTION)
                {
                    installbin.setText(chooser.getSelectedFile().getAbsolutePath());
                };
            }
        });
        JButton cmuclsearch=new JButton(new AbstractAction("...")
        {
            public void actionPerformed(ActionEvent ev)
            {
                String command=getLispCommand(cmuclfield.getText());
                if (command==null)
                {
                    cmuclfield.setText("");
                    cmuclok.setSelected(false);
                }
                else
                {
                    cmuclfield.setText(command);
                    cmuclok.setSelected(true);
                    checkCommands(true);
                };
            }
        });
        JButton clispsearch=new JButton(new AbstractAction("...")
        {
            public void actionPerformed(ActionEvent ev)
            {
                String command=getLispCommand(clispfield.getText());
                if (command==null)
                {
                    clispfield.setText("");
                    clispok.setSelected(false);
                }
                else
                {
                    clispfield.setText(command);
                    clispok.setSelected(true);
                    checkCommands(true);
                };
            }
        });
        JButton aclsearch=new JButton(new AbstractAction("...")
        {
            public void actionPerformed(ActionEvent ev)
            {
                String command=getLispCommand(aclfield.getText());
                if (command==null)
                {
                    aclfield.setText("");
                    aclok.setSelected(false);
                }
                else
                {
                    aclfield.setText(command);
                    aclok.setSelected(true);
                    checkCommands(true);
                };
            }
        });
        JButton antsearch=new JButton(new AbstractAction("...")
        {
            public void actionPerformed(ActionEvent ev)
            {
                String command=getLispCommand(antfield.getText());
                if (command==null)
                {
                    antfield.setText("");
                    antok.setSelected(false);
                }
                else
                {
                    antfield.setText(command);
                    antok.setSelected(true);
                    checkCommands(true);
                };
            }
        });
        install=new JButton(new AbstractAction("Install")
        {
            public void actionPerformed(ActionEvent ev)
            {
                String version=System.getProperty("java.version");
                if (version.startsWith("1.4"))
                {
                    doInstall();
                }
                else
                {
                    showMessage("Java version is "+version+" while it should be 1.4.x.\nPlease install the correct version of Java",true,0);
                };
            }
        });
        install.setEnabled(false);
        JButton cancel=new JButton(new AbstractAction("Cancel")
        {
            public void actionPerformed(ActionEvent ev)
            {
                System.exit(0);
            }
        });
        // Build panel with ok and cancel button
        JPanel buttons=new JPanel();
        buttons.add(install);
        buttons.add(cancel);
        // Build the lisp choices pane */
        gridconstraints.gridx=0;
        gridconstraints.gridy=0;
        gridconstraints.weightx=0.1;
        gridbag.setConstraints(lblInstallDir,gridconstraints);
        gridconstraints.gridx=1;
        gridconstraints.gridy=0;
        gridconstraints.weightx=0.8;
        gridbag.setConstraints(installdir,gridconstraints);
        gridconstraints.gridx=2;
        gridconstraints.gridy=0;
        gridconstraints.weightx=0.1;
        gridbag.setConstraints(changeinstalldir,gridconstraints);
        
        gridconstraints.gridx=0;
        gridconstraints.gridy=1;
        gridconstraints.weightx=0.1;
        gridbag.setConstraints(lblInstallBin,gridconstraints);
        gridconstraints.gridx=1;
        gridconstraints.gridy=1;
        gridconstraints.weightx=0.8;
        gridbag.setConstraints(installbin,gridconstraints);
        gridconstraints.gridx=2;
        gridconstraints.gridy=1;
        gridconstraints.weightx=0.1;
        gridbag.setConstraints(changeinstallbin,gridconstraints);
        
        gridconstraints.gridx=0;
        gridconstraints.gridy=2;
        gridconstraints.weightx=0.1;
        gridbag.setConstraints(clispok,gridconstraints);
        gridconstraints.gridx=1;
        gridconstraints.gridy=2;
        gridconstraints.weightx=0.8;
        gridbag.setConstraints(clispfield,gridconstraints);
        gridconstraints.gridx=2;
        gridconstraints.gridy=2;
        gridconstraints.weightx=0.1;
        gridbag.setConstraints(clispsearch,gridconstraints);
        
        gridconstraints.gridx=0;
        gridconstraints.gridy=3;
        gridconstraints.weightx=0.1;
        gridbag.setConstraints(cmuclok,gridconstraints);
        gridconstraints.gridx=1;
        gridconstraints.gridy=3;
        gridconstraints.weightx=0.8;
        gridbag.setConstraints(cmuclfield,gridconstraints);
        gridconstraints.gridx=2;
        gridconstraints.gridy=3;
        gridconstraints.weightx=0.1;
        gridbag.setConstraints(cmuclsearch,gridconstraints);
        
        gridconstraints.gridx=0;
        gridconstraints.gridy=4;
        gridconstraints.weightx=0.1;
        gridbag.setConstraints(aclok,gridconstraints);
        gridconstraints.gridx=1;
        gridconstraints.gridy=4;
        gridconstraints.weightx=0.8;
        gridbag.setConstraints(aclfield,gridconstraints);
        gridconstraints.gridx=2;
        gridconstraints.gridy=4;
        gridconstraints.weightx=0.1;
        gridbag.setConstraints(aclsearch,gridconstraints);
        
        gridconstraints.gridx=0;
        gridconstraints.gridy=5;
        gridconstraints.weightx=0.1;
        gridbag.setConstraints(antok,gridconstraints);
        gridconstraints.gridx=1;
        gridconstraints.gridy=5;
        gridconstraints.weightx=0.8;
        gridbag.setConstraints(antfield,gridconstraints);
        gridconstraints.gridx=2;
        gridconstraints.gridy=5;
        gridconstraints.weightx=0.1;
        gridbag.setConstraints(antsearch,gridconstraints);
        
        lispchoices.add(lblInstallDir);
        lispchoices.add(installdir);
        lispchoices.add(changeinstalldir);
        
        lispchoices.add(lblInstallBin);
        lispchoices.add(installbin);
        lispchoices.add(changeinstallbin);
        
        lispchoices.add(clispok);
        lispchoices.add(clispfield);
        lispchoices.add(clispsearch);
        
        // Test if we must shown acl extensions
        if (TestACL)
        {
            lispchoices.add(aclok);
            lispchoices.add(aclfield);
            lispchoices.add(aclsearch);
        }
        // Do not show CMUCL on Windows
        if (!System.getProperty("os.name").startsWith("Windows"))
        {
            lispchoices.add(cmuclok);
            lispchoices.add(cmuclfield);
            lispchoices.add(cmuclsearch);
        }
        if (compilejava)
        {
            lispchoices.add(antok);
            lispchoices.add(antfield);
            lispchoices.add(antsearch);
        };
        // Make sure that the install dialog is visible
        installdialog.setVisible(true);
        // Check the commands
        checkCommands(false);
        // Build the content pane
        JPanel splash=new JPanel();
        splash.setBackground(Color.WHITE);
        splash.setLayout(new BoxLayout(splash,BoxLayout.X_AXIS));
        splash.add(imagelabel);
        splash.add(poem);
        content.add(splash);
        content.add(lispchoices);
        content.add(buttons);
        content.add(progressbar);
        // Add a listener to the close event
        frame.addWindowListener(new Install());
        // Define the content of the frame
        JScrollPane scrollPane = new JScrollPane(content);
        frame.setContentPane(scrollPane);
        Rectangle bounds=GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        frame.setSize(700, Math.min(800,bounds.height-50));
        frame.setVisible(true);
        // Place the window in the middle
        int x=Math.max(0,(bounds.width-frame.getWidth())/2);
        int y=Math.max(0,(bounds.height-frame.getHeight())/2);
        frame.setLocation(x,y);
    }
    /** Get the lisp command to use */
    private static String getLispCommand(String command)
    {
        JFileChooser chooser=new JFileChooser(new File(command));
        if (chooser.showOpenDialog(null)==JFileChooser.APPROVE_OPTION)
            return chooser.getSelectedFile().getAbsolutePath();
        else
            return null;
    }
    /** Check if the lisp commands really are lisp commands, do this in background, disable the install button and enable it
     * only when the task is finished, error will indicate if a error must be displayed (error is displayed only if you change things) */
    private static void checkCommands(final boolean error)
    {
        final Runnable enableInstall=new Runnable()
        {
            public void run()
            {
                install.setEnabled(true);
            }
        };
        Thread thread=new Thread(new Runnable()
        {
            final String clisp=clispfield.getText();
            final String cmucl=cmuclfield.getText();
            final String ant=antfield.getText();
            final String acl=aclfield.getText();
            public void run()
            {
                String version;
                // Check the clisp command
                if (clispok.isSelected() && clisp.length()>0)
                {
                    version=startCommand(clisp,new String[]
                    {"--version"},error);
                    if (version==null || version.indexOf("CLISP")==-1)
                    {
                        clispok.setSelected(false);
                        if (error)
                            showMessage(clisp+" is not the command to start CLISP",false,0);
                    };
                }
                else
                {
                    clispok.setSelected(false);
                };
                // Check the cmucl command
                if (cmuclok.isSelected() && cmucl.length()>0)
                {
                    version=startCommand(cmucl,new String[]
                    {"-eval","(progn(princ(lisp-implementation-type))(quit))"},error);
                    if (version==null || version.indexOf("CMU")==-1)
                    {
                        cmuclok.setSelected(false);
                        if (error)
                            showMessage(cmucl+" is not the command to start CMUCL",false,0);
                    };
                }
                else
                {
                    cmuclok.setSelected(false);
                };
                if (TestACL)
                {
                    // Check the acl command
                    if (aclok.isSelected() && acl.length()>0)
                    {
                        version=startCommand(acl,new String[]
                        {"-e","(progn(princ(lisp-implementation-type))(exit))"},error);
                        if (version==null || version.indexOf("Allegro")==-1)
                        {
                            aclok.setSelected(false);
                            if (error)
                                showMessage(acl+" is not the command to start ACL", false,0);
                        };
                    }
                    else
                    {
                        aclok.setSelected(false);
                    };
                };
                if (cmuclok.isSelected() || clispok.isSelected() || aclok.isSelected())
                {
                    SwingUtilities.invokeLater(enableInstall);
                };
                if (antok.isSelected() && ant.length()>0)
                {
                    version=startCommand(ant,new String[]
                    {"-help"},error);
                    if (version==null)
                    {
                        antok.setSelected(false);
                        if (error)
                            showMessage(ant+" is not the command to start Ant",false,0);
                    }
                };
            }
        });
        install.setEnabled(false);
        thread.start();
    }
    /** Do the install of  Jabberwocky */
    private static void doInstall()
    {
        Thread thread=new Thread(new Runnable()
        {
            public void run()
            {
                // Install CLISP code
                if (clispok.isSelected())
                {
                    startCommand(clispfield.getText(),new String[]
                    {"-i","install.lisp"},true);
                };
                // Install CMUCL code
                if (cmuclok.isSelected())
                {
                    startCommand(cmuclfield.getText(),new String[]
                    {"-load","install.lisp"},true);
                };
                File javadir=new File("java");
                if (javadir.isDirectory())
                {
                    // Create the batch file to start the IDE
                    createBatchFile(installdir.getText());
                    // Compile the java files if needed
                    if (compilejava)
                    {
                        //Use Ant for building, if available
                        if (antok.isSelected())
                        {
                            progressbar.setIndeterminate(true);
                            String message = buildWithAnt();
                            if (message != null && message.indexOf("SUCCESSFUL") != -1)
                            {
                                OsSystem.registerJabberwocky();
                                showMessage("Congratulations, Jabberwocky is installed",true,0);
                            }
                            else
                            {
                                showMessage("Sorry, Jabberwocky could not be installed \n \n",true,1);
                            }
                        }
                        else
                        {
                            // Compile the files and add them to the jar file
                            compileJavaFilesInDir(javadir,javadir);
                            // Create the jar file
                            createJarFile(javadir);
                        }
                    };
                    // Copy all the files to the install directory
                    copyFiles(installdir.getText());
                    // Register the installation (creating mnenus and uninstall information)
                    OsSystem.registerJabberwocky();
                }
                else
                {
                    showMessage("This command is not executed in the correct directory or the java subdirectory is missing",true,-1);
                };
                progressbar.setValue(progressbar.getMaximum());
                // Everything is installed
                showMessage("Congratulations, Jabberwocky is installed",true,0);
            }
        });
        install.setEnabled(false);
        thread.start();
    }
    /** Create the startup programs for unix and Windows */
    private static void createBatchFile(String installdir)
    {
        try
        {
            // First the startupfile for unix
            progressbar.setValue(counter++);
            File file=new File(OsSystem.getStartupFile());
            file.delete();
            file.createNewFile();
            Writer writer=new BufferedWriter(new FileWriter(file));
            String cmd;
            if (System.getProperty("os.name").startsWith("Windows"))
                cmd="java -jar \""+installdir+File.separatorChar+"Jabberwocky.jar\""+
                " -i \""+installdir+"\""+
                " -s \""+System.getProperty("user.dir")+"\""+
                " -clisp \""+clispfield.getText()+"\"";
            else
                cmd="java -jar \""+installdir+File.separatorChar+"Jabberwocky.jar\""+
                " -i \""+installdir+"\""+
                " -s \""+System.getProperty("user.dir")+"\""+
                " -clisp \""+clispfield.getText()+"\""+
                " -cmucl \""+cmuclfield.getText()+"\"";
            writer.write(cmd);
            writer.close();
        }
        catch (Exception e)
        {
            showMessage("Failed to create startup script for Jabberwocky",true,-1);
        };
    }
    /** Create the install directory and copy the necessary files to install Jabberwocky */
    private static void copyFiles(String installdirstring)
    {
        progressbar.setValue(counter++);
        String temp;
        // Create the directories
        File installdir=new File(installdirstring);
        if (!installdir.exists())
            installdir.mkdir();
        if (!installdir.exists())
            showMessage("Could not create install directory",true,-1);
        temp=installdirstring+File.separatorChar+"image";
        File imagedir=new File(temp);
        if (!imagedir.exists())
            imagedir.mkdir();
        if (!imagedir.exists())
            showMessage("Could not create image subdirectory",true,-1);
        temp=installdirstring+File.separatorChar+"doc";
        File docdir=new File(temp);
        if (!docdir.exists())
            docdir.mkdir();
        if (!docdir.exists())
            showMessage("Could not create doc subdirectory",true,-1);
        temp=installdirstring+File.separatorChar+"configurations";
        File configurationsdir=new File(temp);
        if (!configurationsdir.exists())
            configurationsdir.mkdir();
        if (!configurationsdir.exists())
            showMessage("Could not create configurations subdirectory",true,-1);
        try
        {
            // Copy the seed file for generated lisp functions usefull in lisp scripts
            temp="seed.lisp";
            copyFile(temp,installdir);
            // Copy the compiled lisp code
            // CMUCL
            if (cmuclok.isSelected())
            {
                temp="debugger.x86f";
                copyFile(temp,installdir);
                temp="java.x86f";
                copyFile(temp,installdir);
                temp="cmu.x86f";
                copyFile(temp,installdir);
                temp="debugcode.x86f";
                copyFile(temp,installdir);
                temp="jabberwocky.x86f";
                copyFile(temp,installdir);
            };
            // CLISP
            if (clispok.isSelected())
            {
                temp="debugger.fas";
                copyFile(temp,installdir);
                temp="java.fas";
                copyFile(temp,installdir);
                temp="clisp.fas";
                copyFile(temp,installdir);
                temp="debugcode.fas";
                copyFile(temp,installdir);
                temp="jabberwocky.fas";
                copyFile(temp,installdir);
            };
            // Copy the jar file
            temp="java"+File.separatorChar+"Jabberwocky.jar";
            copyFile(temp,installdir);
            // Copy the start script
            temp=OsSystem.getStartupFile();
            copyFile(temp,new File(installbin.getText()));
            // Copy the images to the image directory
            temp="java"+File.separatorChar+"image";
            File sourceimage=new File(temp);
            if (!sourceimage.isDirectory())
                showMessage("image directory missing",true,-1);
            File[] images=sourceimage.listFiles();
            for (int i=0;i<images.length;i++)
                copyFile(images[i].getAbsolutePath(),imagedir);
            // Copy the docs to the doc directory
            temp="doc";
            File sourcedoc=new File(temp);
            if (!sourcedoc.isDirectory())
                showMessage("doc directory missing",true,-1);
            File[] docs=sourcedoc.listFiles();
            for (int i=0;i<docs.length;i++)
                copyFile(docs[i].getAbsolutePath(),docdir);
            // Copy the configurationfiles to the configurations directory
            temp="configurations";
            File sourceconfigurations=new File(temp);
            if (!sourceconfigurations.isDirectory())
                showMessage("configurations directory missing",true,-1);
            File[] configurations=sourceconfigurations.listFiles();
            for (int i=0;i<configurations.length;i++)
                copyFile(configurations[i].getAbsolutePath(),configurationsdir);
        }
        catch (Exception e)
        {
            showMessage("Error during copy of the file "+temp,true,-1);
        }
    }
    /** Copy a file to a directory */
    private static void copyFile(String source,File destinationdir)
    {
        progressbar.setValue(counter++);
        try
        {
            updateLog("Copying "+source+" to "+destinationdir.getAbsolutePath());
            BufferedInputStream reader=new BufferedInputStream(new FileInputStream(source));
            BufferedOutputStream writer=new BufferedOutputStream(new FileOutputStream(new File(destinationdir,new File(source).getName())));
            byte[] buffer=new byte[(int) new File(source).length()];
            reader.read(buffer);
            writer.write(buffer);
            writer.close();
        }
        catch (Exception e)
        {
            showMessage("Error copying "+source+" to "+destinationdir.getAbsolutePath()+"\n"+e.getMessage(),true,-1);
        };
    }
    /** Get a string of the standard output and error of a command */
    private static String getOutputError(Process process)
    {
        StringBuffer buffer=new StringBuffer();
        InputStream strm;
        int c;
        try
        {
            strm=process.getInputStream();
            while ((c=strm.read())!=-1)
            {
                buffer.append((char) c);
            };
            buffer.append('\n');
            strm=process.getErrorStream();
            while ((c=strm.read())!=-1)
            {
                buffer.append((char) c);
            }
            return buffer.toString();
        }
        catch (Exception e)
        {
            return buffer.toString();
        }
    }
    /** Create the jar file */
    private static void createJarFile(File javadir)
    {
        progressbar.setValue(counter++);
        String cmd="";
        updateLog("Create the jar file Jabberwocky.jar\n");
        try
        {
            Runtime runtime=Runtime.getRuntime();
            cmd="jar -cmf Manifest Jabberwocky.jar";
            Process process=runtime.exec(cmd,new String[0],javadir);
            process.waitFor();
            if (process.exitValue()!=0)
                showMessage("Failed to execute cmd "+cmd+"\n"+getOutputError(process),true,-1);
            else
                // Add now all the classes to the jar file
                addClassesInDir(javadir,javadir,"");
        }
        catch (Exception e)
        {
            showMessage("Failed to execute "+cmd+"\n"+e.getMessage(),true,-1);
        };
    }
    /** Compile a java file */
    private static void addClass(File javadir,final File javafile,String dir)
    {
        progressbar.setValue(counter++);
        String file;
        if (dir.length()==0)
            file=javafile.getName();
        else
            file=dir+File.separatorChar+javafile.getName();
        updateLog("Archiving class file "+file+"\n");
        // Do the compilation
        try
        {
            Runtime runtime=Runtime.getRuntime();
            Process process=runtime.exec(new String[]
            {"jar","-uf","Jabberwocky.jar",file},new String[0],javadir);
            process.waitFor();
            if (process.exitValue()!=0)
                showMessage("Failed to add class "+file+" jar file\n"+getOutputError(process),true,-1);
        }
        catch (Exception e)
        {
            showMessage("Failed to archive "+javafile.getAbsolutePath()+" because of "+e.getMessage(),true,-1);
        };
        
        
    }
    /** Compile the java files in this directory and its subdirectories */
    private static void addClassesInDir(File javadir,File dir,String relativedir)
    {
        File[] files=dir.listFiles(new ClassFilter());
        for (int i=0;i<files.length;i++)
            if (files[i].isDirectory())
                if (relativedir.length()==0)
                    addClassesInDir(javadir,files[i],files[i].getName());
                else
                    addClassesInDir(javadir,files[i],relativedir+File.separatorChar+files[i].getName());
            else
                addClass(javadir,files[i],relativedir);
    }
    /** Compile a java file */
    private static void compileJavaFile(File javadir,final File javafile)
    {
        progressbar.setValue(counter++);
        updateLog("Compiling  java source "+javafile.getAbsolutePath()+"\n");
        // Do the compilation
        try
        {
            Runtime runtime=Runtime.getRuntime();
            Process process=runtime.exec(new String[]
            {"javac","-O",javafile.getAbsolutePath()},new String[0],javadir);
            process.waitFor();
            if (process.exitValue()!=0)
                showMessage("Failed to compile "+javafile.getAbsolutePath()+"\n"+getOutputError(process),true,-1);
        }
        catch (Exception e)
        {
            showMessage("Failed to compile "+javafile.getAbsolutePath()+" because of "+e.getMessage(),true,-1);
        };
    }
    /** Compile the java files in this directory and its subdirectories */
    private static void compileJavaFilesInDir(File javadir,File dir)
    {
        File[] files=dir.listFiles(new JavaFilter());
        for (int i=0;i<files.length;i++)
            if (files[i].isDirectory())
                compileJavaFilesInDir(javadir,files[i]);
            else
                compileJavaFile(javadir,files[i]);
    }
    /** Called when the window is closing */
    public void windowClosing(WindowEvent e)
    {
        System.exit(0);
    }
    /** Update the log */
    private static void updateLog(final String message)
    {
        Runnable doWork=new Runnable()
        {
            public void run()
            {
                installog.insert("<"+counter+"> "+message,installog.getDocument().getLength());
            };
        };
        SwingUtilities.invokeLater(doWork);
    }
    /**
     * Start a command and read all its output in a string buffer which is returned as a string,
     * showError indicates we want to give a message in case of any errors
     */
    protected static String startCommand(String command,String[] args,boolean error)
    {
        return startCommand(command,args,null,error);
    }
    protected static String startCommand(String command,String[] args,File file,boolean showError)
    {
        String cmdarray[]=new String[args.length+1];
        StringBuffer output=new StringBuffer();
        StringBuffer result=new StringBuffer();
        
        cmdarray[0]=command;
        System.arraycopy(args,0,cmdarray,1,args.length);
        
        try
        {
            Runtime runtime=Runtime.getRuntime();
            Process process;
            if (file==null)
                process=runtime.exec(cmdarray);
            else
                process=runtime.exec(cmdarray,new String[0],file);
            InputStream input=process.getInputStream();
            InputStream error=process.getErrorStream();
            MergedStream sequence=new MergedStream(error,input);
            int c;
            while ((c=sequence.read())!=-1)
            {
                output.append((char) c);
                if (c=='\n')
                {
                    updateLog(output.toString());
                    result.append(output.toString());
                    output.setLength(0);
                };
            };
            process.waitFor();
            result.append(output.toString());
            updateLog(output.toString()+"\n");
            return result.toString();
        }
        catch (Exception e)
        {
            if (showError)
                showMessage("Error executing "+command,false,0);
        }
        return null;
    }
    /** Show error message */
    private static void showMessage(String message,final boolean exit,final int exitcode)
    {
        final JDialog dialog=new JDialog();
        dialog.setModal(false);
        JPanel content=new JPanel();
        content.setLayout(new BorderLayout());
        JTextArea textarea=new JTextArea(message);
        textarea.setForeground(Color.red);
        textarea.setEditable(false);
        JScrollPane scrollpane=new JScrollPane(textarea);
        JButton ok=new JButton(new AbstractAction("Ok")
        {
            public void actionPerformed(ActionEvent ev)
            {
                //dialog.notifyAll();
                dialog.dispose();
                if (exit)
                    System.exit(exitcode);
            }
        });
        content.add(textarea,BorderLayout.CENTER);
        content.add(ok,BorderLayout.SOUTH);
        dialog.setSize(300,200);
        Rectangle bounds=GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        int x=Math.max(0,(bounds.width-dialog.getWidth())/2);
        int y=Math.max(0,(bounds.height-dialog.getHeight())/2);
        dialog.setLocation(x,y);
        dialog.setContentPane(content);
        dialog.setVisible(true);
        try
        {
            synchronized(dialog)
            {
                dialog.wait();           
            };
        }
        catch (InterruptedException e)
        {
        };
    }
    
    private static String buildWithAnt()
    {
        //Create the build.xml file from the build.template
        try
        {
            BufferedReader model = new BufferedReader(new FileReader("build.template"));
            BufferedWriter xml = new BufferedWriter(new FileWriter("build.xml"));
            String line;
            while ((line=model.readLine()) != null)
            {
                if (line.indexOf("@installHome@") != -1)
                    line = line.replaceFirst("@installHome@", new String(installdir.getText().replaceAll("\\\\","/")));
                else if (line.indexOf("@installBinHome@") != -1)
                    line = line.replaceFirst("@installBinHome@", new String(installbin.getText().replaceAll("\\\\","/")));
                else if (line.indexOf("@scriptFile@") != -1)
                    if (System.getProperty("os.name").startsWith("Windows"))
                        line = line.replaceFirst("@scriptFile@", "Jabberwocky.bat");
                    else
                        line = line.replaceFirst("@scriptFile@", "Jabberwocky");
                else if (line.indexOf("@CLISP BEGIN@") != -1)
                {
                    StringBuffer buffer = new StringBuffer();
                    String clispXml;
                    while ((clispXml=model.readLine()).indexOf("@CLISP END@") == -1)
                        buffer.append(clispXml+System.getProperty("line.separator"));
                    if (clispok.isSelected())
                        line = buffer.toString();
                    else
                        line = "skip";
                }
                else if (line.indexOf("@CMUCL BEGIN@") != -1)
                {
                    StringBuffer buffer = new StringBuffer();
                    String cmuclXml;
                    while ((cmuclXml=model.readLine()).indexOf("@CMUCL END@") == -1)
                        buffer.append(cmuclXml+System.getProperty("line.separator"));
                    if (cmuclok.isSelected())
                        line = buffer.toString();
                    else
                        line = "skip";
                }
                if (!line.equals("skip"))
                {
                    xml.write(line);
                    xml.newLine();
                }
            }
            xml.flush();
            xml.close();
            model.close();
            
        }
        catch (IOException e)
        {
            showMessage("Unable to create build.xml "+e.getMessage(),true,1);
        }
        
        StringBuffer output=new StringBuffer();
        StringBuffer result=new StringBuffer();
        try
        {
            Runtime runtime=Runtime.getRuntime();
            Process process;
            // process=runtime.exec(new String[]{antfield.getText(), "-buildfile", new File("build.xml").getAbsolutePath()},new String[0],null);
            process=runtime.exec(new String[]
            {antfield.getText(), "-buildfile", new File("build.xml").getAbsolutePath()});
            InputStream input=process.getInputStream();
            InputStream error=process.getErrorStream();
            MergedStream sequence=new MergedStream(input,error);
            int c;
            try
            {
                while ((c=sequence.read())!=-1)
                {
                    output.append((char) c);
                    if (c=='\n')
                    {
                        updateLog(output.toString());
                        result.append(output.toString());
                        output.setLength(0);
                    };
                };
                process.waitFor();
                result.append(output.toString());
                updateLog(output.toString()+"\n");
                return result.toString();
                
            }
            catch (IOException e)
            {
                showMessage("Error finding Ant",false,0);
                return "";
            }
        }
        catch (Exception e)
        {
            showMessage("Error executing Ant",false,0);
        }
        return null;
    }
}

/** Filter files to return all directories and files with extension .java  */
class JavaFilter implements FileFilter
{
    public boolean accept(File file)
    {
        int i;
        if (file.isDirectory())
            return true;
        else if (file.isFile() && (i=file.getName().lastIndexOf(".java"))!=-1 && i+5==file.getName().length())
            return true;
        else
            return false;
    }
}
/** Filter files to return all directories and files with extension .java  */
class ClassFilter implements FileFilter
{
    public boolean accept(File file)
    {
        int i;
        if (file.isDirectory())
            return true;
        else if (file.isFile() && (i=file.getName().lastIndexOf(".class"))!=-1 && i+6==file.getName().length())
            return true;
        else
            return false;
    }
}
/** Implementation of a InputStream to read alternatively from two streams */
class MergedStream extends InputStream
{
    // Boolean to indicate that strm1 is fully read
    private boolean endstrm1=false;
    // Boolean to indicate that strm2 is fully read
    private boolean endstrm2=false;
    // Queue containing the read data
    private MergedQueue queue;
    // Constructor of the MergedStream
    public MergedStream(final InputStream strm1,final InputStream strm2)
    {
        queue=new MergedQueue();
        Thread run1=new Thread(new Runnable()
        {
            public void run()
            {
                try
                {
                    int c;
                    while ((c=strm1.read())!=-1)
                        queue.add(c);
                }
                catch (IOException e)
                {
                }
                finally
                {
                    try
                    {
                        strm1.close();
                    }
                    catch (Exception e)
                    {
                    };
                    endstrm1=true;
                };
            }
        });
        Thread run2=new Thread(new Runnable()
        {
            public void run()
            {
                try
                {
                    int c;
                    while ((c=strm2.read())!=-1)
                        queue.add(c);
                }
                catch (IOException e)
                {
                }
                finally
                {
                    try
                    {
                        strm2.close();
                    }
                    catch (Exception e)
                    {
                    };
                    endstrm2=true;
                };
            }
        });
        run1.start();
        run2.start();
    }
    public int read() throws java.io.IOException
    {
        int c;
        try
        {
            while (!((c=queue.read())==-1 && endstrm1 && endstrm2))
            {
                if (c!=-1)
                    return c;
                else
                    Thread.sleep(10);
            }
        }
        catch (InterruptedException e)
        {
        };
        return -1;
    }
}
/** Implements a queue of int to collect the input of two streams */
class MergedQueue
{
    // First element in the queue
    MergedQueueElement first=null;
    // Last element in the queue
    MergedQueueElement last=null;
    // Add a element to the queue
    public synchronized void add(int value)
    {
        MergedQueueElement element=new MergedQueueElement(value);
        if (first==null)
        {
            // Queue is empty
            first=element;
            last=element;
        }
        else
        {
            // Queue is not empty
            last.setNext(element);
            last=element;
        }
    }
    // Get the first value in the queue and remove it form the queue, returns -1 if the queue is empty
    public synchronized int read()
    {
        int result;
        if (first==null)
        {
            return -1;
        }
        else
        {
            if (first.getNext()==null)
            {
                result=first.getValue();
                first=null;
                last=null;
                return result;
            }
            else
            {
                result=first.getValue();
                first=first.getNext();
                return result;
            }
        }
    }
}
/** Element of the MergeQueue */
class MergedQueueElement
{
    // Value of the queue element
    private int value;
    // Next queue element if there is one
    private MergedQueueElement next;
    // Constructor
    public MergedQueueElement(int value)
    {
        this.value=value;
        this.next=null;
    }
    // Get the value
    public int getValue()
    {
        return value;
    }
    // Get the next element
    public MergedQueueElement getNext()
    {
        return next;
    }
    /** Set the next element */
    public void setNext(MergedQueueElement next)
    {
        this.next=next;
    }
    
}
