;;; ****************************************************************************
;;; Is a seed file containing LISP code that automatically gets added to the
;;; automatically generated LISP code that allow you from LISP calls all the
;;; IDE actions and QUESTIONS
;;; ****************************************************************************

;;; ****************************************************************************
;;; All symbols reside in the JABBERWOCKY package
;;; ****************************************************************************

(when (not (find-package "JABBERWOCKY")) (make-package "JABBERWOCKY"))
(in-package "JABBERWOCKY")

;;; ****************************************************************************
;;; Return the current editor (if no argument) or the editor containing the
;;; content of the file with filename filename
;;; ****************************************************************************

(defun get-editor (&optional (filename ""))
  (declare (string filename))
  (if (not (string= filename ""))
      (DEBUGGER::call-java-method DEBUGGER::**connection**
                                  "IDE.LispScripting.LispIDEMethods"
                                  "getEditorByName"
                                  filename)
    (DEBUGGER::call-java-method DEBUGGER::**connection**
                                "IDE.LispScripting.LispIDEMethods"
                                "getCurrentEditor")))

;;; ***************************************************************************
;;; Set the cursor position in the given editor to position
;;; ***************************************************************************

(defun set-cursor (editor position)
  (DEBUGGER::call-java-method-swing DEBUGGER::**connection**
                                    "IDE.LispScripting.LispIDEMethods"
                                    "setCursor"
                                    editor
                                    position))

;;; ***************************************************************************
;;; Get the cursor position in the given editor
;;; ***************************************************************************

(defun get-cursor-offset (editor)
  (DEBUGGER::call-java-method DEBUGGER::**connection**
                              "IDE.LispScripting.LispIDEMethods"
                              "getCursorOffset"
                              editor))

;;; ***************************************************************************
;;; Call a AbstractManagedAction from the IDE with the given name
;;; ***************************************************************************

(defun execute-action (actionname)
  (declare (string actionname))
  (DEBUGGER::call-java-method DEBUGGER::**connection**
                              "IDE.LispScripting.LispIDEMethods"
                              "executeAction"
                              actionname))

;;; ****************************************************************************
;;; Ask a string question via the interaction field
;;; ****************************************************************************

(defun ask-string-question (guidetext callback)
  (declare (string guidetext))
  (DEBUGGER::call-java-method-swing DEBUGGER::**connection**
                                    "IDE.LispScripting.LispIDEMethods"
                                    "askStringQuestion"
                                    guidetext
                                    callback))

;;; ****************************************************************************
;;; Ask a numeric question via the interaction field
;;; ****************************************************************************

(defun ask-number-question (guidetext callback)
  (declare (string guidetext))
  (DEBUGGER::call-java-method-swing DEBUGGER::**connection**
                                    "IDE.LispScripting.LispIDEMethods"
                                    "askNumberQuestion"
                                    guidetext
                                    callback))


;;; ****************************************************************************
;;; For a given editor, get the text from poisition pos with length length
;;; ****************************************************************************

(defun get-text (editor position length)
  (declare (fixnum position length))
  (DEBUGGER::call-java-method DEBUGGER::**connection**
                              "IDE.LispScripting.LispIDEMethods"
                              "getText"
                              editor
                              position
                              length))


;;; ****************************************************************************
;;; Create a action with name,shortdescription.longdescription and lisp callback
;;; function (a function with no arguments)
;;; ****************************************************************************

(defun create-action (name short long function &optional (icon nil))
  (declare (string short long) (function function))
  (if icon
      (DEBUGGER::call-java-method-swing DEBUGGER::**connection**
                                        "IDE.LispScripting.LispIDEMethods"
                                        "createAction"
                                        name
                                        short
                                        long
                                        icon
                                        function)
    (DEBUGGER::call-java-method-swing DEBUGGER::**connection**
                                      "IDE.LispScripting.LispIDEMethods"
                                      "createAction"
                                      name
                                      short
                                      long
                                      function)))

;;; ****************************************************************************
;;; Create a copy of a mode give it name name and returns it
;;; ****************************************************************************

(defun copy-mode (mode name)
  (declare (string mode name))
  (DEBUGGER::call-java-method DEBUGGER::**connection**
                              "IDE.LispScripting.LispIDEMethods"
                              "copyMode"
                              mode
                              name))

;;; ****************************************************************************
;;; Add a action (identified by its name) to a menu for a certain mode
;;; ****************************************************************************

(defun add-action-to-menu (mode action menu)
  (declare (string mode menu action))
  (DEBUGGER::call-java-method-swing DEBUGGER::**connection**
                                    "IDE.LispScripting.LispIDEMethods"
                                    "addActionToMenu"
                                    mode
                                    action
                                    menu))

;;; ****************************************************************************
;;; Add a separator to a menu for a certain mode
;;; ****************************************************************************

(defun add-separator-to-menu (mode menu)
  (declare (string mode menu))
  (DEBUGGER::call-java-method-swing DEBUGGER::**connection**
                                    "IDE.LispScripting.LispIDEMethods"
                                    "addSeparatorToMenu"
                                    mode
                                    menu))

;;; ****************************************************************************
;;; Add a checkbox to a menu for a certain action for a given mode
;;; ****************************************************************************

(defun add-checkbox-to-menu (mode action menu enabled)
  (declare (string mode action menu) (boolean enabled))
  (DEBUGGER::call-java-method-swing DEBUGGER::**connection**
                                    "IDE.LispScripting.LispIDEMethods"
                                    "addCheckBoxToMenu"
                                    mode
                                    action
                                    menu
                                    enabled))

;;; ***************************************************************************
;;; Add a separator to a popupmenu for a given mode
;;; ***************************************************************************


(defun add-separator-to-popup-menu (mode menu)
  (declare (string mode menu))
  (DEBUGGER::call-java-method-swing DEBUGGER::**connection**
                                    "IDE.LispScripting.LispIDEMethods"
                                    "addSeparatorToPopupMenu"
                                    mode
                                    menu))
;;; ***************************************************************************
;;; Add a action to a popupmenu for a given mode
;;; ***************************************************************************


(defun add-action-to-popup-menu (mode menu action)
  (declare (string mode menu action))
  (DEBUGGER::call-java-method-swing DEBUGGER::**connection**
                                    "IDE.LispScripting.LispIDEMethods"
                                    "addActionToPopupMenu"
                                    mode
                                    action
                                    menu))

;;; *************************************************************************
;;; Creates a key sequence based on a list of the form
;;; keycode modifiers keycode modifiers ....
;;; *************************************************************************

(defun create-key-sequence (&rest keys)
  (cond ((not (listp keys)) (DEBUGGER::message
                             "Wrong arguments for create-key-sequence"
                             :warn
                             T)
                            nil)
        ((not (evenp (length keys)))
         (DEBUGGER::message
          "Argument list is no of the form keycode modifiers ..."
          :warn
          T)
         nil)
        (T (do ((array (make-array (/ (length keys) 2))) 
                (i 0 (1+ i))
                (keystroke (make-array 2) (make-array 2)))
               ((= i (length array)) (DEBUGGER::call-java-method
                                      DEBUGGER::**connection**
                                      "IDE.LispScripting.LispIDEMethods"
                                      "createKeySequence"
                                      array))
             (setf (aref keystroke 0) (pop keys))
             (setf (aref keystroke 1) (pop keys))
             (setf (aref array i) keystroke)))))



;;; ***************************************************************************
;;; Bind a action to a key for a certain mode
;;; ***************************************************************************


(defun bind-action-to-key-sequence (mode action keysequence)
  (declare (string mode action))
  (DEBUGGER::call-java-method DEBUGGER::**connection**
                              "IDE.LispScripting.LispIDEMethods"
                              "bindActionToKeySequence"
                              mode
                              action
                              keysequence))


;;; ************************************************************************
;;; Create a button in the button panel for a mode and action
;;; ************************************************************************

(defun add-button (mode action)
  (declare (string mode action))
  (DEBUGGER::call-java-method-swing DEBUGGER::**connection**
                                    "IDE.LispScripting.LispIDEMethods"
                                    "addButton"
                                    mode
                                    action))

;;; ************************************************************************
;;; Make the given editor the current editor
;;; ************************************************************************

(defun set-current-editor (editor)
  (DEBUGGER::call-java-method-swing DEBUGGER::**connection**
                                    "IDE.LispScripting.LispIDEMethods"
                                    "setCurrentEditor"
                                    editor))

;;; ***********************************************************************
;;; Create a editor (if file name is given load the file with the filename
;;; in the editor
;;; ***********************************************************************

(defun create-editor (&optional (filename ""))
  (declare (string filename))
  (if (not (string= filename ""))
      (DEBUGGER::call-java-method-swing DEBUGGER::**connection**
                                        "IDE.LispScripting.LispIDEMethods"
                                        "createEditor"
                                        filename)
    (DEBUGGER::call-java-method-swing DEBUGGER::**connection**
                                      "IDE.LispScripting.LispIDEMethods"
                                      "createEditor")))
    

;;; ***************************************************************************
;;; Create a icon for the given file name 
;;; ***************************************************************************

(defun create-icon (filename)
  (declare (string filename))
  (DEBUGGER::call-java-method-swing DEBUGGER::**connection**
                                    "IDE.LispScripting.LispIDEMethods"
                                    "createIcon"
                                    filename))

;;; ***************************************************************************
;;; Insert a text in editor at the given position
;;; ***************************************************************************

(defun insert-text (editor position text)
  (declare (string text) (fixnum position))
  (DEBUGGER::call-java-method-swing DEBUGGER::**connection**
                                    "IDE.LispScripting.LispIDEMethods"
                                    "insertText"
                                    editor
                                    position
                                    text))

;;; ***************************************************************************
;;; Remove a piece of text from a editor with length length and starting at 
;;; position position
;;; ***************************************************************************

(defun remove-text (editor position length)
  (declare (fixnum position))
  (DEBUGGER::call-java-method-swing DEBUGGER::**connection**
                                    "IDE.LispScripting.LispIDEMethods"
                                    "removeText"
                                    editor
                                    position
                                    length))

;;; **************************************************************************
;;; Do a search for a regular expression in the text (case sensitive or no) and
;;; returns the position (or -1 if not found) and a matcher which can be used 
;;; for the next search
;;; ***************************************************************************

(defun search-text (editor regexp case position)
  (declare (string regexp) (boolean case) (fixnum position))
  (let ((matcher (DEBUGGER::call-java-method-swing DEBUGGER::**connection**
                                                   "IDE.LispScripting.LispIDEMethods"
                                                   "regularExpressionSearch"
                                                   editor
                                                   regexp
                                                   case)))
    (values (DEBUGGER::call-java-method DEBUGGER::**connection**
                  "IDE.LispScripting.LispIDEMethods"
                  "matcherFind"
                           matcher
                  position)
         matcher)))
;;; ******************************************************************************
;;; Search for the next occurance of the regular expression
;;; ******************************************************************************

(defun search-next (matcher &optional (position -1))
  (declare (fixnum position))
  (if (>= position 0)
      (DEBUGGER::call-java-method DEBUGGER::**connection**
                                      "IDE.LispScripting.LispIDEMethods"
                                      "matcherFind"
                                      matcher
                                      position)
    (DEBUGGER::call-java-method DEBUGGER::**connection**
                                "IDE.LispScripting.LispIDEMethods"
                                "matcherFind"
                                matcher)))




;;; ***************************************************************
;;; Generated code by Jabberwocky 
;;; ***************************************************************
(defconstant **key-first** 400)
(defconstant **key-last** 402)
(defconstant **key-typed** 400)
(defconstant **key-pressed** 401)
(defconstant **key-released** 402)
(defconstant **vk-enter** 10)
(defconstant **vk-back-space** 8)
(defconstant **vk-tab** 9)
(defconstant **vk-cancel** 3)
(defconstant **vk-clear** 12)
(defconstant **vk-shift** 16)
(defconstant **vk-control** 17)
(defconstant **vk-alt** 18)
(defconstant **vk-pause** 19)
(defconstant **vk-caps-lock** 20)
(defconstant **vk-escape** 27)
(defconstant **vk-space** 32)
(defconstant **vk-page-up** 33)
(defconstant **vk-page-down** 34)
(defconstant **vk-end** 35)
(defconstant **vk-home** 36)
(defconstant **vk-left** 37)
(defconstant **vk-up** 38)
(defconstant **vk-right** 39)
(defconstant **vk-down** 40)
(defconstant **vk-comma** 44)
(defconstant **vk-minus** 45)
(defconstant **vk-period** 46)
(defconstant **vk-slash** 47)
(defconstant **vk-0** 48)
(defconstant **vk-1** 49)
(defconstant **vk-2** 50)
(defconstant **vk-3** 51)
(defconstant **vk-4** 52)
(defconstant **vk-5** 53)
(defconstant **vk-6** 54)
(defconstant **vk-7** 55)
(defconstant **vk-8** 56)
(defconstant **vk-9** 57)
(defconstant **vk-semicolon** 59)
(defconstant **vk-equals** 61)
(defconstant **vk-a** 65)
(defconstant **vk-b** 66)
(defconstant **vk-c** 67)
(defconstant **vk-d** 68)
(defconstant **vk-e** 69)
(defconstant **vk-f** 70)
(defconstant **vk-g** 71)
(defconstant **vk-h** 72)
(defconstant **vk-i** 73)
(defconstant **vk-j** 74)
(defconstant **vk-k** 75)
(defconstant **vk-l** 76)
(defconstant **vk-m** 77)
(defconstant **vk-n** 78)
(defconstant **vk-o** 79)
(defconstant **vk-p** 80)
(defconstant **vk-q** 81)
(defconstant **vk-r** 82)
(defconstant **vk-s** 83)
(defconstant **vk-t** 84)
(defconstant **vk-u** 85)
(defconstant **vk-v** 86)
(defconstant **vk-w** 87)
(defconstant **vk-x** 88)
(defconstant **vk-y** 89)
(defconstant **vk-z** 90)
(defconstant **vk-open-bracket** 91)
(defconstant **vk-back-slash** 92)
(defconstant **vk-close-bracket** 93)
(defconstant **vk-numpad0** 96)
(defconstant **vk-numpad1** 97)
(defconstant **vk-numpad2** 98)
(defconstant **vk-numpad3** 99)
(defconstant **vk-numpad4** 100)
(defconstant **vk-numpad5** 101)
(defconstant **vk-numpad6** 102)
(defconstant **vk-numpad7** 103)
(defconstant **vk-numpad8** 104)
(defconstant **vk-numpad9** 105)
(defconstant **vk-multiply** 106)
(defconstant **vk-add** 107)
(defconstant **vk-separater** 108)
(defconstant **vk-separator** 108)
(defconstant **vk-subtract** 109)
(defconstant **vk-decimal** 110)
(defconstant **vk-divide** 111)
(defconstant **vk-delete** 127)
(defconstant **vk-num-lock** 144)
(defconstant **vk-scroll-lock** 145)
(defconstant **vk-f1** 112)
(defconstant **vk-f2** 113)
(defconstant **vk-f3** 114)
(defconstant **vk-f4** 115)
(defconstant **vk-f5** 116)
(defconstant **vk-f6** 117)
(defconstant **vk-f7** 118)
(defconstant **vk-f8** 119)
(defconstant **vk-f9** 120)
(defconstant **vk-f10** 121)
(defconstant **vk-f11** 122)
(defconstant **vk-f12** 123)
(defconstant **vk-f13** 61440)
(defconstant **vk-f14** 61441)
(defconstant **vk-f15** 61442)
(defconstant **vk-f16** 61443)
(defconstant **vk-f17** 61444)
(defconstant **vk-f18** 61445)
(defconstant **vk-f19** 61446)
(defconstant **vk-f20** 61447)
(defconstant **vk-f21** 61448)
(defconstant **vk-f22** 61449)
(defconstant **vk-f23** 61450)
(defconstant **vk-f24** 61451)
(defconstant **vk-printscreen** 154)
(defconstant **vk-insert** 155)
(defconstant **vk-help** 156)
(defconstant **vk-meta** 157)
(defconstant **vk-back-quote** 192)
(defconstant **vk-quote** 222)
(defconstant **vk-kp-up** 224)
(defconstant **vk-kp-down** 225)
(defconstant **vk-kp-left** 226)
(defconstant **vk-kp-right** 227)
(defconstant **vk-dead-grave** 128)
(defconstant **vk-dead-acute** 129)
(defconstant **vk-dead-circumflex** 130)
(defconstant **vk-dead-tilde** 131)
(defconstant **vk-dead-macron** 132)
(defconstant **vk-dead-breve** 133)
(defconstant **vk-dead-abovedot** 134)
(defconstant **vk-dead-diaeresis** 135)
(defconstant **vk-dead-abovering** 136)
(defconstant **vk-dead-doubleacute** 137)
(defconstant **vk-dead-caron** 138)
(defconstant **vk-dead-cedilla** 139)
(defconstant **vk-dead-ogonek** 140)
(defconstant **vk-dead-iota** 141)
(defconstant **vk-dead-voiced-sound** 142)
(defconstant **vk-dead-semivoiced-sound** 143)
(defconstant **vk-ampersand** 150)
(defconstant **vk-asterisk** 151)
(defconstant **vk-quotedbl** 152)
(defconstant **vk-less** 153)
(defconstant **vk-greater** 160)
(defconstant **vk-braceleft** 161)
(defconstant **vk-braceright** 162)
(defconstant **vk-at** 512)
(defconstant **vk-colon** 513)
(defconstant **vk-circumflex** 514)
(defconstant **vk-dollar** 515)
(defconstant **vk-euro-sign** 516)
(defconstant **vk-exclamation-mark** 517)
(defconstant **vk-inverted-exclamation-mark** 518)
(defconstant **vk-left-parenthesis** 519)
(defconstant **vk-number-sign** 520)
(defconstant **vk-plus** 521)
(defconstant **vk-right-parenthesis** 522)
(defconstant **vk-underscore** 523)
(defconstant **vk-final** 24)
(defconstant **vk-convert** 28)
(defconstant **vk-nonconvert** 29)
(defconstant **vk-accept** 30)
(defconstant **vk-modechange** 31)
(defconstant **vk-kana** 21)
(defconstant **vk-kanji** 25)
(defconstant **vk-alphanumeric** 240)
(defconstant **vk-katakana** 241)
(defconstant **vk-hiragana** 242)
(defconstant **vk-full-width** 243)
(defconstant **vk-half-width** 244)
(defconstant **vk-roman-characters** 245)
(defconstant **vk-all-candidates** 256)
(defconstant **vk-previous-candidate** 257)
(defconstant **vk-code-input** 258)
(defconstant **vk-japanese-katakana** 259)
(defconstant **vk-japanese-hiragana** 260)
(defconstant **vk-japanese-roman** 261)
(defconstant **vk-kana-lock** 262)
(defconstant **vk-input-method-on-off** 263)
(defconstant **vk-cut** 65489)
(defconstant **vk-copy** 65485)
(defconstant **vk-paste** 65487)
(defconstant **vk-undo** 65483)
(defconstant **vk-again** 65481)
(defconstant **vk-find** 65488)
(defconstant **vk-props** 65482)
(defconstant **vk-stop** 65480)
(defconstant **vk-compose** 65312)
(defconstant **vk-alt-graph** 65406)
(defconstant **vk-undefined** 0)
(defconstant **key-location-unknown** 0)
(defconstant **key-location-standard** 1)
(defconstant **key-location-left** 2)
(defconstant **key-location-right** 3)
(defconstant **key-location-numpad** 4)
(defconstant **shift-mask** 1)
(defconstant **ctrl-mask** 2)
(defconstant **meta-mask** 4)
(defconstant **alt-mask** 8)
(defconstant **alt-graph-mask** 32)
(defconstant **button1-mask** 16)
(defconstant **button2-mask** 8)
(defconstant **button3-mask** 4)
(defconstant **shift-down-mask** 64)
(defconstant **ctrl-down-mask** 128)
(defconstant **meta-down-mask** 256)
(defconstant **alt-down-mask** 512)
(defconstant **button1-down-mask** 1024)
(defconstant **button2-down-mask** 2048)
(defconstant **button3-down-mask** 4096)
(defconstant **alt-graph-down-mask** 8192)
(defconstant **component-first** 100)
(defconstant **component-last** 103)
(defconstant **component-moved** 100)
(defconstant **component-resized** 101)
(defconstant **component-shown** 102)
(defconstant **component-hidden** 103)
(defconstant **reserved-id-max** 1999)
;;; ***************************************************************
;;; Functions to execute a action 
;;; ***************************************************************

(defun IDE-addproject ()
    (execute-action "addproject"))

(defun IDE-addwatch ()
    (execute-action "addwatch"))

(defun IDE-backspace ()
    (execute-action "backspace"))

(defun IDE-blinkingrate ()
    (execute-action "blinkingrate"))

(defun IDE-charactercompletion ()
    (execute-action "charactercompletion"))

(defun IDE-clickprojectsetcurrentdirectory ()
    (execute-action "clickProjectSetCurrentDirectory"))

(defun IDE-clispbug ()
    (execute-action "clispbug"))

(defun IDE-close ()
    (execute-action "close"))

(defun IDE-colorarray ()
    (execute-action "colorarray"))

(defun IDE-colorbackground ()
    (execute-action "colorbackground"))

(defun IDE-colorbackgroundline ()
    (execute-action "colorbackgroundline"))

(defun IDE-colorbackquote ()
    (execute-action "colorbackquote"))

(defun IDE-colorbreakpoint ()
    (execute-action "colorbreakpoint"))

(defun IDE-colorcaller ()
    (execute-action "colorcaller"))

(defun IDE-colorcharacter ()
    (execute-action "colorcharacter"))

(defun IDE-colorcomment ()
    (execute-action "colorcomment"))

(defun IDE-colorcursor ()
    (execute-action "colorcursor"))

(defun IDE-colorendline ()
    (execute-action "colorendline"))

(defun IDE-colorexecutedcode ()
    (execute-action "colorexecutedcode"))

(defun IDE-colorexecutingcode ()
    (execute-action "colorexecutingcode"))

(defun IDE-colorforeground ()
    (execute-action "colorforeground"))

(defun IDE-colorforegroundline ()
    (execute-action "colorforegroundline"))

(defun IDE-colorhint ()
    (execute-action "colorhint"))

(defun IDE-colorhook ()
    (execute-action "colorhook"))

(defun IDE-colorkeyword ()
    (execute-action "colorkeyword"))

(defun IDE-colorlist ()
    (execute-action "colorlist"))

(defun IDE-colornextstop ()
    (execute-action "colornextstop"))

(defun IDE-colorprofiling ()
    (execute-action "colorprofiling"))

(defun IDE-colorquote ()
    (execute-action "colorquote"))

(defun IDE-colorsearch ()
    (execute-action "colorsearch"))

(defun IDE-colorselected ()
    (execute-action "colorselected"))

(defun IDE-colorselection ()
    (execute-action "colorselection"))

(defun IDE-colorstring ()
    (execute-action "colorstring"))

(defun IDE-colorvariable ()
    (execute-action "colorvariable"))

(defun IDE-commandhistorylength ()
    (execute-action "commandhistorylength"))

(defun IDE-commentfont ()
    (execute-action "commentfont"))

(defun IDE-compileeditor ()
    (execute-action "compileeditor"))

(defun IDE-continue ()
    (execute-action "continue"))

(defun IDE-copy ()
    (execute-action "copy"))

(defun IDE-cut ()
    (execute-action "cut"))

(defun IDE-deadkeymanagment ()
    (execute-action "deadkeymanagment"))

(defun IDE-debug ()
    (execute-action "debug"))

(defun IDE-debugform ()
    (execute-action "debugform"))

(defun IDE-defaultfont ()
    (execute-action "defaultfont"))

(defun IDE-delete ()
    (execute-action "delete"))

(defun IDE-deletecurrentelement ()
    (execute-action "deletecurrentelement"))

(defun IDE-deletecurrentleaf ()
    (execute-action "deletecurrentleaf"))

(defun IDE-deleteinteraction ()
    (execute-action "deleteinteraction"))

(defun IDE-deleteline ()
    (execute-action "deleteline"))

(defun IDE-deletetoplevelelement ()
    (execute-action "deletetoplevelelement"))

(defun IDE-deletewatch ()
    (execute-action "deletewatch"))

(defun IDE-displayversion ()
    (execute-action "displayversion"))

(defun IDE-down ()
    (execute-action "down"))

(defun IDE-editextensions ()
    (execute-action "editextensions"))

(defun IDE-editwatch ()
    (execute-action "editwatch"))

(defun IDE-execute ()
    (execute-action "execute"))

(defun IDE-exit ()
    (execute-action "exit"))

(defun IDE-explorerfont ()
    (execute-action "explorerfont"))

(defun IDE-findandreplace ()
    (execute-action "findandreplace"))

(defun IDE-future ()
    (execute-action "future"))

(defun IDE-generatehtmlcode ()
    (execute-action "generatehtmlcode"))

(defun IDE-generatelispcode ()
    (execute-action "generatelispcode"))

(defun IDE-gotoline ()
    (execute-action "gotoline"))

(defun IDE-help ()
    (execute-action "help"))

(defun IDE-highlightlist ()
    (execute-action "highlightlist"))

(defun IDE-hintdown ()
    (execute-action "hintdown"))

(defun IDE-hintup ()
    (execute-action "hintup"))

(defun IDE-hovertimeout ()
    (execute-action "hovertimeout"))

(defun IDE-hyperspec ()
    (execute-action "hyperspec"))

(defun IDE-hyperspeccontext ()
    (execute-action "hyperspeccontext"))

(defun IDE-hyperspecdir ()
    (execute-action "hyperspecdir"))

(defun IDE-indentate ()
    (execute-action "indentate"))

(defun IDE-indentatedocument ()
    (execute-action "indentatedocument"))

(defun IDE-indentateelement ()
    (execute-action "indentateelement"))

(defun IDE-indentateonenter ()
    (execute-action "indentateonenter"))

(defun IDE-instrumentcheckerror ()
    (execute-action "instrumentcheckerror"))

(defun IDE-instrumentdebugafter ()
    (execute-action "instrumentdebugafter"))

(defun IDE-keybinding ()
    (execute-action "keybinding"))

(defun IDE-left ()
    (execute-action "left"))

(defun IDE-linenumbers ()
    (execute-action "linenumbers"))

(defun IDE-lispstartupscript ()
    (execute-action "lispstartupscript"))

(defun IDE-loadconfiguration ()
    (execute-action "loadconfiguration"))

(defun IDE-loadeditor ()
    (execute-action "loadeditor"))

(defun IDE-macrosfont ()
    (execute-action "macrosfont"))

(defun IDE-maxlinelength ()
    (execute-action "maxlinelength"))

(defun IDE-movetobeginline ()
    (execute-action "movetobeginline"))

(defun IDE-movetobeginlist ()
    (execute-action "movetobeginlist"))

(defun IDE-movetoendline ()
    (execute-action "movetoendline"))

(defun IDE-movetoendlist ()
    (execute-action "movetoendlist"))

(defun IDE-movetonextleaf ()
    (execute-action "movetonextleaf"))

(defun IDE-movetoprevleaf ()
    (execute-action "movetoprevleaf"))

(defun IDE-new ()
    (execute-action "new"))

(defun IDE-newinteractionclisp ()
    (execute-action "newinteractionclisp"))

(defun IDE-newinteractioncmucl ()
    (execute-action "newinteractioncmucl"))

(defun IDE-newwatch ()
    (execute-action "newwatch"))

(defun IDE-next ()
    (execute-action "next"))

(defun IDE-open ()
    (execute-action "open"))

(defun IDE-pagedown ()
    (execute-action "pagedown"))

(defun IDE-pageup ()
    (execute-action "pageup"))

(defun IDE-past ()
    (execute-action "past"))

(defun IDE-paste ()
    (execute-action "paste"))

(defun IDE-redo ()
    (execute-action "redo"))

(defun IDE-remove ()
    (execute-action "remove"))

(defun IDE-removewatch ()
    (execute-action "removewatch"))

(defun IDE-replacebyhint ()
    (execute-action "replacebyhint"))

(defun IDE-replaceeditor ()
    (execute-action "replaceeditor"))

(defun IDE-replayrecording ()
    (execute-action "replayrecording"))

(defun IDE-right ()
    (execute-action "right"))

(defun IDE-save ()
    (execute-action "save"))

(defun IDE-saveas ()
    (execute-action "saveas"))

(defun IDE-saveconfiguration ()
    (execute-action "saveconfiguration"))

(defun IDE-searchandreplace ()
    (execute-action "searchandreplace"))

(defun IDE-searchbackward ()
    (execute-action "searchbackward"))

(defun IDE-searchforward ()
    (execute-action "searchforward"))

(defun IDE-selectcommand ()
    (execute-action "selectcommand"))

(defun IDE-selectcurrentelement ()
    (execute-action "selectcurrentelement"))

(defun IDE-selectcurrentleaf ()
    (execute-action "selectcurrentleaf"))

(defun IDE-selectline ()
    (execute-action "selectline"))

(defun IDE-selecttoplevelelement ()
    (execute-action "selecttoplevelelement"))

(defun IDE-setbrowser ()
    (execute-action "setbrowser"))

(defun IDE-setcurrentdirectory ()
    (execute-action "setcurrentdirectory"))

(defun IDE-setlookandfeel ()
    (execute-action "setlookandfeel"))

(defun IDE-setnewreturnvalue ()
    (execute-action "setnewreturnvalue"))

(defun IDE-shortenselection ()
    (execute-action "shortenselection"))

(defun IDE-sigcont ()
    (execute-action "sigcont"))

(defun IDE-sigint ()
    (execute-action "sigint"))

(defun IDE-sigkill ()
    (execute-action "sigkill"))

(defun IDE-sigquit ()
    (execute-action "sigquit"))

(defun IDE-sigstop ()
    (execute-action "sigstop"))

(defun IDE-splithorizontal ()
    (execute-action "splithorizontal"))

(defun IDE-splitvertical ()
    (execute-action "splitvertical"))

(defun IDE-startprofiling ()
    (execute-action "startprofiling"))

(defun IDE-startrecording ()
    (execute-action "startrecording"))

(defun IDE-stepinto ()
    (execute-action "stepinto"))

(defun IDE-stepover ()
    (execute-action "stepover"))

(defun IDE-stopafter ()
    (execute-action "stopafter"))

(defun IDE-stopat ()
    (execute-action "stopat"))

(defun IDE-stopprofiling ()
    (execute-action "stopprofiling"))

(defun IDE-stoprecording ()
    (execute-action "stoprecording"))

(defun IDE-switch ()
    (execute-action "switch"))

(defun IDE-tabwidth ()
    (execute-action "tabwidth"))

(defun IDE-timeoutstopprocess ()
    (execute-action "timeoutstopprocess"))

(defun IDE-togglebreakpoint ()
    (execute-action "togglebreakpoint"))

(defun IDE-togglecondbreakpoint ()
    (execute-action "togglecondbreakpoint"))

(defun IDE-togglehint ()
    (execute-action "togglehint"))

(defun IDE-undebug ()
    (execute-action "undebug"))

(defun IDE-undo ()
    (execute-action "undo"))

(defun IDE-up ()
    (execute-action "up"))

(defun IDE-watchesfont ()
    (execute-action "watchesfont"))

(defun IDE-watchleaf ()
    (execute-action "watchleaf"))

(defun IDE-widenselection ()
    (execute-action "widenselection"))
