/*
 * Decompiled with CFR 0.152.
 */
package Install;

import Install.Install;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;

public class OsSystem {
    private static final int OS_WINDOWS = 0;
    private static final int OS_UNIX = 1;

    public static String getDefaultInstallDir() {
        if (OsSystem.getOsVariant() == 0) {
            return String.valueOf(OsSystem.getRootDrive()) + ":\\Program Files\\Jabberwocky";
        }
        return "/usr/local/Jabberwocky";
    }

    public static String getStartupDirectory() {
        if (OsSystem.getOsVariant() == 0) {
            return String.valueOf(OsSystem.getRootDrive()) + ":\\Program Files\\Jabberwocky";
        }
        return "/usr/local/bin";
    }

    protected static String getStartupFile() {
        if (OsSystem.getOsVariant() == 0) {
            return "Jabberwocky.bat";
        }
        return "Jabberwocky";
    }

    public static String getSourceDirectory() {
        return System.getProperty("user.dir");
    }

    public static String getCmuclCommand() {
        if (OsSystem.getOsVariant() == 0) {
            return "";
        }
        return "lisp";
    }

    public static String getClispCommand() {
        if (OsSystem.getOsVariant() == 0) {
            return new File(new File(System.getProperty("user.home")).getParentFile().getAbsolutePath(), "All Users\\Desktop\\Clisp.bat").getAbsolutePath();
        }
        return "clisp";
    }

    public static String getAclCommand() {
        if (OsSystem.getOsVariant() == 0) {
            return "";
        }
        return "mlisp";
    }

    public static String getAntCommand() {
        if (OsSystem.getOsVariant() == 0) {
            return new File(new File(System.getProperty("user.home")).getParentFile().getAbsolutePath(), "All Users\\Desktop\\Ant.bat").getAbsolutePath();
        }
        return "ant";
    }

    private static char getRootDrive() {
        String rootdir = OsSystem.execCommand("cmd /c echo %SystemRoot%");
        if (rootdir.length() == 0) {
            return 'C';
        }
        return rootdir.charAt(0);
    }

    public static void registerJabberwocky() {
        if (OsSystem.getOsVariant() == 1) {
            OsSystem.registerJabberwockyUnix();
        } else {
            OsSystem.registerJabberwockyWindows();
        }
    }

    private static void registerJabberwockyUnix() {
        OsSystem.setRights(new File(Install.getInstallbinDir(), OsSystem.getStartupFile()));
    }

    private static void registerJabberwockyWindows() {
        if (System.getProperty("os.name").indexOf("95") == -1 && System.getProperty("os.name").indexOf("98") == -1 && System.getProperty("os.name").indexOf("Me") == -1) {
            OsSystem.registerJabberwockyWindowsNT();
        } else {
            OsSystem.registerJabberwockyWindows9x();
        }
    }

    private static void registerJabberwockyWindowsNT() {
        File register = new File(OsSystem.getSourceDirectory() + File.separator + "register.bat");
        File uninstall = new File(Install.getInstallDir() + File.separator + "uninstall.bat");
        String menudir = new File(new File(System.getProperty("user.home")).getParentFile().getAbsolutePath(), "All Users\\Start Menu\\Programs\\Jabberwocky").getAbsolutePath();
        try {
            if (register.exists()) {
                register.delete();
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(register));
            writer.write("REM Generated code to register Jabberwocky in Windows\r\n");
            writer.write("REM Adding menu entry\r\n");
            writer.write("mkdir \"" + menudir + "\"\r\n");
            writer.write("copy jabberwocky.bat \"" + menudir + "\"\r\n");
            writer.write("REM Adding undo information\r\n");
            writer.write("REG ADD HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\Jabberwocky\r\n");
            writer.write("REG ADD HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\Jabberwocky /f /v DisplayName /t REG_SZ /d \"Jabberwocky Uninstall\"\r\n");
            writer.write("REG ADD HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\Jabberwocky /f /v UninstallString /t REG_SZ /d \"" + uninstall.getAbsolutePath() + "\"\r\n");
            writer.write("exit");
            writer.close();
            if (uninstall.exists()) {
                uninstall.delete();
            }
            writer = new BufferedWriter(new FileWriter(uninstall));
            writer.write("REM Generated code to uninstall Jabberwocky in Windows\r\n");
            writer.write("REM Removing registry entries\r\n");
            writer.write("REG DELETE HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\Jabberwocky /va /f\r\n");
            writer.write("REG DELETE HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\Jabberwocky /f\r\n");
            writer.write("REM Remove the menu entries\r\n");
            writer.write("RMDIR /S /Q \"" + menudir + "\"\r\n");
            writer.write("REM Delete the Jabberwocky bin directory\r\n");
            writer.write("RMDIR /S /Q \"" + Install.getInstallbinDir() + "\"\r\n");
            writer.write("REM Delete the Jabberwocky installation dir\r\n");
            writer.write("RMDIR /S /Q \"" + Install.getInstallDir() + "\"\r\n");
            writer.write("exit");
            writer.close();
            Install.startCommand(register.getAbsolutePath(), new String[0], true);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private static void registerJabberwockyWindows9x() {
        File register = new File(OsSystem.getSourceDirectory() + File.separator + "register.bat");
        File registerInfo = new File(OsSystem.getSourceDirectory() + File.separator + "registerInfo.txt");
        File unregisterInfo = new File(OsSystem.getSourceDirectory() + File.separator + "unregisterInfo.txt");
        File uninstall = new File(Install.getInstallDir() + File.separator + "uninstall.bat");
        String menudir = new File(new File(System.getProperty("user.home")).getParentFile().getAbsolutePath(), "\\Windows\\Start Menu\\Programs\\Jabberwocky").getAbsolutePath();
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(registerInfo));
            writer.write("REGEDIT4\r\n");
            writer.write("\r\n");
            writer.write("[HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\Jabberwocky]\r\n");
            writer.write("\"UninstallString\"=\"" + new String(uninstall.getAbsolutePath().replaceAll("\\\\", "\\\\\\\\")) + "\"\r\n");
            writer.write("\"DisplayName\"=\"Jabberwocky Uninstall\"\r\n");
            writer.flush();
            writer.close();
            writer = new BufferedWriter(new FileWriter(unregisterInfo));
            writer.write("REGEDIT4\r\n");
            writer.write("\r\n");
            writer.write("[-HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\Jabberwocky]\r\n");
            writer.flush();
            writer.close();
            if (register.exists()) {
                register.delete();
            }
            writer = new BufferedWriter(new FileWriter(register));
            writer.write("REM Generated code to register Jabberwocky in Windows\r\n");
            writer.write("REM Adding menu entry\r\n");
            writer.write("mkdir \"" + menudir + "\"\r\n");
            writer.write("copy jabberwocky.bat \"" + menudir + "\"\r\n");
            writer.write("REM Adding undo information\r\n");
            writer.write("regedit /s registerInfo.txt\r\n");
            writer.write("REM copying unregister information to installation directory\r\n");
            writer.write("copy unregisterInfo.txt \"" + Install.getInstallDir() + "\"\r\n");
            writer.write("exit");
            writer.close();
            if (uninstall.exists()) {
                uninstall.delete();
            }
            writer = new BufferedWriter(new FileWriter(uninstall));
            writer.write("REM Generated code to uninstall Jabberwocky in Windows\r\n");
            writer.write("REM Remove the menu entries\r\n");
            writer.write("deltree /Y \"" + menudir + "\"\r\n");
            writer.write("REM Removing registry entries\r\n");
            writer.write("regedit /s \"" + Install.getInstallDir() + "\\unregisterInfo.txt\"\r\n");
            writer.write("REM Delete the Jabberwocky bin directory\r\n");
            writer.write("deltree /Y \"" + Install.getInstallbinDir() + "\"\r\n");
            writer.write("REM Delete the Jabberwocky installation dir\r\n");
            writer.write("deltree /Y \"" + Install.getInstallDir() + "\"\r\n");
            writer.write("exit");
            writer.close();
            Install.startCommand(register.getAbsolutePath(), new String[0], true);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private static String execCommand(String cmd) {
        try {
            int c;
            StringBuffer buffer = new StringBuffer();
            InputStream strm = Runtime.getRuntime().exec(cmd).getInputStream();
            while ((c = strm.read()) != -1) {
                buffer.append((char)c);
            }
            for (int i = buffer.length() - 1; i >= 0 && buffer.charAt(i) == '\n' || buffer.charAt(i) == '\r' || buffer.charAt(i) == ' '; --i) {
                buffer.deleteCharAt(i);
            }
            return buffer.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    private static String escapeString(String str) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '\\') {
                buffer.append('\\');
            }
            buffer.append(str.charAt(i));
        }
        return buffer.toString();
    }

    private static boolean setRights(File file) {
        if (OsSystem.getOsVariant() == 1) {
            try {
                Runtime runtime = Runtime.getRuntime();
                Process process = runtime.exec("chmod a+rx " + file.getAbsolutePath());
                process.waitFor();
                return process.exitValue() == 0;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public static String getHomeDir() {
        return System.getProperty("user.home");
    }

    private static int getOsVariant() {
        if (System.getProperty("os.name").startsWith("Windows")) {
            return 0;
        }
        return 1;
    }

    private static String correctBackslashes(String filename) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < filename.length(); ++i) {
            if (filename.charAt(i) == '\\') {
                buffer.append("\\\\");
                continue;
            }
            buffer.append(filename.charAt(i));
        }
        return buffer.toString();
    }

    public static String correctPathName(String pathname) {
        if (OsSystem.getOsVariant() == 0) {
            return OsSystem.correctBackslashes(pathname);
        }
        return pathname;
    }

    public static boolean setXORModeHasBug() {
        return OsSystem.getOsVariant() == 0 && System.getProperty("java.version").compareTo("1.4.1") < 0;
    }

    public static boolean processManagmentIsPossible() {
        return OsSystem.getOsVariant() == 1;
    }

    public static void main(String[] args) {
        System.out.println(OsSystem.getDefaultInstallDir());
        System.out.println(OsSystem.getHomeDir());
    }
}

