/*
 * Decompiled with CFR 0.152.
 */
package Install;

import Install.ClassFilter;
import Install.JavaFilter;
import Install.MergedStream;
import Install.OsSystem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class Install
extends WindowAdapter {
    private static boolean TestACL = false;
    private static boolean compilejava = true;
    private static int counter = 0;
    private static JTextArea installog;
    private static JCheckBox cmuclok;
    private static JCheckBox clispok;
    private static JCheckBox aclok;
    private static JCheckBox antok;
    private static JTextField installbin;
    private static JTextField installdir;
    private static JTextField cmuclfield;
    private static JTextField clispfield;
    private static JTextField aclfield;
    private static JTextField antfield;
    private static JButton install;
    protected static JProgressBar progressbar;

    public static String getInstallDir() {
        return installdir.getText();
    }

    public static String getInstallbinDir() {
        return installbin.getText();
    }

    public static void main(String[] args) {
        if (args.length == 0 || args[0].compareTo("-compile") != 0 && args[0].compareTo("-nocompile") != 0) {
            Install.showMessage("Argument must be either -compile or -nocompile", true, -1);
        } else {
            compilejava = args[0].compareTo("-compile") == 0;
        }
        JLabel lblInstallDir = new JLabel("Install directory:");
        lblInstallDir.setForeground(Color.black);
        JLabel lblInstallBin = new JLabel("Install directory Jabberwocky script");
        lblInstallBin.setForeground(Color.black);
        JTextArea poem = new JTextArea();
        poem.setForeground(Color.BLUE);
        poem.setMargin(new Insets(20, 20, 0, 0));
        poem.setEditable(false);
        poem.setFont(new Font("Calligula", 2, 10));
        poem.insert("'Twas brillig, and the slithy toves\n Did gyre and gimble in the wabe:\nAll mimsy were the borogoves,\n And the mome raths outgrabe.\n\nBeware the Jabberwock, my son!\n The jaws that bite, the claws that catch!\nBeware the Jubjub bird, and shun\n The frumious Bandersnatch!\n\nHe took his vorpal sword in hand:\n Long time the maxome foe he sought--\nSo rested he by the Tumtum tree,\n And stood awhile in thought.\n\nAnd, as in uffish thought he stood,\n The Jabberwock, with eyes of flame,\nCame whiffling through the tulgey wood,\n And burbled as it came!\n\nOne, two! One, two And through and through\n The vorpal blade went snicker-snack!\nHe left it dead, and with its head\n He went galumphing back.\n\n\"And hast thou slain the Jabberwock?\n Come to my arms, my beamish boy!\nO frabjous day! Callooh! Callay!\"\n He chortled in his joy.\n\n'Twas brillig, and the slithy toves\n Did gyre and gimble in the wabe:\nAll mimsy were the borogoves,\n And the mome raths outgrabe.", 0);
        JDialog installdialog = new JDialog();
        installdialog.setTitle("Install log");
        installdialog.setModal(false);
        installog = new JTextArea();
        JScrollPane scrollpane = new JScrollPane(installog);
        installdialog.setSize(700, 500);
        installdialog.setContentPane(scrollpane);
        installdialog.addWindowListener(new Install());
        JFrame frame = new JFrame("Installation of Jabberwocky");
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 1));
        progressbar = new JProgressBar(0, 0, 735);
        progressbar.setValue(0);
        JLabel imagelabel = new JLabel(new ImageIcon("jabberwocky.jpg"));
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints gridconstraints = new GridBagConstraints();
        gridconstraints.fill = 1;
        gridconstraints.weightx = 0.5;
        JPanel lispchoices = new JPanel(gridbag);
        lispchoices.setBorder(BorderFactory.createBevelBorder(0));
        cmuclok = new JCheckBox(new AbstractAction("CMUCL"){

            public void actionPerformed(ActionEvent ev) {
                Install.checkCommands(true);
            }
        });
        if (!System.getProperty("os.name").startsWith("Windows")) {
            cmuclok.setSelected(true);
        }
        clispok = new JCheckBox(new AbstractAction("CLISP"){

            public void actionPerformed(ActionEvent ev) {
                Install.checkCommands(true);
            }
        });
        clispok.setSelected(true);
        aclok = new JCheckBox(new AbstractAction("ACL"){

            public void actionPerformed(ActionEvent ev) {
                Install.checkCommands(true);
            }
        });
        aclok.setSelected(true);
        antok = new JCheckBox(new AbstractAction("Ant"){

            public void actionPerformed(ActionEvent ev) {
                Install.checkCommands(true);
            }
        });
        antok.setSelected(true);
        installdir = new JTextField(OsSystem.getDefaultInstallDir());
        installdir.setEditable(false);
        installdir.setBackground(Color.lightGray);
        installdir.setOpaque(true);
        installbin = new JTextField(OsSystem.getStartupDirectory());
        installbin.setEditable(false);
        installbin.setBackground(Color.lightGray);
        installbin.setOpaque(true);
        cmuclfield = new JTextField(OsSystem.getCmuclCommand());
        cmuclfield.setEditable(false);
        cmuclfield.setBackground(Color.lightGray);
        cmuclfield.setOpaque(true);
        clispfield = new JTextField(OsSystem.getClispCommand());
        clispfield.setEditable(false);
        clispfield.setBackground(Color.lightGray);
        clispfield.setOpaque(true);
        aclfield = new JTextField(OsSystem.getAclCommand());
        aclfield.setEditable(false);
        aclfield.setBackground(Color.lightGray);
        aclfield.setOpaque(true);
        antfield = new JTextField(OsSystem.getAntCommand());
        antfield.setEditable(false);
        antfield.setBackground(Color.lightGray);
        antfield.setOpaque(true);
        JButton changeinstalldir = new JButton(new AbstractAction("..."){

            public void actionPerformed(ActionEvent ev) {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(1);
                chooser.setSelectedFile(new File(installdir.getText()));
                chooser.setApproveButtonText("Select");
                chooser.setApproveButtonToolTipText("Installation directory Jabberwocky");
                if (chooser.showSaveDialog(null) == 0) {
                    installdir.setText(chooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        JButton changeinstallbin = new JButton(new AbstractAction("..."){

            public void actionPerformed(ActionEvent ev) {
                JFileChooser chooser = new JFileChooser();
                chooser.setSelectedFile(new File(installbin.getText()));
                chooser.setApproveButtonText("Select");
                chooser.setApproveButtonToolTipText("Directory to install Jabberwocky script");
                chooser.setFileSelectionMode(1);
                if (chooser.showSaveDialog(null) == 0) {
                    installbin.setText(chooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        JButton cmuclsearch = new JButton(new AbstractAction("..."){

            public void actionPerformed(ActionEvent ev) {
                String command = Install.getLispCommand(cmuclfield.getText());
                if (command == null) {
                    cmuclfield.setText("");
                    cmuclok.setSelected(false);
                } else {
                    cmuclfield.setText(command);
                    cmuclok.setSelected(true);
                    Install.checkCommands(true);
                }
            }
        });
        JButton clispsearch = new JButton(new AbstractAction("..."){

            public void actionPerformed(ActionEvent ev) {
                String command = Install.getLispCommand(clispfield.getText());
                if (command == null) {
                    clispfield.setText("");
                    clispok.setSelected(false);
                } else {
                    clispfield.setText(command);
                    clispok.setSelected(true);
                    Install.checkCommands(true);
                }
            }
        });
        JButton aclsearch = new JButton(new AbstractAction("..."){

            public void actionPerformed(ActionEvent ev) {
                String command = Install.getLispCommand(aclfield.getText());
                if (command == null) {
                    aclfield.setText("");
                    aclok.setSelected(false);
                } else {
                    aclfield.setText(command);
                    aclok.setSelected(true);
                    Install.checkCommands(true);
                }
            }
        });
        JButton antsearch = new JButton(new AbstractAction("..."){

            public void actionPerformed(ActionEvent ev) {
                String command = Install.getLispCommand(antfield.getText());
                if (command == null) {
                    antfield.setText("");
                    antok.setSelected(false);
                } else {
                    antfield.setText(command);
                    antok.setSelected(true);
                    Install.checkCommands(true);
                }
            }
        });
        install = new JButton(new AbstractAction("Install"){

            public void actionPerformed(ActionEvent ev) {
                String version = System.getProperty("java.version");
                if (version.startsWith("1.4")) {
                    Install.doInstall();
                } else {
                    Install.showMessage("Java version is " + version + " while it should be 1.4.x.\nPlease install the correct version of Java", true, 0);
                }
            }
        });
        install.setEnabled(false);
        JButton cancel = new JButton(new AbstractAction("Cancel"){

            public void actionPerformed(ActionEvent ev) {
                System.exit(0);
            }
        });
        JPanel buttons = new JPanel();
        buttons.add(install);
        buttons.add(cancel);
        gridconstraints.gridx = 0;
        gridconstraints.gridy = 0;
        gridconstraints.weightx = 0.1;
        gridbag.setConstraints(lblInstallDir, gridconstraints);
        gridconstraints.gridx = 1;
        gridconstraints.gridy = 0;
        gridconstraints.weightx = 0.8;
        gridbag.setConstraints(installdir, gridconstraints);
        gridconstraints.gridx = 2;
        gridconstraints.gridy = 0;
        gridconstraints.weightx = 0.1;
        gridbag.setConstraints(changeinstalldir, gridconstraints);
        gridconstraints.gridx = 0;
        gridconstraints.gridy = 1;
        gridconstraints.weightx = 0.1;
        gridbag.setConstraints(lblInstallBin, gridconstraints);
        gridconstraints.gridx = 1;
        gridconstraints.gridy = 1;
        gridconstraints.weightx = 0.8;
        gridbag.setConstraints(installbin, gridconstraints);
        gridconstraints.gridx = 2;
        gridconstraints.gridy = 1;
        gridconstraints.weightx = 0.1;
        gridbag.setConstraints(changeinstallbin, gridconstraints);
        gridconstraints.gridx = 0;
        gridconstraints.gridy = 2;
        gridconstraints.weightx = 0.1;
        gridbag.setConstraints(clispok, gridconstraints);
        gridconstraints.gridx = 1;
        gridconstraints.gridy = 2;
        gridconstraints.weightx = 0.8;
        gridbag.setConstraints(clispfield, gridconstraints);
        gridconstraints.gridx = 2;
        gridconstraints.gridy = 2;
        gridconstraints.weightx = 0.1;
        gridbag.setConstraints(clispsearch, gridconstraints);
        gridconstraints.gridx = 0;
        gridconstraints.gridy = 3;
        gridconstraints.weightx = 0.1;
        gridbag.setConstraints(cmuclok, gridconstraints);
        gridconstraints.gridx = 1;
        gridconstraints.gridy = 3;
        gridconstraints.weightx = 0.8;
        gridbag.setConstraints(cmuclfield, gridconstraints);
        gridconstraints.gridx = 2;
        gridconstraints.gridy = 3;
        gridconstraints.weightx = 0.1;
        gridbag.setConstraints(cmuclsearch, gridconstraints);
        gridconstraints.gridx = 0;
        gridconstraints.gridy = 4;
        gridconstraints.weightx = 0.1;
        gridbag.setConstraints(aclok, gridconstraints);
        gridconstraints.gridx = 1;
        gridconstraints.gridy = 4;
        gridconstraints.weightx = 0.8;
        gridbag.setConstraints(aclfield, gridconstraints);
        gridconstraints.gridx = 2;
        gridconstraints.gridy = 4;
        gridconstraints.weightx = 0.1;
        gridbag.setConstraints(aclsearch, gridconstraints);
        gridconstraints.gridx = 0;
        gridconstraints.gridy = 5;
        gridconstraints.weightx = 0.1;
        gridbag.setConstraints(antok, gridconstraints);
        gridconstraints.gridx = 1;
        gridconstraints.gridy = 5;
        gridconstraints.weightx = 0.8;
        gridbag.setConstraints(antfield, gridconstraints);
        gridconstraints.gridx = 2;
        gridconstraints.gridy = 5;
        gridconstraints.weightx = 0.1;
        gridbag.setConstraints(antsearch, gridconstraints);
        lispchoices.add(lblInstallDir);
        lispchoices.add(installdir);
        lispchoices.add(changeinstalldir);
        lispchoices.add(lblInstallBin);
        lispchoices.add(installbin);
        lispchoices.add(changeinstallbin);
        lispchoices.add(clispok);
        lispchoices.add(clispfield);
        lispchoices.add(clispsearch);
        if (TestACL) {
            lispchoices.add(aclok);
            lispchoices.add(aclfield);
            lispchoices.add(aclsearch);
        }
        if (!System.getProperty("os.name").startsWith("Windows")) {
            lispchoices.add(cmuclok);
            lispchoices.add(cmuclfield);
            lispchoices.add(cmuclsearch);
        }
        if (compilejava) {
            lispchoices.add(antok);
            lispchoices.add(antfield);
            lispchoices.add(antsearch);
        }
        installdialog.setVisible(true);
        Install.checkCommands(false);
        JPanel splash = new JPanel();
        splash.setBackground(Color.WHITE);
        splash.setLayout(new BoxLayout(splash, 0));
        splash.add(imagelabel);
        splash.add(poem);
        content.add(splash);
        content.add(lispchoices);
        content.add(buttons);
        content.add(progressbar);
        frame.addWindowListener(new Install());
        JScrollPane scrollPane = new JScrollPane(content);
        frame.setContentPane(scrollPane);
        Rectangle bounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        frame.setSize(700, Math.min(800, bounds.height - 50));
        frame.setVisible(true);
        int x = Math.max(0, (bounds.width - frame.getWidth()) / 2);
        int y = Math.max(0, (bounds.height - frame.getHeight()) / 2);
        frame.setLocation(x, y);
    }

    private static String getLispCommand(String command) {
        JFileChooser chooser = new JFileChooser(new File(command));
        if (chooser.showOpenDialog(null) == 0) {
            return chooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    private static void checkCommands(final boolean error) {
        final Runnable enableInstall = new Runnable(){

            public void run() {
                install.setEnabled(true);
            }
        };
        Thread thread = new Thread(new Runnable(){
            final String clisp = Install.access$600().getText();
            final String cmucl = Install.access$300().getText();
            final String ant = Install.access$1000().getText();
            final String acl = Install.access$800().getText();

            public void run() {
                String version;
                if (clispok.isSelected() && this.clisp.length() > 0) {
                    version = Install.startCommand(this.clisp, new String[]{"--version"}, error);
                    if (version == null || version.indexOf("CLISP") == -1) {
                        clispok.setSelected(false);
                        if (error) {
                            Install.showMessage(this.clisp + " is not the command to start CLISP", false, 0);
                        }
                    }
                } else {
                    clispok.setSelected(false);
                }
                if (cmuclok.isSelected() && this.cmucl.length() > 0) {
                    version = Install.startCommand(this.cmucl, new String[]{"-eval", "(progn(princ(lisp-implementation-type))(quit))"}, error);
                    if (version == null || version.indexOf("CMU") == -1) {
                        cmuclok.setSelected(false);
                        if (error) {
                            Install.showMessage(this.cmucl + " is not the command to start CMUCL", false, 0);
                        }
                    }
                } else {
                    cmuclok.setSelected(false);
                }
                if (TestACL) {
                    if (aclok.isSelected() && this.acl.length() > 0) {
                        version = Install.startCommand(this.acl, new String[]{"-e", "(progn(princ(lisp-implementation-type))(exit))"}, error);
                        if (version == null || version.indexOf("Allegro") == -1) {
                            aclok.setSelected(false);
                            if (error) {
                                Install.showMessage(this.acl + " is not the command to start ACL", false, 0);
                            }
                        }
                    } else {
                        aclok.setSelected(false);
                    }
                }
                if (cmuclok.isSelected() || clispok.isSelected() || aclok.isSelected()) {
                    SwingUtilities.invokeLater(enableInstall);
                }
                if (antok.isSelected() && this.ant.length() > 0 && (version = Install.startCommand(this.ant, new String[]{"-help"}, error)) == null) {
                    antok.setSelected(false);
                    if (error) {
                        Install.showMessage(this.ant + " is not the command to start Ant", false, 0);
                    }
                }
            }
        });
        install.setEnabled(false);
        thread.start();
    }

    private static void doInstall() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                File javadir;
                if (clispok.isSelected()) {
                    Install.startCommand(clispfield.getText(), new String[]{"-i", "install.lisp"}, true);
                }
                if (cmuclok.isSelected()) {
                    Install.startCommand(cmuclfield.getText(), new String[]{"-load", "install.lisp"}, true);
                }
                if ((javadir = new File("java")).isDirectory()) {
                    Install.createBatchFile(installdir.getText());
                    if (compilejava) {
                        if (antok.isSelected()) {
                            progressbar.setIndeterminate(true);
                            String message = Install.buildWithAnt();
                            if (message != null && message.indexOf("SUCCESSFUL") != -1) {
                                OsSystem.registerJabberwocky();
                                Install.showMessage("Congratulations, Jabberwocky is installed", true, 0);
                            } else {
                                Install.showMessage("Sorry, Jabberwocky could not be installed \n \n", true, 1);
                            }
                        } else {
                            Install.compileJavaFilesInDir(javadir, javadir);
                            Install.createJarFile(javadir);
                        }
                    }
                    Install.copyFiles(installdir.getText());
                    OsSystem.registerJabberwocky();
                } else {
                    Install.showMessage("This command is not executed in the correct directory or the java subdirectory is missing", true, -1);
                }
                progressbar.setValue(progressbar.getMaximum());
                Install.showMessage("Congratulations, Jabberwocky is installed", true, 0);
            }
        });
        install.setEnabled(false);
        thread.start();
    }

    private static void createBatchFile(String installdir) {
        try {
            progressbar.setValue(counter++);
            File file = new File(OsSystem.getStartupFile());
            file.delete();
            file.createNewFile();
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            String cmd = System.getProperty("os.name").startsWith("Windows") ? "java -jar \"" + installdir + File.separatorChar + "Jabberwocky.jar\"" + " -i \"" + installdir + "\"" + " -s \"" + System.getProperty("user.dir") + "\"" + " -clisp \"" + clispfield.getText() + "\"" : "java -jar \"" + installdir + File.separatorChar + "Jabberwocky.jar\"" + " -i \"" + installdir + "\"" + " -s \"" + System.getProperty("user.dir") + "\"" + " -clisp \"" + clispfield.getText() + "\"" + " -cmucl \"" + cmuclfield.getText() + "\"";
            writer.write(cmd);
            ((Writer)writer).close();
        }
        catch (Exception e) {
            Install.showMessage("Failed to create startup script for Jabberwocky", true, -1);
        }
    }

    private static void copyFiles(String installdirstring) {
        File configurationsdir;
        File docdir;
        String temp;
        File imagedir;
        progressbar.setValue(counter++);
        File installdir = new File(installdirstring);
        if (!installdir.exists()) {
            installdir.mkdir();
        }
        if (!installdir.exists()) {
            Install.showMessage("Could not create install directory", true, -1);
        }
        if (!(imagedir = new File(temp = installdirstring + File.separatorChar + "image")).exists()) {
            imagedir.mkdir();
        }
        if (!imagedir.exists()) {
            Install.showMessage("Could not create image subdirectory", true, -1);
        }
        if (!(docdir = new File(temp = installdirstring + File.separatorChar + "doc")).exists()) {
            docdir.mkdir();
        }
        if (!docdir.exists()) {
            Install.showMessage("Could not create doc subdirectory", true, -1);
        }
        if (!(configurationsdir = new File(temp = installdirstring + File.separatorChar + "configurations")).exists()) {
            configurationsdir.mkdir();
        }
        if (!configurationsdir.exists()) {
            Install.showMessage("Could not create configurations subdirectory", true, -1);
        }
        try {
            temp = "seed.lisp";
            Install.copyFile(temp, installdir);
            if (cmuclok.isSelected()) {
                temp = "debugger.x86f";
                Install.copyFile(temp, installdir);
                temp = "java.x86f";
                Install.copyFile(temp, installdir);
                temp = "cmu.x86f";
                Install.copyFile(temp, installdir);
                temp = "debugcode.x86f";
                Install.copyFile(temp, installdir);
                temp = "jabberwocky.x86f";
                Install.copyFile(temp, installdir);
            }
            if (clispok.isSelected()) {
                temp = "debugger.fas";
                Install.copyFile(temp, installdir);
                temp = "java.fas";
                Install.copyFile(temp, installdir);
                temp = "clisp.fas";
                Install.copyFile(temp, installdir);
                temp = "debugcode.fas";
                Install.copyFile(temp, installdir);
                temp = "jabberwocky.fas";
                Install.copyFile(temp, installdir);
            }
            temp = "java" + File.separatorChar + "Jabberwocky.jar";
            Install.copyFile(temp, installdir);
            temp = OsSystem.getStartupFile();
            Install.copyFile(temp, new File(installbin.getText()));
            temp = "java" + File.separatorChar + "image";
            File sourceimage = new File(temp);
            if (!sourceimage.isDirectory()) {
                Install.showMessage("image directory missing", true, -1);
            }
            File[] images = sourceimage.listFiles();
            for (int i = 0; i < images.length; ++i) {
                Install.copyFile(images[i].getAbsolutePath(), imagedir);
            }
            temp = "doc";
            File sourcedoc = new File(temp);
            if (!sourcedoc.isDirectory()) {
                Install.showMessage("doc directory missing", true, -1);
            }
            File[] docs = sourcedoc.listFiles();
            for (int i = 0; i < docs.length; ++i) {
                Install.copyFile(docs[i].getAbsolutePath(), docdir);
            }
            temp = "configurations";
            File sourceconfigurations = new File(temp);
            if (!sourceconfigurations.isDirectory()) {
                Install.showMessage("configurations directory missing", true, -1);
            }
            File[] configurations = sourceconfigurations.listFiles();
            for (int i = 0; i < configurations.length; ++i) {
                Install.copyFile(configurations[i].getAbsolutePath(), configurationsdir);
            }
        }
        catch (Exception e) {
            Install.showMessage("Error during copy of the file " + temp, true, -1);
        }
    }

    private static void copyFile(String source, File destinationdir) {
        progressbar.setValue(counter++);
        try {
            Install.updateLog("Copying " + source + " to " + destinationdir.getAbsolutePath());
            BufferedInputStream reader = new BufferedInputStream(new FileInputStream(source));
            BufferedOutputStream writer = new BufferedOutputStream(new FileOutputStream(new File(destinationdir, new File(source).getName())));
            byte[] buffer = new byte[(int)new File(source).length()];
            reader.read(buffer);
            writer.write(buffer);
            writer.close();
        }
        catch (Exception e) {
            Install.showMessage("Error copying " + source + " to " + destinationdir.getAbsolutePath() + "\n" + e.getMessage(), true, -1);
        }
    }

    private static String getOutputError(Process process) {
        StringBuffer buffer = new StringBuffer();
        try {
            int c;
            InputStream strm = process.getInputStream();
            while ((c = strm.read()) != -1) {
                buffer.append((char)c);
            }
            buffer.append('\n');
            strm = process.getErrorStream();
            while ((c = strm.read()) != -1) {
                buffer.append((char)c);
            }
            return buffer.toString();
        }
        catch (Exception e) {
            return buffer.toString();
        }
    }

    private static void createJarFile(File javadir) {
        progressbar.setValue(counter++);
        String cmd = "";
        Install.updateLog("Create the jar file Jabberwocky.jar\n");
        try {
            Runtime runtime = Runtime.getRuntime();
            cmd = "jar -cmf Manifest Jabberwocky.jar";
            Process process = runtime.exec(cmd, new String[0], javadir);
            process.waitFor();
            if (process.exitValue() != 0) {
                Install.showMessage("Failed to execute cmd " + cmd + "\n" + Install.getOutputError(process), true, -1);
            } else {
                Install.addClassesInDir(javadir, javadir, "");
            }
        }
        catch (Exception e) {
            Install.showMessage("Failed to execute " + cmd + "\n" + e.getMessage(), true, -1);
        }
    }

    private static void addClass(File javadir, File javafile, String dir) {
        progressbar.setValue(counter++);
        String file = dir.length() == 0 ? javafile.getName() : dir + File.separatorChar + javafile.getName();
        Install.updateLog("Archiving class file " + file + "\n");
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(new String[]{"jar", "-uf", "Jabberwocky.jar", file}, new String[0], javadir);
            process.waitFor();
            if (process.exitValue() != 0) {
                Install.showMessage("Failed to add class " + file + " jar file\n" + Install.getOutputError(process), true, -1);
            }
        }
        catch (Exception e) {
            Install.showMessage("Failed to archive " + javafile.getAbsolutePath() + " because of " + e.getMessage(), true, -1);
        }
    }

    private static void addClassesInDir(File javadir, File dir, String relativedir) {
        File[] files = dir.listFiles(new ClassFilter());
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                if (relativedir.length() == 0) {
                    Install.addClassesInDir(javadir, files[i], files[i].getName());
                    continue;
                }
                Install.addClassesInDir(javadir, files[i], relativedir + File.separatorChar + files[i].getName());
                continue;
            }
            Install.addClass(javadir, files[i], relativedir);
        }
    }

    private static void compileJavaFile(File javadir, File javafile) {
        progressbar.setValue(counter++);
        Install.updateLog("Compiling  java source " + javafile.getAbsolutePath() + "\n");
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(new String[]{"javac", "-O", javafile.getAbsolutePath()}, new String[0], javadir);
            process.waitFor();
            if (process.exitValue() != 0) {
                Install.showMessage("Failed to compile " + javafile.getAbsolutePath() + "\n" + Install.getOutputError(process), true, -1);
            }
        }
        catch (Exception e) {
            Install.showMessage("Failed to compile " + javafile.getAbsolutePath() + " because of " + e.getMessage(), true, -1);
        }
    }

    private static void compileJavaFilesInDir(File javadir, File dir) {
        File[] files = dir.listFiles(new JavaFilter());
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                Install.compileJavaFilesInDir(javadir, files[i]);
                continue;
            }
            Install.compileJavaFile(javadir, files[i]);
        }
    }

    public void windowClosing(WindowEvent e) {
        System.exit(0);
    }

    private static void updateLog(final String message) {
        Runnable doWork = new Runnable(){

            public void run() {
                installog.insert("<" + counter + "> " + message, installog.getDocument().getLength());
            }
        };
        SwingUtilities.invokeLater(doWork);
    }

    protected static String startCommand(String command, String[] args, boolean error) {
        return Install.startCommand(command, args, null, error);
    }

    protected static String startCommand(String command, String[] args, File file, boolean showError) {
        String[] cmdarray = new String[args.length + 1];
        StringBuffer output = new StringBuffer();
        StringBuffer result = new StringBuffer();
        cmdarray[0] = command;
        System.arraycopy(args, 0, cmdarray, 1, args.length);
        try {
            int c;
            Runtime runtime = Runtime.getRuntime();
            Process process = file == null ? runtime.exec(cmdarray) : runtime.exec(cmdarray, new String[0], file);
            InputStream input = process.getInputStream();
            InputStream error = process.getErrorStream();
            MergedStream sequence = new MergedStream(error, input);
            while ((c = sequence.read()) != -1) {
                output.append((char)c);
                if (c != 10) continue;
                Install.updateLog(output.toString());
                result.append(output.toString());
                output.setLength(0);
            }
            process.waitFor();
            result.append(output.toString());
            Install.updateLog(output.toString() + "\n");
            return result.toString();
        }
        catch (Exception e) {
            if (showError) {
                Install.showMessage("Error executing " + command, false, 0);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void showMessage(String message, final boolean exit, final int exitcode) {
        final JDialog dialog = new JDialog();
        dialog.setModal(false);
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout());
        JTextArea textarea = new JTextArea(message);
        textarea.setForeground(Color.red);
        textarea.setEditable(false);
        JScrollPane scrollpane = new JScrollPane(textarea);
        JButton ok = new JButton(new AbstractAction("Ok"){

            public void actionPerformed(ActionEvent ev) {
                dialog.dispose();
                if (exit) {
                    System.exit(exitcode);
                }
            }
        });
        content.add((Component)textarea, "Center");
        content.add((Component)ok, "South");
        dialog.setSize(300, 200);
        Rectangle bounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        int x = Math.max(0, (bounds.width - dialog.getWidth()) / 2);
        int y = Math.max(0, (bounds.height - dialog.getHeight()) / 2);
        dialog.setLocation(x, y);
        dialog.setContentPane(content);
        dialog.setVisible(true);
        try {
            JDialog jDialog = dialog;
            synchronized (jDialog) {
                dialog.wait();
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    private static String buildWithAnt() {
        try {
            String line;
            BufferedReader model = new BufferedReader(new FileReader("build.template"));
            BufferedWriter xml = new BufferedWriter(new FileWriter("build.xml"));
            while ((line = model.readLine()) != null) {
                StringBuffer buffer;
                if (line.indexOf("@installHome@") != -1) {
                    line = line.replaceFirst("@installHome@", new String(installdir.getText().replaceAll("\\\\", "/")));
                } else if (line.indexOf("@installBinHome@") != -1) {
                    line = line.replaceFirst("@installBinHome@", new String(installbin.getText().replaceAll("\\\\", "/")));
                } else if (line.indexOf("@scriptFile@") != -1) {
                    line = System.getProperty("os.name").startsWith("Windows") ? line.replaceFirst("@scriptFile@", "Jabberwocky.bat") : line.replaceFirst("@scriptFile@", "Jabberwocky");
                } else if (line.indexOf("@CLISP BEGIN@") != -1) {
                    String clispXml;
                    buffer = new StringBuffer();
                    while ((clispXml = model.readLine()).indexOf("@CLISP END@") == -1) {
                        buffer.append(clispXml + System.getProperty("line.separator"));
                    }
                    line = clispok.isSelected() ? buffer.toString() : "skip";
                } else if (line.indexOf("@CMUCL BEGIN@") != -1) {
                    String cmuclXml;
                    buffer = new StringBuffer();
                    while ((cmuclXml = model.readLine()).indexOf("@CMUCL END@") == -1) {
                        buffer.append(cmuclXml + System.getProperty("line.separator"));
                    }
                    line = cmuclok.isSelected() ? buffer.toString() : "skip";
                }
                if (line.equals("skip")) continue;
                xml.write(line);
                xml.newLine();
            }
            xml.flush();
            xml.close();
            model.close();
        }
        catch (IOException e) {
            Install.showMessage("Unable to create build.xml " + e.getMessage(), true, 1);
        }
        StringBuffer output = new StringBuffer();
        StringBuffer result = new StringBuffer();
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(new String[]{antfield.getText(), "-buildfile", new File("build.xml").getAbsolutePath()});
            InputStream input = process.getInputStream();
            InputStream error = process.getErrorStream();
            MergedStream sequence = new MergedStream(input, error);
            try {
                int c;
                while ((c = sequence.read()) != -1) {
                    output.append((char)c);
                    if (c != 10) continue;
                    Install.updateLog(output.toString());
                    result.append(output.toString());
                    output.setLength(0);
                }
                process.waitFor();
                result.append(output.toString());
                Install.updateLog(output.toString() + "\n");
                return result.toString();
            }
            catch (IOException e) {
                Install.showMessage("Error finding Ant", false, 0);
                return "";
            }
        }
        catch (Exception e) {
            Install.showMessage("Error executing Ant", false, 0);
            return null;
        }
    }
}

