/*
 * Decompiled with CFR 0.152.
 */
package IDE.WorkArea;

import IDE.CodeEditor.CodeCursor;
import IDE.CodeEditor.CodeEditor;
import IDE.CodeEditor.CodePane;
import IDE.CodeEditor.Parser.LispParser;
import IDE.CodeEditor.Parser.Parser;
import IDE.Configuration.XMLConfigObject;
import IDE.LinearFocusTraversalPolicy;
import IDE.Main;
import IDE.Utilities.Util;
import IDE.WorkArea.CodePaneState;
import IDE.WorkArea.WorkArea;
import Install.OsSystem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class WorkPane
extends JSplitPane
implements FocusListener {
    JComponent first;
    JComponent second = null;

    public WorkPane(CodePane pane) {
        super(0);
        this.first = pane;
        this.add(pane);
        this.setDividerSize(3);
        this.setDividerLocation(0.5);
        this.setResizeWeight(0.5);
        this.addFocusListener(this);
    }

    public WorkPane(JComponent first, JComponent second, int orientation, int dividerlocation) {
        super(orientation);
        this.first = first;
        this.second = second;
        this.setTopComponent(first);
        this.setBottomComponent(second);
        this.setDividerSize(3);
        this.setDividerLocation(dividerlocation);
        WorkArea.refreshTitles();
        this.addFocusListener(this);
    }

    public WorkPane(JComponent first, int orientation, int dividerlocation) {
        super(orientation);
        this.first = first;
        this.second = null;
        this.setTopComponent(first);
        this.setDividerSize(3);
        this.setDividerLocation(dividerlocation);
        WorkArea.refreshTitles();
        this.addFocusListener(this);
    }

    public WorkPane(Object first, int orientation, int dividerlocation) {
        super(orientation);
        this.first = this.getMember(first);
        this.second = null;
        this.setTopComponent(this.first);
        this.setDividerSize(3);
        this.setDividerLocation(dividerlocation);
        WorkArea.refreshTitles();
        this.addFocusListener(this);
    }

    public WorkPane(Object first, Object second, int orientation, int dividerlocation) {
        super(orientation);
        this.first = this.getMember(first);
        this.second = this.getMember(second);
        this.setTopComponent(this.first);
        this.setBottomComponent(this.second);
        this.setDividerSize(3);
        this.setDividerLocation(dividerlocation);
        WorkArea.refreshTitles();
        this.addFocusListener(this);
    }

    private JComponent getMember(Object object) {
        if (object instanceof WorkPane) {
            return (JComponent)object;
        }
        if (object instanceof CodePaneState) {
            CodePane codepane;
            String filename = ((CodePaneState)object).getFilename();
            Parser parser = ((CodePaneState)object).getParser();
            if (filename.length() == 0) {
                codepane = new CodePane(parser);
            } else {
                codepane = CodePane.createCodePane(parser, new File(filename));
                WorkArea.addEditor(codepane.getEditor());
            }
            codepane.getEditor().cursor.setCursor(((CodePaneState)object).getCursorPosition());
            return codepane;
        }
        return new CodePane(new LispParser(true));
    }

    public boolean containsEditor(CodeEditor editor) {
        if (this.first instanceof CodePane && ((CodePane)this.first).getEditor() == editor) {
            return true;
        }
        if (this.second instanceof CodePane && ((CodePane)this.second).getEditor() == editor) {
            return true;
        }
        if (this.first instanceof WorkPane && ((WorkPane)this.first).containsEditor(editor)) {
            return true;
        }
        return this.second instanceof WorkPane && ((WorkPane)this.second).containsEditor(editor);
    }

    private WorkPane getFocussedWorkPane() {
        WorkPane workpane;
        if (this.first instanceof CodePane && ((CodePane)this.first).getEditor().isCurrent()) {
            return this;
        }
        if (this.second instanceof CodePane && ((CodePane)this.second).getEditor().isCurrent()) {
            return this;
        }
        if (this.first instanceof WorkPane && (workpane = ((WorkPane)this.first).getFocussedWorkPane()) != null) {
            return workpane;
        }
        if (this.second instanceof WorkPane && (workpane = ((WorkPane)this.second).getFocussedWorkPane()) != null) {
            return workpane;
        }
        return null;
    }

    public void repaintAll() {
        if (this.first instanceof CodePane) {
            ((CodePane)this.first).revalidate();
            ((CodePane)this.first).refreshBackground();
            ((CodePane)this.first).initAndRepaintVisible();
        } else {
            ((WorkPane)this.first).repaintAll();
        }
        if (this.second instanceof CodePane) {
            ((CodePane)this.second).revalidate();
            ((CodePane)this.second).refreshBackground();
            ((CodePane)this.second).initAndRepaintVisible();
        } else if (this.second != null) {
            ((WorkPane)this.second).repaintAll();
        }
    }

    public CodeEditor[] getEditors() {
        Vector editors = new Vector();
        this.getEditorsImp(editors);
        int m = editors.size();
        CodeEditor[] result = new CodeEditor[m];
        for (int i = 0; i < m; ++i) {
            result[i] = (CodeEditor)editors.elementAt(i);
        }
        return result;
    }

    private void getEditorsImp(Vector editors) {
        if (this.first instanceof CodePane) {
            editors.add(((CodePane)this.first).getEditor());
        } else {
            ((WorkPane)this.first).getEditorsImp(editors);
        }
        if (this.second instanceof CodePane) {
            editors.add(((CodePane)this.second).getEditor());
        } else if (this.second != null) {
            ((WorkPane)this.second).getEditorsImp(editors);
        }
    }

    public void replaceEditor(Vector editors) {
        WorkPane workpane;
        if (editors.size() > 0 && (workpane = this.getFocussedWorkPane()) != null) {
            workpane.replaceEditorDialog(editors);
        }
    }

    private void replaceEditorImp(CodeEditor editor, Vector editors) {
        if (this.first instanceof CodePane && ((CodePane)this.first).getEditor().isCurrent()) {
            CodePane codepane = editor.getCodePane().cloneCodePane();
            editors.add(codepane.getEditor());
            this.first = codepane;
            this.setTopComponent(codepane);
        } else if (this.second instanceof CodePane && ((CodePane)this.second).getEditor().isCurrent()) {
            CodePane codepane = editor.getCodePane().cloneCodePane();
            editors.add(codepane.getEditor());
            this.second = codepane;
            this.setBottomComponent(codepane);
        }
    }

    private void replaceEditorDialog(final Vector editors) {
        final JDialog dialog = new JDialog();
        dialog.setTitle("Choose a document");
        dialog.setModal(true);
        JPanel pane = new JPanel(new BorderLayout());
        JPanel buttons = new JPanel();
        final JList list = new JList(editors);
        JScrollPane scrollpane = new JScrollPane(list);
        list.setSelectionMode(0);
        list.setSelectedIndex(0);
        JButton ok = new JButton(new AbstractAction("Ok"){

            public void actionPerformed(ActionEvent ev) {
                WorkPane.this.replaceEditorImp((CodeEditor)list.getSelectedValue(), editors);
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        JButton cancel = new JButton(new AbstractAction("Cancel"){

            public void actionPerformed(ActionEvent ev) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        buttons.add(ok);
        buttons.add(cancel);
        pane.add((Component)scrollpane, "Center");
        pane.add((Component)buttons, "South");
        pane.setFocusTraversalPolicy(new LinearFocusTraversalPolicy(new Component[]{list, ok, cancel}));
        dialog.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent ev) {
                list.grabFocus();
            }

            public void focusLost(FocusEvent ev) {
            }
        });
        dialog.getContentPane().add(pane);
        dialog.setSize(400, 500);
        dialog.setVisible(true);
    }

    public void split(int orientation, Vector editors) {
        WorkPane workpane = this.getFocussedWorkPane();
        if (workpane != null) {
            workpane.splitImp(orientation, editors);
        }
    }

    private void splitImp(int orientation, Vector editors) {
        boolean index = false;
        if (this.first instanceof CodePane && ((CodePane)this.first).getEditor().isCurrent()) {
            CodePane codepane = (CodePane)this.first;
            if (this.second == null) {
                this.setOrientation(orientation);
                this.second = codepane.cloneCodePane();
                this.add((CodePane)this.second);
                this.setDividerLocation(0.5);
                this.setDividerSize(3);
                this.setOneTouchExpandable(true);
                this.resetToPreferredSizes();
            } else {
                WorkPane workpane = new WorkPane(codepane);
                workpane.second = codepane.cloneCodePane();
                workpane.setOrientation(orientation);
                workpane.add((CodePane)workpane.second);
                workpane.setDividerLocation(0.5);
                workpane.setOneTouchExpandable(true);
                this.first = workpane;
                this.setTopComponent(workpane);
                this.setDividerLocation(0.5);
                this.setDividerSize(3);
                this.setOneTouchExpandable(true);
                this.resetToPreferredSizes();
                workpane.resetToPreferredSizes();
            }
        } else if (this.second instanceof CodePane && ((CodePane)this.second).getEditor().isCurrent()) {
            CodePane codepane = (CodePane)this.second;
            WorkPane workpane = new WorkPane(codepane);
            workpane.second = codepane.cloneCodePane();
            workpane.setOrientation(orientation);
            workpane.add((CodePane)workpane.second);
            workpane.setDividerLocation(0.5);
            workpane.setDividerSize(3);
            workpane.setOneTouchExpandable(true);
            this.second = workpane;
            this.setBottomComponent(workpane);
            this.setDividerLocation(0.5);
            this.setDividerSize(3);
            this.setOneTouchExpandable(true);
            this.resetToPreferredSizes();
            workpane.resetToPreferredSizes();
        }
        this.updateEditors(editors);
    }

    public CodeEditor getFirstEditor() {
        if (this.first instanceof WorkPane) {
            return ((WorkPane)this.first).getFirstEditor();
        }
        if (this.first instanceof CodePane) {
            return ((CodePane)this.first).getEditor();
        }
        return null;
    }

    public String getShortTitle() {
        String title = "";
        if (this.first instanceof CodePane) {
            title = ((CodePane)this.first).getEditor().getShortName();
        } else if (this.first instanceof WorkPane) {
            title = ((WorkPane)this.first).getShortTitle();
        }
        if (this.second instanceof CodePane) {
            title = title + "-" + ((CodePane)this.second).getEditor().getShortName();
        } else if (this.second instanceof WorkPane) {
            title = title + "-" + ((WorkPane)this.second).getShortTitle();
        }
        return title;
    }

    public String getLongTitle() {
        String title = "";
        if (this.first instanceof CodePane) {
            title = ((CodePane)this.first).getEditor().getLongName();
        } else if (this.first instanceof WorkPane) {
            title = ((WorkPane)this.first).getLongTitle();
        }
        if (this.second instanceof CodePane) {
            title = title + "-" + ((CodePane)this.second).getEditor().getLongName();
        } else if (this.second instanceof CodePane) {
            title = title + "-" + ((WorkPane)this.second).getLongTitle();
        }
        return title;
    }

    public void close() {
        if (this.removeCodePane()) {
            WorkArea.removePane(this);
        }
    }

    private boolean removeCodePane() {
        if (this.first instanceof CodePane && ((CodePane)this.first).getEditor().isCurrent()) {
            CodeEditor editor = ((CodePane)this.first).getEditor();
            if (!editor.ensureSaved() && JOptionPane.showConfirmDialog(null, "Changes are not saved, continue close ?", "Error closing", 0) != 0) {
                return false;
            }
            editor.closeEditor();
            WorkArea.removeEditor(editor);
            this.remove(this.first);
            if (this.second == null) {
                this.first = null;
                return true;
            }
            this.first = this.second;
            this.second = null;
            return false;
        }
        if (this.second instanceof CodePane && ((CodePane)this.second).getEditor().isCurrent()) {
            CodeEditor editor = ((CodePane)this.second).getEditor();
            if (!editor.ensureSaved() && JOptionPane.showConfirmDialog(null, "Changes are not saved, continue close ?", "Error closing", 0) != 0) {
                return false;
            }
            editor.closeEditor();
            WorkArea.removeEditor(editor);
            this.remove(this.second);
            this.second = null;
            return false;
        }
        if (this.first instanceof WorkPane) {
            if (((WorkPane)this.first).removeCodePane()) {
                if (this.second == null) {
                    this.remove(this.first);
                    this.first = null;
                    return true;
                }
                this.remove(this.first);
                this.first = this.second;
                this.second = null;
                return false;
            }
            return false;
        }
        if (this.second instanceof WorkPane && ((WorkPane)this.second).removeCodePane()) {
            this.remove(this.second);
            this.second = null;
            return true;
        }
        return false;
    }

    public void enumerateEditors(Vector editors) {
        if (this.first instanceof CodePane) {
            editors.add(((CodePane)this.first).getEditor());
        } else if (this.first instanceof WorkPane) {
            ((WorkPane)this.first).enumerateEditors(editors);
        }
        if (this.second instanceof CodePane) {
            editors.add(((CodePane)this.second).getEditor());
        } else if (this.second instanceof WorkPane) {
            ((WorkPane)this.second).enumerateEditors(editors);
        }
    }

    public void removePane(CodeEditor editor) {
        if (this.first instanceof CodePane && ((CodePane)this.first).getEditor() == editor) {
            CodePane codepane = (CodePane)this.first;
            if (this.second == null) {
                WorkArea.removePane(this);
            } else {
                this.remove(this.first);
                this.first = this.second;
                this.second = null;
            }
        } else if (this.second instanceof CodePane && ((CodePane)this.second).getEditor() == editor) {
            CodePane codepane = (CodePane)this.second;
            this.remove(this.second);
            this.second = null;
        }
    }

    public XMLConfigObject createStateWorkPaneObject() {
        XMLConfigObject object = new XMLConfigObject(this.getClass().getName());
        if (this.first instanceof CodePane) {
            object.addArgument(this.createStateCodePaneObject((CodePane)this.first));
        } else if (this.first instanceof WorkPane) {
            object.addArgument(((WorkPane)this.first).createStateWorkPaneObject());
        }
        if (this.second instanceof CodePane) {
            object.addArgument(this.createStateCodePaneObject((CodePane)this.second));
        } else if (this.second instanceof WorkPane) {
            object.addArgument(((WorkPane)this.second).createStateWorkPaneObject());
        }
        object.addArgument(this.getOrientation());
        object.addArgument(this.getDividerLocation());
        return object;
    }

    private XMLConfigObject createStateCodePaneObject(CodePane codepane) {
        XMLConfigObject object = new XMLConfigObject(new CodePaneState(null, null).getClass().getName());
        XMLConfigObject parser = new XMLConfigObject(codepane.getEditor().getDocument().getParser().getClass().getName());
        parser.addArgument(true);
        object.addArgument(parser);
        File file = codepane.getEditor().getDocument().getFile();
        object.addArgument(file == null ? "" : OsSystem.correctPathName(Util.getCanonicalFileName(file)));
        object.addArgument(codepane.getEditor().cursor.cursorOffset());
        return object;
    }

    public void updateEditors(Vector editors) {
        if (this.first instanceof CodePane) {
            WorkPane.uniqueAdd(((CodePane)this.first).getEditor(), editors);
        } else if (this.first instanceof WorkPane) {
            ((WorkPane)this.first).updateEditors(editors);
        }
        if (this.second instanceof CodePane) {
            WorkPane.uniqueAdd(((CodePane)this.second).getEditor(), editors);
        } else if (this.second instanceof WorkPane) {
            ((WorkPane)this.second).updateEditors(editors);
        }
    }

    private static void uniqueAdd(Object object, Vector objects) {
        if (!objects.contains(object)) {
            objects.add(object);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        CodeEditor editor = Main.currentEditor();
        if (editor != null) {
            editor.requestFocus();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        CodeEditor editor;
        if (!(focusEvent.getOppositeComponent() instanceof CodeEditor) && (editor = Main.currentEditor()) != null) {
            CodeCursor.cancelCursor();
        }
    }
}

