/*
 * Decompiled with CFR 0.152.
 */
package IDE.WorkArea;

import IDE.CodeEditor.CodeDocument;
import IDE.CodeEditor.CodeEditor;
import IDE.CodeEditor.CodePane;
import IDE.Configuration.XMLConfigClass;
import IDE.Configuration.XMLConfigMethod;
import IDE.IIDEAddin;
import IDE.Interaction.DebugCodePane;
import IDE.Main;
import IDE.Utilities.Util;
import IDE.WorkArea.WorkPane;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.Writer;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WorkArea
extends JTabbedPane
implements ChangeListener,
IIDEAddin,
MouseListener {
    private static Vector editors = new Vector();
    private static WorkArea workarea;
    private static CodeEditor currentEditor;

    private WorkArea() {
        this.addChangeListener(this);
        this.addMouseListener(this);
        workarea = this;
        this.setFocusable(false);
    }

    public static WorkArea createWorkArea() {
        if (workarea != null) {
            return workarea;
        }
        return new WorkArea();
    }

    public static void selectWorkPaneContainingEditor(CodeEditor editor) {
        int m = workarea.getComponentCount();
        for (int i = 0; i < m; ++i) {
            if (!((WorkPane)workarea.getComponentAt(i)).containsEditor(editor)) continue;
            workarea.removeChangeListener(workarea);
            workarea.setSelectedIndex(i);
            workarea.addChangeListener(workarea);
            currentEditor = editor;
            break;
        }
    }

    public static void removeCodePanes(File file) {
        int i = 0;
        while (i < editors.size()) {
            CodeEditor editor = (CodeEditor)editors.elementAt(i);
            if (Util.getCanonicalFileName(editor.getDocument().getFile()).compareTo(Util.getCanonicalFileName(file)) == 0) {
                if (editor == currentEditor) {
                    currentEditor = null;
                }
                editors.remove(i);
                for (int j = 0; j < workarea.getComponentCount(); ++j) {
                    Main.setCurrent(editor);
                    ((WorkPane)workarea.getComponent(j)).close();
                }
                continue;
            }
            ++i;
        }
        WorkArea.refreshTitles();
    }

    public static void addPane(CodePane pane) {
        CodeEditor editor = pane.getEditor();
        WorkPane workpane = new WorkPane(pane);
        editors.add(editor);
        workarea.addTab(editor.getName(), workpane);
        workarea.setSelectedComponent(workpane);
        WorkArea.refreshTitles();
    }

    protected static void addEditor(CodeEditor editor) {
        if (editors.indexOf(editor) == -1) {
            editors.addElement(editor);
        }
    }

    public void split(int orientation) {
        WorkPane workpane = (WorkPane)this.getSelectedComponent();
        if (workpane != null) {
            workpane.split(orientation, editors);
            WorkArea.refreshTitles();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.setSelectedWorkpaneCurrent();
    }

    private void setSelectedWorkpaneCurrent() {
        WorkPane workpane = (WorkPane)this.getSelectedComponent();
        if (workpane != null) {
            Main.setCurrent(workpane.getFirstEditor());
        } else {
            Main.setCurrent(null);
        }
    }

    public static void refreshTitles() {
        int m = workarea.getTabCount();
        for (int i = 0; i < m; ++i) {
            WorkPane workpane = (WorkPane)workarea.getComponentAt(i);
            workarea.setTitleAt(i, workpane.getShortTitle());
            workarea.setToolTipTextAt(i, workpane.getLongTitle());
        }
    }

    public void replaceEditor() {
        WorkPane workpane = (WorkPane)this.getSelectedComponent();
        if (workpane != null) {
            workpane.replaceEditor(editors);
            WorkArea.refreshTitles();
        }
    }

    public static void close() {
        WorkPane workpane = (WorkPane)workarea.getSelectedComponent();
        if (workpane != null) {
            workpane.close();
            WorkArea.refreshTitles();
        }
    }

    public void closeAll() {
        currentEditor = null;
        for (int i = 0; i < editors.size(); ++i) {
            CodeEditor editor = (CodeEditor)editors.elementAt(i);
            editor.closeEditor();
            WorkArea.removeWorkPaneContaining(editor);
        }
    }

    public boolean saveAll() {
        Vector<CodeDocument> processedDocuments = new Vector<CodeDocument>();
        boolean notsaved = false;
        for (int i = 0; i < editors.size(); ++i) {
            CodeEditor editor = (CodeEditor)editors.elementAt(i);
            if (!processedDocuments.contains(editor.getDocument()) && !editor.ensureSaved()) {
                notsaved = true;
            }
            processedDocuments.add(editor.getDocument());
        }
        if (notsaved) {
            return JOptionPane.showConfirmDialog(null, "Not all changes are saved, proceed with exit ?", "Exit Warning", 0) == 0;
        }
        return true;
    }

    public static void removeEditor(CodeEditor editor) {
        if (currentEditor == editor) {
            currentEditor = null;
        }
        editors.remove(editor);
    }

    public static void removeWorkPaneContaining(CodeEditor editor) {
        editors.remove(editor);
        for (int i = 0; i < workarea.getComponentCount(); ++i) {
            WorkPane pane = (WorkPane)workarea.getComponentAt(i);
            if (!pane.containsEditor(editor)) continue;
            if (editor == currentEditor) {
                currentEditor = null;
            }
            pane.removePane(editor);
        }
    }

    public static void removePane(JComponent component) {
        workarea.remove(component);
    }

    public void saveState(Writer writer) {
        int m = editors.size();
        for (int i = 0; i < m; ++i) {
            if (!(((CodeEditor)editors.elementAt(i)).getCodePane() instanceof DebugCodePane)) continue;
            WorkArea.removeWorkPaneContaining((CodeEditor)editors.elementAt(i));
        }
        XMLConfigClass cls = new XMLConfigClass(this.getClass().getName());
        for (int i = 0; i < this.getTabCount(); ++i) {
            XMLConfigMethod method = new XMLConfigMethod("addWorkPane");
            method.addArgument(((WorkPane)this.getComponentAt(i)).createStateWorkPaneObject());
            cls.addMethod(method);
        }
        cls.serialize(writer);
    }

    public static void addWorkPane(WorkPane workpane) {
        workarea.addTab(workpane.getShortTitle(), workpane);
        workpane.updateEditors(editors);
    }

    public static CodeDocument[] getDocuments() {
        int m = editors.size();
        CodeDocument[] result = new CodeDocument[m];
        for (int i = 0; i < m; ++i) {
            result[i] = ((CodeEditor)editors.elementAt(i)).getDocument();
        }
        return result;
    }

    public static CodeEditor getEditorForLongName(String longname) {
        CodeDocument[] documents = WorkArea.getDocuments();
        for (int i = 0; i < documents.length; ++i) {
            CodeEditor editor = documents[i].getCodeEditor();
            if (editor == null || editor.getLongName().compareTo(longname) != 0) continue;
            return editor;
        }
        return null;
    }

    public static CodeEditor getEditorForFile(File file) {
        CodeDocument[] documents = WorkArea.getDocuments();
        for (int i = 0; i < documents.length; ++i) {
            if (documents[i] == null || documents[i].getFile() == null || Util.getCanonicalFileName(documents[i].getFile()).compareTo(Util.getCanonicalFileName(file)) != 0) continue;
            return documents[i].getCodeEditor();
        }
        return null;
    }

    public static boolean fileOpenByAnotherEditor(File file, CodeEditor editor) {
        int m = editors.size();
        for (int i = 0; i < m; ++i) {
            if (((CodeEditor)editors.elementAt(i)).getDocument() == editor.getDocument() || !Util.FileEqual(file, ((CodeEditor)editors.elementAt(i)).getDocument().getFile())) continue;
            return true;
        }
        return false;
    }

    public void repaintAll() {
        WorkPane workpane = (WorkPane)this.getSelectedComponent();
        if (workpane != null) {
            workpane.repaintAll();
        }
    }

    public boolean isCurrent() {
        CodeEditor editor = Main.currentEditor();
        return editors.contains(editor);
    }

    public static CodeEditor getCurrentEditor() {
        return currentEditor;
    }

    public void enumerateEditors(Vector editors) {
        int m = this.getComponentCount();
        for (int i = 0; i < m; ++i) {
            if (!(this.getComponentAt(i) instanceof WorkPane)) continue;
            ((WorkPane)this.getComponentAt(i)).enumerateEditors(editors);
        }
    }

    public void next() {
        int index = this.getSelectedIndex();
        CodeEditor editor = Main.currentEditor();
        if (index >= 0 && editor != null) {
            int inext;
            CodeEditor[] editors = ((WorkPane)this.getComponentAt(index)).getEditors();
            for (inext = 0; inext < editors.length && editors[inext] != editor; ++inext) {
            }
            if (++inext < editors.length) {
                Main.setCurrent(editors[inext]);
            } else {
                if (++index >= this.getComponentCount()) {
                    index = 0;
                }
                if (index < this.getComponentCount()) {
                    Main.setCurrent(((WorkPane)this.getComponentAt(index)).getFirstEditor());
                }
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.setSelectedWorkpaneCurrent();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

