/*
 * Decompiled with CFR 0.152.
 */
package IDE.Watch;

import IDE.CodeEditor.CodeDialogBox;
import IDE.CodeEditor.CodeDocument;
import IDE.CodeEditor.CodeEditor;
import IDE.CodeEditor.Parser.Parser;
import IDE.CodeEditor.Region;
import IDE.Configuration.Mode;
import IDE.Interaction.IInteraction;
import IDE.Watch.WatchNode;
import IDE.Watch.WatchRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class Watches
extends JPanel
implements MouseListener {
    private JTree tree;
    private DefaultTreeModel treemodel;
    private DefaultMutableTreeNode root = new DefaultMutableTreeNode("Watches");
    private JScrollPane scrollpane;
    private JPopupMenu topnodemenu;
    private JPopupMenu nodemenu;

    public Watches() {
        this.treemodel = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.treemodel);
        this.tree.setCellRenderer(new WatchRenderer());
        this.scrollpane = new JScrollPane(this.tree);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollpane, "Center");
        this.tree.addMouseListener(this);
        this.createPopupMenus();
    }

    public void repaintAll() {
        this.treemodel.nodeStructureChanged(this.root);
        this.repaint();
    }

    public static void refreshWatches(final LinkedList nodeResultList) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                Iterator iter = nodeResultList.iterator();
                while (iter.hasNext()) {
                    Object element = iter.next();
                    if (!(element instanceof LinkedList) || ((LinkedList)element).size() != 2) continue;
                    Object first = ((LinkedList)element).get(0);
                    Object second = ((LinkedList)element).get(1);
                    if (!(first instanceof WatchNode)) continue;
                    Watches.refreshWatchNode((WatchNode)first, second instanceof LinkedList ? (LinkedList)second : null);
                }
            }
        });
        thread.run();
    }

    private static void refreshWatchNode(final WatchNode node, final LinkedList list) {
        Runnable updateNode = new Runnable(){

            public void run() {
                node.refresh(list);
            }
        };
        SwingUtilities.invokeLater(updateNode);
    }

    private void createPopupMenus() {
        this.topnodemenu = new JPopupMenu("Watches");
        this.topnodemenu.add(Mode.getAction("addwatch")).setIcon(null);
        this.nodemenu = new JPopupMenu("Watch");
        this.nodemenu.add(Mode.getAction("editwatch")).setIcon(null);
        this.nodemenu.add(Mode.getAction("removewatch")).setIcon(null);
    }

    public void addWatchedLeaf(CodeEditor editor, IInteraction interaction) {
        CodeDocument document = editor.getDocument();
        Parser parser = document.getParser();
        String str = document.getLeafAt(editor.cursor.cursorOffset()).getString(document);
        if (str != null) {
            WatchNode node = new WatchNode(str, str, interaction, parser.cloneParser(true), this.treemodel);
            this.tree.expandRow(0);
        }
    }

    public void addWatchPoint(CodeEditor editor, IInteraction interaction) {
        Parser parser = editor.getDocument().getParser();
        Region region = parser.findHooks(editor.cursor.cursorOffset());
        String str = region == null ? "" : editor.getDocument().getString(region.begin, region.end - region.begin + 1);
        str = CodeDialogBox.showDialog("Watch Expression", parser.cloneParser(false), str);
        if (str != null) {
            WatchNode node = new WatchNode(str, str, interaction, parser.cloneParser(true), this.treemodel);
            this.tree.expandRow(0);
        }
    }

    public void addWatchPoint(String title, String watch, IInteraction interaction) {
        if (watch != null) {
            WatchNode node = new WatchNode(title, watch, interaction, null, this.treemodel);
            this.tree.expandRow(0);
        }
    }

    public void editWatchPoint() {
        Object node = this.tree.getLastSelectedPathComponent();
        if (node instanceof WatchNode) {
            ((WatchNode)node).editWatch();
        }
    }

    public void removeWatchPointsForInteraction(IInteraction interaction) {
        int i = 0;
        while (i < this.treemodel.getChildCount(this.root)) {
            WatchNode node = (WatchNode)this.treemodel.getChild(this.root, i);
            if (node.getInteraction() == interaction) {
                this.treemodel.removeNodeFromParent(node);
                node.cleanup();
                continue;
            }
            ++i;
        }
    }

    public void removeWatchPoint() {
        Object node = this.tree.getLastSelectedPathComponent();
        if (node instanceof WatchNode) {
            this.treemodel.removeNodeFromParent((WatchNode)node);
            this.tree.repaint();
            ((WatchNode)node).cleanup();
        }
    }

    private void checkpopup(MouseEvent ev) {
        if (ev.isPopupTrigger()) {
            this.tree.clearSelection();
            this.tree.addSelectionPath(this.tree.getClosestPathForLocation(ev.getX(), ev.getY()));
            Object node = this.tree.getLastSelectedPathComponent();
            if (node instanceof WatchNode) {
                this.nodemenu.show(this.tree, ev.getX(), ev.getY());
            } else {
                this.topnodemenu.show(this.tree, ev.getX(), ev.getY());
            }
        }
    }

    public void mouseExited(MouseEvent ev) {
    }

    public void mouseReleased(MouseEvent ev) {
        this.checkpopup(ev);
    }

    public void mousePressed(MouseEvent ev) {
        this.checkpopup(ev);
    }

    public void mouseClicked(MouseEvent ev) {
        this.checkpopup(ev);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }
}

