/*
 * Decompiled with CFR 0.152.
 */
package IDE.Watch;

import IDE.CodeEditor.CodeDialogBox;
import IDE.CodeEditor.Parser.Parser;
import IDE.Interaction.IInteraction;
import IDE.Watch.AbstractWatchNode;
import IDE.Watch.WatchValueNode;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;

public class WatchNode
extends AbstractWatchNode {
    private IInteraction interaction;
    private String watch;
    private String text;
    private ImageIcon icon;
    private DefaultTreeModel treemodel;
    private Parser parser;

    public WatchNode(String title, String watch, IInteraction interaction, Parser parser, DefaultTreeModel treemodel) {
        super(watch);
        this.interaction = interaction;
        this.title = title;
        this.watch = watch;
        this.parser = parser;
        this.treemodel = treemodel;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)treemodel.getRoot();
        treemodel.insertNodeInto(this, root, root.getChildCount());
        interaction.setWatchPoint(this, watch);
    }

    public void cleanup() {
        IInteraction saved = this.interaction;
        this.interaction = null;
        saved.removeWatchPoint(this);
    }

    public void editWatch() {
        String str;
        if (this.parser != null && (str = CodeDialogBox.showDialog("Watch Expression", this.parser.cloneParser(false), this.watch)) != null) {
            this.watch = str;
            this.title = str;
            this.interaction.changeWatchPoint(this, this.watch);
        }
    }

    public IInteraction getInteraction() {
        return this.interaction;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    protected void populateWatchNode(int type, Object object, AbstractWatchNode node) {
        while (node.getChildCount() > 0) {
            this.treemodel.removeNodeFromParent((MutableTreeNode)this.treemodel.getChild(node, 0));
        }
        if (object instanceof LinkedList) {
            node.setTextAndIcon(this.interaction.getTypeString(type), this.interaction.getTypeIcon(type));
            this.populateWatchNodeList((LinkedList)object, node);
        } else {
            node.setTextAndIcon("[" + this.interaction.getTypeString(type) + "]=" + object.toString(), this.interaction.getTypeIcon(type));
            this.treemodel.nodeChanged(node);
        }
    }

    protected void populateWatchNodeList(LinkedList list, AbstractWatchNode node) {
        Iterator iterator = list.iterator();
        while (node.getChildCount() > 0) {
            this.treemodel.removeNodeFromParent((MutableTreeNode)this.treemodel.getChild(node, 0));
        }
        int i = 0;
        while (iterator.hasNext()) {
            LinkedList typeValue = (LinkedList)iterator.next();
            WatchValueNode child = new WatchValueNode("Test");
            if (typeValue.get(0) instanceof Long) {
                this.populateWatchNode(((Long)typeValue.get(0)).intValue(), typeValue.get(1), child);
            } else if (typeValue.get(0) instanceof String) {
                child.title = (String)typeValue.get(0);
                typeValue = (LinkedList)typeValue.get(1);
                this.populateWatchNode(((Long)typeValue.get(0)).intValue(), typeValue.get(1), child);
            }
            this.treemodel.insertNodeInto(child, node, i);
            ++i;
        }
    }

    public void setTextAndIcon(String text, ImageIcon icon) {
        this.text = text;
        this.icon = icon;
        this.treemodel.nodeChanged(this);
    }

    public String getDisplayString() {
        return this.title + "==>" + this.text;
    }

    public boolean isLeaf() {
        return false;
    }

    public void refresh(LinkedList list) {
        if (this.interaction == null) {
            return;
        }
        if (list == null) {
            this.text = "Unknown";
            this.icon = this.interaction.getTypeIcon(0);
            this.treemodel.nodeChanged(this);
        } else if (list.size() > 1) {
            this.text = "Multiple Values";
            this.icon = this.interaction.getTypeIcon(0);
            this.populateWatchNodeList(list, this);
        } else {
            list = (LinkedList)list.get(0);
            this.populateWatchNode(((Long)list.get(0)).intValue(), list.get(1), this);
        }
    }
}

