/*
 * Decompiled with CFR 0.152.
 */
package IDE.Utilities;

import IDE.Messaging.MessageHandler;
import java.io.File;

public class Util {
    public static String getCanonicalFileName(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (Exception e) {
            MessageHandler.report("IO Error when trying to determine the canonical file name of a file, returning the absolute path name", e);
            return file.getAbsolutePath();
        }
    }

    public static boolean FileEqual(File f1, File f2) {
        return Util.getCanonicalFileName(f1).compareTo(Util.getCanonicalFileName(f2)) == 0;
    }

    public static File renameFileInDir(File file, File dir) {
        return new File(dir, file.getName());
    }

    public static File findFile(String name) {
        File[] roots = File.listRoots();
        if (roots == null) {
            return null;
        }
        int i = 0;
        if (i < roots.length) {
            File found = Util.findFile(roots[i], name);
            if (found != null) {
                return found;
            }
            return null;
        }
        return null;
    }

    public static File findFile(File dir, String name) {
        if (!dir.isDirectory()) {
            return null;
        }
        if (dir.getName().compareTo(name) == 0) {
            return dir;
        }
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File found;
            if (files[i].getName().compareTo(name) == 0) {
                return files[i];
            }
            if (!files[i].isDirectory() || (found = Util.findFile(files[i], name)) == null) continue;
            return found;
        }
        return null;
    }

    public static String normalize(String input) {
        StringBuffer buffer = new StringBuffer();
        block4: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '\\': {
                    buffer.append('\\');
                    buffer.append(c);
                    continue block4;
                }
                case '\"': {
                    buffer.append('\\');
                    buffer.append(c);
                    continue block4;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }
}

