/*
 * Decompiled with CFR 0.152.
 */
package IDE.Search;

import IDE.CodeEditor.CodeEditor;
import IDE.CodeEditor.CodeHighLighter;
import IDE.Configuration.Configuration;
import IDE.Main;
import IDE.Messaging.IQuestion;
import IDE.Messaging.InstructionField;
import java.util.HashMap;

public class SearchAndReplace
implements IQuestion {
    private boolean replace = false;
    private boolean forward;
    boolean endorbegin = false;
    private String search = "";
    private int start;
    private CodeEditor editor;
    private HashMap founds;
    private char[] chars;
    private CodeHighLighter highlighter;

    public boolean restoreState() {
        CodeEditor editor = Main.currentEditor();
        if (editor != null) {
            this.editor = editor;
            this.highlighter = editor.highlighter;
            this.founds = new HashMap();
            this.forward = true;
            this.start = editor.cursor.cursorOffset();
            this.chars = editor.getDocument().getChars();
            this.highlighter.removeHighLight("60search");
            this.search = "";
            this.replace = false;
            this.endorbegin = false;
            this.searchForward();
            return true;
        }
        return false;
    }

    public void setInitialText(String text) {
        this.search = text;
    }

    public void completeAnswer(String answer) {
        if (!this.replace && this.matches(this.start)) {
            this.replace = true;
        } else if (this.replace) {
            if (this.matches(this.start)) {
                this.editor.replace(this.start, this.search.length(), answer);
                this.chars = this.editor.getDocument().getChars();
            }
            if (this.forward) {
                this.searchForward();
            } else {
                this.searchBackward();
            }
        }
    }

    public String guideText() {
        if (this.replace) {
            return "Replace <" + this.search + "> by ";
        }
        if (this.endorbegin) {
            return "Search and replace (wrap around) ctrl-(delete=clear,n=next,p=previous), enter=replace";
        }
        return "Search and replace ctrl-(delete=clear,n=next,p=previous), enter-replace";
    }

    public String initialText() {
        return "";
    }

    public void keyPressed(int keycode, int modifiers) {
        if (modifiers == 2) {
            if (keycode == 127) {
                this.search = "";
                InstructionField.updateText("");
            } else if (keycode == 78) {
                ++this.start;
                this.searchForward();
            } else if (keycode == 80) {
                --this.start;
                this.searchBackward();
            }
        }
    }

    public void newAnswer(String answer) {
        if (!this.replace) {
            if (this.search.startsWith(answer)) {
                this.search = answer;
                Integer newstart = (Integer)this.founds.get(this.search);
                if (newstart != null) {
                    this.start = newstart;
                    this.searchForward();
                }
            } else {
                this.search = answer;
                this.searchForward();
            }
        }
    }

    private boolean matches(int offset) {
        int i;
        int l = this.search.length();
        for (i = 0; i < l && i + offset < this.chars.length && this.chars[i + offset] == this.search.charAt(i); ++i) {
        }
        return i == l;
    }

    private void searchForward() {
        int i;
        this.highlighter.removeHighLight("60search");
        for (i = this.start; i > -1 && i < this.chars.length && !this.matches(i); ++i) {
        }
        if (i < this.chars.length && i > -1) {
            this.endorbegin = false;
            if (this.founds.get(this.search) == null) {
                this.founds.put(this.search, new Integer(i));
            }
            this.start = i;
            this.editor.cursor.setCursor(i, false);
            this.highlighter.addHighLightRegion("60search", Configuration.colorSearch, i, this.search.length(), true);
        } else {
            this.endorbegin = true;
            this.start = 0;
        }
    }

    private void searchBackward() {
        int i;
        this.highlighter.removeHighLight("60search");
        for (i = this.start; i > -1 && i < this.chars.length && !this.matches(i); --i) {
        }
        if (i < this.chars.length && i > -1) {
            this.endorbegin = false;
            if (this.founds.get(this.search) == null) {
                this.founds.put(this.search, new Integer(i));
            }
            this.start = i;
            this.editor.cursor.setCursor(i, false);
            this.highlighter.addHighLightRegion("60search", Configuration.colorSearch, i, this.search.length(), true);
        } else {
            this.endorbegin = true;
            this.start = this.chars.length - 1;
        }
    }

    public boolean abort() {
        return true;
    }
}

