/*
 * Decompiled with CFR 0.152.
 */
package IDE.Search;

import IDE.CodeEditor.CodeDocument;
import IDE.CodeEditor.CodeEditor;
import IDE.CodeEditor.CodeLine;
import IDE.CodeEditor.CodePane;
import IDE.CodeEditor.Parser.Parser;
import IDE.Configuration.Configuration;
import IDE.Explorer.Explorer;
import IDE.Explorer.FileExtensions;
import IDE.Explorer.ProjectNode;
import IDE.Main;
import IDE.Messaging.MessageHandler;
import IDE.Search.BooleanEditor;
import IDE.Search.BooleanRenderer;
import IDE.Search.ResultMouseListener;
import IDE.Search.ResultTableModel;
import IDE.Search.SimpleMatcher;
import IDE.Utilities.Util;
import IDE.WorkArea.WorkArea;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class RegularExpressionSearch {
    private static JDialog dialog;
    private static JTextField searchField;
    private static JTextField replaceField;
    private static JRadioButton caseSensitiveButton;
    private static JRadioButton caseInsensitiveButton;
    private static JRadioButton regexpressionButton;
    private static JCheckBox multifileCheckBox;
    private static JComboBox projectsBox;
    private static JButton replaceButton;
    private static JButton replaceAllButton;
    private static JButton closeButton;
    private static JButton searchButton;
    private static JTable resultList;
    private static Vector sources;
    private static Vector starts;
    private static Vector ends;
    private static Vector lines;
    private static ProjectNode[] projects;
    static /* synthetic */ Class class$java$lang$Boolean;

    public static void SearchAndReplace() {
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 1));
        dialog = new JDialog();
        dialog.setTitle("Search");
        dialog.setModal(false);
        dialog.setSize(600, 300);
        dialog.setContentPane(content);
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent ev) {
                RegularExpressionSearch.processClose();
            }
        });
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        JPanel searchAndReplace = new JPanel(gbl);
        content.add(searchAndReplace);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.2;
        JLabel searchLabel = new JLabel("Search For:");
        gbl.setConstraints(searchLabel, gbc);
        searchAndReplace.add(searchLabel);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.8;
        searchField = new JTextField();
        gbl.setConstraints(searchField, gbc);
        searchAndReplace.add(searchField);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.2;
        JLabel replaceLabel = new JLabel("Replace By:");
        gbl.setConstraints(replaceLabel, gbc);
        searchAndReplace.add(replaceLabel);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 0.8;
        replaceField = new JTextField();
        gbl.setConstraints(replaceField, gbc);
        searchAndReplace.add(replaceField);
        JPanel radiobuttons = new JPanel(new FlowLayout(0));
        content.add(radiobuttons);
        ButtonGroup buttongroup = new ButtonGroup();
        regexpressionButton = new JRadioButton("Regular expression search");
        caseSensitiveButton = new JRadioButton("Case sensitive search");
        caseInsensitiveButton = new JRadioButton("Case insensitive search");
        caseInsensitiveButton.setSelected(true);
        buttongroup.add(regexpressionButton);
        buttongroup.add(caseSensitiveButton);
        buttongroup.add(caseInsensitiveButton);
        radiobuttons.add(regexpressionButton);
        radiobuttons.add(caseSensitiveButton);
        radiobuttons.add(caseInsensitiveButton);
        JPanel checkbuttons = new JPanel(new FlowLayout(0));
        multifileCheckBox = new JCheckBox("Search all project files");
        projectsBox = new JComboBox();
        projects = Explorer.getProjects();
        for (int i = 0; i < projects.length; ++i) {
            projectsBox.addItem(projects[i].getText());
        }
        checkbuttons.add(multifileCheckBox);
        checkbuttons.add(projectsBox);
        content.add(checkbuttons);
        resultList = new JTable();
        resultList.setDefaultRenderer(class$java$lang$Boolean == null ? (class$java$lang$Boolean = RegularExpressionSearch.class$("java.lang.Boolean")) : class$java$lang$Boolean, new BooleanRenderer());
        resultList.setDefaultEditor(class$java$lang$Boolean == null ? (class$java$lang$Boolean = RegularExpressionSearch.class$("java.lang.Boolean")) : class$java$lang$Boolean, new BooleanEditor(resultList));
        resultList.setAutoResizeMode(4);
        resultList.getSelectionModel().setSelectionMode(0);
        resultList.addMouseListener(new ResultMouseListener());
        JScrollPane scrollpane = new JScrollPane(resultList);
        scrollpane.setSize(600, 200);
        content.add(scrollpane);
        JPanel buttons = new JPanel(new FlowLayout(0));
        content.add(buttons);
        searchButton = new JButton(new AbstractAction("Search"){

            public void actionPerformed(ActionEvent ev) {
                RegularExpressionSearch.processSearch();
            }
        });
        replaceButton = new JButton(new AbstractAction("Replace"){

            public void actionPerformed(ActionEvent ev) {
                RegularExpressionSearch.processReplace();
            }
        });
        replaceAllButton = new JButton(new AbstractAction("Replace All"){

            public void actionPerformed(ActionEvent ev) {
                RegularExpressionSearch.processReplaceAll();
            }
        });
        closeButton = new JButton(new AbstractAction("Close"){

            public void actionPerformed(ActionEvent ev) {
                RegularExpressionSearch.processClose();
            }
        });
        buttons.add(searchButton);
        buttons.add(replaceButton);
        buttons.add(replaceAllButton);
        buttons.add(closeButton);
        dialog.setVisible(true);
    }

    private static void processReplaceAll() {
        int m = resultList.getRowCount();
        for (int i = 0; i < m; ++i) {
            resultList.setValueAt(new Boolean(true), i, 0);
        }
        RegularExpressionSearch.processReplace();
    }

    private static void processReplace() {
        String oldpath = null;
        File file = null;
        Serializable source = null;
        int delta = 0;
        TableModel tm = resultList.getModel();
        int m = tm.getRowCount();
        for (int i = 0; i < m; ++i) {
            if (!((Boolean)tm.getValueAt(i, 0)).booleanValue()) continue;
            String path = (String)tm.getValueAt(i, 1);
            int begin = (Integer)tm.getValueAt(i, 3);
            int end = (Integer)tm.getValueAt(i, 4);
            if (oldpath == null || path.compareTo(oldpath) != 0) {
                delta = 0;
                if (source instanceof StringBuffer) {
                    RegularExpressionSearch.saveBuffer((StringBuffer)source, file);
                }
                oldpath = path;
                file = new File(path);
                source = WorkArea.getEditorForLongName(path);
                if (source == null) {
                    try {
                        BufferedReader reader = new BufferedReader(new FileReader(file));
                        char[] chars = new char[(int)file.length()];
                        reader.read(chars);
                        source = new StringBuffer(CodeDocument.removeTabs(new String(chars)));
                    }
                    catch (IOException e) {
                        MessageHandler.warn(e.getMessage());
                    }
                }
            }
            if (source instanceof StringBuffer) {
                RegularExpressionSearch.replaceBuffer((StringBuffer)source, begin + delta, end + delta);
            } else if (source instanceof CodeEditor) {
                RegularExpressionSearch.replaceDocument(source, begin + delta, end + delta);
            }
            delta = delta - end + begin + replaceField.getText().length();
        }
        if (source instanceof StringBuffer) {
            RegularExpressionSearch.saveBuffer((StringBuffer)source, file);
        }
        RegularExpressionSearch.processSearch();
    }

    private static void replaceDocument(CodeEditor editor, int begin, int end) {
        CodeDocument document = editor.getDocument();
        document.remove(begin, end - begin);
        document.insertStringAt(replaceField.getText(), begin);
    }

    private static void replaceBuffer(StringBuffer buffer, int begin, int end) {
        buffer.replace(begin, end, replaceField.getText());
    }

    private static void saveBuffer(StringBuffer buffer, final File file) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            writer.write(buffer.toString());
            writer.close();
            Thread reparse = new Thread(){

                public void run() {
                    Explorer.refreshFileNode(file);
                }
            };
            reparse.start();
        }
        catch (IOException e) {
            MessageHandler.warn(e.getMessage());
        }
    }

    private static void processSearch() {
        CodeEditor editor;
        sources.clear();
        starts.clear();
        ends.clear();
        lines.clear();
        if (regexpressionButton.isSelected()) {
            if (multifileCheckBox.isSelected()) {
                RegularExpressionSearch.regExpSearchFiles();
            } else {
                editor = Main.currentEditor();
                if (editor != null) {
                    RegularExpressionSearch.regExpSearchDocument(editor.getDocument());
                }
            }
        } else if (multifileCheckBox.isSelected()) {
            RegularExpressionSearch.searchFiles();
        } else {
            editor = Main.currentEditor();
            if (editor != null) {
                RegularExpressionSearch.searchDocument(editor.getDocument());
            }
        }
        resultList.setModel(new ResultTableModel(sources, starts, ends, lines));
        TableColumnModel cm = resultList.getColumnModel();
        cm.getColumn(0).setMaxWidth(20);
        cm.getColumn(2).setMinWidth(200);
        cm.getColumn(3).setPreferredWidth(50);
        resultList.doLayout();
    }

    private static void processClose() {
        dialog.setVisible(false);
        sources.clear();
        starts.clear();
        ends.clear();
        lines.clear();
    }

    private static void searchFiles() {
        if (projects.length == 0) {
            return;
        }
        File[] files = Explorer.getFilesInProject(projects[projectsBox.getSelectedIndex()]);
        for (int i = 0; i < files.length; ++i) {
            RegularExpressionSearch.searchFile(files[i]);
        }
    }

    private static void searchFile(File file) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            char[] content = new char[(int)file.length()];
            reader.read(content);
            String str = CodeDocument.removeTabs(new String(content));
            SimpleMatcher matcher = new SimpleMatcher(str, searchField.getText(), caseInsensitiveButton.isSelected());
            String path = Util.getCanonicalFileName(file);
            while (matcher.find()) {
                sources.add(path);
                starts.add(new Integer(matcher.start()));
                ends.add(new Integer(matcher.end()));
                lines.add(RegularExpressionSearch.getLine(str, matcher.start()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void regExpSearchFiles() {
        if (projects.length == 0) {
            return;
        }
        File[] files = Explorer.getFilesInProject(projects[projectsBox.getSelectedIndex()]);
        for (int i = 0; i < files.length; ++i) {
            RegularExpressionSearch.regExpSearchFile(files[i]);
        }
    }

    private static void regExpSearchFile(File file) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            char[] content = new char[(int)file.length()];
            reader.read(content);
            String str = CodeDocument.removeTabs(new String(content));
            Pattern pattern = Pattern.compile(searchField.getText());
            Matcher matcher = pattern.matcher(str);
            String path = Util.getCanonicalFileName(file);
            while (matcher.find()) {
                sources.add(path);
                starts.add(new Integer(matcher.start()));
                ends.add(new Integer(matcher.end()));
                lines.add(RegularExpressionSearch.getLine(str, matcher.start()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String getLine(String str, int pos) {
        int i;
        for (i = pos; i >= 0 && i < str.length() && str.charAt(i) != '\n'; --i) {
        }
        int begin = i + 1;
        for (i = pos; i < str.length() && str.charAt(i) != '\n'; ++i) {
        }
        int end = i;
        return str.substring(begin, end);
    }

    private static void searchDocument(CodeDocument document) {
        CodeEditor editor = document.getCodeEditor();
        String content = document.getString(0, document.length());
        try {
            String found;
            SimpleMatcher matcher = new SimpleMatcher(content, searchField.getText(), caseInsensitiveButton.isSelected());
            String string = found = editor == null ? Util.getCanonicalFileName(document.getFile()) : editor.getLongName();
            while (matcher.find()) {
                sources.add(found);
                starts.add(new Integer(matcher.start()));
                ends.add(new Integer(matcher.end()));
                CodeLine line = document.getLineAt(matcher.start());
                if (line == null) continue;
                lines.add(document.getString(line.begin(), line.end() - line.begin()));
            }
        }
        catch (PatternSyntaxException e) {
            MessageHandler.warn(e.getMessage());
        }
    }

    private static void regExpSearchDocument(CodeDocument document) {
        CodeEditor editor = document.getCodeEditor();
        String content = document.getString(0, document.length());
        try {
            String found;
            Pattern pattern = Pattern.compile(searchField.getText());
            Matcher matcher = pattern.matcher(content);
            String string = found = editor == null ? Util.getCanonicalFileName(document.getFile()) : editor.getLongName();
            while (matcher.find()) {
                sources.add(found);
                starts.add(new Integer(matcher.start()));
                ends.add(new Integer(matcher.end()));
                CodeLine line = document.getLineAt(matcher.start());
                if (line == null) continue;
                lines.add(document.getString(line.begin(), line.end() - line.begin()));
            }
        }
        catch (PatternSyntaxException e) {
            MessageHandler.warn(e.getMessage());
        }
    }

    protected static void selectMatch(CodeEditor editor, JTable table, int row) {
        Main.setCurrent(editor);
        TableModel model = table.getModel();
        int begin = (Integer)model.getValueAt(row, 3);
        int end = (Integer)model.getValueAt(row, 4);
        editor.cursor.setCursor(begin);
        editor.highlighter.removeHighLight("60search");
        editor.highlighter.addHighLightRegion("60search", Configuration.colorSearch, begin, end - begin, true);
    }

    protected static void selectMatch(File file, JTable table, int row) {
        TableModel model = table.getModel();
        int begin = (Integer)model.getValueAt(row, 3);
        int end = (Integer)model.getValueAt(row, 4);
        Parser parser = FileExtensions.createParser(file, false);
        if (parser == null) {
            return;
        }
        CodePane codepane = CodePane.createCodePane(parser, file);
        WorkArea.addPane(codepane);
        CodeEditor editor = codepane.getEditor();
        Main.setCurrent(editor);
        editor.cursor.setCursor(begin);
        editor.highlighter.removeHighLight("60search");
        editor.highlighter.addHighLightRegion("60search", Configuration.colorSearch, begin, end - begin, true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        sources = new Vector(0);
        starts = new Vector(0);
        ends = new Vector(0);
        lines = new Vector(0);
    }
}

