/*
 * Decompiled with CFR 0.152.
 */
package IDE.Search;

import IDE.CodeEditor.CodeEditor;
import IDE.CodeEditor.CodeHighLighter;
import IDE.Configuration.Configuration;
import IDE.Main;
import IDE.Messaging.IQuestion;
import IDE.Messaging.InstructionField;
import IDE.Recording.Recording;
import java.util.HashMap;

public class IncrementalSearch
implements IQuestion {
    private boolean forward;
    private boolean endorbegin = false;
    private int start;
    private String search = "";
    private CodeEditor editor;
    private HashMap founds;
    char[] chars;
    private CodeHighLighter highlighter;

    public IncrementalSearch(boolean forward) {
        this.forward = forward;
    }

    public boolean restoreState() {
        CodeEditor editor = Main.currentEditor();
        if (editor != null) {
            this.editor = editor;
            this.founds = new HashMap();
            this.endorbegin = false;
            if (Recording.isReplaying()) {
                this.search = "";
            }
            this.start = editor.cursor.cursorOffset();
            this.chars = editor.getDocument().getChars();
            this.highlighter = editor.highlighter;
            this.highlighter.removeHighLight("60search");
            if (this.forward) {
                this.searchForward();
            } else {
                this.searchBackward();
            }
            return true;
        }
        return false;
    }

    public void setInitialText(String text) {
        this.search = text;
    }

    private boolean matches(int offset) {
        int i;
        int l = this.search.length();
        for (i = 0; i < l && i + offset < this.chars.length && this.chars[i + offset] == this.search.charAt(i); ++i) {
        }
        return i == l;
    }

    private void searchForward() {
        int i;
        this.highlighter.removeHighLight("60search");
        for (i = this.start; i > -1 && i < this.chars.length && !this.matches(i); ++i) {
        }
        if (i < this.chars.length && i > -1) {
            this.endorbegin = false;
            if (this.founds.get(this.search) == null) {
                this.founds.put(this.search, new Integer(i));
            }
            this.start = i;
            this.editor.cursor.setCursor(i);
            this.highlighter.addHighLightRegion("60search", Configuration.colorSearch, i, this.search.length(), true);
        } else {
            this.endorbegin = true;
            this.start = 0;
        }
    }

    private void searchBackward() {
        int i;
        this.highlighter.removeHighLight("60search");
        for (i = this.start; i > -1 && i < this.chars.length && !this.matches(i); --i) {
        }
        if (i < this.chars.length && i > -1) {
            this.endorbegin = false;
            if (this.founds.get(this.search) == null) {
                this.founds.put(this.search, new Integer(i));
            }
            this.start = i;
            this.editor.cursor.setCursor(i);
            this.highlighter.addHighLightRegion("60search", Configuration.colorSearch, i, this.search.length(), true);
        } else {
            this.endorbegin = true;
            this.start = this.chars.length - 1;
        }
    }

    public void completeAnswer(String answer) {
    }

    public void newAnswer(String answer) {
        if (this.search.startsWith(answer)) {
            this.search = answer;
            Integer newstart = (Integer)this.founds.get(this.search);
            if (newstart != null) {
                this.start = newstart;
                if (this.forward) {
                    this.searchForward();
                } else {
                    this.searchBackward();
                }
            }
        } else {
            this.search = answer;
            if (this.forward) {
                this.searchForward();
            } else {
                this.searchBackward();
            }
        }
    }

    public void keyPressed(int keycode, int modifiers) {
        if (modifiers == 2) {
            if (keycode == 127) {
                this.search = "";
                InstructionField.updateText("");
            } else if (keycode == 78) {
                ++this.start;
                this.searchForward();
            } else if (keycode == 80) {
                --this.start;
                this.searchBackward();
            }
        }
    }

    public String guideText() {
        if (this.endorbegin) {
            return "Search (wrap around)  ctrl-(delete=clear,n=next,p=previous)";
        }
        return "Search expression ctrl-(delete=clear,n=next,p=previous)";
    }

    public String initialText() {
        return this.search;
    }

    public boolean abort() {
        this.highlighter.removeHighLight("60search");
        return true;
    }
}

