/*
 * Decompiled with CFR 0.152.
 */
package IDE.Search;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

class BooleanEditor
extends JCheckBox
implements TableCellEditor {
    JTable table;
    private Vector listeners = new Vector();
    boolean original = false;

    public BooleanEditor(JTable table) {
        this.table = table;
        this.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                BooleanEditor.this.table.setValueAt(new Boolean(BooleanEditor.this.isSelected()), BooleanEditor.this.table.getSelectedRow(), 0);
            }
        });
    }

    public void addCellEditorListener(CellEditorListener listener) {
        this.listeners.addElement(listener);
    }

    public void cancelCellEditing() {
        this.setSelected(this.original);
        int m = this.listeners.size();
        ChangeEvent ev = new ChangeEvent(this);
        for (int i = 0; i < m; ++i) {
            ((CellEditorListener)this.listeners.elementAt(i)).editingCanceled(ev);
        }
    }

    public Object getCellEditorValue() {
        return new Boolean(this.isSelected());
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        this.setSelected((Boolean)value);
        this.original = (Boolean)value;
        table.setRowSelectionInterval(row, row);
        table.setColumnSelectionInterval(col, col);
        return this;
    }

    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    public void removeCellEditorListener(CellEditorListener listener) {
        this.listeners.remove(listener);
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    public boolean stopCellEditing() {
        int m = this.listeners.size();
        ChangeEvent ev = new ChangeEvent(this);
        for (int i = 0; i < m; ++i) {
            ((CellEditorListener)this.listeners.elementAt(i)).editingStopped(ev);
        }
        return true;
    }
}

