/*
 * Decompiled with CFR 0.152.
 */
package IDE.Recording;

import IDE.CodeEditor.CodeEditor;
import IDE.Configuration.AbstractIDEAction;
import IDE.Configuration.AbstractManagedAction;
import IDE.Configuration.Mode;
import IDE.Configuration.XMLConfigClass;
import IDE.Configuration.XMLConfigMethod;
import IDE.IIDEAddin;
import IDE.Main;
import IDE.Messaging.IQuestion;
import IDE.Messaging.InstructionField;
import IDE.Messaging.MessageHandler;
import IDE.Recording.Macro;
import IDE.Recording.RecordActionEvent;
import IDE.Recording.RecordKeyEvent;
import IDE.Recording.RecordQuestionEvent;
import java.awt.event.KeyEvent;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;

public class Recording
implements IIDEAddin {
    private static boolean replaying = false;
    private static Macro currentMacro = null;
    private static HashMap nameToMacro = new HashMap();
    private static boolean recording = false;
    private static Recording self = null;

    private Recording() {
        self = this;
    }

    public static Recording getRecording() {
        if (self == null) {
            return new Recording();
        }
        return self;
    }

    public static void startRecording() {
        MessageHandler.say("Start recording");
        currentMacro = new Macro();
        recording = true;
    }

    public static void stopRecording() {
        nameToMacro.put("*", currentMacro);
        currentMacro.setName("*");
        Main.getMacroExplorer().addMacroNode("*");
        recording = false;
    }

    public static void stopRecording(String name) {
        nameToMacro.put(name, currentMacro);
        currentMacro.setName(name);
        Main.getMacroExplorer().addMacroNode(name);
        recording = false;
    }

    public static void abortRecording() {
        currentMacro = null;
        recording = false;
    }

    public static void recordInsertDeadKeyEvent(char unicodechar) {
        if (recording) {
            currentMacro.recordInsertDeadKeyEvent(unicodechar);
        }
    }

    public static void recordActionEvent(AbstractIDEAction action) {
        if (recording) {
            currentMacro.recordActionEvent(action);
        }
    }

    public static void recordQuestionEvent(IQuestion question, int keycode, int modifiers, String text, int type) {
        if (recording) {
            currentMacro.recordQuestionEvent(question, keycode, modifiers, text, type);
        }
    }

    public static void recordKeyEventPressed(KeyEvent ev) {
        if (recording) {
            currentMacro.recordKeyEvent(ev.getID(), ev.getWhen(), ev.getModifiers(), ev.getKeyCode(), ev.getKeyChar(), ev.getKeyLocation(), 1);
        }
    }

    public static void recordKeyEventTyped(KeyEvent ev) {
        if (recording) {
            currentMacro.recordKeyEvent(ev.getID(), ev.getWhen(), ev.getModifiers(), ev.getKeyCode(), ev.getKeyChar(), ev.getKeyLocation(), 0);
        }
    }

    public static void removeMacro(String name) {
        nameToMacro.remove(name);
    }

    public static void replay() {
        CodeEditor current = Main.currentEditor();
        if (currentMacro != null) {
            replaying = true;
            currentMacro.replay();
            replaying = false;
        }
        if (current != null) {
            current.grabFocus();
        }
    }

    public static void replay(String name) {
        CodeEditor current = Main.currentEditor();
        Macro macro = (Macro)nameToMacro.get(name);
        if (macro != null) {
            replaying = true;
            currentMacro = macro;
            currentMacro.replay();
            replaying = false;
        }
        if (current != null) {
            current.grabFocus();
        }
    }

    public static boolean isReplaying() {
        return replaying;
    }

    public static Macro getMacro(String name) {
        return (Macro)nameToMacro.get(name);
    }

    public void saveState(Writer writer) {
        XMLConfigMethod method;
        XMLConfigClass cls = new XMLConfigClass(self.getClass().getName());
        nameToMacro.remove("*");
        Iterator itermacro = nameToMacro.values().iterator();
        while (itermacro.hasNext()) {
            Macro macro = (Macro)itermacro.next();
            if (macro.getName() == null) continue;
            Iterator records = macro.getRecordIterator();
            while (records.hasNext()) {
                Object record = records.next();
                if (record instanceof RecordActionEvent) {
                    RecordActionEvent actionevent = (RecordActionEvent)record;
                    method = new XMLConfigMethod("addActionRecord");
                    method.addArgument(macro.getName());
                    method.addArgument(Mode.getNameAction(actionevent.getAction()));
                    cls.addMethod(method);
                    continue;
                }
                if (record instanceof RecordQuestionEvent) {
                    RecordQuestionEvent questionevent = (RecordQuestionEvent)record;
                    method = new XMLConfigMethod("addQuestionRecord");
                    method.addArgument(macro.getName());
                    method.addArgument(InstructionField.getQuestionName(questionevent.getQuestion()));
                    method.addArgument(questionevent.getKeyCode());
                    method.addArgument(questionevent.getModifiers());
                    method.addArgument(questionevent.getText());
                    method.addArgument(questionevent.getType());
                    cls.addMethod(method);
                    continue;
                }
                if (!(record instanceof RecordKeyEvent)) continue;
                RecordKeyEvent keyevent = (RecordKeyEvent)record;
                method = new XMLConfigMethod("addKeyEventRecord");
                method.addArgument(macro.getName());
                method.addArgument(keyevent.getId());
                method.addArgument(keyevent.getWhen());
                method.addArgument(keyevent.getModifiers());
                method.addArgument(keyevent.getKeycode());
                method.addArgument(keyevent.getKeychar());
                method.addArgument(keyevent.getKeylocation());
                method.addArgument(keyevent.getType());
                cls.addMethod(method);
            }
        }
        method = new XMLConfigMethod("updateMacroExplorer");
        cls.addMethod(method);
        cls.serialize(writer);
    }

    public static void addQuestionRecord(String macroname, String questionname, int keycode, int modifiers, String text, int type) {
        Macro macro = (Macro)nameToMacro.get(macroname);
        if (macro == null) {
            macro = new Macro();
            nameToMacro.put(macroname, macro);
            macro.setName(macroname);
        }
        macro.recordQuestionEvent(InstructionField.getQuestion(questionname), keycode, modifiers, text, type);
    }

    public static void addActionRecord(String macroname, String actionname) {
        Macro macro = (Macro)nameToMacro.get(macroname);
        AbstractManagedAction action = Mode.getAction(actionname);
        if (action instanceof AbstractIDEAction) {
            if (macro == null) {
                macro = new Macro();
                nameToMacro.put(macroname, macro);
                macro.setName(macroname);
            }
            macro.recordActionEvent((AbstractIDEAction)action);
        }
    }

    public static void addKeyEventRecord(String macroname, int id, long when, int modifiers, int keycode, char keychar, int keylocation, int type) {
        Macro macro = (Macro)nameToMacro.get(macroname);
        if (macro == null) {
            macro = new Macro();
            nameToMacro.put(macroname, macro);
            macro.setName(macroname);
        }
        macro.recordKeyEvent(id, when, modifiers, keycode, keychar, keylocation, type);
    }

    public static void updateMacroExplorer() {
        Iterator iter = nameToMacro.keySet().iterator();
        while (iter.hasNext()) {
            Main.getMacroExplorer().addMacroNode((String)iter.next());
        }
    }
}

