/*
 * Decompiled with CFR 0.152.
 */
package IDE.Recording;

import IDE.Configuration.Configuration;
import IDE.Recording.AbstractMacroNode;
import IDE.Recording.MacroActionNode;
import IDE.Recording.MacroInsertDeadKey;
import IDE.Recording.MacroKeyNode;
import IDE.Recording.MacroNode;
import IDE.Recording.MacroQuestionNode;
import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;

public class MacroRenderer
extends JLabel
implements TreeCellRenderer {
    private static final ImageIcon iconRoot = Configuration.getIcon("macros.png");
    private static final ImageIcon iconMacroNode = Configuration.getIcon("macro.png");
    private static final ImageIcon iconActionNode = Configuration.getIcon("action.png");
    private static final ImageIcon iconQuestionNode = Configuration.getIcon("question.png");
    private static final ImageIcon iconKeyNode = Configuration.getIcon("key.png");

    private String imageFile(String filename) {
        String separator = System.getProperty("file.separator");
        String result = Configuration.installDirectory + separator + "java" + separator + "image" + separator + filename;
        return result;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasfocus) {
        this.setFont(Configuration.macrosFont);
        if (selected) {
            this.setOpaque(true);
            this.setBackground(Configuration.colorSelected);
            this.setForeground(Color.black);
        } else {
            this.setOpaque(false);
            this.setForeground(Color.black);
        }
        if (value instanceof AbstractMacroNode) {
            this.setText(((AbstractMacroNode)value).getName());
            if (value instanceof MacroNode) {
                this.setIcon(iconMacroNode);
            } else if (value instanceof MacroActionNode) {
                this.setIcon(iconActionNode);
            } else if (value instanceof MacroQuestionNode) {
                this.setIcon(iconQuestionNode);
            } else if (value instanceof MacroKeyNode) {
                this.setIcon(iconKeyNode);
            } else if (value instanceof MacroInsertDeadKey) {
                this.setIcon(iconKeyNode);
            }
        } else {
            this.setText("All Macros and Lisp Scripts");
            this.setIcon(iconRoot);
        }
        return this;
    }
}

