/*
 * Decompiled with CFR 0.152.
 */
package IDE.Recording;

import IDE.Configuration.Mode;
import IDE.Recording.AbstractMacroNode;
import IDE.Recording.Macro;
import IDE.Recording.MacroActionNode;
import IDE.Recording.MacroInsertDeadKey;
import IDE.Recording.MacroKeyNode;
import IDE.Recording.MacroNode;
import IDE.Recording.MacroQuestionNode;
import IDE.Recording.MacroRenderer;
import IDE.Recording.RecordActionEvent;
import IDE.Recording.RecordInsertDeadKeyEvent;
import IDE.Recording.RecordKeyEvent;
import IDE.Recording.RecordQuestionEvent;
import IDE.Recording.Recording;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class MacroExplorer
extends JPanel
implements MouseListener {
    private JTree tree;
    private DefaultTreeModel treemodel;
    private DefaultMutableTreeNode root = new DefaultMutableTreeNode("All Macros And Lisp Scripts");
    private JScrollPane scrollpane;
    private JPopupMenu rootnodemenu;
    private JPopupMenu macronodemenu;

    public MacroExplorer() {
        this.treemodel = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.treemodel);
        this.tree.setCellRenderer(new MacroRenderer());
        this.scrollpane = new JScrollPane(this.tree);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollpane, "Center");
        this.tree.addMouseListener(this);
        this.createPopupMenus();
    }

    public void repaintAll() {
        this.treemodel.nodeStructureChanged(this.root);
        this.repaint();
    }

    private void createPopupMenus() {
        this.rootnodemenu = new JPopupMenu("Macros/Scripts");
        this.rootnodemenu.add(Mode.getAction("startrecording")).setIcon(null);
        this.rootnodemenu.add(Mode.getAction("stoprecording")).setIcon(null);
        this.rootnodemenu.add(Mode.getAction("replayrecording")).setIcon(null);
        this.macronodemenu = new JPopupMenu("Macro");
        this.macronodemenu.add(new AbstractAction("Replay"){

            public void actionPerformed(ActionEvent ev) {
                MacroExplorer.this.replayMacroNode();
            }
        });
        this.macronodemenu.add(new AbstractAction("Delete"){

            public void actionPerformed(ActionEvent ev) {
                MacroExplorer.this.removeMacroNode();
            }
        });
    }

    private void replayMacroNode() {
        Object node = this.tree.getLastSelectedPathComponent();
        if (node instanceof MacroNode) {
            Recording.replay(((MacroNode)node).getName());
        }
    }

    private void removeMacroNode() {
        Object node = this.tree.getLastSelectedPathComponent();
        if (node instanceof MacroNode) {
            Recording.removeMacro(((MacroNode)node).getName());
            this.treemodel.removeNodeFromParent((MacroNode)node);
        }
    }

    private int findMacroIndex(String name) {
        int i;
        int m = this.root.getChildCount();
        for (i = 0; i < m && name.compareTo(((AbstractMacroNode)this.root.getChildAt(i)).getName()) < 0; ++i) {
        }
        return i;
    }

    public void addMacroNode(String name) {
        Macro macro = Recording.getMacro(name);
        if (macro != null) {
            MacroNode macronode = new MacroNode(name);
            int index = this.findMacroIndex(name);
            if (index < this.root.getChildCount() && this.root.getChildAt(index) instanceof AbstractMacroNode && ((AbstractMacroNode)this.root.getChildAt(index)).getName().compareTo(name) == 0) {
                this.treemodel.removeNodeFromParent((AbstractMacroNode)this.root.getChildAt(index));
            }
            this.treemodel.insertNodeInto(macronode, this.root, this.findMacroIndex(name));
            Iterator iter = macro.getRecordIterator();
            int i = 0;
            while (iter.hasNext()) {
                this.addRecordNode(macronode, iter.next(), i);
                ++i;
            }
            this.tree.expandRow(0);
        }
    }

    private void addRecordNode(MacroNode macronode, Object record, int i) {
        if (record instanceof RecordActionEvent) {
            MacroActionNode node = new MacroActionNode((RecordActionEvent)record);
            this.treemodel.insertNodeInto(node, macronode, i);
        } else if (record instanceof RecordQuestionEvent) {
            MacroQuestionNode node = new MacroQuestionNode((RecordQuestionEvent)record);
            this.treemodel.insertNodeInto(node, macronode, i);
        } else if (record instanceof RecordKeyEvent) {
            MacroKeyNode node = new MacroKeyNode((RecordKeyEvent)record);
            this.treemodel.insertNodeInto(node, macronode, i);
        } else if (record instanceof RecordInsertDeadKeyEvent) {
            MacroInsertDeadKey node = new MacroInsertDeadKey(((RecordInsertDeadKeyEvent)record).getChar());
            this.treemodel.insertNodeInto(node, macronode, i);
        }
    }

    private void checkpopup(MouseEvent ev) {
        if (ev.isPopupTrigger()) {
            this.tree.clearSelection();
            this.tree.addSelectionPath(this.tree.getClosestPathForLocation(ev.getX(), ev.getY()));
            Object node = this.tree.getLastSelectedPathComponent();
            if (node == this.root) {
                this.rootnodemenu.show(this.tree, ev.getX(), ev.getY());
            } else if (node instanceof MacroNode) {
                this.macronodemenu.show(this.tree, ev.getX(), ev.getY());
            }
        }
    }

    public void mouseClicked(MouseEvent ev) {
    }

    public void mouseEntered(MouseEvent ev) {
        this.checkpopup(ev);
    }

    public void mouseExited(MouseEvent ev) {
        this.checkpopup(ev);
    }

    public void mousePressed(MouseEvent ev) {
        this.checkpopup(ev);
    }

    public void mouseReleased(MouseEvent ev) {
        this.checkpopup(ev);
    }
}

