/*
 * Decompiled with CFR 0.152.
 */
package IDE.Recording;

import IDE.CodeEditor.CodeEditor;
import IDE.Configuration.AbstractIDEAction;
import IDE.Main;
import IDE.Messaging.IQuestion;
import IDE.Messaging.InstructionField;
import IDE.Recording.IRecordable;
import IDE.Recording.RecordActionEvent;
import IDE.Recording.RecordInsertDeadKeyEvent;
import IDE.Recording.RecordKeyEvent;
import IDE.Recording.RecordQuestionEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;

public class Macro {
    private LinkedList records = new LinkedList();
    private Object current = null;
    private String name = null;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    protected void recordActionEvent(AbstractIDEAction action) {
        this.records.add(new RecordActionEvent(action));
    }

    protected void recordInsertDeadKeyEvent(char unicodechar) {
        this.records.add(new RecordInsertDeadKeyEvent(unicodechar));
    }

    protected void recordQuestionEvent(IQuestion question, int keycode, int modifiers, String text, int type) {
        this.records.add(new RecordQuestionEvent(question, keycode, modifiers, text, type));
    }

    protected void recordKeyEvent(int id, long when, int modifiers, int keycode, char keychar, int keylocation, int type) {
        this.records.add(new RecordKeyEvent(id, when, modifiers, keycode, keychar, keylocation, type));
    }

    public Iterator getRecordIterator() {
        return this.records.iterator();
    }

    protected void replay() {
        HashSet<IRecordable> staterestored = new HashSet<IRecordable>();
        ListIterator iter = this.records.listIterator();
        CodeEditor current = Main.currentEditor();
        if (current == null) {
            return;
        }
        while (iter.hasNext()) {
            Object record = iter.next();
            if (record instanceof RecordActionEvent) {
                RecordActionEvent actionevent = (RecordActionEvent)record;
                if (!staterestored.contains(actionevent.getAction())) {
                    actionevent.getAction().restoreState();
                    staterestored.add(actionevent.getAction());
                }
                actionevent.getAction().doWork();
                continue;
            }
            if (record instanceof RecordQuestionEvent) {
                RecordQuestionEvent questionevent = (RecordQuestionEvent)record;
                IQuestion question = questionevent.getQuestion();
                if (!staterestored.contains(question)) {
                    question.restoreState();
                    staterestored.add(question);
                }
                switch (questionevent.getType()) {
                    case 0: {
                        question.completeAnswer(questionevent.getText());
                        break;
                    }
                    case 3: {
                        question.setInitialText(questionevent.getText());
                        question.restoreState();
                        InstructionField.updateText(question.initialText());
                        break;
                    }
                    case 2: {
                        question.keyPressed(questionevent.getKeyCode(), questionevent.getModifiers());
                        break;
                    }
                    case 1: {
                        question.newAnswer(questionevent.getText());
                    }
                }
                continue;
            }
            if (record instanceof RecordKeyEvent) {
                if (current == null) continue;
                int type = ((RecordKeyEvent)record).getType();
                if (type == 1) {
                    current.processKeyPressed(((RecordKeyEvent)record).createKeyEvent(current), true);
                    continue;
                }
                if (type != 0) continue;
                current.processKeyTyped(((RecordKeyEvent)record).createKeyEvent(current), true);
                continue;
            }
            if (!(record instanceof RecordInsertDeadKeyEvent) || current == null) continue;
            current.insertCharacter(((RecordInsertDeadKeyEvent)record).getChar());
        }
    }
}

