/*
 * Decompiled with CFR 0.152.
 */
package IDE.Messaging;

import IDE.Messaging.InstructionField;
import IDE.Utilities.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class MessageHandler
extends JSplitPane
implements ItemListener {
    private static File logfile;
    private static MessageHandler message;
    private static JLabel messagefield;
    private static JComboBox errorandwarnings;
    private static InstructionField instructionfield;
    private static JSplitPane messageInput;
    private static JLabel modeIndicator;

    public MessageHandler() {
        logfile = new File(System.getProperty("user.home") + File.separator + ".Jabberwocky" + File.separator + "error.log");
        messagefield = new JLabel();
        messagefield.setBorder(BorderFactory.createEtchedBorder());
        modeIndicator = new JLabel();
        modeIndicator.setBorder(BorderFactory.createEtchedBorder());
        errorandwarnings = new JComboBox();
        errorandwarnings.setOpaque(true);
        this.setOpaque(true);
        errorandwarnings.addItem("");
        errorandwarnings.addItemListener(this);
        errorandwarnings.setBorder(BorderFactory.createEtchedBorder());
        instructionfield = new InstructionField();
        messageInput = new JSplitPane();
        messageInput.add((Component)messagefield, "left");
        messageInput.add((Component)instructionfield, "right");
        this.add((Component)errorandwarnings, "left");
        JSplitPane rightPane = new JSplitPane();
        rightPane.add((Component)messageInput, "left");
        rightPane.add((Component)modeIndicator, "right");
        rightPane.setResizeWeight(1.0);
        rightPane.setDividerSize(3);
        this.add((Component)rightPane, "right");
        messageInput.setDividerLocation(0.5);
        messageInput.setResizeWeight(0.5);
        messageInput.setDividerSize(3);
        this.setDividerLocation(0.25);
        this.setResizeWeight(0.25);
        this.setDividerSize(3);
        message = this;
        MessageHandler.resetSize();
    }

    public static void logError(String error, Exception e) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(Util.getCanonicalFileName(logfile), true));
            writer.write(error + "\n");
            if (e != null) {
                StackTraceElement[] elements = e.getStackTrace();
                for (int i = 0; i < elements.length; ++i) {
                    writer.write(elements[i].toString() + "\n");
                }
            }
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void report(final String errorstr, final Exception e) {
        Runnable doreport = new Runnable(){

            public void run() {
                String error = MessageHandler.getTime() + " " + errorstr;
                errorandwarnings.setBackground(Color.green);
                errorandwarnings.setForeground(Color.red);
                errorandwarnings.addItem(error);
                errorandwarnings.setSelectedItem(error);
                e.printStackTrace();
                MessageHandler.resetSize();
            }
        };
        if (message != null) {
            SwingUtilities.invokeLater(doreport);
        }
        MessageHandler.logError(errorstr, e);
    }

    public static void reportAndExit(String errorstr, Exception e) {
        if (message != null) {
            MessageHandler.report(errorstr, e);
        }
        System.exit(-1);
    }

    public static void warn(final String errorstr) {
        Runnable dowarn = new Runnable(){

            public void run() {
                String error = MessageHandler.getTime() + " " + errorstr;
                errorandwarnings.addItem(error);
                errorandwarnings.setSelectedItem(error);
                errorandwarnings.setBackground(Color.cyan);
                errorandwarnings.setForeground(Color.red);
                MessageHandler.resetSize();
            }
        };
        if (message != null) {
            SwingUtilities.invokeLater(dowarn);
        }
    }

    public static void displayMode(final String mode) {
        Runnable domode = new Runnable(){

            public void run() {
                modeIndicator.setText(mode);
            }
        };
        SwingUtilities.invokeLater(domode);
    }

    public static void say(final String str) {
        Runnable dosay = new Runnable(){

            public void run() {
                if (str.length() > 0) {
                    errorandwarnings.setBackground(Color.lightGray);
                    errorandwarnings.setForeground(Color.black);
                }
                messagefield.setText(str);
                messagefield.setToolTipText(str);
                messagefield.repaint();
                MessageHandler.resetSize();
            }
        };
        if (message != null) {
            SwingUtilities.invokeLater(dosay);
        }
    }

    public static void clear() {
        errorandwarnings.setBackground(Color.lightGray);
        errorandwarnings.setForeground(Color.black);
        errorandwarnings.setSelectedIndex(0);
    }

    private static String getTime() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(11) + ":" + calendar.get(12) + ":" + calendar.get(13);
    }

    private static void resetSize() {
        Font font = messagefield.getFont();
        FontMetrics fm = messagefield.getFontMetrics(font);
        Dimension dim = new Dimension(50, fm.getHeight() + 8);
        messagefield.setMinimumSize(dim);
        errorandwarnings.setMinimumSize(dim);
        instructionfield.setMinimumSize(dim);
        messageInput.setMinimumSize(dim);
        messagefield.setPreferredSize(dim);
        errorandwarnings.setPreferredSize(dim);
        instructionfield.setPreferredSize(dim);
        messageInput.setPreferredSize(dim);
    }

    public void itemStateChanged(ItemEvent ev) {
        String message = (String)errorandwarnings.getSelectedItem();
        errorandwarnings.setToolTipText(message);
    }

    static {
        message = null;
    }
}

