/*
 * Decompiled with CFR 0.152.
 */
package IDE.Messaging;

import IDE.Main;
import IDE.Messaging.IQuestion;
import IDE.Messaging.MessageHandler;
import IDE.Recording.Recording;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class InstructionField
extends JTextField
implements FocusListener,
KeyListener,
DocumentListener {
    public static HashMap nameToQuestion = new HashMap();
    public static HashMap questionToName = new HashMap();
    public static final int completeAnswer = 0;
    public static final int newAnswer = 1;
    public static final int keyPressed = 2;
    public static final int initialText = 3;
    private static IQuestion question = null;
    private static InstructionField self;

    public InstructionField() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.addFocusListener(this);
        this.addKeyListener(this);
        this.getDocument().addDocumentListener(this);
        self = this;
    }

    public static void addQuestion(String name, IQuestion question) {
        nameToQuestion.put(name, question);
        questionToName.put(question, name);
    }

    public static String getQuestionName(IQuestion question) {
        return (String)questionToName.get(question);
    }

    public static IQuestion getQuestion(String name) {
        return (IQuestion)nameToQuestion.get(name);
    }

    public static void ask(String name) {
        IQuestion question = (IQuestion)nameToQuestion.get(name);
        if (question != null && self != null && !Recording.isReplaying() && question.restoreState()) {
            InstructionField.question = question;
            self.setText(question.initialText());
            self.selectAll();
            Recording.recordQuestionEvent(question, 0, 0, self.getText(), 3);
            self.requestFocus();
            MessageHandler.say(question.guideText());
        }
    }

    public static void ask(IQuestion question) {
        if (self != null && question.restoreState()) {
            InstructionField.question = question;
            self.setText(question.initialText());
            self.selectAll();
            self.requestFocus();
            MessageHandler.say(question.guideText());
        }
    }

    public static void updateText(String text) {
        self.setText(text);
    }

    public static boolean inFocus() {
        return self.hasFocus();
    }

    public void focusLost(FocusEvent e) {
        if (!Recording.isReplaying()) {
            if (question == null || question.abort()) {
                MessageHandler.say("");
                question = null;
                this.setText("");
            } else {
                this.requestFocus();
            }
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void keyTyped(KeyEvent e) {
        if (!Recording.isReplaying() && question == null) {
            e.consume();
        }
    }

    public void keyReleased(KeyEvent e) {
        if (question == null || Recording.isReplaying()) {
            e.consume();
        }
    }

    public void keyPressed(KeyEvent e) {
        if (question == null || Recording.isReplaying()) {
            e.consume();
        } else if (e.getKeyChar() == '\u001b') {
            if (question == null || question.abort()) {
                MessageHandler.say("");
                question = null;
                this.setText("");
                Main.currentEditor().grabFocus();
            }
        } else if (e.getKeyChar() == '\n') {
            Recording.recordQuestionEvent(question, e.getKeyCode(), e.getModifiers(), this.getText(), 0);
            question.completeAnswer(this.getText());
            MessageHandler.say(question.guideText());
            e.consume();
        } else {
            Recording.recordQuestionEvent(question, e.getKeyCode(), e.getModifiers(), this.getText(), 2);
            question.keyPressed(e.getKeyCode(), e.getModifiers());
            MessageHandler.say(question.guideText());
        }
    }

    public void removeUpdate(DocumentEvent e) {
        if (question != null && !Recording.isReplaying()) {
            Recording.recordQuestionEvent(question, 0, 0, this.getText(), 1);
            question.newAnswer(this.getText());
        }
    }

    public void insertUpdate(DocumentEvent e) {
        if (question != null && !Recording.isReplaying()) {
            Recording.recordQuestionEvent(question, 0, 0, this.getText(), 1);
            question.newAnswer(this.getText());
        }
    }

    public void changedUpdate(DocumentEvent e) {
        if (question != null && !Recording.isReplaying()) {
            Recording.recordQuestionEvent(question, 0, 0, this.getText(), 1);
            question.newAnswer(this.getText());
        }
    }
}

