/*
 * Decompiled with CFR 0.152.
 */
package IDE;

import IDE.CodeEditor.CodeEditor;
import IDE.CodeEditor.CodeLineVector;
import IDE.CodeEditor.CodePane;
import IDE.CodeEditor.Parser.LispParser;
import IDE.CodeEditor.Parser.Parser;
import IDE.CodeEditor.Region;
import IDE.Configuration.AbstractIDEAction;
import IDE.Configuration.ActionKeyMap;
import IDE.Configuration.Configuration;
import IDE.Configuration.InstallParameters;
import IDE.Configuration.Mode;
import IDE.Configuration.SplashScreen;
import IDE.Configuration.XMLConfigClass;
import IDE.Configuration.XMLConfigMethod;
import IDE.Explorer.Explorer;
import IDE.Explorer.FileExtensions;
import IDE.Help.Help;
import IDE.Help.Hint;
import IDE.Help.HyperSpec;
import IDE.Help.ValueWindow;
import IDE.IDEFocusManager;
import IDE.IIDEAddin;
import IDE.Interaction.AbstractInteractionPane;
import IDE.Interaction.IInteraction;
import IDE.Interaction.InteractionPane;
import IDE.Interaction.Interactions;
import IDE.Interaction.LispClispInteraction;
import IDE.Interaction.LispCmuInteraction;
import IDE.Interaction.WatchPane;
import IDE.Messaging.InstructionField;
import IDE.Messaging.MessageHandler;
import IDE.Messaging.NumberQuestion;
import IDE.Recording.MacroExplorer;
import IDE.Recording.Recording;
import IDE.Recording.ReplayRecordingAction;
import IDE.Recording.StartRecordingAction;
import IDE.Recording.StopRecordingAction;
import IDE.Search.IncrementalSearch;
import IDE.Search.RegularExpressionSearch;
import IDE.Search.SearchAndReplace;
import IDE.Utilities.Util;
import IDE.Watch.Watches;
import IDE.WorkArea.WorkArea;
import IDE.WorkArea.WorkPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class Main
extends WindowAdapter
implements IIDEAddin,
FocusListener {
    private static Vector addins = new Vector();
    public static JFrame frame;
    public static JSplitPane central;
    public static JSplitPane deskinteractions;
    private static JLabel cursorinfo;
    private static JPanel toolbar;
    private static WorkArea workarea;
    private static Interactions interactions;
    private static JTabbedPane explorers;
    private static Explorer explorer;
    private static Watches watch;
    private static MacroExplorer macroexplorer;
    private static CodeEditor currentEditor;
    private static Mode currentmode;
    private static Configuration configuration;
    public static ActionKeyMap keymap;
    private static Main main;

    public static void main(String[] args) {
        if (!Main.checkFirstInstance()) {
            System.exit(0);
        }
        boolean argsnok = true;
        if (args.length % 2 != 0 || args.length == 0) {
            JOptionPane.showMessageDialog(null, "Possible arguments are -i installdir -s sourcedir - command -clisp clispcommand, -i argument is required", "Argument error", 0);
            System.exit(-1);
        }
        int i = 0;
        while (i + 1 < args.length) {
            if (args[i].compareTo("-i") == 0) {
                InstallParameters.setInstallDir(args[i + 1]);
                argsnok = false;
            } else if (args[i].compareTo("-s") == 0) {
                InstallParameters.setSourceDir(args[i + 1]);
            } else if (args[i].compareTo("-cmucl") == 0) {
                InstallParameters.setCmuclCommand(args[i + 1]);
            } else if (args[i].compareTo("-clisp") == 0) {
                InstallParameters.setClispCommand(args[i + 1]);
            } else {
                argsnok = true;
            }
            i += 2;
        }
        if (argsnok) {
            JOptionPane.showMessageDialog(null, "Possible arguments are -i installdir -s sourcedir - cmuclcommand -clisp clispcommand, -i argument is required", "Argument error", 0);
            System.exit(-1);
        }
        SplashScreen.showSplash();
        SplashScreen.showMessage("Configure the IDE");
        Main.createQuestions();
        Main.createActions();
        main = new Main();
        Main.createIDEWindow();
        Hint.initHint();
        configuration = new Configuration();
        Mode.getMode("basic").activate();
        Main.registerAddin(explorer);
        Main.registerAddin(workarea);
        Main.registerAddin(interactions);
        Main.registerAddin(main);
        Main.registerAddin(Recording.getRecording());
        FocusManager.setCurrentManager(new IDEFocusManager());
        SplashScreen.disposeSplash();
        if (Configuration.lookAndFeel.length() > 0) {
            try {
                UIManager.setLookAndFeel(Configuration.lookAndFeel);
                SwingUtilities.updateComponentTreeUI(frame);
                frame.pack();
            }
            catch (ClassNotFoundException e) {
                MessageHandler.warn("Look and feel class " + Configuration.lookAndFeel + " not found.");
            }
            catch (Exception e) {
                MessageHandler.report(e.getMessage(), e);
            }
        }
        Configuration.loadState();
        frame.setVisible(true);
        if (currentEditor != null) {
            currentEditor.requestFocus();
        }
    }

    private static void createIDEWindow() {
        frame = new JFrame(Configuration.IDEName + " " + Configuration.IDEVersion);
        frame.addWindowListener(main);
        frame.setDefaultCloseOperation(0);
        frame.addFocusListener(main);
        toolbar = new JPanel();
        toolbar.setLayout(new FlowLayout(0, 0, 0));
        workarea = WorkArea.createWorkArea();
        explorer = new Explorer();
        watch = new Watches();
        macroexplorer = new MacroExplorer();
        MessageHandler messagehandler = new MessageHandler();
        JPanel bottempanel = new JPanel();
        GridBagLayout bottempanellayout = new GridBagLayout();
        bottempanel.setLayout(bottempanellayout);
        GridBagConstraints gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.gridx = 1;
        gridbagconstraints.gridy = 0;
        gridbagconstraints.weightx = 0.01;
        cursorinfo = new JLabel("     0-0     ");
        cursorinfo.setForeground(Color.black);
        cursorinfo.setBorder(BorderFactory.createEtchedBorder());
        bottempanellayout.setConstraints(cursorinfo, gridbagconstraints);
        gridbagconstraints.gridx = 0;
        gridbagconstraints.gridy = 0;
        gridbagconstraints.weightx = 0.9;
        gridbagconstraints.fill = 1;
        bottempanellayout.setConstraints(messagehandler, gridbagconstraints);
        bottempanel.add(messagehandler);
        bottempanel.add(cursorinfo);
        interactions = new Interactions(3);
        explorers = new JTabbedPane(1);
        explorers.addTab("Explorer", explorer);
        explorers.addTab("Watches", watch);
        explorers.addTab("Macros", macroexplorer);
        deskinteractions = new JSplitPane(0, workarea, interactions);
        deskinteractions.setDividerSize(3);
        deskinteractions.setDividerLocation(0.8);
        deskinteractions.setResizeWeight(0.8);
        central = new JSplitPane(1, explorers, deskinteractions);
        central.setDividerSize(3);
        central.setDividerLocation(0.2);
        central.setResizeWeight(0.1);
        central.setDividerLocation(-1);
        deskinteractions.setDividerLocation(-1);
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout());
        content.add((Component)central, "Center");
        content.add((Component)toolbar, "North");
        content.add((Component)bottempanel, "South");
        frame.setSize(1000, 1000);
        frame.getContentPane().add(content);
    }

    public static Watches getWatches() {
        return watch;
    }

    public static MacroExplorer getMacroExplorer() {
        return macroexplorer;
    }

    private static void createQuestions() {
        InstructionField.addQuestion("asklinenumber", new NumberQuestion("Line number ?"){

            public void processEnter(int linenr) {
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    CodeLineVector lines = editor.getDocument().getLines();
                    if (linenr > 0 && linenr + 1 < lines.size()) {
                        editor.cursor.setCursor(lines.lineAt(linenr - 1).begin());
                        editor.requestFocus();
                    }
                }
            }
        });
        InstructionField.addQuestion("nextsearch", new IncrementalSearch(true));
        InstructionField.addQuestion("prevsearch", new IncrementalSearch(false));
        InstructionField.addQuestion("searchandreplace", new SearchAndReplace());
    }

    private static void createActions() {
        Mode.addAction("up", "Move Up", "Move the cursor in the current edit buffer  one line up", new AbstractIDEAction("Move Up"){

            public void doWork() {
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor.cursor.moveUp();
                }
            }
        });
        Mode.addAction("down", "Move Down", "Move the cursor in the current edit buffer  one line down", new AbstractIDEAction("Move Down"){

            public void doWork() {
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor.cursor.moveDown();
                }
            }
        });
        Mode.addAction("pageup", "Move one page up", "Move one page up (in the current editor buffer)", new AbstractIDEAction("Move Page Up"){

            public void doWork() {
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor.cursor.pageUp();
                }
            }
        });
        Mode.addAction("pagedown", "Move one page down", "Move one page down (in the current editor buffer)", new AbstractIDEAction("Move Page Down"){

            public void doWork() {
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor.cursor.pageDown();
                }
            }
        });
        Mode.addAction("left", "Move Left", "Move the cursor in the current edit buffer to the left", new AbstractIDEAction("Move Left"){

            public void doWork() {
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor.cursor.moveLeft();
                }
            }
        });
        Mode.addAction("right", "Move Right", "Move the cursor in the current edit buffer to the right", new AbstractIDEAction("Move Right"){

            public void doWork() {
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor.cursor.moveRight();
                }
            }
        });
        Mode.addAction("movetonextleaf", "Move the cursor to next word", "Move the cursor to the begin of the next element at the same level in its parent list.", new AbstractIDEAction("Move to next word"){

            public void doWork() {
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor.moveToNextLeaf();
                }
            }
        });
        Mode.addAction("movetoendlist", "Move the cursor to end of list", "Move the cursor to the end of the list containing the cursor.", new AbstractIDEAction("Move to end list"){

            public void doWork() {
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor.moveToEndList();
                }
            }
        });
        Mode.addAction("movetoprevleaf", "Move the cursor to prev word", "Move the cursor to the end of the previous element at the same level in its parent list.", new AbstractIDEAction("Move to prev word"){

            public void doWork() {
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor.moveToPrevLeaf();
                }
            }
        });
        Mode.addAction("movetobeginlist", "Move the cursor to begin list", "Move the cursor to begin list", new AbstractIDEAction("Move to begin list"){

            public void doWork() {
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor.moveToBeginList();
                }
            }
        });
        Mode.addAction("movetobeginline", "Move the cursor to begin line", "Move the cursor to the begin lof the current line.", new AbstractIDEAction("Move to begin line"){

            public void doWork() {
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor.moveToBeginLine();
                }
            }
        });
        Mode.addAction("movetoendline", "Move the cursor to end of line", "Move the cursor to end of the current line", new AbstractIDEAction("Move the cursor to end of line"){

            public void doWork() {
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor.moveToEndLine();
                }
            }
        });
        Mode.addAction("selectcurrentleaf", "Select the current leaf", "Select the word covering the current cursor position.", new AbstractIDEAction("Select the current leaf"){

            public void doWork() {
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor.selectCurrentLeaf();
                }
            }
        });
        Mode.addAction("selectcurrentelement", "Select the current element", "Select the element covering the current cursor position.", new AbstractIDEAction("Select the current element"){

            public void doWork() {
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor.selectCurrentElement();
                }
            }
        });
        Mode.addAction("selecttoplevelelement", "Select the toplevel element", "Select the toplevel element covering the cursor position.", new AbstractIDEAction("Select the toplevel element"){

            public void doWork() {
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor.selectToplevelElement();
                }
            }
        });
        Mode.addAction("selectline", "Select the current line", "Select the current line.", new AbstractIDEAction("Select the current line"){

            public void doWork() {
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor.selectLine();
                }
            }
        });
        Mode.addAction("widenselection", "Widen the selection", "Widen the selection so that it selects the parent element of the current selected element.", new AbstractIDEAction("Widen the selection"){

            public void doWork() {
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor.widenSelection();
                }
            }
        });
        Mode.addAction("shortenselection", "Shorten the selection", "Widen the selection so that it selects the parent element of the current selected element.", new AbstractIDEAction("Shorten the selection"){

            public void doWork() {
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor.shortenSelection();
                }
            }
        });
        Mode.addAction("deletecurrentleaf", "Delete the current leaf", "Delete the current leaf", new AbstractIDEAction("Delete the current leaf"){

            public void doWork() {
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor.deleteCurrentLeaf();
                }
            }
        });
        Mode.addAction("deletecurrentelement", "Delete the current element", "Deletes the word covering the cursor position.", new AbstractIDEAction("Delete the current element"){

            public void doWork() {
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor.deleteCurrentElement();
                }
            }
        });
        Mode.addAction("deletetoplevelelement", "Delete the toplevel element", "Delete the toplevel element covering the cursor position.", new AbstractIDEAction("Delete the toplevel element"){

            public void doWork() {
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor.deleteToplevelElement();
                }
            }
        });
        Mode.addAction("deleteline", "Delete the current line", "Delete the line covering the cursor position", new AbstractIDEAction("Delete the current line"){

            public void doWork() {
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor.deleteLine();
                }
            }
        });
        Mode.addAction("gotoline", "Go to line", "Ask for a line number and jumps to this line in the current editor.", new AbstractIDEAction("Go to line"){

            public void doWork() {
                this.releaseFocus = false;
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    InstructionField.ask("asklinenumber");
                }
            }
        });
        Mode.addAction("remove", "Delete Character", "Remove the selected text in the current buffer or if no text is selected delete the character after the cursor.", new AbstractIDEAction("Delete Character"){

            public void doWork() {
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor.removeCharacter(editor.cursor.cursorOffset());
                }
            }
        });
        Mode.addAction("searchforward", "Search Forward", "Search forwards in the current buffer (Incremental search).", new AbstractIDEAction("Search Forward", Configuration.getIcon("searchforward.png")){

            public void doWork() {
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    this.releaseFocus = false;
                    InstructionField.ask("nextsearch");
                }
            }
        });
        Mode.addAction("searchbackward", "Search Backward", "Search backwards in the current buffer (Incremental search).", new AbstractIDEAction("Search Backward", Configuration.getIcon("searchbackward.png")){

            public void doWork() {
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    this.releaseFocus = false;
                    InstructionField.ask("prevsearch");
                }
            }
        });
        Mode.addAction("searchandreplace", "Search And Replace", "Start a search and replace session.", new AbstractIDEAction("Search And Replace"){

            public void doWork() {
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    this.releaseFocus = false;
                    InstructionField.ask("searchandreplace");
                }
            }
        });
        Mode.addAction("findandreplace", "Find And Replace", "Starts a dialog box for search and replace in the current buffer (or all the files in a choosen project). You can do a regular expression search or a normal case sensitive (insensitive) string search.", new AbstractIDEAction("Find And Replace"){

            public void doWork() {
                RegularExpressionSearch.SearchAndReplace();
            }
        });
        Mode.addAction("backspace", "Delete Previous Character", "Delete the previous character", new AbstractIDEAction("Backspace"){

            public void doWork() {
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor.removeCharacter(editor.cursor.cursorOffset() - 1);
                    editor.cursor.moveLeft();
                }
            }
        });
        Mode.addAction("undo", "Undo last edit", "Undo last modification in the current buffer.", new AbstractIDEAction("Undo last edit", Configuration.getIcon("undo.png")){

            public void doWork() {
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    try {
                        editor.getDocument().getUndoManager().undo();
                    }
                    catch (Exception e) {
                        MessageHandler.warn("No more undo possible ");
                    }
                    editor.revalidate();
                    editor.repaint();
                }
            }
        });
        Mode.addAction("redo", "Redo last edit", "Redo last edit", new AbstractIDEAction("Redo last edit", Configuration.getIcon("redo.png")){

            public void doWork() {
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    try {
                        editor.getDocument().getUndoManager().redo();
                    }
                    catch (Exception e) {
                        MessageHandler.warn("No more redo possible");
                    }
                    editor.revalidate();
                    editor.repaint();
                }
            }
        });
        Mode.addAction("copy", "copy", "Copies the text selected in the current buffer to the copy buffer.", new AbstractIDEAction("copy", Configuration.getIcon("copy.png")){

            public void doWork() {
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor.copySelectedText();
                }
            }
        });
        Mode.addAction("cut", "cut", "Copies the text selected in the current buffer to the copy buffer and removes the selected text.", new AbstractIDEAction("cut", Configuration.getIcon("cut.png")){

            public void doWork() {
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor.cutSelectedText();
                }
            }
        });
        Mode.addAction("delete", "delete", "Deletes the selected text in the current buffer.", new AbstractIDEAction("delete"){

            public void doWork() {
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor.deleteSelectedText();
                }
            }
        });
        Mode.addAction("paste", "paste", "Paste the text in the clipboard after the cursor in the current buffer.", new AbstractIDEAction("paste", Configuration.getIcon("paste.png")){

            public void doWork() {
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor.pasteSelection();
                }
            }
        });
        Mode.addAction("startrecording", "Start Recording", "Start recording of the activation of all actions (with the exception of course of the replayrecording,startrecording and stoprecording action). If a action activates a question via the instruction field, record also the activity in the instruction field.", new StartRecordingAction("Start Recording", Configuration.getIcon("startrecording.png")));
        Mode.addAction("stoprecording", "Stop Recording", "Stop de macro recording and saves the recorded information in the current macro. Ask then for a name for the current macro and create a macro with that name.", new StopRecordingAction("Stop Recording", Configuration.getIcon("stoprecording.png")));
        Mode.addAction("replayrecording", "Replay Recording", "Asks for a macro name (if you press enter without giving a name the current macro will be used) and replays the macro.", new ReplayRecordingAction("Replay Recording", Configuration.getIcon("replayrecording.png")));
        Mode.addAction("indentatedocument", "Indentate the document", "Indentate the document", new AbstractIDEAction("Indentate the document"){

            public void doWork() {
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor.getDocument().indentateAllElements();
                }
            }
        });
        Mode.addAction("new", "New File", "Opens a new empty editor buffer.", new AbstractIDEAction("New", Configuration.getIcon("new.png")){

            public void doWork() {
                CodePane pane = new CodePane(new LispParser(true));
                WorkArea.addPane(pane);
                Main.setCurrent(pane.getEditor());
            }
        });
        Mode.addAction("open", "Open File", "Starts a file dialog box to open a file and create a edit buffer for this file.", new AbstractIDEAction("Open", Configuration.getIcon("open.png")){

            public void doWork() {
                JFileChooser chooser = new JFileChooser(Interactions.currentDirectory);
                chooser.setFileFilter(FileExtensions.getFileChooserFilter());
                chooser.setAcceptAllFileFilterUsed(false);
                if (chooser.showOpenDialog(null) == 0) {
                    File file = chooser.getSelectedFile();
                    Parser parser = FileExtensions.createParser(file = new File(Util.getCanonicalFileName(file)), true);
                    if (parser == null) {
                        return;
                    }
                    CodePane pane = CodePane.createCodePane(parser, file);
                    WorkArea.addPane(pane);
                    Main.setCurrent(pane.getEditor());
                }
            }
        });
        Mode.addAction("save", "Save File", "Save the contents of the current buffer.", new AbstractIDEAction("Save", Configuration.getIcon("save.png")){

            public void doWork() {
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor.getCodePane().save();
                }
            }
        });
        Mode.addAction("saveas", "Save File As", "Starts a dialog box to get a file name and save the current buffer in it.", new AbstractIDEAction("Save as", Configuration.getIcon("saveas.png")){

            public void doWork() {
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor.getCodePane().saveAs();
                }
            }
        });
        Mode.addAction("close", "Close File", "If the buffer is modified since the last save, ask to save the buffer and then destroys the source buffer.", new AbstractIDEAction("Close", Configuration.getIcon("close.png")){

            public void doWork() {
                WorkArea.close();
            }
        });
        Mode.addAction("setcurrentdirectory", "Set the current directory", "Set the current diretory for all interaction buffers and set the default directory for all file dialogs", new AbstractIDEAction("Set Current Directory"){

            public void doWork() {
                JFileChooser chooser = new JFileChooser(Interactions.currentDirectory);
                chooser.setDialogTitle("Choose the current directory");
                chooser.setDialogType(0);
                chooser.setFileSelectionMode(1);
                if (chooser.showOpenDialog(null) == 0) {
                    Interactions.setCurrentDirectory(chooser.getSelectedFile());
                }
            }
        });
        Mode.addAction("splitvertical", "Split Vertical", "Split the current buffer in a bottom and upper part buffer, each buffer using the same document.", new AbstractIDEAction("Split Vertical", Configuration.getIcon("splitvertical.png")){

            public void doWork() {
                workarea.split(0);
            }
        });
        Mode.addAction("splithorizontal", "Split Horizontal", "Split the current buffer in a left and right buffer, each new buffer is using the same document.", new AbstractIDEAction("Split Horizontal", Configuration.getIcon("splithorizontal.png")){

            public void doWork() {
                workarea.split(1);
            }
        });
        Mode.addAction("replaceeditor", "Replace Document", "Replace the document associated with a buffer.", new AbstractIDEAction("Replace Document"){

            public void doWork() {
                workarea.replaceEditor();
            }
        });
        Mode.addAction("addproject", "Add Project", "Adds a project to the explorer window.", new AbstractIDEAction("Add Project"){

            public void doWork() {
                Explorer.addProject();
            }
        });
        Mode.addAction("exit", "Exit", "Closes all the open buffers, stops all lisp processes and exit Jabberwocky.", new AbstractIDEAction("Exit"){

            public void doWork() {
                Main.exitJabberwocky();
            }
        });
        if (InstallParameters.getCmuclCommand() != null) {
            Mode.addAction("newinteractioncmucl", "New Interaction with CMUCL", "Starts a new process to run cmucl and creates a new interaction buffer to interact with this process.", new AbstractIDEAction("New Interaction with CMUCL", Configuration.getIcon("lambda.png")){

                public void doWork() {
                    LispCmuInteraction interaction = new LispCmuInteraction();
                    if (interaction != null) {
                        InteractionPane pane = new InteractionPane(new LispParser(true), interaction);
                        interactions.add(((AbstractInteractionPane)pane).getName(), pane);
                        interactions.setSelectedComponent(pane);
                    }
                }
            });
        }
        if (InstallParameters.getClispCommand() != null) {
            Mode.addAction("newinteractionclisp", "New Interaction with CLISP", "Starts a new process to run clisp and creates a new interaction buffer to interact with this process.", new AbstractIDEAction("New Interaction with CLISP", Configuration.getIcon("lambda.png")){

                public void doWork() {
                    LispClispInteraction interaction = new LispClispInteraction();
                    if (interaction != null) {
                        InteractionPane pane = new InteractionPane(new LispParser(true), interaction);
                        interactions.add(((AbstractInteractionPane)pane).getName(), pane);
                        interactions.setSelectedComponent(pane);
                    }
                }
            });
        }
        Mode.addAction("newwatch", "New Watch Window", "Creates a watch buffer associated with the current interaction buffer. This watch buffer can be used to type in lisp forms and see there results while debugging a program.", new AbstractIDEAction("New Watch Window"){

            public void doWork() {
                InteractionPane interactionpane = Interactions.getSelectedInteraction();
                if (interactionpane != null) {
                    WatchPane watchpane = interactionpane.createWatchPane();
                    interactions.add("Watch " + interactionpane.getName(), watchpane);
                    interactions.setSelectedComponent(watchpane);
                }
            }
        });
        Mode.addAction("loadeditor", "Load Editor Content", "Load the content of the current editor buffer in the process in the current interaction buffer.", new AbstractIDEAction("Load Editor Content"){

            public void doWork() {
                InteractionPane interactionpane = Interactions.getSelectedInteraction();
                CodeEditor editor = Main.currentEditor();
                if (interactionpane != null && editor != null && !editor.isInteractionEditor()) {
                    interactionpane.getInteraction().loadEditor(editor);
                }
            }
        });
        Mode.addAction("compileeditor", "Compile Editor Content", "Compile the content of the current editor buffer, using the process in the current interaction buffer.", new AbstractIDEAction("Compile Editor Content", Configuration.getIcon("compile.png")){

            public void doWork() {
                InteractionPane interactionpane = Interactions.getSelectedInteraction();
                CodeEditor editor = Main.currentEditor();
                if (interactionpane != null && editor != null && !editor.isInteractionEditor()) {
                    interactionpane.getInteraction().compileEditor(editor);
                }
            }
        });
        Mode.addAction("deleteinteraction", "Delete Interaction", "Put all buffers in debugmode which uses this interaction in edit mode. Remove all watchpoints using this interaction. Stops the lispprocess and close the buffer associated with this lisp process.", new AbstractIDEAction("Delete Interaction", Configuration.getIcon("deleteinteraction.png")){

            public void doWork() {
                InteractionPane interactionpane = Interactions.getSelectedInteraction();
                if (interactionpane != null) {
                    interactionpane.cleanup();
                    interactions.remove(interactionpane);
                }
            }
        });
        Mode.addAction("deletewatch", "Delete Watch", "Remove the watch pane", new AbstractIDEAction("Delete Interaction"){

            public void doWork() {
                WatchPane watchpane = Interactions.getSelectedWatch();
                if (watchpane != null) {
                    watchpane.cleanup();
                    interactions.remove(watchpane);
                }
            }
        });
        Mode.addAction("sigint", "Send Interrupt", "Send Interrupt signal to process in the current interaction buffer", new AbstractIDEAction("Send Interrupt"){

            public void doWork() {
                InteractionPane interactionpane = Interactions.getSelectedInteraction();
                if (interactionpane != null) {
                    interactionpane.signalProcess("-SIGINT");
                    Main.setCurrent(interactionpane.getEditor());
                }
            }
        });
        Mode.addAction("sigstop", "Send Stop", "Send Stop signal to process in the current interaction buffer", new AbstractIDEAction("Send Stop"){

            public void doWork() {
                InteractionPane interactionpane = Interactions.getSelectedInteraction();
                if (interactionpane != null) {
                    interactionpane.signalProcess("-SIGSTOP");
                    Main.setCurrent(interactionpane.getEditor());
                }
            }
        });
        Mode.addAction("sigcont", "Send Continue", "Send Continue signal to process in the current interaction buffer", new AbstractIDEAction("Send Continue"){

            public void doWork() {
                InteractionPane interactionpane = Interactions.getSelectedInteraction();
                if (interactionpane != null) {
                    interactionpane.signalProcess("-SIGCONT");
                    Main.setCurrent(interactionpane.getEditor());
                }
            }
        });
        Mode.addAction("sigquit", "Send Quit", "Send Quit signal to process in the current interaction buffer", new AbstractIDEAction("Send Quit"){

            public void doWork() {
                InteractionPane interactionpane = Interactions.getSelectedInteraction();
                if (interactionpane != null) {
                    interactionpane.signalProcess("-SIGQUIT");
                    Main.setCurrent(interactionpane.getEditor());
                }
            }
        });
        Mode.addAction("sigkill", "Send Kill", "Send Kill signal to process in the current interaction buffer", new AbstractIDEAction("Send Kill"){

            public void doWork() {
                InteractionPane interactionpane = Interactions.getSelectedInteraction();
                if (interactionpane != null) {
                    interactionpane.signalProcess("-SIGINT");
                    Main.setCurrent(interactionpane.getEditor());
                }
            }
        });
        Mode.addAction("togglehint", "Show/Hide Hint", "Show/Hide the hint window.", new AbstractIDEAction("Show/Hide Hint", Configuration.getIcon("hint.png")){

            public void doWork() {
                Hint.toggleHint();
            }
        });
        Mode.addAction("help", "Show Help", "Show Help", new AbstractIDEAction("Show Help", Configuration.getIcon("help.png")){

            public void doWork() {
                Help.displayHelp();
            }
        });
        Mode.addAction("replacebyhint", "Replace by the Hint", "Replace the element containing the cursor by the selected hint value.", new AbstractIDEAction("Replace by the hint"){

            public void doWork() {
                Hint.replaceByHint();
            }
        });
        Mode.addAction("hintdown", "Go down in hint list", "Move one line down in the hint list.", new AbstractIDEAction("Go down in hint list"){

            public void doWork() {
                Hint.goDown();
            }
        });
        Mode.addAction("hintup", "Go up in hint list", "Move one line up in the hint list.", new AbstractIDEAction("Go up in hint"){

            public void doWork() {
                Hint.goUp();
            }
        });
        Mode.addAction("hyperspeccontext", "Hyperspec Context Help", "Show the hyperspec help for the current context", new AbstractIDEAction("Hyperspec Context Help"){

            public void doWork() {
                HyperSpec.displayHyperSpecContext();
            }
        });
        Mode.addAction("hyperspec", "Hyperspec Help", "Show the hyperspec documentation", new AbstractIDEAction("Hyperspec Context Help"){

            public void doWork() {
                HyperSpec.displayHyperSpec();
            }
        });
        Mode.addAction("selectcommand", "Select command of command history", "Select command of command hsitory", new AbstractIDEAction("Command History"){

            public void doWork() {
                InteractionPane interactionpane = Interactions.getSelectedInteraction();
                if (interactionpane != null) {
                    interactionpane.chooseCommand();
                }
            }
        });
        Mode.addAction("execute", "Execute", "Execute the selected command in the command history.", new AbstractIDEAction("Execute", Configuration.getIcon("execute.png")){

            public void doWork() {
                CodeEditor editor = Main.currentEditor();
                InteractionPane interactionpane = Interactions.getSelectedInteraction();
                if (editor != null && interactionpane != null) {
                    String str = editor.highlighter.getHighLightedCode("30select");
                    if (str != null) {
                        ((AbstractInteractionPane)interactionpane).executeCommand(str);
                    } else {
                        Region region = editor.getDocument().getParser().findHooks(editor.cursor.cursorOffset());
                        if (region != null) {
                            ((AbstractInteractionPane)interactionpane).executeCommand(editor.getDocument().getString(region.begin, region.end - region.begin + 1));
                        }
                    }
                }
            }
        });
        Mode.addAction("indentate", "Indentate Line", "Add spaces to the begin of the line so that the code on this line is correctly indentated.", new AbstractIDEAction("Indentate Line"){

            public void doWork() {
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor.getDocument().indentateLine();
                }
            }
        });
        Mode.addAction("indentateelement", "Indentate Element", "Indentate the toplevel element containing the cursor.", new AbstractIDEAction("Indentate Element"){

            public void doWork() {
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor.getDocument().indentateElement(editor.cursor.cursorOffset());
                }
            }
        });
        Mode.addAction("debug", "Debug Document", "Starts a debugging session for the current source buffer using the current interaction window.", new AbstractIDEAction("Debug Document", Configuration.getIcon("debug.png")){

            public void doWork() {
                CodeEditor editor = Main.currentEditor();
                InteractionPane interactionpane = Interactions.getSelectedInteraction();
                if (editor != null && interactionpane != null) {
                    ((AbstractInteractionPane)interactionpane).enableDebugging(editor);
                }
            }
        });
        Mode.addAction("debugform", "Debug Selection/Form", "Debug the selected code (or the current lispform) in a separate window.", new AbstractIDEAction("Debug Selection/Form", Configuration.getIcon("debug.png")){

            public void doWork() {
                CodeEditor editor = Main.currentEditor();
                InteractionPane interactionpane = Interactions.getSelectedInteraction();
                if (editor != null && interactionpane != null) {
                    String str = editor.highlighter.getHighLightedCode("30select");
                    if (str != null) {
                        ((AbstractInteractionPane)interactionpane).enableDebugging(str);
                    } else {
                        Region region = editor.getDocument().getParser().findHooks(editor.cursor.cursorOffset());
                        if (region != null) {
                            ((AbstractInteractionPane)interactionpane).enableDebugging(editor.getDocument().getString(region.begin, region.end - region.begin + 1));
                        }
                    }
                }
            }
        });
        Mode.addAction("undebug", "Finish Debugging Document", "Load the original code of a source, disabling the debugging of this source.", new AbstractIDEAction("Finish Debugging Document", Configuration.getIcon("undebug.png")){

            public void doWork() {
                CodeEditor editor = Main.currentEditor();
                InteractionPane interactionpane = Interactions.getSelectedInteraction();
                if (editor != null) {
                    editor = editor.getEditorForInteraction();
                }
                if (editor != null && interactionpane != null) {
                    ((AbstractInteractionPane)interactionpane).disableDebugging(editor);
                }
            }
        });
        Mode.addAction("togglebreakpoint", "Toggle Breakpoint", "Enable/ disable a breakpoint on the current form.", new AbstractIDEAction("Toggle Breakpoint", Configuration.getIcon("togglebreakpoint.png")){

            public void doWork() {
                IInteraction interaction;
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor = editor.getEditorForInteraction();
                }
                if (editor != null && (interaction = editor.getInteraction()) != null) {
                    interactions.selectInteraction(interaction);
                    interaction.toggleBreakpoint(editor);
                }
            }
        });
        Mode.addAction("togglecondbreakpoint", "Toggle Conditional Breakpoint", "Enable/Disable a conditional breakpoint on the current form.", new AbstractIDEAction("Toggle Conditional Breakpoint", Configuration.getIcon("toggleconditionalbreakpoint.png")){

            public void doWork() {
                IInteraction interaction;
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor = editor.getEditorForInteraction();
                }
                if (editor != null && (interaction = editor.getInteraction()) != null) {
                    interactions.selectInteraction(interaction);
                    interaction.toggleConditionalBreakpoint(editor);
                }
            }
        });
        Mode.addAction("stepinto", "Step Into", "Give control to the program, stopping before execution of the next form.", new AbstractIDEAction("Step Into", Configuration.getIcon("stepinto.png")){

            public void doWork() {
                IInteraction interaction;
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor = editor.getEditorForInteraction();
                }
                if (editor != null && (interaction = editor.getInteraction()) != null) {
                    interactions.selectInteraction(interaction);
                    interaction.stepInto(editor);
                }
            }
        });
        Mode.addAction("stepover", "Step Over", "Give control to the program, stopping at the next form having the same parent as the current form.", new AbstractIDEAction("Step Over", Configuration.getIcon("stepover.png")){

            public void doWork() {
                IInteraction interaction;
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor = editor.getEditorForInteraction();
                }
                if (editor != null && (interaction = editor.getInteraction()) != null) {
                    interactions.selectInteraction(interaction);
                    interaction.stepOver(editor);
                }
            }
        });
        Mode.addAction("stopat", "Stop At", "Stop At", new AbstractIDEAction("Give control to the program and stop at the next breakpoint or the highlighted form (what comes first).", Configuration.getIcon("stopat.png")){

            public void doWork() {
                IInteraction interaction;
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor = editor.getEditorForInteraction();
                }
                if (editor != null && (interaction = editor.getInteraction()) != null) {
                    interactions.selectInteraction(interaction);
                    interaction.stopAt(editor);
                }
            }
        });
        Mode.addAction("stopafter", "Stop After", "Execute the current lisp form and returns to the debugger before executing the next form.", new AbstractIDEAction("Stop After", Configuration.getIcon("stopafter.png")){

            public void doWork() {
                IInteraction interaction;
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor = editor.getEditorForInteraction();
                }
                if (editor != null && (interaction = editor.getInteraction()) != null) {
                    interactions.selectInteraction(interaction);
                    interaction.stopAfter(editor);
                }
            }
        });
        Mode.addAction("setnewreturnvalue", "Set New Return Value", "Change the value of the just executed lispform (only when current editor is in debug mode and when you have done a stepafter).", new AbstractIDEAction("Set New Return Value", Configuration.getIcon("setnewreturnvalue.png")){

            public void doWork() {
                IInteraction interaction;
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor = editor.getEditorForInteraction();
                }
                if (editor != null && (interaction = editor.getInteraction()) != null) {
                    interactions.selectInteraction(interaction);
                    interaction.setNewReturnValue(editor);
                }
            }
        });
        Mode.addAction("continue", "Continue", "Returns control from the debugger to the debugged program.", new AbstractIDEAction("Continue", Configuration.getIcon("continue.png")){

            public void doWork() {
                IInteraction interaction;
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor = editor.getEditorForInteraction();
                }
                if (editor != null && (interaction = editor.getInteraction()) != null) {
                    interactions.selectInteraction(interaction);
                    interaction.continueExecution(editor);
                }
            }
        });
        Mode.addAction("future", "Step Forward In Time", "Go one frame forward in time. The lisp form which was executed after the current highlighted form is highlighted and the saved lexical environment of that moment is restored. If the maximum depth of the time buffer is reached a wrap around is taken place.", new AbstractIDEAction("Step Forward In Time", Configuration.getIcon("future.png")){

            public void doWork() {
                IInteraction interaction;
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor = editor.getEditorForInteraction();
                }
                if (editor != null && (interaction = editor.getInteraction()) != null) {
                    interactions.selectInteraction(interaction);
                    interaction.goToFuture(editor);
                }
            }
        });
        Mode.addAction("past", "Step Backward In Time", "Go one frame back in time. The lisp form which was executed before the current highlighted form is highlighted and the saved lexical environment of that moment is restored. If the maximum depth of the time buffer is reached a wrap around is taken place.", new AbstractIDEAction("Step Backward In Time", Configuration.getIcon("past.png")){

            public void doWork() {
                IInteraction interaction;
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor = editor.getEditorForInteraction();
                }
                if (editor != null && (interaction = editor.getInteraction()) != null) {
                    interactions.selectInteraction(interaction);
                    interaction.goToPast(editor);
                }
            }
        });
        Mode.addAction("startprofiling", "Start (reset) profiling", "Only valid for a editor in debug mode. Starts profiling or reset the profile counters. The debugger will count the number of times a lisp form is called during execution. Displays also a slider to highlight the forms with call count higer or equal to the sliders value.", new AbstractIDEAction("Start (reset) profiling", Configuration.getIcon("startprofiling.png")){

            public void doWork() {
                IInteraction interaction;
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor = editor.getEditorForInteraction();
                }
                if (editor != null && (interaction = editor.getInteraction()) != null) {
                    interactions.selectInteraction(interaction);
                    interaction.startProfiling(editor);
                }
            }
        });
        Mode.addAction("stopprofiling", "Stop Profiling", "Stop the profiling of a lisp program. The debugger will not track any more the amout of time that a lisp form is called. Will remove also the slider to display the profile information.", new AbstractIDEAction("Stop Profiling", Configuration.getIcon("stopprofiling.png")){

            public void doWork() {
                IInteraction interaction;
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor = editor.getEditorForInteraction();
                }
                if (editor != null && (interaction = editor.getInteraction()) != null) {
                    interactions.selectInteraction(interaction);
                    interaction.stopProfiling(editor);
                }
            }
        });
        Mode.addAction("addwatch", "Add Watch", "Adds a watch point to the current buffer if this buffer is in debug mode.", new AbstractIDEAction("Add Watch", Configuration.getIcon("watch.png")){

            public void doWork() {
                IInteraction interaction;
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor = editor.getEditorForInteraction();
                }
                if (editor != null && (interaction = editor.getInteraction()) != null) {
                    watch.addWatchPoint(editor, interaction);
                }
            }
        });
        Mode.addAction("watchleaf", "Watch variable", "Watch the current word (is considered a variable).", new AbstractIDEAction("Watch variable"){

            public void doWork() {
                IInteraction interaction;
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    editor = editor.getEditorForInteraction();
                }
                if (editor != null && (interaction = editor.getInteraction()) != null) {
                    watch.addWatchedLeaf(editor, interaction);
                }
            }
        });
        Mode.addAction("editwatch", "Edit Watch", "Starts a editor buffer allowing you to change the expression associated with the watchpoint selected in the watch explorer.", new AbstractIDEAction("Edit Watch"){

            public void doWork() {
                watch.editWatchPoint();
            }
        });
        Mode.addAction("removewatch", "Remode Watch", "Remove the watchpoint selected in the watch explorer.", new AbstractIDEAction("Remove Watch"){

            public void doWork() {
                watch.removeWatchPoint();
            }
        });
        Mode.addAction("keybinding", "Change Keybinding", "Displays a dialog box allowing you to change the keysequences acting as a shortcut for actions.", new AbstractIDEAction("keybinding"){

            public void doWork() {
                keymap.changeKeyMap();
            }
        });
        Mode.addAction("switch", "Switch", "Switch between the editor pane and the interaction pan.", new AbstractIDEAction("Switch"){

            public void doWork() {
                WorkPane pane;
                if (workarea.isCurrent()) {
                    CodePane pane2 = (CodePane)interactions.getSelectedComponent();
                    if (pane2 != null) {
                        Main.setCurrent(pane2.getEditor());
                    }
                } else if (interactions.isCurrent() && (pane = (WorkPane)workarea.getSelectedComponent()) != null) {
                    Main.setCurrent(pane.getFirstEditor());
                }
            }
        });
        Mode.addAction("next", "Next", "Switch to the next editor buffer in the interaction or editor pane. If the last buffer is reached switch back to the first buffer.", new AbstractIDEAction("next"){

            public void doWork() {
                if (workarea.isCurrent()) {
                    workarea.next();
                } else if (interactions.isCurrent()) {
                    interactions.next();
                }
            }
        });
    }

    public static void setCurrent(CodeEditor editor) {
        if (editor == null) {
            currentEditor = null;
            Mode.getMode("basic").activate();
        } else if (currentEditor != editor) {
            currentEditor = editor;
            Hint.setEditor(currentEditor);
            editor.getMode().activate();
            WorkArea.selectWorkPaneContainingEditor(editor);
            Interactions.selectInteractionPaneContainingEditor(editor);
            currentEditor.requestFocus();
            Main.currentEditor.cursor.setCursor(Main.currentEditor.cursor.cursorOffset());
            currentEditor.getDocument().setCodeEditor(currentEditor);
            ValueWindow.removeValueLeaf();
        }
    }

    public static void setMode(Mode mode, JMenuBar menubar, JPanel toolbar, ActionKeyMap keymap) {
        if (currentmode != mode) {
            frame.setJMenuBar(menubar);
            Main.keymap = keymap;
            Main.toolbar.removeAll();
            Main.toolbar.add(toolbar);
            Main.toolbar.revalidate();
            Main.toolbar.repaint();
            frame.validate();
            currentmode = mode;
            MessageHandler.displayMode(currentmode.getName());
        }
    }

    public static void updateCursorInfo(int line, int column) {
        cursorinfo.setText(line + "-" + column);
        cursorinfo.revalidate();
    }

    public static void setMousePointer(Cursor cursor) {
        frame.getContentPane().setCursor(cursor);
    }

    public static void setMousePointer(int cursortype) {
        frame.getContentPane().setCursor(new Cursor(cursortype));
    }

    public static CodeEditor currentEditor() {
        return currentEditor;
    }

    public static Mode currentMode() {
        return currentmode;
    }

    public static WorkArea getWorkArea() {
        return workarea;
    }

    public static JTabbedPane getInteractions() {
        return interactions;
    }

    public static void repaintEverything() {
        workarea.repaintAll();
        interactions.repaintAll();
        explorer.repaintAll();
        watch.repaintAll();
        macroexplorer.repaintAll();
    }

    public void windowClosing(WindowEvent e) {
        Main.exitJabberwocky();
    }

    private static void exitJabberwocky() {
        Thread stop = new Thread(){

            public void run() {
                Runnable doStop = new Runnable(this){
                    private final /* synthetic */ 94 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void run() {
                        Main.access$400();
                        Interactions.cleanup();
                        Main.saveStateAddins();
                        Main.access$000().closeAll();
                        SplashScreen.disposeSplash();
                        frame.setVisible(false);
                        frame.dispose();
                        System.out.flush();
                    }
                };
                try {
                    Thread.sleep(200L);
                    SwingUtilities.invokeAndWait(doStop);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.exit(0);
            }
        };
        if (workarea.saveAll()) {
            frame.getRootPane().setCursor(new Cursor(3));
            SplashScreen.showSplash();
            SplashScreen.showMessage("Exiting Jabberwocky");
            stop.start();
        } else {
            frame.getRootPane().setCursor(new Cursor(0));
        }
    }

    private static void cleanupTempFiles() {
        try {
            File tempdir = new File(System.getProperty("java.io.tmpdir"));
            File[] tempfiles = tempdir.listFiles();
            for (int i = 0; i < tempfiles.length; ++i) {
                if (!tempfiles[i].getName().startsWith("debug") && !tempfiles[i].getName().startsWith("instrument") && !tempfiles[i].getName().startsWith("lock")) continue;
                tempfiles[i].delete();
            }
        }
        catch (Exception ex) {
            MessageHandler.report("Error cleaning up temp files", ex);
        }
    }

    private static boolean checkFirstInstance() {
        File tempdir = new File(System.getProperty("java.io.tmpdir"));
        File[] lockfiles = tempdir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().startsWith("LockJabberwocky");
            }
        });
        if (lockfiles.length > 0 && JOptionPane.showConfirmDialog(null, "Jabberwocky is already started or was not terminated correctly the previous time.\nProceed with startup?", "Startup Jabberwocky", 2) == 2) {
            return false;
        }
        try {
            if (lockfiles.length > 0 && JOptionPane.showConfirmDialog(null, "Remove the lock files (Choose OK if Jabberwocky was not terminated correctly the previous time) ?", "Cleanup Lock files", 2) == 0) {
                for (int i = 0; i < lockfiles.length; ++i) {
                    lockfiles[i].delete();
                }
            }
            File lockfile = File.createTempFile("LockJabberwocky", "lck", tempdir);
            lockfile.deleteOnExit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static void registerAddin(IIDEAddin addin) {
        addins.add(addin);
    }

    public static void saveStateAddins() {
        try {
            File file = new File(System.getProperty("user.home") + File.separator + ".Jabberwocky" + File.separator + ".LispIDEState");
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            for (int i = 0; i < addins.size(); ++i) {
                ((IIDEAddin)addins.elementAt(i)).saveState(writer);
            }
            ((Writer)writer).close();
        }
        catch (IOException e) {
            MessageHandler.report("Failed to save state of components", e);
        }
    }

    private static Vector enumerateEditors() {
        Vector result = new Vector();
        workarea.enumerateEditors(result);
        interactions.enumerateEditors(result);
        return result;
    }

    public static void restoreCurrent(int max, int current) {
        Vector editors = Main.enumerateEditors();
        if (max == editors.size() && current < max && editors.elementAt(current) instanceof CodeEditor) {
            Main.setCurrent((CodeEditor)editors.elementAt(current));
        }
    }

    public void saveState(Writer writer) {
        XMLConfigClass cls = new XMLConfigClass(this.getClass().getName());
        XMLConfigMethod method = new XMLConfigMethod("restoreState");
        Dimension dim = frame.getSize();
        method.addArgument((int)dim.getWidth());
        method.addArgument((int)dim.getHeight());
        method.addArgument(deskinteractions.getDividerLocation());
        method.addArgument(central.getDividerLocation());
        cls.addMethod(method);
        if (currentEditor != null) {
            int current;
            Vector editors = Main.enumerateEditors();
            int m = editors.size();
            for (current = 0; current < m && editors.elementAt(current) != currentEditor; ++current) {
            }
            if (current < m) {
                method = new XMLConfigMethod("restoreCurrent");
                method.addArgument(m);
                method.addArgument(current);
                cls.addMethod(method);
            }
        }
        cls.serialize(writer);
    }

    public static void restoreState(int width, int height, int divDeskinteractions, int divCentral) {
        frame.setSize(width, height);
        deskinteractions.setDividerLocation(divDeskinteractions);
        central.setDividerLocation(divCentral);
    }

    public void focusGained(FocusEvent e) {
        if (currentEditor != null) {
            currentEditor.requestFocus();
        }
    }

    public void focusLost(FocusEvent e) {
    }

    static /* synthetic */ void access$400() {
        Main.cleanupTempFiles();
    }
}

