/*
 * Decompiled with CFR 0.152.
 */
package IDE.LispScripting;

import IDE.CodeEditor.CodeDocument;
import IDE.CodeEditor.CodeEditor;
import IDE.CodeEditor.CodePane;
import IDE.CodeEditor.Parser.LispParser;
import IDE.Configuration.AbstractIDEAction;
import IDE.Configuration.AbstractManagedAction;
import IDE.Configuration.KeySequence;
import IDE.Configuration.Mode;
import IDE.Interaction.Interactions;
import IDE.LispConnection.LispObject;
import IDE.Main;
import IDE.Messaging.InstructionField;
import IDE.Messaging.MessageHandler;
import IDE.Messaging.NumberQuestion;
import IDE.Messaging.StringQuestion;
import IDE.WorkArea.WorkArea;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;

public class LispIDEMethods {
    private LispIDEMethods() {
    }

    public static CodeEditor getCurrentEditor() {
        return Main.currentEditor();
    }

    public static CodeEditor getEditorByName(String filename) {
        return WorkArea.getEditorForLongName(filename);
    }

    public static void setCursor(CodeEditor editor, Long position) {
        editor.cursor.setCursor(position.intValue());
    }

    public static int getCursorOffset(CodeEditor editor) {
        return editor.cursor.cursorOffset();
    }

    public static void executeAction(String actionname) {
        AbstractManagedAction action = Mode.getAction(actionname);
        if (action != null) {
            action.actionPerformed(null);
        }
    }

    public static void askStringQuestion(String guidetext, final LispObject function) {
        StringQuestion question = new StringQuestion(guidetext){

            public void processEnter(String answer) {
                try {
                    function.getLispConnection().callLisp(function, new Object[]{answer}, false);
                }
                catch (Exception e) {
                    MessageHandler.warn("Error calling LISP from within string question");
                }
            }
        };
        InstructionField.ask(question);
    }

    public static void askNumberQuestion(String guidetext, final LispObject function) {
        NumberQuestion question = new NumberQuestion(guidetext){

            public void processEnter(int answer) {
                try {
                    function.getLispConnection().callLisp(function, new Object[]{new Integer(answer)}, false);
                }
                catch (Exception e) {
                    MessageHandler.warn("Error calling LISP from within number question");
                }
            }
        };
        InstructionField.ask(question);
    }

    public static String getText(CodeEditor editor, Long position, Long length) {
        return editor.getDocument().getString(position.intValue(), length.intValue());
    }

    public static AbstractIDEAction createAction(String name, String shortdescription, String longdescription, LispObject function) {
        return LispIDEMethods.createAction(name, shortdescription, longdescription, null, function);
    }

    public static AbstractIDEAction createAction(String name, String shortdescription, String longdescription, ImageIcon icon, final LispObject function) {
        AbstractIDEAction action = icon == null ? new AbstractIDEAction(name){

            public void doWork() {
                try {
                    function.getLispConnection().callLisp(function, new Object[0], false);
                }
                catch (Exception e) {
                    MessageHandler.warn("Error calling LISP action function");
                }
            }
        } : new AbstractIDEAction(name, icon){

            public void doWork() {
                try {
                    function.getLispConnection().callLisp(function, new Object[0], false);
                }
                catch (Exception e) {
                    MessageHandler.warn("Error calling LISP action function");
                }
            }
        };
        Mode.addAction(name, shortdescription, longdescription, action);
        return action;
    }

    public static void copyMode(String mode, String name) {
        Mode.getMode(mode).createCopy(name);
    }

    public static void addActionToMenu(String mode, String action, String menu) {
        Mode.getMode(mode).addActionToMenu(menu, action);
    }

    public static void addSeparatorToMenu(String mode, String menu) {
        Mode.getMode(mode).addSeparatorToMenu(menu);
    }

    public static void addCheckBoxToMenu(String mode, String action, String menu, Boolean enabled) {
        Mode.getMode(mode).addCheckboxToMenu(menu, action, enabled);
    }

    public static void addSeparatorToPopupMenu(String mode, String menu) {
        Mode.getMode(mode).addSeparatorToPopup(menu);
    }

    public static void addActionToPopupMenu(String mode, String action, String menu) {
        if (menu.length() > 0) {
            Mode.getMode(mode).addActionToPopup(menu, action);
        } else {
            Mode.getMode(mode).addActionToPopup(action);
        }
    }

    public static KeySequence createKeySequence(Object[] keysequence) {
        try {
            int m = keysequence.length;
            int[][] intkeystrokes = new int[m][2];
            for (int i = 0; i < m; ++i) {
                Object[] keystroke = (Object[])keysequence[i];
                intkeystrokes[i][0] = ((Long)keystroke[0]).intValue();
                intkeystrokes[i][1] = ((Long)keystroke[1]).intValue();
            }
            return new KeySequence(intkeystrokes);
        }
        catch (Exception e) {
            MessageHandler.warn("Error creating keysequence " + e.getMessage());
            return null;
        }
    }

    public static void bindActionToKeySequence(String mode, String action, KeySequence keysequence) {
        Mode.getMode(mode).bindActionToKeySequence(action, keysequence);
    }

    public static void addButton(String toolbar, String mode, String action) {
        Mode.getMode(mode).addButton(toolbar, action);
    }

    public static void setCurrentEditor(CodeEditor editor) {
        Main.setCurrent(editor);
    }

    public static CodeEditor createEditor() {
        CodePane pane = new CodePane(new LispParser(true));
        return pane.getEditor();
    }

    public static CodeEditor createEditor(String filename) {
        File file = new File(filename);
        CodePane pane = CodePane.createCodePane(new LispParser(true), file);
        return pane.getEditor();
    }

    public static ImageIcon createIcon(String filename) {
        return new ImageIcon(filename);
    }

    public static void insertText(CodeEditor editor, Long position, String text) {
        editor.insertStringAt(text, position.intValue());
    }

    public static void removeText(CodeEditor editor, Long position, Long length) {
        editor.remove(position.intValue(), length.intValue());
    }

    public static Matcher regularExpressionSearch(CodeEditor editor, String regexp, Boolean casesensitive) {
        CodeDocument document = editor.getDocument();
        String content = document.getString(0, document.length());
        Pattern pattern = casesensitive != false ? Pattern.compile(regexp) : Pattern.compile(regexp, 2);
        return pattern.matcher(content);
    }

    public static int matcherFind(Matcher matcher) {
        if (matcher.find()) {
            return matcher.start();
        }
        return -1;
    }

    public static int matcherFind(Matcher matcher, Long position) {
        if (matcher.find(position.intValue())) {
            return matcher.start();
        }
        return -1;
    }

    public static int matcherEnd(Matcher matcher) {
        return matcher.end();
    }

    public static void sendCommand(String command) {
        Interactions.getSelectedInteraction().getInteraction().sendCommand(command);
    }
}

