/*
 * Decompiled with CFR 0.152.
 */
package IDE.LispScripting;

import IDE.Configuration.AbstractManagedAction;
import IDE.Configuration.InstallParameters;
import IDE.Configuration.Mode;
import IDE.Interaction.InteractionPane;
import IDE.Interaction.Interactions;
import IDE.Interaction.LispInteraction;
import IDE.Messaging.MessageHandler;
import IDE.Utilities.Util;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Iterator;

public class GenerateLispCode {
    private GenerateLispCode() {
    }

    public static void generate() {
        MessageHandler.say("Start generating LISP code");
        try {
            int i;
            int c;
            String sourcedir = InstallParameters.getSourceDir();
            String installdir = InstallParameters.getInstallDir();
            File seedfile = new File(installdir + File.separator + "seed.lisp");
            File resultfile = new File(installdir + File.separator + "jabberwocky.lisp");
            File sourcefile = new File(sourcedir + File.separator + "jabberwocky.lisp");
            if (resultfile.exists()) {
                resultfile.delete();
            }
            resultfile.createNewFile();
            BufferedReader reader = new BufferedReader(new FileReader(seedfile));
            BufferedWriter writer = new BufferedWriter(new FileWriter(resultfile, false));
            while ((c = reader.read()) != -1) {
                writer.write(c);
            }
            writer.write(";;; ***************************************************************\n");
            writer.write(";;; Generated code by Jabberwocky \n");
            writer.write(";;; ***************************************************************\n");
            try {
                Class<?> cls = Class.forName("java.awt.event.KeyEvent");
                Field[] fields = cls.getFields();
                for (i = 0; i < fields.length; ++i) {
                    if (fields[i].getType() != Integer.TYPE || !Modifier.isPublic(fields[i].getModifiers()) || !Modifier.isStatic(fields[i].getModifiers()) || !Modifier.isFinal(fields[i].getModifiers())) continue;
                    writer.write("(defconstant **" + fields[i].getName().toLowerCase().replace('_', '-') + "** " + fields[i].getInt(null) + ")\n");
                }
            }
            catch (Exception e) {
                MessageHandler.warn("Error finding fields in KeyEvent class, " + e.getMessage());
            }
            writer.write(";;; ***************************************************************\n");
            writer.write(";;; Functions to execute a action \n");
            writer.write(";;; ***************************************************************\n");
            Iterator iter = Mode.getActionIterator();
            while (iter.hasNext()) {
                GenerateLispCode.writeActionDefinition((AbstractManagedAction)iter.next(), writer);
            }
            writer.close();
            InteractionPane[] interactionpanes = Interactions.getInteractionPanes();
            for (i = 0; i < interactionpanes.length; ++i) {
                if (!(interactionpanes[i].getInteraction() instanceof LispInteraction)) continue;
                interactionpanes[i].executeCommand("(if (not (find-package \"JABBERWOCKY\")) (make-package \"JABBERWOCKY\"))");
                interactionpanes[i].executeCommand("(compile-file \"" + Util.getCanonicalFileName(resultfile) + "\")");
                String compiledfile = installdir + File.separator + "jabberwocky." + ((LispInteraction)interactionpanes[i].getInteraction()).getCompiledExtension();
                interactionpanes[i].executeCommand("(load \"" + compiledfile + "\")");
            }
            if (new File(sourcedir).exists()) {
                if (sourcefile.exists()) {
                    sourcefile.delete();
                }
                sourcefile.createNewFile();
                reader = new BufferedReader(new FileReader(resultfile));
                writer = new BufferedWriter(new FileWriter(sourcefile));
                while ((c = reader.read()) != -1) {
                    writer.write(c);
                }
                writer.close();
            }
        }
        catch (Exception e) {
            MessageHandler.warn("Error generating LISP code, " + e.getMessage());
        }
        MessageHandler.say("Finished generating LISP code");
    }

    private static void writeActionDefinition(AbstractManagedAction action, Writer writer) {
        String functionname = GenerateLispCode.createFunctionName(action);
        try {
            writer.write(10);
            writer.write("(defun IDE-" + functionname + " ()\n");
            writer.write("    (execute-action \"" + Mode.getNameAction(action) + "\"))");
            writer.write("\n");
        }
        catch (Exception e) {
            MessageHandler.warn("Error generating LISP code for action, " + e.getMessage());
        }
    }

    public static String createFunctionName(AbstractManagedAction action) {
        return ((String)action.getValue("ACTION")).replace(' ', '-').toLowerCase();
    }
}

