/*
 * Decompiled with CFR 0.152.
 */
package IDE.LispConnection;

import IDE.LispConnection.LispConnectionException;
import IDE.LispConnection.LispObject;
import IDE.Messaging.MessageHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.SwingUtilities;

public class LispConnection
implements Runnable {
    private BufferedOutputStream callOut;
    private BufferedInputStream callIn;
    private ServerSocket callServer;
    private Socket callClient;
    private BufferedOutputStream calledOut;
    private BufferedInputStream calledIn;
    private ServerSocket calledServer;
    private Socket calledClient;
    private Thread thread;
    private Hashtable integerToObject;
    private Hashtable objectToInteger = new Hashtable(100);
    private int objectcounter = 0;
    static /* synthetic */ Class class$java$util$LinkedList;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$IDE$LispConnection$LispObject;

    public LispConnection(int socket1, int socket2) throws LispConnectionException {
        this.integerToObject = new Hashtable(100);
        try {
            this.calledServer = new ServerSocket(socket1);
        }
        catch (IOException e) {
            throw new LispConnectionException("Could not listen on port", socket1, socket2);
        }
        try {
            this.calledClient = this.calledServer.accept();
            this.calledClient.setTcpNoDelay(true);
            this.calledOut = new BufferedOutputStream(this.calledClient.getOutputStream());
            this.calledIn = new BufferedInputStream(this.calledClient.getInputStream());
        }
        catch (IOException e) {
            throw new LispConnectionException("Accept on port " + socket1 + " failed", socket1, socket2);
        }
        try {
            this.callServer = new ServerSocket(socket2);
        }
        catch (IOException e) {
            throw new LispConnectionException("Could not listen on port" + socket2, socket1, socket2);
        }
        try {
            this.callClient = this.callServer.accept();
            this.callClient.setTcpNoDelay(true);
            this.callOut = new BufferedOutputStream(this.callClient.getOutputStream());
            this.callIn = new BufferedInputStream(this.callClient.getInputStream());
        }
        catch (IOException e) {
            throw new LispConnectionException("Accept on port " + socket1 + " failed", socket1, socket2);
        }
        this.integerToObject.put(new Integer(0), this);
        this.objectToInteger.put(this, new Integer(0));
        this.objectcounter = 1;
        this.thread = new Thread((Runnable)this, "processLISP");
        this.thread.setPriority(1);
        this.thread.start();
    }

    public static int getFreeSocketPort(int begin, int end) {
        if (begin > end) {
            return -1;
        }
        ServerSocket socket = null;
        for (int socketnr = begin; socketnr <= end; ++socketnr) {
            try {
                socket = new ServerSocket(socketnr);
                socket.close();
                return socketnr;
            }
            catch (Exception e1) {
                try {
                    socket.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                continue;
            }
        }
        return -1;
    }

    public Thread getThread() {
        return this.thread;
    }

    public void cleanup() {
        try {
            try {
                this.callOut.write(65);
                this.callOut.flush();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.thread.interrupt();
            this.callOut.close();
            this.callIn.close();
            this.calledOut.close();
            this.calledIn.close();
            this.callClient.close();
            this.callServer.close();
            this.calledClient.close();
            this.calledServer.close();
        }
        catch (IOException e) {
            System.exit(-1);
        }
    }

    public void run() {
        while (!Thread.interrupted()) {
            try {
                this.processLisp();
            }
            catch (IOException e) {
                MessageHandler.report("IO errors during processing LISP input", e);
                return;
            }
        }
    }

    private void callInSwingThread(final Method method, final Object object, final Object[] arglist) {
        Runnable caller = new Runnable(){

            public void run() {
                try {
                    LispConnection.this.returnToLisp(method.invoke(object, arglist), LispConnection.this.calledOut);
                }
                catch (Exception e) {
                    MessageHandler.report("Error processing lisp function", e);
                }
            }
        };
        try {
            SwingUtilities.invokeAndWait(caller);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected void processLisp() throws IOException {
        String classname = "";
        String methodname = "";
        String membername = "";
        Class[] arglistclass = null;
        try {
            char c = (char)this.calledIn.read();
            switch (c) {
                case 'C': 
                case 'S': {
                    classname = (String)this.readLispData(this.calledIn);
                    methodname = (String)this.readLispData(this.calledIn);
                    long nrargs = (Long)this.readLispData(this.calledIn);
                    Object[] arglist = new Object[(int)nrargs];
                    arglistclass = new Class[(int)nrargs];
                    int i = 1;
                    while ((long)i <= nrargs) {
                        Object data = this.readLispData(this.calledIn);
                        if (data instanceof BaseType) {
                            arglist[i - 1] = ((BaseType)data).getValue();
                            arglistclass[i - 1] = ((BaseType)data).getType();
                        } else {
                            arglist[i - 1] = data;
                            arglistclass[i - 1] = data.getClass();
                        }
                        ++i;
                    }
                    Class<?> cls = Class.forName(classname);
                    Method method = cls.getMethod(methodname, arglistclass);
                    if (c == 'S') {
                        this.callInSwingThread(method, null, arglist);
                        break;
                    }
                    this.returnToLisp(method.invoke(null, arglist), this.calledOut);
                    break;
                }
                case 'c': {
                    classname = (String)this.readLispData(this.calledIn);
                    membername = (String)this.readLispData(this.calledIn);
                    Class<?> cls = Class.forName(classname);
                    this.returnToLisp(cls.getField(membername).get(null), this.calledOut);
                    break;
                }
                case 'O': 
                case 's': {
                    Object object = this.readLispData(this.calledIn);
                    methodname = (String)this.readLispData(this.calledIn);
                    long nrargs = (Long)this.readLispData(this.calledIn);
                    Object[] arglist = new Object[(int)nrargs];
                    arglistclass = new Class[(int)nrargs];
                    int i = 1;
                    while ((long)i <= nrargs) {
                        Object data = this.readLispData(this.calledIn);
                        if (data instanceof BaseType) {
                            arglist[i - 1] = ((BaseType)data).getValue();
                            arglistclass[i - 1] = ((BaseType)data).getType();
                        } else {
                            arglist[i - 1] = data;
                            arglistclass[i - 1] = data.getClass();
                        }
                        ++i;
                    }
                    Class<?> cls = object.getClass();
                    classname = cls.toString();
                    Method method = cls.getMethod(methodname, arglistclass);
                    if (c == 's') {
                        this.callInSwingThread(method, object, arglist);
                        break;
                    }
                    this.returnToLisp(method.invoke(object, arglist), this.calledOut);
                    break;
                }
                case 'o': {
                    Object object = this.readLispData(this.calledIn);
                    membername = (String)this.readLispData(this.calledIn);
                    Class<?> cls = object.getClass();
                    this.returnToLisp(cls.getField(membername).get(object), this.calledOut);
                    break;
                }
                case 'N': {
                    classname = (String)this.readLispData(this.calledIn);
                    long nrargs = (Long)this.readLispData(this.calledIn);
                    Object[] arglist = new Object[(int)nrargs];
                    arglistclass = new Class[(int)nrargs];
                    int i = 1;
                    while ((long)i <= nrargs) {
                        Object data = this.readLispData(this.calledIn);
                        if (data instanceof BaseType) {
                            arglist[i - 1] = ((BaseType)data).getValue();
                            arglistclass[i - 1] = ((BaseType)data).getType();
                        } else {
                            arglist[i - 1] = data;
                            arglistclass[i - 1] = data.getClass();
                        }
                        ++i;
                    }
                    Class<?> cls = Class.forName(classname);
                    Constructor<?> constructor = cls.getConstructor(arglistclass);
                    this.returnToLisp(constructor.newInstance(arglist), this.calledOut);
                }
            }
        }
        catch (ClassNotFoundException e) {
            this.returnToLisp(null, this.calledOut);
            MessageHandler.report("Could not find class = " + classname + " to call a static method from", e);
        }
        catch (NoSuchMethodException e) {
            String args = "(";
            if (arglistclass != null) {
                for (int i = 0; i < arglistclass.length; ++i) {
                    args = args + arglistclass[i].getName();
                }
            }
            args = args + ")";
            this.returnToLisp(null, this.calledOut);
            MessageHandler.report("Could not find method " + classname + "." + methodname + args, e);
        }
        catch (SecurityException e) {
            this.returnToLisp(null, this.calledOut);
            MessageHandler.report("You are not allowed to call method " + classname + "." + methodname, e);
        }
        catch (IllegalAccessException e) {
            this.returnToLisp(null, this.calledOut);
            MessageHandler.report("Illegal Access Exception when calling method " + classname + "." + methodname, e);
        }
        catch (InvocationTargetException e) {
            this.returnToLisp(null, this.calledOut);
            MessageHandler.report("Invocation Target Exception", e);
        }
        catch (InstantiationException e) {
            this.returnToLisp(null, this.calledOut);
            MessageHandler.report("Instantiation Exception", e);
        }
        catch (NoSuchFieldException e) {
            this.returnToLisp(null, this.calledOut);
            MessageHandler.report("Could not find member = " + membername, e);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected void returnToLisp(Object obj, BufferedOutputStream out) throws IOException {
        if (obj == null) {
            this.returnToLispBool(false, out);
        } else {
            Class<?> objclass = obj.getClass();
            if (objclass.isArray()) {
                this.returnToLispArray((Object[])obj, out);
            } else if (objclass == (class$java$util$LinkedList == null ? (class$java$util$LinkedList = LispConnection.class$("java.util.LinkedList")) : class$java$util$LinkedList)) {
                this.returnToLispList((LinkedList)obj, out);
            } else if (objclass == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = LispConnection.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                this.returnToLispBool((Boolean)obj, out);
            } else if (objclass == (class$java$lang$Short == null ? (class$java$lang$Short = LispConnection.class$("java.lang.Short")) : class$java$lang$Short)) {
                this.returnToLispNumber(((Short)obj).toString(), out);
            } else if (objclass == (class$java$lang$Integer == null ? (class$java$lang$Integer = LispConnection.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                this.returnToLispNumber(((Integer)obj).toString(), out);
            } else if (objclass == (class$java$lang$Long == null ? (class$java$lang$Long = LispConnection.class$("java.lang.Long")) : class$java$lang$Long)) {
                this.returnToLispNumber(((Long)obj).toString(), out);
            } else if (objclass == (class$java$lang$Float == null ? (class$java$lang$Float = LispConnection.class$("java.lang.Float")) : class$java$lang$Float)) {
                this.returnToLispNumber(((Float)obj).toString(), out);
            } else if (objclass == (class$java$lang$Double == null ? (class$java$lang$Double = LispConnection.class$("java.lang.Double")) : class$java$lang$Double)) {
                this.returnToLispNumber(((Double)obj).toString(), out);
            } else if (objclass == (class$java$lang$Byte == null ? (class$java$lang$Byte = LispConnection.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                this.returnToLispNumber(((Byte)obj).toString(), out);
            } else if (objclass == (class$java$lang$Character == null ? (class$java$lang$Character = LispConnection.class$("java.lang.Character")) : class$java$lang$Character)) {
                this.returnToLispChar(((Character)obj).charValue(), out);
            } else if (objclass == (class$java$lang$String == null ? (class$java$lang$String = LispConnection.class$("java.lang.String")) : class$java$lang$String)) {
                this.returnToLispString((String)obj, out);
            } else if (objclass == (class$IDE$LispConnection$LispObject == null ? (class$IDE$LispConnection$LispObject = LispConnection.class$("IDE.LispConnection.LispObject")) : class$IDE$LispConnection$LispObject)) {
                this.returnToLispLispObject((LispObject)obj, out);
            } else {
                this.returnToLispObject(obj, out);
            }
        }
    }

    protected void returnToLispArray(Object[] obj, BufferedOutputStream out) throws IOException {
        int len = obj.length;
        out.write(65);
        out.write(String.valueOf(len).getBytes());
        out.write(10);
        out.flush();
        for (int i = 0; i < len; ++i) {
            this.returnToLisp(obj[i], out);
        }
    }

    protected void returnToLispList(LinkedList lst, BufferedOutputStream out) throws IOException {
        long len = lst.size();
        out.write(76);
        out.write(String.valueOf(len).getBytes());
        out.write(10);
        out.flush();
        ListIterator lstiterator = lst.listIterator();
        int i = 1;
        while ((long)i <= len) {
            this.returnToLisp(lstiterator.next(), out);
            ++i;
        }
    }

    protected void returnToLispBool(boolean bool, BufferedOutputStream out) throws IOException {
        out.write(66);
        if (bool) {
            out.write(84);
        } else {
            out.write("NIL".getBytes());
        }
        out.write(10);
        out.flush();
    }

    protected void returnToLispNumber(String number, BufferedOutputStream out) throws IOException {
        out.write(78);
        out.write(number.getBytes());
        out.write(10);
        out.flush();
    }

    protected void returnToLispChar(char chr, BufferedOutputStream out) throws IOException {
        out.write(67);
        String str = "#\\" + chr;
        out.write(str.getBytes());
        out.write(10);
        out.flush();
    }

    protected void returnToLispString(String str, BufferedOutputStream out) throws IOException {
        out.write(83);
        out.write(String.valueOf(str.length()).getBytes());
        out.write(10);
        out.write(str.getBytes());
        out.flush();
    }

    protected void returnToLispObject(Object obj, BufferedOutputStream out) throws IOException {
        int objectid;
        Integer integer = (Integer)this.objectToInteger.get(obj);
        if (integer == null) {
            ++this.objectcounter;
            objectid = this.objectcounter;
            this.integerToObject.put(new Integer(this.objectcounter), obj);
            this.objectToInteger.put(obj, new Integer(this.objectcounter));
        } else {
            objectid = integer;
        }
        out.write(79);
        out.write(String.valueOf(objectid).getBytes());
        out.write(10);
        out.flush();
    }

    protected void returnToLispLispObject(LispObject obj, BufferedOutputStream out) throws IOException {
        out.write(108);
        out.write(String.valueOf(obj.getId()).getBytes());
        out.write(10);
        out.flush();
    }

    public synchronized Object callLisp(String lispcmd, boolean nodisplay) throws IOException {
        if (nodisplay) {
            this.callOut.write(83);
        } else {
            this.callOut.write(115);
        }
        this.returnToLisp(lispcmd, this.callOut);
        this.callOut.flush();
        return this.readLispData(this.callIn);
    }

    public synchronized Object callLisp(LinkedList lst, boolean nodisplay) throws IOException {
        ListIterator lstiterator = lst.listIterator();
        if (nodisplay) {
            this.callOut.write(67);
        } else {
            this.callOut.write(99);
        }
        this.callOut.write(String.valueOf(lst.size() - 1).getBytes());
        this.callOut.write(10);
        Object function = lstiterator.next();
        this.returnToLisp(function, this.callOut);
        while (lstiterator.hasNext()) {
            this.returnToLisp(lstiterator.next(), this.callOut);
        }
        return this.readLispData(this.callIn);
    }

    public synchronized Object callLisp(Object function, Object[] args, boolean nodisplay) throws IOException {
        if (nodisplay) {
            this.callOut.write(67);
        } else {
            this.callOut.write(99);
        }
        this.callOut.write(String.valueOf(args.length).getBytes());
        this.callOut.write(10);
        this.returnToLisp(function, this.callOut);
        for (int i = 0; i < args.length; ++i) {
            this.returnToLisp(args[i], this.callOut);
        }
        return this.readLispData(this.callIn);
    }

    protected Object readLispData(BufferedInputStream strm) throws IOException {
        char c = (char)strm.read();
        switch (c) {
            case 'N': {
                return this.readLispDataNumber(strm);
            }
            case 'B': {
                return this.readLispDataBool(strm);
            }
            case 'S': {
                return this.readLispDataString(strm);
            }
            case 'A': {
                return this.readLispDataArray(strm);
            }
            case 'L': {
                return this.readLispDataList(strm);
            }
            case 'l': {
                return this.readLispDataLispObject(strm);
            }
            case 'O': {
                return this.readLispDataObject(strm);
            }
            case 'C': {
                return this.readLispDataCast(strm);
            }
        }
        MessageHandler.warn("Expected a character N,B,S,A,L,I,O or C but received a <" + c + ">");
        return new Integer(0);
    }

    protected Object readLispDataCast(BufferedInputStream strm) throws IOException {
        switch ((char)strm.read()) {
            case 'S': {
                return new ShortType(this.readLispData(strm));
            }
            case 'I': {
                return new IntType(this.readLispData(strm));
            }
            case 'B': {
                return new ByteType(this.readLispData(strm));
            }
            case 'L': {
                return new LongType(this.readLispData(strm));
            }
            case 'F': {
                return new FloatType(this.readLispData(strm));
            }
            case 'D': {
                return new DoubleType(this.readLispData(strm));
            }
            case 'C': {
                return new CharType(this.readLispData(strm));
            }
            case 'b': {
                return new BooleanType(this.readLispData(strm));
            }
        }
        return new Integer(0);
    }

    protected Object[] readLispDataArray(BufferedInputStream strm) throws IOException {
        long len = (Long)this.readLispDataNumber(strm);
        Object[] res = new Object[(int)len];
        int i = 0;
        while ((long)i < len) {
            res[i] = this.readLispData(strm);
            ++i;
        }
        return res;
    }

    protected LinkedList readLispDataList(BufferedInputStream strm) throws IOException {
        long len = (Long)this.readLispDataNumber(strm);
        LinkedList<Object> lst = new LinkedList<Object>();
        int i = 0;
        while ((long)i < len) {
            lst.add(this.readLispData(strm));
            ++i;
        }
        return lst;
    }

    protected Object readLispDataObject(BufferedInputStream strm) {
        long id = (Long)this.readLispDataNumber(strm);
        return this.integerToObject.get(new Integer((int)id));
    }

    protected Object readLispDataLispObject(BufferedInputStream strm) throws IOException {
        return new LispObject((Long)this.readLispData(strm), this);
    }

    protected Object readLispDataNumber(BufferedInputStream strm) {
        StringBuffer buffer = new StringBuffer(10);
        try {
            char c;
            while ((c = (char)strm.read()) != '\u0000') {
                buffer.append(c);
            }
            String str = buffer.toString();
            try {
                Long longResult = Long.valueOf(str);
                return longResult;
            }
            catch (NumberFormatException e3) {
                try {
                    Double doubleResult = Double.valueOf(str);
                    return doubleResult;
                }
                catch (NumberFormatException e5) {
                    MessageHandler.report("Data from lisp is not a number when it should be, data=" + str, e5);
                }
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return new Long(0L);
    }

    protected Boolean readLispDataBool(BufferedInputStream strm) throws IOException {
        if ((char)strm.read() == 'T') {
            return new Boolean(true);
        }
        return new Boolean(false);
    }

    protected String readLispDataString(BufferedInputStream strm) throws IOException {
        char c;
        StringBuffer buffer = new StringBuffer(10);
        int length = 0;
        while ((c = (char)strm.read()) != '\u0000') {
            buffer.append(c);
        }
        length = Integer.parseInt(buffer.toString());
        buffer = new StringBuffer(100);
        for (int i = 1; i <= length; ++i) {
            buffer.append((char)strm.read());
        }
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class BooleanType
    extends BaseType {
        Boolean value;

        BooleanType(Object val) {
            this.value = (Boolean)val;
        }

        protected Object getValue() {
            return this.value;
        }

        protected Class getType() {
            return Boolean.TYPE;
        }
    }

    private class CharType
    extends BaseType {
        Character value;

        CharType(Object val) {
            this.value = (Character)val;
        }

        protected Object getValue() {
            return this.value;
        }

        protected Class getType() {
            return Character.TYPE;
        }
    }

    private class DoubleType
    extends BaseType {
        Double value;

        DoubleType(Object val) {
            this.value = (Double)val;
        }

        protected Object getValue() {
            return this.value;
        }

        protected Class getType() {
            return Double.TYPE;
        }
    }

    private class FloatType
    extends BaseType {
        Float value;

        FloatType(Object val) {
            this.value = new Float((float)((Double)val).doubleValue());
        }

        protected Object getValue() {
            return this.value;
        }

        protected Class getType() {
            return Double.TYPE;
        }
    }

    private class LongType
    extends BaseType {
        Long value;

        LongType(Object val) {
            this.value = (Long)val;
        }

        protected Object getValue() {
            return this.value;
        }

        protected Class getType() {
            return Long.TYPE;
        }
    }

    private class IntType
    extends BaseType {
        Integer value;

        IntType(Object val) {
            this.value = new Integer((int)((Long)val).longValue());
        }

        protected Object getValue() {
            return this.value;
        }

        protected Class getType() {
            return Integer.TYPE;
        }
    }

    private class ShortType
    extends BaseType {
        Short value;

        ShortType(Object val) {
            this.value = new Short((short)((Long)val).longValue());
        }

        protected Object getValue() {
            return this.value;
        }

        protected Class getType() {
            return Short.TYPE;
        }
    }

    private class ByteType
    extends BaseType {
        Byte value;

        ByteType(Object val) {
            this.value = new Byte((byte)((Long)val).longValue());
        }

        protected Object getValue() {
            return this.value;
        }

        protected Class getType() {
            return Byte.TYPE;
        }
    }

    private class BaseType {
        private BaseType() {
        }

        protected Object getValue() {
            return new Integer(0);
        }

        protected Class getType() {
            return Integer.TYPE;
        }
    }
}

