/*
 * Decompiled with CFR 0.152.
 */
package IDE.Interaction;

import IDE.CodeEditor.CodeDocument;
import IDE.CodeEditor.CodeEditor;
import IDE.CodeEditor.Parser.Parser;
import IDE.Interaction.AbstractInteractionPane;
import IDE.Interaction.IInteraction;
import IDE.Interaction.InteractionPane;
import javax.swing.SwingUtilities;

public class WatchPane
extends AbstractInteractionPane {
    private InteractionPane interactionPane;
    private IInteraction interaction;
    private String result;

    protected WatchPane(InteractionPane interactionPane) {
        super(interactionPane.getEditor().getDocument().getParser().cloneParser(true));
        this.interactionPane = interactionPane;
        this.interaction = interactionPane.getInteraction();
        interactionPane.addWatchPane(this);
    }

    public void enableDebugging(String code) {
        this.interactionPane.enableDebugging(code);
    }

    public void enableDebugging(CodeEditor editor) {
        this.interactionPane.enableDebugging(editor);
    }

    public boolean processEnter() {
        Parser parser = this.getEditor().getDocument().getParser();
        CodeDocument document = this.getEditor().getDocument();
        Object command = null;
        return this.executeCommand(this.findLastCommand());
    }

    public void disableDebugging(CodeEditor editor) {
        this.interactionPane.disableDebugging(editor);
    }

    public IInteraction getInteraction() {
        return this.interaction;
    }

    public InteractionPane getInteractionPane() {
        return this.interactionPane;
    }

    public String getName() {
        return "Watch " + this.interactionPane.getName();
    }

    public void insertCommand(String command) {
        this.getEditor().insertStringAt(command, this.getEditor().getDocument().length() - 1);
        this.moveCursorToEnd();
    }

    public boolean executeCommand(final String command) {
        final Runnable updateContent = new Runnable(){

            public void run() {
                AbstractInteractionPane.addCommandToHistory(WatchPane.this.result);
                WatchPane.this.getEditor().insertStringAt("\n" + WatchPane.this.result, WatchPane.this.getEditor().getDocument().length() - 1);
                WatchPane.this.moveToEnd();
            }
        };
        Runnable doWork = new Runnable(){

            public void run() {
                WatchPane.this.result = WatchPane.this.interaction.callProcess(command);
                SwingUtilities.invokeLater(updateContent);
            }
        };
        if (command != null) {
            Thread thread = new Thread(doWork);
            thread.start();
            return true;
        }
        return false;
    }

    public void cleanup() {
        this.getEditor().getDocument().getParser().stopParsing();
    }
}

