/*
 * Decompiled with CFR 0.152.
 */
package IDE.Interaction;

import IDE.CodeEditor.CodeDialogBox;
import IDE.CodeEditor.CodeEditor;
import IDE.CodeEditor.CodeElement;
import IDE.CodeEditor.CodeLeafElement;
import IDE.CodeEditor.CodeLeafSeparator;
import IDE.CodeEditor.LeafVector;
import IDE.CodeEditor.Parser.LispListElement;
import IDE.CodeEditor.Parser.LispParser;
import IDE.CodeEditor.Parser.Parser;
import IDE.CodeEditor.Region;
import IDE.Configuration.Configuration;
import IDE.Configuration.Mode;
import IDE.Interaction.AbstractInteractionPane;
import IDE.Interaction.IInteraction;
import IDE.Interaction.InteractionPane;
import IDE.Interaction.Interactions;
import IDE.Interaction.LispInteraction;
import IDE.LispConnection.LispConnection;
import IDE.Main;
import IDE.Messaging.MessageHandler;
import IDE.Utilities.Util;
import IDE.Watch.WatchNode;
import IDE.WorkArea.WorkArea;
import Install.OsSystem;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LispInteraction
implements IInteraction {
    private boolean stoplisten = false;
    protected int processid = -1;
    private static int portnr = 4442;
    private static ImageIcon[] icons = new ImageIcon[]{Configuration.getIcon("watch_unknow.png"), Configuration.getIcon("watch_string.png"), Configuration.getIcon("watch_bit_vector.png"), Configuration.getIcon("watch_vector.png"), Configuration.getIcon("watch_array.png"), Configuration.getIcon("watch_character.png"), Configuration.getIcon("watch_complex.png"), Configuration.getIcon("watch_float.png"), Configuration.getIcon("watch_function.png"), Configuration.getIcon("watch_hash_table.png"), Configuration.getIcon("watch_integer.png"), Configuration.getIcon("watch_ration.png"), Configuration.getIcon("watch_number.png"), Configuration.getIcon("watch_package.png"), Configuration.getIcon("watch_pathname.png"), Configuration.getIcon("watch_randomstate.png"), Configuration.getIcon("watch_readtable.png"), Configuration.getIcon("watch_null.png"), Configuration.getIcon("watch_list.png"), Configuration.getIcon("watch_cons.png"), Configuration.getIcon("watch_sequence.png"), Configuration.getIcon("watch_stream.png"), Configuration.getIcon("watch_symbol.png"), Configuration.getIcon("watch_T.png"), Configuration.getIcon("watch_structure.png"), Configuration.getIcon("watch_class.png"), Configuration.getIcon("watch_unknow.png")};
    private static String[] types = new String[]{new String("unknow"), new String("string"), new String("bit_vector"), new String("vector"), new String("array"), new String("character"), new String("complex"), new String("float"), new String("function"), new String("hash_table"), new String("integer"), new String("ration"), new String("number"), new String("package"), new String("pathname"), new String("randomstate"), new String("readtable"), new String("null"), new String("list"), new String("cons"), new String("sequence"), new String("stream"), new String("symbol"), new String("T"), new String("structure"), new String("class"), new String("unknow")};
    private InteractionPane interactionpane = null;
    private Hashtable editorToDebuggedEditor;
    private String startcommand;
    private String lispcommand;
    private Process process;
    private Writer lispinput;
    private InputStream lispoutput;
    private InputStream lisperror;
    protected LispConnection lispconnection = null;
    private static Vector interactions = new Vector();

    protected LispInteraction(String startcommand, String lispcommand) {
        this.startcommand = startcommand;
        this.lispcommand = lispcommand;
        interactions.add(this);
        this.editorToDebuggedEditor = new Hashtable();
    }

    protected static IInteraction createInteractionImp(String startcommand, String lispcommand) {
        return new LispInteraction(startcommand, lispcommand);
    }

    public static String getSyntaxDescription(String name) {
        InteractionPane interactionpane = Interactions.getSelectedInteraction();
        if (interactionpane == null) {
            return "";
        }
        try {
            LispInteraction interaction = (LispInteraction)interactionpane.getInteraction();
            Object object = interaction.lispconnection.callLisp("DEBUGGER::get-syntax", new Object[]{name}, true);
            if (object instanceof String) {
                return (String)object;
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public void sendCommand(final String command) {
        Runnable doSend = new Runnable(){

            public void run() {
                try {
                    MessageHandler.say("Lisp command : " + command);
                    LispInteraction.this.lispinput.write(command + "\n");
                    LispInteraction.this.lispinput.flush();
                }
                catch (IOException e) {
                    LispInteraction.this.cleanupAftererror("IOError during write to lispprocess error " + e.getMessage(), e);
                }
            }
        };
        Thread thread = new Thread(doSend);
        thread.start();
    }

    public String callProcess(String command) {
        try {
            if (this.lispconnection != null) {
                Object object = this.lispconnection.callLisp("DEBUGGER::simple-eval-expression", new Object[]{command}, true);
                if (object instanceof String) {
                    return (String)object + "\n";
                }
                return "\n";
            }
            return "\n";
        }
        catch (IOException e) {
            this.cleanupAftererror("Error sending watch command to lisp system", e);
            return "\n";
        }
    }

    public void setWatchPoint(WatchNode node, String watchExp) {
        if (this.lispconnection != null) {
            this.asyncCallLisp("DEBUGGER::register-watch-expression", new Object[]{node, watchExp});
        }
    }

    public void changeWatchPoint(WatchNode node, String watchExp) {
        if (this.lispconnection != null) {
            this.asyncCallLisp("DEBUGGER::change-watch-expression", new Object[]{node, watchExp});
        }
    }

    public void removeWatchPoint(WatchNode node) {
        if (this.lispconnection != null) {
            this.asyncCallLisp("DEBUGGER::unregister-watch-expression", new Object[]{node});
        }
    }

    public void setCurrentDirectory(String directory) {
        if (this.lispconnection != null) {
            this.asyncCallLisp("(setf (default-directory) \"" + directory + "\")");
        }
    }

    public LinkedList watchExpression(String expression) {
        try {
            if (this.lispconnection != null) {
                Object object = this.lispconnection.callLisp("DEBUGGER::eval-expression", new Object[]{expression}, true);
                if (object instanceof LinkedList) {
                    return (LinkedList)object;
                }
                return null;
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public String receiveErrorAndOutput() {
        StringBuffer error = new StringBuffer();
        StringBuffer output = new StringBuffer();
        try {
            while (true) {
                if (this.stoplisten) {
                    return "";
                }
                if (this.lisperror.available() == 0 && this.lispoutput.available() == 0) {
                    if (error.length() > 0 || output.length() > 0) {
                        return error.toString() + output.toString();
                    }
                    Thread.sleep(50L);
                } else if (this.lisperror.available() > 0) {
                    error.append((char)this.lisperror.read());
                } else if (this.lispoutput.available() > 0) {
                    output.append((char)this.lispoutput.read());
                }
                System.out.println(error.toString() + output.toString());
            }
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (IOException e) {
            this.cleanupAftererror("IO Error during read from lispprocess ", e);
            return null;
        }
    }

    public void stopProcess() {
        try {
            if (this.lispconnection != null) {
                Iterator iter = this.editorToDebuggedEditor.values().iterator();
                while (iter.hasNext()) {
                    CodeEditor editor = ((DebuggedEditor)iter.next()).editor;
                    this.disableDebugging(editor);
                    editor.setMode(Mode.getMode("basic"));
                    editor.highlighter.removeHighLight("40breakpoint");
                    editor.highlighter.removeHighLight("50nextstop");
                    editor.highlighter.removeHighLight("70executedcode");
                }
                this.asyncCallLisp("(USER::quit)");
                Thread.sleep(1000L);
                this.lispconnection.cleanup();
                this.lispinput.close();
                this.lisperror.close();
                this.lispoutput.close();
                this.stoplisten = true;
                Thread.sleep(1000L);
                this.process.destroy();
                this.process.waitFor();
                this.lispconnection = null;
                interactions.remove(this);
            }
        }
        catch (Exception e) {
            this.cleanupAftererror("Error stopping lisp proces because " + e.getMessage(), e);
        }
    }

    private static synchronized int getPortNr() {
        int newportnr;
        if ((newportnr = LispConnection.getFreeSocketPort(portnr += 2, portnr + 100)) >= 0) {
            portnr = newportnr;
            return portnr;
        }
        MessageHandler.warn("Error getting new server socket port in the range " + portnr + "-" + (portnr + 100));
        return -1;
    }

    public void startProcess() {
        final int portnr = LispInteraction.getPortNr();
        if (portnr < 0) {
            return;
        }
        final Runnable setWatchResult = new Runnable(){

            public void run() {
                Main.getWatches().addWatchPoint("Result(" + LispInteraction.this.getName() + ")", "DEBUGGER::**values**", LispInteraction.this);
            }
        };
        Thread createlispconnection = new Thread(new Runnable(){

            public void run() {
                try {
                    Object result;
                    LispInteraction.this.lispconnection = new LispConnection(portnr, portnr + 1);
                    MessageHandler.say("Socket connection to lisp process established");
                    LispInteraction.this.lispconnection.callLisp("DEBUGGER::set-interaction", new Object[]{LispInteraction.this}, true);
                    MessageHandler.say("Creating interaction object finished");
                    LispInteraction.this.setCurrentDirectory(Interactions.currentDirectory);
                    if (OsSystem.processManagmentIsPossible() && (result = LispInteraction.this.lispconnection.callLisp("(DEBUGGER::get-process-id)", true)) instanceof Long) {
                        LispInteraction.this.processid = ((Long)result).intValue();
                    }
                    SwingUtilities.invokeLater(setWatchResult);
                }
                catch (Exception e) {
                    LispInteraction.this.cleanupAftererror("Failed to establish socket connection to lisp process", e);
                }
            }
        });
        try {
            this.process = Runtime.getRuntime().exec(new String[]{this.startcommand}, null, new File(Configuration.installDirectory));
            this.lispoutput = this.process.getInputStream();
            this.lisperror = this.process.getErrorStream();
            this.lispinput = new OutputStreamWriter(this.process.getOutputStream());
            this.lispinput.write(this.lispcommand + "\n");
            this.lispinput.flush();
            createlispconnection.start();
            this.sendCommand("(DEBUGGER::enter-debug " + String.valueOf(portnr) + " " + String.valueOf(portnr + 1) + ")");
            if (Configuration.lispStartupFile.length() > 0 && new File(Configuration.lispStartupFile).exists()) {
                this.sendCommand("(load \"" + Configuration.lispStartupFile + "\")");
            }
        }
        catch (IOException e) {
            this.cleanupAftererror("Could not run the command <" + this.startcommand + ">", e);
        }
        catch (Exception e) {
            this.cleanupAftererror("Lisp startup interrupted", e);
        }
    }

    public boolean enableDebugging(CodeEditor editor) {
        if (editor.getCodePane() instanceof AbstractInteractionPane) {
            return false;
        }
        if (this.lispconnection == null) {
            return false;
        }
        try {
            File temp1 = File.createTempFile("debug", ".lisp");
            File temp2 = File.createTempFile("instrument", ".lisp");
            editor.getDocument().saveTemporyFile(temp1);
            String path1 = Util.getCanonicalFileName(temp1);
            String path2 = Util.getCanonicalFileName(temp2);
            if (Configuration.instrumentCheckError) {
                this.lispconnection.callLisp("(setf DEBUGGER::**check-error** T)", true);
            } else {
                this.lispconnection.callLisp("(setf DEBUGGER::**check-error** NIL)", true);
            }
            if (Configuration.instrumentDebugAfter) {
                this.lispconnection.callLisp("(setf DEBUGGER::**debug-after** T)", true);
            } else {
                this.lispconnection.callLisp("(setf DEBUGGER::**debug-after** NIL)", true);
            }
            if (((Boolean)this.lispconnection.callLisp("DEBUGGER::debug-open-file", new Object[]{path1, path2, editor}, true)).booleanValue()) {
                DebuggedEditor debuggededitor = new DebuggedEditor(editor, temp1);
                this.editorToDebuggedEditor.put(editor, debuggededitor);
                editor.getDocument().setReadOnly(true);
                return true;
            }
            MessageHandler.warn("Failed to enable debugging for this editor");
            return false;
        }
        catch (IOException e) {
            MessageHandler.report("Failed to create temp or debug file", e);
            return false;
        }
    }

    public void disableDebugging(CodeEditor editor) {
        try {
            editor.getDocument().setReadOnly(false);
            DebuggedEditor debuggededitor = (DebuggedEditor)this.editorToDebuggedEditor.get(editor);
            if (debuggededitor != null) {
                debuggededitor.stopProfiling();
                String path = Util.getCanonicalFileName(debuggededitor.savedDocument);
                if (this.lispconnection != null) {
                    this.lispconnection.callLisp("DEBUGGER::undebug", new Object[]{path, editor}, true);
                }
                this.editorToDebuggedEditor.remove(editor);
            }
        }
        catch (IOException e) {
            MessageHandler.report("Failed to disable debugging", e);
        }
    }

    public void toggleBreakpoint(final CodeEditor editor) {
        DebuggedEditor dEditor = (DebuggedEditor)this.editorToDebuggedEditor.get(editor);
        if (dEditor == null) {
            return;
        }
        Parser parser = editor.getDocument().getParser();
        final Region region = parser.findHooks(editor.cursor.cursorOffset());
        if (region == null) {
            return;
        }
        ++region.end;
        final Runnable addHighLight = new Runnable(){

            public void run() {
                editor.highlighter.addHighLightRegion("40breakpoint", Configuration.colorBreakpoint, region.begin, region.end - region.begin, true);
            }
        };
        final Runnable removeHighLight = new Runnable(){

            public void run() {
                editor.highlighter.removeHighLightRegion("40breakpoint", region.begin, region.end - region.begin, true);
            }
        };
        Thread setBreakPoint = new Thread(new Runnable(){

            public void run() {
                if (LispInteraction.this.lispconnection != null) {
                    try {
                        Object result = LispInteraction.this.lispconnection.callLisp("DEBUGGER::toggle-breakpoint", new Object[]{editor, new Integer(region.begin + 1), new Integer(region.end + 1)}, true);
                        if (result instanceof Long) {
                            switch (((Long)result).intValue()) {
                                case 1: {
                                    SwingUtilities.invokeLater(addHighLight);
                                    break;
                                }
                                case 0: {
                                    MessageHandler.warn("No valid breakpoint");
                                    break;
                                }
                                case -1: {
                                    SwingUtilities.invokeLater(removeHighLight);
                                }
                            }
                        } else {
                            MessageHandler.warn("Failed to set/unset breakpoint because of wong type returned");
                        }
                    }
                    catch (Exception e) {
                        LispInteraction.this.cleanupAftererror("Error setting/unsetting breakpoint ,error " + e.getMessage(), e);
                    }
                }
            }
        });
        setBreakPoint.run();
    }

    public void toggleConditionalBreakpoint(final CodeEditor editor) {
        DebuggedEditor dEditor = (DebuggedEditor)this.editorToDebuggedEditor.get(editor);
        if (dEditor == null) {
            return;
        }
        Parser parser = editor.getDocument().getParser();
        final Region region = parser.findHooks(editor.cursor.cursorOffset());
        if (region == null) {
            return;
        }
        ++region.end;
        final Runnable addHighLight = new Runnable(){

            public void run() {
                editor.highlighter.addHighLightRegion("40breakpoint", Configuration.colorBreakpoint, region.begin, region.end - region.begin, true);
            }
        };
        final Runnable removeHighLight = new Runnable(){

            public void run() {
                editor.highlighter.removeHighLightRegion("40breakpoint", region.begin, region.end - region.begin, true);
            }
        };
        final Runnable createBreakPoint = new Runnable(){

            public void run() {
                String condition = CodeDialogBox.showDialog("Condition breakpoint", new LispParser(true), "");
                Thread setBreakPoint = new Thread(new Runnable(this, condition){
                    private final /* synthetic */ String val$condition;
                    private final /* synthetic */ 9 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$condition = val$condition;
                    }

                    public void run() {
                        if (9.access$600(this.this$1).lispconnection != null) {
                            try {
                                Object result = 9.access$600(this.this$1).lispconnection.callLisp("DEBUGGER::toggle-breakpoint", new Object[]{9.access$700(this.this$1), new Integer(9.access$800(this.this$1).begin + 1), new Integer(9.access$800(this.this$1).end + 1), this.val$condition}, true);
                                if (result instanceof Long) {
                                    switch (((Long)result).intValue()) {
                                        case 1: {
                                            SwingUtilities.invokeLater(9.access$900(this.this$1));
                                            break;
                                        }
                                        case 0: {
                                            MessageHandler.warn("No valid breakpoint");
                                            break;
                                        }
                                        case -1: {
                                            SwingUtilities.invokeLater(9.access$1000(this.this$1));
                                        }
                                    }
                                } else {
                                    MessageHandler.warn("Failed to set/unset breakpoint because of wong type returned");
                                }
                            }
                            catch (Exception e) {
                                LispInteraction.access$100(9.access$600(this.this$1), "Error setting/unsetting breakpoint ,error " + e.getMessage(), e);
                            }
                        }
                    }
                });
                if (condition != null) {
                    setBreakPoint.run();
                }
            }

            static /* synthetic */ LispInteraction access$600(9 x0) {
                return x0.LispInteraction.this;
            }

            static /* synthetic */ CodeEditor access$700(9 x0) {
                return x0.editor;
            }

            static /* synthetic */ Region access$800(9 x0) {
                return x0.region;
            }

            static /* synthetic */ Runnable access$900(9 x0) {
                return x0.addHighLight;
            }

            static /* synthetic */ Runnable access$1000(9 x0) {
                return x0.removeHighLight;
            }
        };
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    Object result;
                    if (LispInteraction.this.lispconnection != null && (result = LispInteraction.this.lispconnection.callLisp("DEBUGGER::is-breakpoint", new Object[]{editor, new Integer(region.begin + 1), new Integer(region.end + 1)}, true)) instanceof Boolean && ((Boolean)result).booleanValue()) {
                        SwingUtilities.invokeLater(createBreakPoint);
                    }
                }
                catch (IOException e) {
                    LispInteraction.this.cleanupAftererror("Error verifying breakpoint", e);
                }
            }
        });
        thread.start();
    }

    public void stepInto(CodeEditor editor) {
        DebuggedEditor dEditor = (DebuggedEditor)this.editorToDebuggedEditor.get(editor);
        if (dEditor == null) {
            return;
        }
        editor.highlighter.removeHighLight("50nextstop");
        editor.highlighter.removeHighLight("70executedcode");
        dEditor.currentBreakpoint = null;
        this.asyncCallLisp("DEBUGGER::step-into-action", new Object[]{editor});
    }

    public void stepOver(CodeEditor editor) {
        DebuggedEditor dEditor = (DebuggedEditor)this.editorToDebuggedEditor.get(editor);
        if (dEditor == null) {
            return;
        }
        editor.highlighter.removeHighLight("50nextstop");
        editor.highlighter.removeHighLight("70executedcode");
        if (dEditor.currentBreakpoint != null) {
            Parser parser = editor.getDocument().getParser();
            Region toplist = null;
            Region region = parser.findHooks(dEditor.currentBreakpoint.end + 1);
            while (region != null) {
                toplist = region;
                region = parser.findHooks(region.end + 1);
            }
            if (toplist != null) {
                this.asyncCallLisp("DEBUGGER::step-over-action", new Object[]{editor, new Integer(toplist.begin + 1), new Integer(toplist.end + 1)});
            } else {
                this.asyncCallLisp("DEBUGGER::step-over-action", new Object[]{editor});
            }
        } else {
            this.asyncCallLisp("(DEBUGGER::end-debug-eventloop)");
        }
        dEditor.currentBreakpoint = null;
    }

    public void goToFuture(CodeEditor editor) {
        this.asyncCallLisp("(DEBUGGER::step-forward-in-time)");
    }

    public void goToPast(CodeEditor editor) {
        this.asyncCallLisp("(DEBUGGER::step-back-in-time)");
    }

    public void stopAfter(CodeEditor editor) {
        DebuggedEditor dEditor = (DebuggedEditor)this.editorToDebuggedEditor.get(editor);
        if (dEditor == null) {
            return;
        }
        editor.highlighter.removeHighLight("50nextstop");
        editor.highlighter.removeHighLight("70executedcode");
        this.asyncCallLisp("DEBUGGER::stop-after-action", new Object[]{editor});
    }

    public void setNewReturnValue(CodeEditor editor) {
        String returnexp;
        DebuggedEditor debuggededitor = (DebuggedEditor)this.editorToDebuggedEditor.get(editor);
        if (debuggededitor != null && (returnexp = CodeDialogBox.showDialog("Expression to be returned", new LispParser(true))) != null && this.lispconnection != null) {
            this.asyncCallLisp("DEBUGGER::change-result", new Object[]{returnexp});
        }
    }

    public void stopAt(CodeEditor editor) {
        DebuggedEditor dEditor = (DebuggedEditor)this.editorToDebuggedEditor.get(editor);
        if (dEditor == null) {
            return;
        }
        editor.highlighter.removeHighLight("50nextstop");
        editor.highlighter.removeHighLight("70executedcode");
        Region region = editor.getDocument().getParser().findHooks(editor.cursor.cursorOffset());
        if (region != null) {
            this.asyncCallLisp("DEBUGGER::stop-at-action", new Object[]{editor, new Integer(region.begin + 1), new Integer(region.end + 2)});
            editor.highlighter.addHighLightRegion("50nextstop", Configuration.colorNextStop, region.begin, region.end - region.begin, true);
        } else {
            this.asyncCallLisp("DEBUGGER::stop-at-action", new Object[]{editor});
        }
        dEditor.currentBreakpoint = null;
    }

    public void continueExecution(CodeEditor editor) {
        DebuggedEditor dEditor = (DebuggedEditor)this.editorToDebuggedEditor.get(editor);
        if (dEditor == null) {
            return;
        }
        editor.highlighter.removeHighLight("50nextstop");
        editor.highlighter.removeHighLight("70executedcode");
        this.asyncCallLisp("DEBUGGER::continue-execution-action", new Object[]{editor});
    }

    public void displayNewTime(final CodeEditor editor, Long begin, Long end) {
        DebuggedEditor debuggededitor = (DebuggedEditor)this.editorToDebuggedEditor.get(editor);
        final int b = begin.intValue();
        final int e = end.intValue();
        Runnable showExecutedCode = new Runnable(){

            public void run() {
                editor.cursor.setCursor(b);
                editor.highlighter.removeHighLight("70executedcode");
                editor.highlighter.removeHighLight("50nextstop");
                editor.highlighter.addHighLightRegion("70executedcode", Configuration.colorExecutingCode, b, e - b, true);
                WorkArea.selectWorkPaneContainingEditor(editor);
            }
        };
        if (debuggededitor != null) {
            SwingUtilities.invokeLater(showExecutedCode);
        }
    }

    public void giveControlToInterfaceAfter(final CodeEditor editor, Long begin, Long end) {
        DebuggedEditor dEditor = (DebuggedEditor)this.editorToDebuggedEditor.get(editor);
        final int b = begin.intValue();
        final int e = end.intValue();
        Runnable showExecutedCode = new Runnable(){

            public void run() {
                CodeEditor current = Main.currentEditor();
                editor.cursor.setCursor(b);
                if (current != null) {
                    Main.setCurrent(current);
                }
                editor.highlighter.removeHighLight("70executedcode");
                editor.highlighter.removeHighLight("50nextstop");
                editor.highlighter.addHighLightRegion("70executedcode", Configuration.colorExecutedCode, b, e - b, true);
                WorkArea.selectWorkPaneContainingEditor(editor);
            }
        };
        if (dEditor != null) {
            dEditor.currentBreakpoint = new Breakpoint(b, e);
            SwingUtilities.invokeLater(showExecutedCode);
        }
    }

    public boolean giveControlToInterface(final CodeEditor editor, Long begin, Long end) {
        DebuggedEditor dEditor = (DebuggedEditor)this.editorToDebuggedEditor.get(editor);
        final int b = begin.intValue();
        final int e = end.intValue();
        Runnable showExecutingCode = new Runnable(){

            public void run() {
                CodeEditor current = Main.currentEditor();
                editor.cursor.setCursor(b);
                if (current != null) {
                    Main.setCurrent(current);
                }
                editor.highlighter.removeHighLight("70executedcode");
                editor.highlighter.removeHighLight("50nextstop");
                editor.highlighter.addHighLightRegion("70executedcode", Configuration.colorExecutingCode, b, e - b, true);
                WorkArea.selectWorkPaneContainingEditor(editor);
            }
        };
        if (dEditor == null) {
            return true;
        }
        dEditor.currentBreakpoint = new Breakpoint(b, e);
        SwingUtilities.invokeLater(showExecutingCode);
        return false;
    }

    public void compileEditor(final CodeEditor editor) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    File file = File.createTempFile("debuggerload", ".lisp");
                    editor.getDocument().saveTemporyFile(file);
                    Object result = LispInteraction.this.lispconnection.callLisp("DEBUGGER::checked-compile-file", new Object[]{Util.getCanonicalFileName(file)}, false);
                    if (result instanceof Boolean) {
                        if (((Boolean)result).booleanValue()) {
                            MessageHandler.say("Content compiled");
                        } else {
                            MessageHandler.warn("Failed to compile content loaded");
                        }
                    }
                    file.delete();
                }
                catch (IOException e) {
                    MessageHandler.warn("Failed to create tempory file");
                }
            }
        });
        if (this.lispconnection != null) {
            thread.run();
        }
    }

    public void loadEditor(final CodeEditor editor) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    File file = File.createTempFile("debuggerload", "lisp");
                    editor.getDocument().saveTemporyFile(file);
                    Object result = LispInteraction.this.lispconnection.callLisp("DEBUGGER::checked-load-file", new Object[]{Util.getCanonicalFileName(file)}, false);
                    if (result instanceof Long) {
                        int pos = ((Long)result).intValue();
                        if (pos > 0) {
                            Runnable position = new Runnable(this, pos){
                                private final /* synthetic */ int val$pos;
                                private final /* synthetic */ 16 this$1;
                                {
                                    this.this$1 = this$1;
                                    this.val$pos = val$pos;
                                }

                                public void run() {
                                    16.access$1400(this.this$1).cursor.setCursor(this.val$pos - 1);
                                }
                            };
                            SwingUtilities.invokeLater(position);
                        } else {
                            MessageHandler.say("Content loaded");
                        }
                    }
                    file.delete();
                }
                catch (IOException e) {
                    MessageHandler.warn("Failed to create tempory file");
                }
            }

            static /* synthetic */ CodeEditor access$1400(16 x0) {
                return x0.editor;
            }
        });
        if (this.lispconnection != null) {
            thread.run();
        }
    }

    public String getValueLeaf(CodeEditor editor, int pos) {
        CodeLeafElement leaf = editor.getDocument().getLeafAt(pos);
        if (leaf == null) {
            return null;
        }
        if (leaf instanceof CodeLeafSeparator) {
            return null;
        }
        try {
            if (this.lispconnection != null) {
                Object object = this.lispconnection.callLisp("DEBUGGER::simple-eval-expression", new Object[]{leaf.getString(editor.getDocument())}, true);
                if (object instanceof String) {
                    return (String)object;
                }
                return null;
            }
            return null;
        }
        catch (IOException e) {
            this.cleanupAftererror("Error getting value of leaf", e);
            return null;
        }
    }

    public void setInteractionPane(InteractionPane interactionpane) {
        this.interactionpane = interactionpane;
    }

    private void cleanupAftererror(String error, Exception e) {
        MessageHandler.report(error, e);
        Iterator iter = this.editorToDebuggedEditor.values().iterator();
        while (iter.hasNext()) {
            CodeEditor editor = ((DebuggedEditor)iter.next()).editor;
            this.disableDebugging(editor);
            editor.setMode(Mode.getMode("basic"));
            editor.highlighter.removeHighLight("40breakpoint");
            editor.highlighter.removeHighLight("50nextstop");
            editor.highlighter.removeHighLight("70executedcode");
        }
        this.lispconnection = null;
        if (this.interactionpane != null) {
            this.interactionpane.cleanup();
        }
    }

    public ImageIcon getTypeIcon(int type) {
        return icons[type];
    }

    public String getCompiledExtension() {
        return "";
    }

    public String getTypeString(int type) {
        return types[type];
    }

    public String getName() {
        return "LISP";
    }

    protected void asyncCallLisp(final String function, final Object[] args) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    if (LispInteraction.this.lispconnection != null) {
                        LispInteraction.this.lispconnection.callLisp(function, args, true);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        thread.start();
    }

    protected void asyncCallLisp(final String command) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    if (LispInteraction.this.lispconnection != null) {
                        LispInteraction.this.lispconnection.callLisp(command, true);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        thread.start();
    }

    public void startProfiling(CodeEditor editor) {
        DebuggedEditor debuggededitor = (DebuggedEditor)this.editorToDebuggedEditor.get(editor);
        if (debuggededitor != null) {
            debuggededitor.startProfiling();
        }
    }

    public void stopProfiling(CodeEditor editor) {
        DebuggedEditor debuggededitor = (DebuggedEditor)this.editorToDebuggedEditor.get(editor);
        if (debuggededitor != null) {
            debuggededitor.stopProfiling();
        }
    }

    public void signalProcess(String signal) {
        if (OsSystem.processManagmentIsPossible() && this.processid > 0) {
            Runtime runtime = Runtime.getRuntime();
            try {
                runtime.exec(new String[]{"kill", signal, Integer.toString(this.processid)});
            }
            catch (IOException e) {
                MessageHandler.warn("Failed to signal process");
            }
        } else {
            this.asyncCallLisp("(break)");
        }
    }

    private class DebuggedEditor {
        private JSlider slider = null;
        private JPanel sliderPanel = null;
        private boolean profiling = false;
        private HashMap callCount;
        private CodeEditor editor;
        private boolean stepInto = false;
        private Breakpoint currentBreakpoint = null;
        private File savedDocument;

        private DebuggedEditor(CodeEditor editor, File savedDocument) {
            this.editor = editor;
            this.savedDocument = savedDocument;
            this.callCount = new HashMap();
        }

        private synchronized void startProfiling() {
            Runnable createSliderPanel = new Runnable(this){
                private final /* synthetic */ DebuggedEditor this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    if (DebuggedEditor.access$1600(this.this$1) == null) {
                        DebuggedEditor.access$1602(this.this$1, new JPanel());
                        DebuggedEditor.access$1600(this.this$1).setLayout(new FlowLayout());
                        DebuggedEditor.access$1600(this.this$1).addAncestorListener(new AncestorListener(this){
                            private final /* synthetic */ 20 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            public void ancestorAdded(AncestorEvent e) {
                                DebuggedEditor.access$1900(20.access$1700(this.this$2), DebuggedEditor.access$1800(20.access$1700(this.this$2)).getValue());
                            }

                            public void ancestorMoved(AncestorEvent e) {
                            }

                            public void ancestorRemoved(AncestorEvent e) {
                            }
                        });
                        JButton update = new JButton(new AbstractAction(this){
                            private final /* synthetic */ 20 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            public void actionPerformed(ActionEvent e) {
                                DebuggedEditor.access$1900(20.access$1700(this.this$2), DebuggedEditor.access$1800(20.access$1700(this.this$2)).getValue());
                            }
                        });
                        update.setText("");
                        update.setBorder(BorderFactory.createEtchedBorder());
                        update.setToolTipText("Update the call count");
                        update.setIcon(Configuration.getIcon("refreshCallCount.png"));
                        JButton up = new JButton(new AbstractAction(this){
                            private final /* synthetic */ 20 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            public void actionPerformed(ActionEvent e) {
                                DebuggedEditor.access$1800(20.access$1700(this.this$2)).setValue(Math.min(DebuggedEditor.access$1800(20.access$1700(this.this$2)).getMaximum(), DebuggedEditor.access$1800(20.access$1700(this.this$2)).getValue() + 1));
                            }
                        });
                        up.setText("");
                        up.setBorder(BorderFactory.createEtchedBorder());
                        up.setToolTipText("Increase the display threshold");
                        up.setIcon(Configuration.getIcon("increaseThreshold.png"));
                        JButton down = new JButton(new AbstractAction(this){
                            private final /* synthetic */ 20 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            public void actionPerformed(ActionEvent e) {
                                DebuggedEditor.access$1800(20.access$1700(this.this$2)).setValue(Math.max(1, DebuggedEditor.access$1800(20.access$1700(this.this$2)).getValue() - 1));
                            }
                        });
                        down.setText("");
                        down.setBorder(BorderFactory.createEtchedBorder());
                        down.setToolTipText("Decrease the display threshold");
                        down.setIcon(Configuration.getIcon("decreaseThreshold.png"));
                        JTextField valueField = new JTextField("1");
                        DebuggedEditor.access$1802(this.this$1, new JSlider(0));
                        DebuggedEditor.access$1800(this.this$1).setMinimum(1);
                        DebuggedEditor.access$1800(this.this$1).setMaximum(2);
                        DebuggedEditor.access$1800(this.this$1).setValue(1);
                        DebuggedEditor.access$1800(this.this$1).setMinorTickSpacing(1);
                        DebuggedEditor.access$1800(this.this$1).setMajorTickSpacing(10);
                        DebuggedEditor.access$1800(this.this$1).setPaintTicks(true);
                        DebuggedEditor.access$1800(this.this$1).setSnapToTicks(true);
                        DebuggedEditor.access$1800(this.this$1).addChangeListener(new ChangeListener(this, valueField){
                            private final /* synthetic */ JTextField val$valueField;
                            private final /* synthetic */ 20 this$2;
                            {
                                this.this$2 = this$2;
                                this.val$valueField = val$valueField;
                            }

                            public void stateChanged(ChangeEvent ev) {
                                DebuggedEditor.access$2000(20.access$1700(this.this$2), DebuggedEditor.access$1800(20.access$1700(this.this$2)).getValue());
                                this.val$valueField.setText(Integer.toString(DebuggedEditor.access$1800(20.access$1700(this.this$2)).getValue()));
                                this.val$valueField.setSize(this.val$valueField.getPreferredSize());
                                DebuggedEditor.access$1600(20.access$1700(this.this$2)).revalidate();
                            }
                        });
                        DebuggedEditor.access$1600(this.this$1).add(update);
                        DebuggedEditor.access$1600(this.this$1).add(down);
                        DebuggedEditor.access$1600(this.this$1).add(DebuggedEditor.access$1800(this.this$1));
                        DebuggedEditor.access$1600(this.this$1).add(up);
                        DebuggedEditor.access$1600(this.this$1).add(valueField);
                        DebuggedEditor.access$200(this.this$1).getMode().addMiscToMode("debug", DebuggedEditor.access$1600(this.this$1));
                    }
                }

                static /* synthetic */ DebuggedEditor access$1700(20 x0) {
                    return x0.this$1;
                }
            };
            Thread enableProfiling = new Thread(new Runnable(this, createSliderPanel){
                private final /* synthetic */ Runnable val$createSliderPanel;
                private final /* synthetic */ DebuggedEditor this$1;
                {
                    this.this$1 = this$1;
                    this.val$createSliderPanel = val$createSliderPanel;
                }

                public void run() {
                    try {
                        DebuggedEditor.access$2100((DebuggedEditor)this.this$1).lispconnection.callLisp("DEBUGGER::start-profiling", new Object[]{DebuggedEditor.access$200(this.this$1)}, true);
                        DebuggedEditor.access$2202(this.this$1, new HashMap<K, V>());
                        DebuggedEditor.access$2302(this.this$1, true);
                        SwingUtilities.invokeLater(this.val$createSliderPanel);
                    }
                    catch (IOException e) {
                        LispInteraction.access$100(DebuggedEditor.access$2100(this.this$1), "Error enabling profiling, error " + e.getMessage(), e);
                    }
                }
            });
            enableProfiling.start();
        }

        private synchronized void stopProfiling() {
            Runnable removeSlider = new Runnable(this){
                private final /* synthetic */ DebuggedEditor this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    if (DebuggedEditor.access$1600(this.this$1) != null) {
                        DebuggedEditor.access$200(this.this$1).getMode().removeComponentFromMode("debug", DebuggedEditor.access$1600(this.this$1));
                    }
                    DebuggedEditor.access$200((DebuggedEditor)this.this$1).highlighter.removeHighLight("65profiling");
                    DebuggedEditor.access$2302(this.this$1, false);
                    DebuggedEditor.access$1602(this.this$1, null);
                }
            };
            Thread disableProfiling = new Thread(new Runnable(this, removeSlider){
                private final /* synthetic */ Runnable val$removeSlider;
                private final /* synthetic */ DebuggedEditor this$1;
                {
                    this.this$1 = this$1;
                    this.val$removeSlider = val$removeSlider;
                }

                public void run() {
                    try {
                        SwingUtilities.invokeAndWait(this.val$removeSlider);
                        DebuggedEditor.access$2100((DebuggedEditor)this.this$1).lispconnection.callLisp("DEBUGGER::stop-profiling", new Object[]{DebuggedEditor.access$200(this.this$1)}, true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            disableProfiling.start();
        }

        private void highlightCalled(int count) {
            Runnable dowork = new Runnable(this, count){
                private final /* synthetic */ int val$count;
                private final /* synthetic */ DebuggedEditor this$1;
                {
                    this.this$1 = this$1;
                    this.val$count = val$count;
                }

                public void run() {
                    LeafVector leafs = DebuggedEditor.access$200(this.this$1).getDocument().getLeafs();
                    int m = leafs.size();
                    DebuggedEditor.access$200((DebuggedEditor)this.this$1).highlighter.removeHighLight("65profiling");
                    for (int i = 0; i < m; ++i) {
                        CodeLeafElement leaf = leafs.leafAt(i);
                        int cnt = DebuggedEditor.access$2400(this.this$1, leaf);
                        if (cnt < this.val$count) continue;
                        DebuggedEditor.access$200((DebuggedEditor)this.this$1).highlighter.addHighLightRegion("65profiling", Configuration.colorProfiling, leaf.begin(), leaf.end() - leaf.begin(), false);
                    }
                    DebuggedEditor.access$200(this.this$1).repaint();
                }
            };
            SwingUtilities.invokeLater(dowork);
        }

        private synchronized void updateCount(int threshold) {
            Thread getCount = new Thread(new Runnable(this, threshold){
                private final /* synthetic */ int val$threshold;
                private final /* synthetic */ DebuggedEditor this$1;
                {
                    this.this$1 = this$1;
                    this.val$threshold = val$threshold;
                }

                public void run() {
                    try {
                        Object result = DebuggedEditor.access$2100((DebuggedEditor)this.this$1).lispconnection.callLisp("DEBUGGER::get-call-count", new Object[]{DebuggedEditor.access$200(this.this$1)}, true);
                        if (result instanceof LinkedList) {
                            Iterator<E> iter = ((LinkedList)result).iterator();
                            DebuggedEditor.access$2200(this.this$1).clear();
                            while (iter.hasNext()) {
                                LinkedList countinfo = (LinkedList)iter.next();
                                int b = ((Long)countinfo.get(0)).intValue() - 1;
                                int count = ((Long)countinfo.get(2)).intValue();
                                CodeElement element = DebuggedEditor.access$200(this.this$1).getDocument().getElementAt(b);
                                if (element != null) {
                                    DebuggedEditor.access$2200(this.this$1).put(element, new Integer(count));
                                }
                                DebuggedEditor.access$1800(this.this$1).setMaximum(Math.max(DebuggedEditor.access$1800(this.this$1).getMaximum(), count));
                            }
                            DebuggedEditor.access$2000(this.this$1, this.val$threshold);
                        }
                    }
                    catch (IOException e) {
                        LispInteraction.access$100(DebuggedEditor.access$2100(this.this$1), "Error getting profile info from lisp, error " + e.getMessage(), e);
                    }
                }
            });
            getCount.start();
        }

        private int getCount(CodeLeafElement leaf) {
            CodeElement element;
            for (element = leaf.getParent(); element != null && !(element instanceof LispListElement); element = element.getParent()) {
            }
            Integer cnt = (Integer)this.callCount.get(element);
            if (cnt != null) {
                return cnt;
            }
            return -1;
        }

        static /* synthetic */ JPanel access$1600(DebuggedEditor x0) {
            return x0.sliderPanel;
        }

        static /* synthetic */ JPanel access$1602(DebuggedEditor x0, JPanel x1) {
            x0.sliderPanel = x1;
            return x0.sliderPanel;
        }

        static /* synthetic */ JSlider access$1800(DebuggedEditor x0) {
            return x0.slider;
        }

        static /* synthetic */ void access$1900(DebuggedEditor x0, int x1) {
            x0.updateCount(x1);
        }

        static /* synthetic */ JSlider access$1802(DebuggedEditor x0, JSlider x1) {
            x0.slider = x1;
            return x0.slider;
        }

        static /* synthetic */ void access$2000(DebuggedEditor x0, int x1) {
            x0.highlightCalled(x1);
        }

        static /* synthetic */ LispInteraction access$2100(DebuggedEditor x0) {
            return x0.LispInteraction.this;
        }

        static /* synthetic */ HashMap access$2202(DebuggedEditor x0, HashMap x1) {
            x0.callCount = x1;
            return x0.callCount;
        }

        static /* synthetic */ boolean access$2302(DebuggedEditor x0, boolean x1) {
            x0.profiling = x1;
            return x0.profiling;
        }

        static /* synthetic */ int access$2400(DebuggedEditor x0, CodeLeafElement x1) {
            return x0.getCount(x1);
        }

        static /* synthetic */ HashMap access$2200(DebuggedEditor x0) {
            return x0.callCount;
        }
    }

    private class Breakpoint {
        private int begin;
        private int end;
        private String condition;

        private Breakpoint(int begin, int end) {
            this.begin = begin;
            this.end = end;
        }

        private Breakpoint(int begin, int end, String condition) {
            this.begin = begin;
            this.end = end;
            this.condition = condition;
        }
    }
}

