/*
 * Decompiled with CFR 0.152.
 */
package IDE.Interaction;

import IDE.CodeEditor.CodeEditor;
import IDE.CodeEditor.CodePane;
import IDE.CodeEditor.Parser.Parser;
import IDE.Configuration.Configuration;
import IDE.Configuration.XMLConfigClass;
import IDE.Configuration.XMLConfigField;
import IDE.Configuration.XMLConfigMethod;
import IDE.Configuration.XMLConfigObject;
import IDE.IIDEAddin;
import IDE.Interaction.AbstractInteractionPane;
import IDE.Interaction.IInteraction;
import IDE.Interaction.InteractionPane;
import IDE.Interaction.WatchPane;
import IDE.Main;
import IDE.Utilities.Util;
import Install.OsSystem;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.Writer;
import java.util.Vector;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Interactions
extends JTabbedPane
implements ChangeListener,
MouseListener,
IIDEAddin {
    public static String currentDirectory = System.getProperty("user.dir");
    private static Interactions interactions;
    private static boolean interactionStopped;

    public Interactions(int position) {
        super(position);
        interactions = this;
        this.addChangeListener(this);
        this.addMouseListener(this);
        this.setFocusable(false);
    }

    public void selectInteraction(IInteraction interaction) {
        int m = this.getComponentCount();
        for (int i = 0; i < m; ++i) {
            InteractionPane interactionpane;
            if (!(this.getComponentAt(i) instanceof InteractionPane) || (interactionpane = (InteractionPane)this.getComponentAt(i)).getInteraction() != interaction) continue;
            this.setSelectedComponent(interactionpane);
        }
    }

    public static InteractionPane getSelectedInteraction() {
        Component selected = interactions.getSelectedComponent();
        if (selected instanceof InteractionPane) {
            return (InteractionPane)selected;
        }
        return null;
    }

    public static WatchPane getSelectedWatch() {
        Component selected = interactions.getSelectedComponent();
        if (selected instanceof WatchPane) {
            return (WatchPane)selected;
        }
        return null;
    }

    public static InteractionPane[] getInteractionPanes() {
        Vector<Component> temp = new Vector<Component>();
        int m = interactions.getComponentCount();
        for (int i = 0; i < m; ++i) {
            if (!(interactions.getComponentAt(i) instanceof InteractionPane)) continue;
            temp.addElement(interactions.getComponentAt(i));
        }
        InteractionPane[] result = new InteractionPane[temp.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (InteractionPane)temp.elementAt(i);
        }
        return result;
    }

    public static void setCurrentDirectory(File file) {
        InteractionPane[] panes = Interactions.getInteractionPanes();
        for (int i = 0; i < panes.length; ++i) {
            panes[i].getInteraction().setCurrentDirectory(Util.getCanonicalFileName(file));
        }
        currentDirectory = Util.getCanonicalFileName(file);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.setSelectedPaneCurrent();
    }

    private void setSelectedPaneCurrent() {
        AbstractInteractionPane pane = (AbstractInteractionPane)this.getSelectedComponent();
        if (pane != null) {
            Main.setCurrent(pane.getEditor());
        } else {
            Main.setCurrent(null);
        }
    }

    public static void cleanup() {
        InteractionPane[] interactionpanes = Interactions.getInteractionPanes();
        int m = interactionpanes.length;
        for (int i = 0; i < m; ++i) {
            Interactions.stopInteraction(interactionpanes[i].getInteraction());
        }
    }

    private static void stopInteraction(final IInteraction interaction) {
        interactionStopped = false;
        Thread stopInteraction = new Thread(new Runnable(){

            public void run() {
                interaction.stopProcess();
                interactionStopped = true;
            }
        });
        stopInteraction.start();
        try {
            for (int maxsleep = 0; maxsleep < Configuration.timeoutStopProcess && !interactionStopped; maxsleep += 50) {
                Thread.sleep(50L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void addInteraction(Parser parser, IInteraction interaction) {
        InteractionPane pane = new InteractionPane(parser, interaction);
        interactions.add(pane.getName(), pane);
    }

    public static void addWatch(int index) {
        InteractionPane pane = (InteractionPane)interactions.getComponentAt(index);
        interactions.add("Watch " + pane.getName(), new WatchPane(pane));
    }

    public void enumerateEditors(Vector editors) {
        int m = this.getComponentCount();
        for (int i = 0; i < m; ++i) {
            if (!(this.getComponentAt(i) instanceof AbstractInteractionPane)) continue;
            editors.add(((AbstractInteractionPane)this.getComponentAt(i)).getEditor());
        }
    }

    public void saveState(Writer writer) {
        XMLConfigMethod method;
        int i;
        XMLConfigClass cls = new XMLConfigClass(this.getClass().getName());
        int m = this.getTabCount();
        Vector<InteractionPane> savedinteractions = new Vector<InteractionPane>();
        XMLConfigField field = new XMLConfigField("currentDirectory", OsSystem.correctPathName(currentDirectory));
        cls.addField(field);
        for (i = 0; i < m; ++i) {
            if (!(this.getComponentAt(i) instanceof InteractionPane)) continue;
            InteractionPane ipane = (InteractionPane)this.getComponentAt(i);
            savedinteractions.add(ipane);
            XMLConfigObject parser = new XMLConfigObject(ipane.getEditor().getDocument().getParser().getClass().getName());
            parser.addArgument(true);
            XMLConfigObject interaction = new XMLConfigObject(ipane.getInteraction().getClass().getName());
            method = new XMLConfigMethod("addInteraction");
            method.addArgument(parser);
            method.addArgument(interaction);
            cls.addMethod(method);
        }
        for (i = 0; i < m; ++i) {
            if (!(this.getComponentAt(i) instanceof WatchPane)) continue;
            WatchPane wpane = (WatchPane)this.getComponentAt(i);
            int index = savedinteractions.indexOf(wpane.getInteractionPane());
            method = new XMLConfigMethod("addWatch");
            method.addArgument(index);
            cls.addMethod(method);
        }
        cls.serialize(writer);
        AbstractInteractionPane.saveState(writer);
    }

    public void repaintAll() {
        CodePane pane = (CodePane)this.getSelectedComponent();
        if (pane != null) {
            pane.revalidate();
            pane.refreshBackground();
            pane.initAndRepaintVisible();
        }
    }

    public boolean isCurrent() {
        CodeEditor editor = Main.currentEditor();
        int m = this.getComponentCount();
        for (int i = 0; i < m; ++i) {
            if (((CodePane)this.getComponentAt(i)).getEditor() != editor) continue;
            return true;
        }
        return false;
    }

    public void next() {
        int index = this.getSelectedIndex();
        if (index >= 0) {
            if (++index >= this.getComponentCount()) {
                index = 0;
            }
            if (index < this.getComponentCount()) {
                this.setSelectedIndex(index);
            }
        }
    }

    public static void selectInteractionPaneContainingEditor(CodeEditor editor) {
        int m = interactions.getComponentCount();
        for (int i = 0; i < m; ++i) {
            if (((CodePane)interactions.getComponentAt(i)).getEditor() != editor) continue;
            interactions.removeChangeListener(interactions);
            interactions.setSelectedIndex(i);
            interactions.addChangeListener(interactions);
            break;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.setSelectedPaneCurrent();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

