/*
 * Decompiled with CFR 0.152.
 */
package IDE.Interaction;

import IDE.CodeEditor.CodeDocument;
import IDE.CodeEditor.CodeEditor;
import IDE.CodeEditor.Parser.Parser;
import IDE.Configuration.Configuration;
import IDE.Configuration.Mode;
import IDE.Interaction.AbstractInteractionPane;
import IDE.Interaction.DebugCodePane;
import IDE.Interaction.IInteraction;
import IDE.Interaction.WatchPane;
import IDE.Main;
import IDE.Messaging.MessageHandler;
import IDE.WorkArea.WorkArea;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class InteractionPane
extends AbstractInteractionPane {
    private boolean stopreading = false;
    private Vector watchpanes = new Vector();
    private Thread outputThread;

    public InteractionPane(Parser interactionparser, IInteraction interaction) {
        super(interactionparser);
        this.interaction = interaction;
        this.interaction.setInteractionPane(this);
        Runnable listenForOutput = new Runnable(){

            public void run() {
                InteractionPane.this.listenOutput();
            }
        };
        this.outputThread = new Thread(listenForOutput);
        this.outputThread.setPriority(1);
        this.outputThread.start();
    }

    public WatchPane createWatchPane() {
        return new WatchPane(this);
    }

    public void removeWatchPane(WatchPane watch) {
        this.watchpanes.remove(watch);
    }

    protected void addWatchPane(WatchPane watchpane) {
        this.watchpanes.add(watchpane);
    }

    public IInteraction getInteraction() {
        return this.interaction;
    }

    public String getName() {
        return this.interaction.getName();
    }

    private void listenOutput() {
        this.interaction.startProcess();
        try {
            while (true) {
                if (this.stopreading) {
                    return;
                }
                if (this.interaction == null) {
                    return;
                }
                String output = this.interaction.receiveErrorAndOutput();
                if (output != null) {
                    if (output.length() <= 0) continue;
                    this.outputString(output);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            MessageHandler.report("Error dring start of the process " + e.getMessage(), e);
        }
        this.cleanup();
    }

    private void outputString(final String output) {
        Runnable dowork = new Runnable(){

            public void run() {
                InteractionPane.this.getEditor().insertStringAt(output, Math.max(0, InteractionPane.this.getEditor().getDocument().length() - 1), false);
                InteractionPane.this.moveToEnd();
            }
        };
        SwingUtilities.invokeLater(dowork);
    }

    public boolean processEnter() {
        Parser parser = this.getEditor().getDocument().getParser();
        CodeDocument document = this.getEditor().getDocument();
        String command = this.findLastCommand();
        if (command == null || command.length() == 1 && command.charAt(0) == '\n') {
            this.getEditor().insertCharacter('\n', 0);
            this.moveCursorToEnd();
            return true;
        }
        if (command != null) {
            if (Configuration.clispBug) {
                command = this.removeLeadingWhiteSpaces(command);
            }
            if (command.length() > 0) {
                InteractionPane.addCommandToHistory(command);
                this.interaction.sendCommand(command);
                this.moveToEnd();
                return true;
            }
            return false;
        }
        return false;
    }

    private String removeLeadingWhiteSpaces(String command) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        for (i = 0; i < command.length() && (command.charAt(i) == '\n' || command.charAt(i) == ' ' || command.charAt(i) == '\t' || command.charAt(i) == '\r'); ++i) {
        }
        while (i < command.length()) {
            buffer.append(command.charAt(i));
            ++i;
        }
        return buffer.toString();
    }

    public void enableDebugging(final CodeEditor editor) {
        final Runnable updatedocument = new Runnable(){

            public void run() {
                editor.setInteraction(InteractionPane.this.interaction);
                editor.setMode(Mode.getMode("debug"));
            }
        };
        Thread thread = new Thread(new Runnable(){

            public void run() {
                if (InteractionPane.this.interaction.enableDebugging(editor)) {
                    SwingUtilities.invokeLater(updatedocument);
                }
            }
        });
        thread.start();
    }

    public void enableDebugging(String code) {
        Parser parser = this.getEditor().getDocument().getParser().cloneParser(true);
        final DebugCodePane pane = new DebugCodePane(parser, code);
        final Runnable updatedocument = new Runnable(){

            public void run() {
                CodeEditor editor = pane.getEditor();
                editor.setInteraction(InteractionPane.this.interaction);
                editor.getDocument().setModified(false);
                editor.setMode(Mode.getMode("debug"));
                if (!Configuration.instrumentDebugAfter && !Configuration.instrumentCheckError) {
                    Mode.getAction("stopafter").setEnabled(false);
                    Mode.getAction("setnewreturnvalue").setEnabled(false);
                } else {
                    Mode.getAction("stopafter").setEnabled(true);
                    Mode.getAction("setnewreturnvalue").setEnabled(true);
                }
                WorkArea.addPane(pane);
            }
        };
        Thread thread = new Thread(new Runnable(){

            public void run() {
                if (InteractionPane.this.interaction.enableDebugging(pane.getEditor())) {
                    SwingUtilities.invokeLater(updatedocument);
                }
            }
        });
        thread.start();
    }

    public void disableDebugging(final CodeEditor editor) {
        final Runnable updatedocument = new Runnable(){

            public void run() {
                if (editor.getCodePane() instanceof DebugCodePane) {
                    WorkArea.removeWorkPaneContaining(editor);
                    editor.cleanup();
                } else {
                    editor.setInteraction(null);
                    editor.setMode(Mode.getMode("basic"));
                }
            }
        };
        final Runnable removeHighLight = new Runnable(){

            public void run() {
                editor.highlighter.removeHighLight("40breakpoint");
                editor.highlighter.removeHighLight("50nextstop");
                editor.highlighter.removeHighLight("70executedcode");
            }
        };
        Thread thread = new Thread(new Runnable(){

            public void run() {
                SwingUtilities.invokeLater(removeHighLight);
                InteractionPane.this.interaction.disableDebugging(editor);
                SwingUtilities.invokeLater(updatedocument);
            }
        });
        thread.start();
    }

    public void cleanup() {
        final IInteraction saveinteraction = this.interaction;
        final Runnable cleanupPane = new Runnable(){

            public void run() {
                Main.getWatches().removeWatchPointsForInteraction(saveinteraction);
                for (int i = 0; i < InteractionPane.this.watchpanes.size(); ++i) {
                    Main.getInteractions().remove((WatchPane)InteractionPane.this.watchpanes.elementAt(i));
                }
                InteractionPane.this.stopreading = true;
                InteractionPane.this.getEditor().getDocument().getParser().stopParsing();
                Main.getInteractions().remove(InteractionPane.this);
            }
        };
        Thread thread = new Thread(new Runnable(){

            public void run() {
                InteractionPane.this.interaction.stopProcess();
                InteractionPane.this.interaction = null;
                SwingUtilities.invokeLater(cleanupPane);
            }
        });
        thread.start();
    }

    public boolean executeCommand(String command) {
        if (command != null) {
            this.getEditor().insertStringAt(command + "\n", this.getEditor().getDocument().length() - 1, false);
            this.moveToEnd();
            InteractionPane.addCommandToHistory(command);
            this.interaction.sendCommand(command);
        }
        return true;
    }

    public void insertCommand(String command) {
        this.getEditor().insertStringAt(command, this.getEditor().getDocument().length() - 1, false);
        this.moveCursorToEnd();
    }
}

