/*
 * Decompiled with CFR 0.152.
 */
package IDE.Interaction;

import IDE.CodeEditor.CodeDocument;
import IDE.CodeEditor.CodeEditor;
import IDE.CodeEditor.CodeElement;
import IDE.CodeEditor.CodeElementVector;
import IDE.CodeEditor.CodePane;
import IDE.CodeEditor.LeafVector;
import IDE.CodeEditor.Parser.Parser;
import IDE.Configuration.Mode;
import IDE.Configuration.XMLConfigClass;
import IDE.Configuration.XMLConfigMethod;
import IDE.Interaction.CommandHistory;
import IDE.Interaction.IInteraction;
import IDE.Main;
import IDE.WorkArea.ListOfChoices;
import java.awt.Point;
import java.io.Writer;
import javax.swing.SwingUtilities;

public abstract class AbstractInteractionPane
extends CodePane {
    protected int endPositionOutput;
    protected IInteraction interaction;
    public static final String SIGINT = "-SIGINT";
    public static final String SIGSTOP = "-SIGSTOP";
    public static final String SIGCONT = "-SIGCONT";
    public static final String SIGQUIT = "-SIGQUIT";
    public static final String SIGKILL = "-SIGKILL";
    private static CommandHistory commandHistory = new CommandHistory();

    public AbstractInteractionPane(Parser parser) {
        super(parser);
        this.getEditor().setMode(Mode.getMode("interaction"));
    }

    public void signalProcess(String signal) {
        this.interaction.signalProcess(signal);
    }

    public static void addCommandToHistory(String command) {
        if ((command = AbstractInteractionPane.removeWhiteSpaceFromBeginEnd(command)).length() > 0) {
            commandHistory.addCommand(command);
        }
    }

    private static String removeWhiteSpaceFromBeginEnd(String command) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < command.length(); ++i) {
            char c = command.charAt(i);
            if (c != '\n' && c != '\r' && c != '\t' && c != ' ') {
                buffer.append(c);
                continue;
            }
            buffer.append(' ');
        }
        return buffer.toString().trim();
    }

    public void chooseCommand() {
        Point point;
        CodeEditor editor = this.getEditor();
        if (editor == null) {
            point = null;
        } else {
            point = editor.getAbsolutePoint(editor.cursor.cursorOffset());
            SwingUtilities.convertPointToScreen(point, Main.frame);
        }
        String command = (String)ListOfChoices.showList("Command History", commandHistory.reverse(), point);
        if (command != null) {
            this.insertCommand(command);
        }
    }

    protected String findLastCommand() {
        CodeDocument document = this.getEditor().getDocument();
        LeafVector leafs = document.getLeafs();
        Parser parser = document.getParser();
        if (document.length() <= this.endPositionOutput) {
            return this.findLastCommandFromEnd();
        }
        int ileaf = document.getIndexLeafAt(this.endPositionOutput);
        if (ileaf < -1) {
            return null;
        }
        CodeElementVector elements = new CodeElementVector();
        int m = leafs.size();
        while (ileaf < m) {
            ileaf = parser.parseElement(ileaf, elements);
        }
        StringBuffer buffer = new StringBuffer();
        m = elements.size();
        for (int i = 0; i < m; ++i) {
            if (!elements.codeElementAt(i).isComplete()) {
                return this.findLastCommandFromEnd();
            }
            buffer.append(elements.codeElementAt(i).getString(document));
        }
        return buffer.toString();
    }

    private String findLastCommandFromEnd() {
        int ileaf;
        CodeDocument document = this.getEditor().getDocument();
        LeafVector leafs = document.getLeafs();
        Parser parser = document.getParser();
        if (leafs.size() == 0) {
            return null;
        }
        for (ileaf = leafs.size() - 1; ileaf >= 0 && parser.isWhiteSpace(leafs.leafAt(ileaf).getSeparatorChar()); --ileaf) {
        }
        if (ileaf < 0 || ileaf >= leafs.size()) {
            return null;
        }
        int inonwhite = ileaf;
        CodeElement element = document.getToplevelElementAt(leafs.leafAt(ileaf).begin());
        if (element != null) {
            if (element.isComplete()) {
                return element.getString(document);
            }
            return null;
        }
        while (ileaf >= 0 && leafs.leafAt(ileaf).getParent() == null) {
            --ileaf;
        }
        element = leafs.leafAt(ileaf = Math.max(0, ileaf)).getTopParent();
        ileaf = element == null ? 0 : document.getIndexLeafAt(element.end());
        CodeElementVector elements = new CodeElementVector();
        while (ileaf <= inonwhite) {
            ileaf = parser.parseElement(ileaf, elements);
        }
        int m = elements.size();
        if (m > 1 && (element = elements.codeElementAt(m - 1)).isComplete()) {
            return element.getString(document);
        }
        return null;
    }

    public void moveToEnd() {
        this.getEditor().cursor.moveToEnd();
        this.endPositionOutput = this.getEditor().cursor.cursorOffset();
    }

    public void moveCursorToEnd() {
        this.getEditor().cursor.moveToEnd();
    }

    public static void saveState(Writer writer) {
        XMLConfigClass cls = new XMLConfigClass("IDE.Interaction.AbstractInteractionPane");
        if (commandHistory != null) {
            int m = commandHistory.size();
            for (int i = 0; i < m; ++i) {
                XMLConfigMethod method = new XMLConfigMethod("addCommandToHistory");
                method.addArgument((String)commandHistory.elementAt(i));
                cls.addMethod(method);
            }
            cls.serialize(writer);
        }
    }

    public abstract IInteraction getInteraction();

    public abstract void enableDebugging(String var1);

    public abstract void enableDebugging(CodeEditor var1);

    public abstract void disableDebugging(CodeEditor var1);

    public abstract boolean processEnter();

    public abstract boolean executeCommand(String var1);

    public abstract void insertCommand(String var1);

    public abstract void cleanup();

    public abstract String getName();
}

