/*
 * Decompiled with CFR 0.152.
 */
package IDE.Help;

import IDE.CodeEditor.CodeEditor;
import IDE.Configuration.Configuration;
import IDE.Interaction.IInteraction;
import IDE.Main;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class ValueWindow
extends JScrollPane {
    private static Timer timer;
    private static JTextArea text;
    private static final int offsetX = 10;
    private static final int offsetY = 10;
    private static String result;
    private static int pos;

    public static void removeValueLeaf() {
        if (text != null) {
            Main.frame.getLayeredPane().remove(text);
        }
    }

    public static void displayValueLeaf(final CodeEditor editor, final int x, final int y) {
        final Runnable doDisplay = new Runnable(){

            public void run() {
                if (text != null) {
                    Main.frame.getLayeredPane().remove(text);
                    text = null;
                }
                Point point = editor.getAbsolutePoint(pos);
                if (editor != null && result != null) {
                    text = new JTextArea();
                    text.setBackground(Configuration.colorHint);
                    text.setText(result);
                    Dimension textDim = text.getPreferredSize();
                    Dimension frameDim = Main.frame.getSize();
                    FontMetrics fm = editor.getFontMetrics(editor.getFont());
                    text.setSize(textDim.width, textDim.height);
                    int posX = point.x + 10 + textDim.width > frameDim.width ? Math.max(0, point.x - 10 - textDim.width) : point.x + 10;
                    int posY = point.y + 10 + textDim.height > frameDim.height ? Math.max(0, point.y - 10 - textDim.height - fm.getHeight()) : point.y + 10;
                    text.setLocation(posX, posY);
                    Main.frame.getLayeredPane().add((Component)text, JLayeredPane.POPUP_LAYER);
                }
                Main.frame.repaint();
            }
        };
        TimerTask display = new TimerTask(){

            public void run() {
                IInteraction interaction = editor.getInteraction();
                pos = editor.getPosition(x, y);
                result = interaction.getValueLeaf(editor, pos);
                SwingUtilities.invokeLater(doDisplay);
            }
        };
        if (timer != null) {
            timer.cancel();
        }
        timer = new Timer();
        timer.schedule(display, Configuration.hoverTimeout);
    }

    static {
        text = null;
        result = "";
        pos = 0;
    }
}

