/*
 * Decompiled with CFR 0.152.
 */
package IDE.Help;

import IDE.CodeEditor.CodeDocument;
import IDE.CodeEditor.CodeEditor;
import IDE.CodeEditor.CodeElement;
import IDE.CodeEditor.CodeLeafElement;
import IDE.CodeEditor.CodeLeafSeparator;
import IDE.CodeEditor.LeafVector;
import IDE.CodeEditor.Parser.LispListElement;
import IDE.CodeEditor.Parser.LispParser;
import IDE.Configuration.XMLConfigClass;
import IDE.Configuration.XMLConfigMethod;
import IDE.Help.Help;
import IDE.Main;
import IDE.Messaging.MessageHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Writer;
import java.util.HashMap;

public class HyperSpec {
    private static HashMap keywordToFileName = new HashMap();
    private static String hyperSpecDirectory = null;

    public static String getHyperSpecDirectory() {
        return hyperSpecDirectory;
    }

    public static void setHyperSpecDirectory(String hyperSpecDirectory) {
        HyperSpec.hyperSpecDirectory = hyperSpecDirectory;
        File keywordfile = HyperSpec.getKeyWordFile(hyperSpecDirectory);
        if (keywordfile != null) {
            BufferedReader reader = null;
            try {
                String urlfile;
                String keyword;
                keywordToFileName.clear();
                reader = new BufferedReader(new FileReader(keywordfile));
                while ((keyword = reader.readLine()) != null && (urlfile = reader.readLine()) != null) {
                    keywordToFileName.put(keyword, urlfile.substring(8));
                }
                reader.close();
            }
            catch (Exception e) {
                MessageHandler.warn("Error opening the index file HyperSpec is " + e.getMessage());
            }
        }
    }

    private static File getKeyWordFile(String directory) {
        File file = new File(directory + File.separator + "Data" + File.separator + "Symbol-Table.text");
        if (!file.exists()) {
            file = new File(directory + File.separator + "Data" + File.separator + "Map_Sym.txt");
        }
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    private static String getFrontMatterIndexUrl() {
        String urlFile = hyperSpecDirectory + File.separator + "FrontMatter" + File.separator + "index.html";
        if (new File(urlFile).exists()) {
            return "File:" + hyperSpecDirectory + "/FrontMatter/index.html";
        }
        urlFile = hyperSpecDirectory + File.separator + "Front" + File.separator + "index.htm";
        if (new File(urlFile).exists()) {
            return "File:" + hyperSpecDirectory + "/Front/index.htm";
        }
        return null;
    }

    public static void displayHyperSpecContext() {
        CodeDocument document;
        if (hyperSpecDirectory == null) {
            return;
        }
        CodeEditor editor = Main.currentEditor();
        if (editor != null && (document = editor.getDocument()) != null && document.getParser() instanceof LispParser) {
            int ileaf;
            int pos = editor.cursor.cursorOffset();
            LeafVector leafs = document.getLeafs();
            for (ileaf = document.getIndexLeafAt(pos); ileaf >= 0 && leafs.leafAt(ileaf) instanceof CodeLeafSeparator; --ileaf) {
            }
            if (ileaf >= 0) {
                CodeElement element;
                CodeLeafElement leaf = leafs.leafAt(ileaf);
                for (element = leaf.getParent(); element != null && !(element instanceof LispListElement); element = element.getParent()) {
                }
                if (element != null) {
                    String url = (String)keywordToFileName.get(leaf.getString(document).toUpperCase());
                    url = (String)keywordToFileName.get(element.getString(document).toUpperCase());
                    for (element = ((LispListElement)element).getFirst(); url == null && element != null; element = element.getParent()) {
                        if (!(element instanceof LispListElement)) continue;
                        url = (String)keywordToFileName.get(((LispListElement)element).getFirst().getString(document).toUpperCase());
                    }
                    if (url != null) {
                        Help.displayHelpNative("file:" + hyperSpecDirectory + "/Body/" + url);
                    }
                }
            }
        }
    }

    public static void displayHyperSpec() {
        String urlFrontMatter = HyperSpec.getFrontMatterIndexUrl();
        if (urlFrontMatter != null) {
            Help.displayHelpNative(urlFrontMatter);
        }
    }

    public static void saveConfiguration(Writer writer) {
        if (hyperSpecDirectory != null) {
            XMLConfigClass cls = new XMLConfigClass("IDE.Help.HyperSpec");
            XMLConfigMethod method = new XMLConfigMethod("setHyperSpecDirectory");
            method.addArgument(hyperSpecDirectory);
            cls.addMethod(method);
            cls.serialize(writer);
        }
    }
}

