/*
 * Decompiled with CFR 0.152.
 */
package IDE.Help;

import IDE.CodeEditor.CodeDocument;
import IDE.CodeEditor.CodeLeafElement;
import IDE.CodeEditor.Parser.Parser;
import IDE.Configuration.Configuration;
import IDE.Help.HintInfo;
import IDE.Main;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import javax.swing.DefaultListModel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;

public class HintWindow
extends JSplitPane
implements ListSelectionListener {
    Timer timer = null;
    private static final int offsetX = 10;
    private static final int offsetY = 10;
    private static JTextArea text;
    private static JScrollPane textpane;
    private static JList list;
    private static JScrollPane listpane;
    private static Parser parser;
    private static CodeLeafElement leaf;

    public HintWindow() {
        super(0);
        text = new JTextArea();
        text.setEditable(false);
        textpane = new JScrollPane(text);
        list = new JList(new DefaultListModel());
        list.addListSelectionListener(this);
        list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent ev) {
                if (2 == ev.getClickCount()) {
                    HintWindow.replaceByHint();
                }
            }
        });
        listpane = new JScrollPane(list);
        this.add(textpane);
        this.add(listpane);
        this.setVisible(true);
        this.toBack();
    }

    public static void replaceByHint() {
        if (parser != null && leaf != null) {
            parser.replaceLeafByHint(leaf, (String)list.getSelectedValue());
            Main.currentEditor().requestFocus();
        }
    }

    public static void goUp() {
        int i = list.getSelectedIndex();
        if (i > 0) {
            list.setSelectedIndex(i - 1);
            list.ensureIndexIsVisible(i - 1);
        }
    }

    public static void goDown() {
        int i = list.getSelectedIndex();
        if (i + 1 < list.getModel().getSize()) {
            list.setSelectedIndex(i + 1);
            list.ensureIndexIsVisible(i + 1);
        }
    }

    public void showHint(final int position, CodeDocument document, final int x, final int y) {
        parser = document.getParser();
        final Runnable toback = new Runnable(){

            public void run() {
                leaf = null;
                HintWindow.this.toBack();
            }
        };
        TimerTask task = new TimerTask(){

            public void run() {
                HintInfo info = parser.getHintInfo(position);
                if (info == null) {
                    SwingUtilities.invokeLater(toback);
                } else {
                    DisplayHintWindow display = new DisplayHintWindow(info, x, y);
                    SwingUtilities.invokeLater(display);
                    HintWindow.this.timer.cancel();
                }
            }
        };
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer();
        this.timer.schedule(task, 50L, 100L);
    }

    public void valueChanged(ListSelectionEvent e) {
        int i;
        if (parser != null && (i = list.getSelectedIndex()) >= 0 && i < list.getModel().getSize()) {
            String syntax = parser.getSyntaxDescription((String)list.getModel().getElementAt(i));
            if (syntax.length() != 0) {
                text.setText(syntax);
                text.revalidate();
            }
            this.sizeHintWindow();
        }
    }

    private void sizeHintWindow() {
        int xmax = 5000;
        int xmin = 100;
        int ymax = 500;
        int ymin = 30;
        FontMetrics fm = text.getFontMetrics(text.getFont());
        int xs = 0;
        int ys = fm.getHeight() * (text.getLineCount() - 1);
        try {
            for (int i = 0; i < text.getLineCount(); ++i) {
                String str = text.getDocument().getText(text.getLineStartOffset(i), text.getLineEndOffset(i) - text.getLineStartOffset(i));
                xs = Math.max(xs, fm.stringWidth(str));
            }
        }
        catch (BadLocationException ex) {
            // empty catch block
        }
        xs = Math.min(Math.max(xs, xmin), xmax);
        ys = Math.min(Math.max(ys, ymin), ymax);
        int xl = xs;
        list.setVisibleRowCount(Math.min(10, list.getModel().getSize()));
        int yl = HintWindow.list.getPreferredScrollableViewportSize().height;
        xl = HintWindow.list.getPreferredScrollableViewportSize().width;
        xl = Math.min(Math.max(xl, xmin), xmax);
        yl = Math.min(Math.max(yl, ymin), ymax);
        int x = Math.max(xs, xl);
        textpane.setPreferredSize(new Dimension(x + 30, ys + 30));
        textpane.setMinimumSize(new Dimension(x + 30, ys + 60));
        listpane.setPreferredSize(new Dimension(x + 30, yl + 60));
        this.setDividerSize(2);
        this.setSize(x + 30, yl + ys + 66);
        this.resetToPreferredSizes();
        this.validateTree();
    }

    public void toFront() {
        JLayeredPane lp = Main.frame.getLayeredPane();
        lp.remove(this);
        lp.add((Component)this, JLayeredPane.POPUP_LAYER);
        Main.frame.repaint();
    }

    public void toBack() {
        Main.frame.getLayeredPane().remove(this);
        Main.frame.repaint();
    }

    private void setPosition(int x, int y) {
        Dimension dim = Main.frame.getSize();
        int widthFrame = dim.width;
        int heightFrame = dim.height;
        dim = this.getSize();
        int widthWindow = dim.width;
        int heightWindow = dim.height;
        int posX = x + 10 + widthWindow + 30 > widthFrame ? Math.max(0, x - 10 - widthWindow) : x + 10;
        int posY = y + 10 + heightWindow + 30 > heightFrame ? Math.max(0, y - 10 - heightWindow - 20) : y + 10;
        this.setLocation(posX, posY);
    }

    static {
        parser = null;
        leaf = null;
    }

    private class DisplayHintWindow
    implements Runnable {
        private String[] hints;
        private String syntaxhint;
        private int iHint;
        private int x;
        private int y;
        private CodeLeafElement leaf;

        private DisplayHintWindow(HintInfo info, int x, int y) {
            this.hints = this.removeDuplicatesAndSort(info.hints);
            this.leaf = info.leaf;
            this.syntaxhint = info.syntaxhint;
            this.iHint = info.iHint;
            this.x = x;
            this.y = y;
        }

        public void run() {
            list.setListData(this.hints);
            if (this.iHint < 0) {
                this.iHint = 0;
            }
            if (this.iHint < this.hints.length) {
                list.setSelectedIndex(this.iHint);
            }
            text.setText(this.syntaxhint);
            text.setBackground(Configuration.colorHint);
            HintWindow.this.sizeHintWindow();
            if (this.iHint >= 0 && this.iHint < this.hints.length) {
                list.ensureIndexIsVisible(this.iHint);
            }
            HintWindow.this.setPosition(this.x, this.y);
            HintWindow.this.toFront();
            leaf = this.leaf;
        }

        private String[] removeDuplicatesAndSort(String[] values) {
            TreeSet<String> newvalues = new TreeSet<String>();
            for (int i = 0; i < values.length; ++i) {
                newvalues.add(values[i]);
            }
            String[] result = new String[newvalues.size()];
            Iterator iter = newvalues.iterator();
            int i = 0;
            while (iter.hasNext()) {
                result[i] = (String)iter.next();
                ++i;
            }
            return result;
        }
    }
}

