/*
 * Decompiled with CFR 0.152.
 */
package IDE.Help;

import IDE.CodeEditor.CodeDocument;
import IDE.CodeEditor.CodeEditor;
import IDE.Help.HintWindow;
import java.awt.Point;

public class Hint {
    private static boolean display = false;
    private static CodeEditor editor;
    private static HintWindow hintwindow;

    public static void initHint() {
        hintwindow = new HintWindow();
    }

    public static void setEditor(CodeEditor editor) {
        Hint.editor = editor;
    }

    public static void toggleHint() {
        if (display) {
            display = false;
            Hint.removeHint();
        } else {
            display = true;
            Hint.showHint();
        }
    }

    public static void activateHint() {
        if (display) {
            Hint.showHint();
        }
    }

    public static void replaceByHint() {
        if (display) {
            HintWindow.replaceByHint();
        }
    }

    public static void goUp() {
        if (display) {
            HintWindow.goUp();
        }
    }

    public static void goDown() {
        if (display) {
            HintWindow.goDown();
        }
    }

    public static void showHint() {
        if (editor != null && display) {
            CodeDocument document = editor.getDocument();
            int offset = Hint.editor.cursor.cursorOffset();
            Point point = editor.getAbsolutePoint(offset);
            point.x = point.x;
            point.y = point.y;
            hintwindow.showHint(offset, document, point.x, point.y);
        }
    }

    public static void removeHint() {
        hintwindow.toBack();
    }

    static {
        hintwindow = null;
    }
}

