/*
 * Decompiled with CFR 0.152.
 */
package IDE.Help;

import IDE.Configuration.Configuration;
import IDE.Messaging.MessageHandler;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class Help {
    private static JFrame helpFrame = null;
    private static JEditorPane helpPane = new JEditorPane();
    private static Vector visitedURLs = new Vector();
    private static int currentURLnum = 0;
    private static URL url;
    private static String targetFrame;
    private static JButton prevButton;
    private static JButton nextButton;
    private static JButton homeButton;
    private static JLabel addressLabel;
    private static JTextField addressField;

    public static void displayHelp() {
        if (Configuration.helpbrowser.compareTo("native") == 0) {
            Help.displayHelpNative();
        } else {
            String browsercommand = Configuration.helpbrowser + " " + Help.getUrlHelp();
            Runtime runtime = Runtime.getRuntime();
            try {
                Process process = runtime.exec(browsercommand);
                final InputStream in = process.getInputStream();
                final InputStream error = process.getErrorStream();
                Thread thread = new Thread(new Runnable(){

                    public void run() {
                        try {
                            while (in.read() > 0) {
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
                thread.start();
                thread = new Thread(new Runnable(){

                    public void run() {
                        try {
                            while (error.read() > 0) {
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
                thread.start();
            }
            catch (Exception e) {
                MessageHandler.report("Failed to start browser for help", e);
            }
        }
    }

    public static void displayHelpNative() {
        Help.displayHelpNative(Help.getUrlHelp());
    }

    public static void displayHelpNative(String urlString) {
        if (helpFrame == null) {
            Help.displayHelpNativeImp(urlString);
        } else {
            try {
                helpFrame.toFront();
                url = new URL(urlString);
                helpPane.setPage(url);
                visitedURLs.setSize(currentURLnum + 1);
                Help.storeURL(url);
            }
            catch (IOException e) {
                MessageHandler.report("Cannot go to" + url.toExternalForm(), e);
            }
        }
    }

    private static void displayHelpNativeImp(final String urlString) {
        JPanel topPanel = new JPanel(new FlowLayout(0));
        nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                if (visitedURLs.size() == currentURLnum + 1) {
                    return;
                }
                try {
                    currentURLnum++;
                    Help.updateButtons();
                    url = (URL)visitedURLs.get(currentURLnum);
                    helpPane.setPage(url);
                    addressField.setText(url.toExternalForm());
                }
                catch (IOException e) {
                    MessageHandler.report("Cannot go to" + url.toExternalForm(), e);
                }
            }
        });
        prevButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                if (0 == currentURLnum) {
                    return;
                }
                try {
                    currentURLnum--;
                    Help.updateButtons();
                    url = (URL)visitedURLs.get(currentURLnum);
                    helpPane.setPage(url);
                    addressField.setText(url.toExternalForm());
                }
                catch (IOException e) {
                    MessageHandler.report("Cannot go to" + url.toExternalForm(), e);
                }
            }
        });
        homeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    url = new URL(urlString);
                    helpPane.setPage(url);
                    Help.storeURL(url);
                }
                catch (IOException e) {
                    MessageHandler.report("Cannot go to" + url.toExternalForm(), e);
                }
            }
        });
        addressField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    url = new URL(addressField.getText());
                    helpPane.setPage(url);
                    visitedURLs.setSize(currentURLnum + 1);
                    Help.storeURL(url);
                }
                catch (IOException e) {
                    MessageHandler.report("Cannot go to" + url.toExternalForm(), e);
                }
            }
        });
        topPanel.add(prevButton);
        topPanel.add(nextButton);
        topPanel.add(homeButton);
        topPanel.add(addressLabel);
        topPanel.add(addressField);
        helpPane.addHyperlinkListener(new LinkActivator());
        helpPane.setEditable(false);
        try {
            url = new URL(urlString);
            helpPane.setPage(url);
            helpFrame = new JFrame();
            helpFrame.getContentPane().add((Component)topPanel, "North");
            helpFrame.getContentPane().add((Component)new JScrollPane(helpPane), "Center");
            helpFrame.setSize(750, 600);
            helpFrame.setVisible(true);
            helpFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    helpFrame = null;
                }
            });
            visitedURLs.clear();
            visitedURLs.add(url);
            currentURLnum = 0;
            Help.updateButtons();
            addressField.setText(url.toExternalForm());
        }
        catch (IOException e) {
            MessageHandler.report("Failed to start browser for help", e);
        }
    }

    private static String getUrlHelp() {
        return "file:" + Configuration.installDirectory + "/doc/index.html";
    }

    private static void storeURL(URL url) {
        if (!url.equals((URL)visitedURLs.get(currentURLnum))) {
            visitedURLs.add(url);
            ++currentURLnum;
            Help.updateButtons();
            addressField.setText(url.toExternalForm());
        }
    }

    private static void updateButtons() {
        if (currentURLnum == 0) {
            prevButton.setEnabled(false);
        } else {
            prevButton.setEnabled(true);
        }
        if (currentURLnum >= visitedURLs.size() - 1) {
            nextButton.setEnabled(false);
        } else {
            nextButton.setEnabled(true);
        }
    }

    public static void main(String[] args) {
        Help.displayHelpNative();
    }

    static {
        targetFrame = "main";
        prevButton = new JButton("Back");
        nextButton = new JButton("Next");
        homeButton = new JButton("Home");
        addressLabel = new JLabel("Address:");
        addressField = new JTextField(40);
    }

    private static class LinkActivator
    implements HyperlinkListener {
        private LinkActivator() {
        }

        public void hyperlinkUpdate(HyperlinkEvent event) {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane clickedPane = (JEditorPane)event.getSource();
                if (event instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent frameEvent = (HTMLFrameHyperlinkEvent)event;
                    HTMLDocument doc = (HTMLDocument)clickedPane.getDocument();
                    doc.processHTMLFrameHyperlinkEvent(frameEvent);
                    addressField.setText(event.getURL().toExternalForm());
                    visitedURLs.setSize(currentURLnum + 1);
                    Help.storeURL(frameEvent.getURL());
                } else {
                    try {
                        HTMLDocument doc = (HTMLDocument)clickedPane.getDocument();
                        clickedPane.setPage(event.getURL());
                        addressField.setText(event.getURL().toExternalForm());
                        visitedURLs.setSize(currentURLnum + 1);
                        Help.storeURL(event.getURL());
                    }
                    catch (IOException e) {
                        MessageHandler.report("Cannot go to" + event.getURL().toExternalForm(), e);
                    }
                }
            }
        }
    }
}

