/*
 * Decompiled with CFR 0.152.
 */
package IDE.Explorer;

import IDE.Configuration.Configuration;
import IDE.Explorer.DefinitionNode;
import IDE.Explorer.DefinitionTypeNode;
import IDE.Explorer.DirectoryNode;
import IDE.Explorer.ExplorerNode;
import IDE.Explorer.FileExtensions;
import IDE.Explorer.FileNode;
import IDE.Explorer.ProjectNode;
import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;

public class NodeTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    private static ImageIcon iconDir = Configuration.getIcon("directory.png");
    private static ImageIcon iconProject = Configuration.getIcon("project.png");
    private static ImageIcon root = Configuration.getIcon("root.png");

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasfocus) {
        this.setFont(Configuration.explorerFont);
        this.setToolTipText("");
        if (selected) {
            this.setOpaque(true);
            this.setBackground(Configuration.colorSelected);
            this.setForeground(Color.black);
        } else {
            this.setOpaque(false);
            this.setForeground(Color.black);
        }
        if (value instanceof ExplorerNode) {
            this.setText(((ExplorerNode)value).getText());
        } else {
            this.setText(value.toString());
        }
        if (value instanceof FileNode) {
            String base = FileExtensions.getExtension(((FileNode)value).getFile().getName());
            ImageIcon iconFile = Configuration.getIcon(base == null ? "file.png" : "ext_" + base + ".png");
            this.setIcon(iconFile);
            this.setToolTipText(((FileNode)value).getFile().getAbsolutePath());
        } else if (value instanceof DirectoryNode) {
            this.setIcon(iconDir);
            this.setToolTipText(((DirectoryNode)value).getDirectory().getAbsolutePath());
        } else if (value instanceof DefinitionNode) {
            String base = ((DefinitionNode)value).getType();
            this.setIcon(Configuration.getIcon("small_" + base + ".png"));
        } else if (value instanceof DefinitionTypeNode) {
            String base = ((DefinitionTypeNode)value).getType();
            this.setIcon(Configuration.getIcon("big_" + base + ".png"));
        } else if (value instanceof ProjectNode) {
            this.setToolTipText(((ProjectNode)value).getDirectory().getAbsolutePath());
            this.setIcon(iconProject);
        } else {
            this.setIcon(root);
        }
        return this;
    }
}

