/*
 * Decompiled with CFR 0.152.
 */
package IDE.Explorer;

import IDE.CodeEditor.Parser.Definition;
import IDE.Explorer.DefinitionNode;
import IDE.Explorer.DefinitionTypeNode;
import IDE.Explorer.ExplorerNode;
import java.io.File;
import java.util.Iterator;
import java.util.SortedSet;
import javax.swing.tree.DefaultTreeModel;

public class FileNode
extends ExplorerNode {
    private File file;

    public FileNode(String name, File file, SortedSet definitions) {
        super(name);
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getText() {
        return this.file.getName();
    }

    public void updateDefinitionTypes(SortedSet definitions, DefaultTreeModel model) {
        Iterator iter = definitions.iterator();
        int indextype = 0;
        if (iter.hasNext()) {
            Definition definition = (Definition)iter.next();
            while (true) {
                DefinitionTypeNode newtypenode;
                if (indextype < this.getChildCount()) {
                    DefinitionTypeNode typenode = (DefinitionTypeNode)this.getChildAt(indextype);
                    int compare = typenode.getType().compareTo(definition.getType());
                    if (compare < 0) {
                        model.removeNodeFromParent(typenode);
                        continue;
                    }
                    if (compare == 0) {
                        definition = this.updateDefinitions(definition, typenode, iter, model);
                        ++indextype;
                        if (iter.hasNext()) continue;
                        this.removeRemainingNodes(this, indextype, model);
                        return;
                    }
                    newtypenode = new DefinitionTypeNode(definition.getType());
                    model.insertNodeInto(newtypenode, this, indextype);
                    definition = this.updateDefinitions(definition, newtypenode, iter, model);
                    ++indextype;
                    if (iter.hasNext()) continue;
                    this.removeRemainingNodes(this, indextype, model);
                    return;
                }
                newtypenode = new DefinitionTypeNode(definition.getType());
                model.insertNodeInto(newtypenode, this, indextype);
                ++indextype;
                definition = this.updateDefinitions(definition, newtypenode, iter, model);
                if (!iter.hasNext()) break;
            }
            return;
        }
        this.removeRemainingNodes(this, 0, model);
    }

    private void removeRemainingNodes(ExplorerNode node, int indextype, DefaultTreeModel model) {
        while (indextype < node.getChildCount()) {
            model.removeNodeFromParent((ExplorerNode)node.getChildAt(indextype));
        }
    }

    private Definition updateDefinitions(Definition definition, DefinitionTypeNode typenode, Iterator iter, DefaultTreeModel model) {
        int indexdefinition = 0;
        String oldtype = definition.getType();
        while (oldtype.compareTo(definition.getType()) == 0) {
            DefinitionNode newnode;
            if (indexdefinition < typenode.getChildCount()) {
                DefinitionNode node = (DefinitionNode)typenode.getChildAt(indexdefinition);
                int compare = node.getText().compareTo(definition.getName());
                if (compare < 0) {
                    model.removeNodeFromParent(node);
                    continue;
                }
                if (compare == 0) {
                    node.updatePosition(definition.getBeginPosition());
                    ++indexdefinition;
                    if (iter.hasNext()) {
                        definition = (Definition)iter.next();
                        continue;
                    }
                    return null;
                }
                newnode = new DefinitionNode(definition.getName(), definition.getType(), this, definition.getBeginPosition());
                model.insertNodeInto(newnode, typenode, indexdefinition);
                ++indexdefinition;
                if (iter.hasNext()) {
                    definition = (Definition)iter.next();
                    continue;
                }
                return null;
            }
            newnode = new DefinitionNode(definition.getName(), definition.getType(), this, definition.getBeginPosition());
            model.insertNodeInto(newnode, typenode, indexdefinition);
            ++indexdefinition;
            if (iter.hasNext()) {
                definition = (Definition)iter.next();
                continue;
            }
            return null;
        }
        return definition;
    }
}

