/*
 * Decompiled with CFR 0.152.
 */
package IDE.Explorer;

import java.awt.Component;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

class FileExtensionsCellEditor
extends JTextField
implements TableCellEditor {
    private JTable table;
    private Vector listeners = new Vector();
    private int row;
    private int column;

    FileExtensionsCellEditor() {
    }

    public void addCellEditorListener(CellEditorListener l) {
        this.listeners.add(l);
    }

    public void cancelCellEditing() {
        TableModel model = this.table.getModel();
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ((CellEditorListener)this.listeners.elementAt(i)).editingCanceled(new ChangeEvent(this));
        }
        if (model != null && this.row < model.getRowCount() && this.column < model.getColumnCount()) {
            model.setValueAt(this.getText(), this.row, this.column);
            this.table.setRowSelectionInterval(this.row, this.row);
            this.table.setColumnSelectionInterval(this.column, this.column);
        }
        this.setText("");
    }

    public Object getCellEditorValue() {
        return this.getText();
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.row = row;
        this.column = column;
        this.table = table;
        if (value instanceof String) {
            this.setText((String)value);
        } else {
            this.setText("");
        }
        this.setEditable(true);
        TableModel model = table.getModel();
        if (model != null && row < model.getRowCount() && column < model.getColumnCount()) {
            table.setRowSelectionInterval(row, row);
            table.setColumnSelectionInterval(column, column);
        }
        return this;
    }

    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    public void removeCellEditorListener(CellEditorListener l) {
        this.listeners.remove(l);
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    public boolean stopCellEditing() {
        TableModel model = this.table.getModel();
        if (model != null && this.row < model.getRowCount() && this.column < model.getColumnCount()) {
            model.setValueAt(this.getText(), this.row, this.column);
            this.table.setRowSelectionInterval(this.row, this.row);
            this.table.setColumnSelectionInterval(this.column, this.column);
        }
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ((CellEditorListener)this.listeners.elementAt(i)).editingStopped(new ChangeEvent(this));
        }
        this.setText("");
        System.out.println("In Model=" + model + " row=" + this.row + " column=" + this.column);
        return true;
    }
}

