/*
 * Decompiled with CFR 0.152.
 */
package IDE.Explorer;

import IDE.CodeEditor.Parser.Parser;
import IDE.Configuration.XMLConfigClass;
import IDE.Configuration.XMLConfigMethod;
import IDE.Explorer.CreateFileAction;
import IDE.Explorer.DirectoryNode;
import IDE.Explorer.FileExtensionsCellEditor;
import IDE.Explorer.ProjectNode;
import IDE.Messaging.MessageHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;

public class FileExtensions {
    private static FileExtensions self = new FileExtensions();
    private static TreeMap extensionToParserClassName = new TreeMap();
    static /* synthetic */ Class class$java$lang$Object;

    private FileExtensions() {
    }

    public static void addExtension(String extension, String parserClassName) {
        extensionToParserClassName.put(extension, parserClassName);
    }

    public static FileFilter getFilter() {
        return self.getFilterImp();
    }

    public static javax.swing.filechooser.FileFilter getFileChooserFilter() {
        return self.getFileChooserFilterImp();
    }

    public static String getExtension(Parser parser) {
        Iterator iter = extensionToParserClassName.keySet().iterator();
        String parserstring = parser.getClass().getName();
        while (iter.hasNext()) {
            String extension = (String)iter.next();
            if (((String)extensionToParserClassName.get(extension)).compareTo(parserstring) != 0) continue;
            return extension;
        }
        return "";
    }

    private FileExtentionsFilter getFilterImp() {
        return new FileExtentionsFilter();
    }

    private javax.swing.filechooser.FileFilter getFileChooserFilterImp() {
        return new FileChooserFilter();
    }

    public static void editExtensions() {
        final JDialog dialog = new JDialog();
        JPanel panel = new JPanel();
        JPanel buttons = new JPanel();
        final DefaultTableModel model = new DefaultTableModel(new String[0][0], new String[]{"Extension", "Parser Class Name"});
        final JTable table = new JTable(model);
        table.setDefaultEditor(class$java$lang$Object == null ? (class$java$lang$Object = FileExtensions.class$("java.lang.Object")) : class$java$lang$Object, new FileExtensionsCellEditor());
        JScrollPane scrollpane = new JScrollPane(table);
        JButton add = new JButton(new AbstractAction("Add"){

            public void actionPerformed(ActionEvent ev) {
                model.addRow(new String[]{"", ""});
            }
        });
        JButton remove = new JButton(new AbstractAction("Remove"){

            public void actionPerformed(ActionEvent ev) {
                int i = table.getSelectedRow();
                TableCellEditor ce = table.getCellEditor();
                if (ce != null) {
                    ce.stopCellEditing();
                }
                if (i >= 0) {
                    model.removeRow(i);
                }
            }
        });
        JButton ok = new JButton(new AbstractAction("Ok"){

            public void actionPerformed(ActionEvent ev) {
                int i;
                int m = model.getRowCount();
                TableCellEditor ce = table.getCellEditor();
                if (ce != null) {
                    ce.stopCellEditing();
                }
                for (i = 0; i < m; ++i) {
                    try {
                        Class<?> cls = Class.forName((String)model.getValueAt(i, 1));
                        if (Class.forName("IDE.CodeEditor.Parser.Parser").isAssignableFrom(cls)) continue;
                        if (JOptionPane.showConfirmDialog(null, "Parser does not exist, continue edit", "Class is not parser", 2) == 2) {
                            dialog.setVisible(false);
                            dialog.dispose();
                            continue;
                        }
                        return;
                    }
                    catch (Exception e) {
                        if (JOptionPane.showConfirmDialog(null, "Parser does not exist, continue edit", "Class " + model.getValueAt(i, 1) + " not found", 2) == 2) {
                            dialog.setVisible(false);
                            dialog.dispose();
                            continue;
                        }
                        return;
                    }
                }
                extensionToParserClassName.clear();
                for (i = 0; i < m; ++i) {
                    FileExtensions.addExtension((String)model.getValueAt(i, 0), (String)model.getValueAt(i, 1));
                }
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        JButton cancel = new JButton(new AbstractAction("Cancel"){

            public void actionPerformed(ActionEvent ev) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        table.getSelectionModel().setSelectionMode(0);
        Iterator iter = extensionToParserClassName.keySet().iterator();
        while (iter.hasNext()) {
            String extension = (String)iter.next();
            String parser = (String)extensionToParserClassName.get(extension);
            model.addRow(new String[]{extension, parser});
        }
        buttons.add(ok);
        buttons.add(cancel);
        buttons.add(add);
        buttons.add(remove);
        panel.setLayout(new BorderLayout());
        panel.add((Component)scrollpane, "Center");
        panel.add((Component)buttons, "South");
        dialog.setTitle("Edit extensions");
        dialog.setModal(true);
        dialog.setContentPane(panel);
        dialog.setSize(400, 500);
        dialog.setLocation(100, 200);
        dialog.setVisible(true);
    }

    public static void saveConfiguration(Writer writer) {
        XMLConfigClass cls = new XMLConfigClass(self.getClass().getName());
        Iterator iter = extensionToParserClassName.keySet().iterator();
        while (iter.hasNext()) {
            String extension = (String)iter.next();
            String parser = (String)extensionToParserClassName.get(extension);
            XMLConfigMethod method = new XMLConfigMethod("addExtension");
            method.addArgument(extension);
            method.addArgument(parser);
            cls.addMethod(method);
        }
        cls.serialize(writer);
    }

    public static Parser createParser(File file, boolean async) {
        String extension = FileExtensions.getExtension(file.getName());
        String nameParserClass = "";
        Class<?> parserClass = null;
        Constructor<?> parserConstructor = null;
        if (extension == null) {
            MessageHandler.warn("No extension for file");
            return null;
        }
        nameParserClass = (String)extensionToParserClassName.get(extension);
        if (nameParserClass == null) {
            MessageHandler.warn("Unknown extension=" + extension);
            return null;
        }
        try {
            parserClass = Class.forName(nameParserClass);
            parserConstructor = parserClass.getConstructor(Boolean.TYPE);
            return (Parser)parserConstructor.newInstance(new Boolean(async));
        }
        catch (ClassNotFoundException e) {
            MessageHandler.warn("Class for parser=" + nameParserClass + " was not found");
            return null;
        }
        catch (NoSuchMethodException e) {
            MessageHandler.report("Constructor for parser=" + nameParserClass + " was not found", e);
            return null;
        }
        catch (Exception e) {
            MessageHandler.report("Error instantiating parser : " + e.getMessage(), e);
            return null;
        }
    }

    public static void addCreateFilePopups(JPopupMenu menu, DirectoryNode directorynode) {
        JMenu submenu = new JMenu("New File");
        Iterator iter = extensionToParserClassName.keySet().iterator();
        while (iter.hasNext()) {
            String extension = (String)iter.next();
            submenu.add(new JMenuItem(new CreateFileAction("*." + extension, extension, directorynode)));
        }
        menu.add(submenu);
    }

    public static void addCreateFilePopups(JPopupMenu menu, ProjectNode projectnode) {
        JMenu submenu = new JMenu("New File");
        Iterator iter = extensionToParserClassName.keySet().iterator();
        while (iter.hasNext()) {
            String extension = (String)iter.next();
            submenu.add(new JMenuItem(new CreateFileAction("*." + extension, extension, projectnode)));
        }
        menu.add(submenu);
    }

    public static String getExtension(String name) {
        int i;
        StringBuffer extension = new StringBuffer();
        for (i = name.length() - 1; i >= 0 && name.charAt(i) != '.'; --i) {
            extension.append(name.charAt(i));
        }
        if (i < 0) {
            return null;
        }
        extension.reverse();
        return extension.toString();
    }

    private static boolean hasCorrectExtension(String name) {
        String extension = FileExtensions.getExtension(name);
        if (extension == null) {
            return false;
        }
        return extensionToParserClassName.containsKey(extension);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        FileExtensions.addExtension("lisp", "IDE.CodeEditor.Parser.LispParser");
        FileExtensions.addExtension("lsp", "IDE.CodeEditor.Parser.LispParser");
    }

    private class FileExtentionsFilter
    implements FileFilter {
        private HashSet seen = new HashSet();

        public boolean accept(File file) {
            try {
                file = file.getCanonicalFile();
                if (!this.seen.contains(file)) {
                    this.seen.add(file);
                    if (file.isDirectory()) {
                        return true;
                    }
                    return file.isFile() && FileExtensions.hasCorrectExtension(file.getName());
                }
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }
    }

    private class FileChooserFilter
    extends javax.swing.filechooser.FileFilter {
        private FileChooserFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return file.isFile() && FileExtensions.hasCorrectExtension(file.getName());
        }

        public String getDescription() {
            StringBuffer buffer = new StringBuffer();
            Iterator iter = extensionToParserClassName.keySet().iterator();
            boolean notfirst = false;
            while (iter.hasNext()) {
                if (notfirst) {
                    buffer.append(',');
                } else {
                    buffer.append("Known extensions: ");
                    notfirst = true;
                }
                buffer.append("*.");
                buffer.append((String)iter.next());
            }
            return buffer.toString();
        }
    }
}

