/*
 * Decompiled with CFR 0.152.
 */
package IDE.Explorer;

import IDE.CodeEditor.CodeCursor;
import IDE.CodeEditor.CodeDocument;
import IDE.CodeEditor.CodeEditor;
import IDE.CodeEditor.CodeElement;
import IDE.CodeEditor.CodeElementVector;
import IDE.CodeEditor.CodePane;
import IDE.CodeEditor.CodeStructureElement;
import IDE.CodeEditor.Parser.LispParser;
import IDE.CodeEditor.Parser.Parser;
import IDE.Configuration.Configuration;
import IDE.Configuration.Mode;
import IDE.Configuration.XMLConfigClass;
import IDE.Configuration.XMLConfigMethod;
import IDE.Configuration.XMLConfigObject;
import IDE.Explorer.DefinitionInfo;
import IDE.Explorer.DefinitionNode;
import IDE.Explorer.DefinitionTypeNode;
import IDE.Explorer.DirectoryNode;
import IDE.Explorer.ExplorerNode;
import IDE.Explorer.FileExtensions;
import IDE.Explorer.FileNode;
import IDE.Explorer.NodeTreeCellRenderer;
import IDE.Explorer.ProjectNode;
import IDE.IIDEAddin;
import IDE.Interaction.Interactions;
import IDE.Main;
import IDE.Messaging.MessageHandler;
import IDE.Utilities.Util;
import IDE.WorkArea.WorkArea;
import Install.OsSystem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class Explorer
extends JPanel
implements MouseListener,
IIDEAddin {
    private static JTree tree;
    private static DefaultTreeModel treemodel;
    private static DefaultMutableTreeNode root;
    private static JScrollPane scrollpane;
    private static TreeMap fileToDocument;
    private static TreeMap fileToFileNode;
    private static ExplorerNode copynode;

    public Explorer() {
        root = new DefaultMutableTreeNode("Projects");
        treemodel = new ExplorerTreeModel(root);
        tree = new JTree(treemodel);
        tree.setCellRenderer(new NodeTreeCellRenderer());
        tree.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent ev) {
                CodeEditor editor = Main.currentEditor();
                if (editor != null) {
                    CodeCursor.cancelCursor();
                }
            }

            public void focusLost(FocusEvent ev) {
            }
        });
        scrollpane = new JScrollPane(tree);
        this.setLayout(new BorderLayout());
        this.add((Component)scrollpane, "Center");
        tree.addMouseListener(this);
        ToolTipManager.sharedInstance().registerComponent(tree);
    }

    private static void addFileToDocument(String path, CodeDocument document) {
        fileToDocument.put(path, document);
    }

    private static void addFileToFileNode(String path, FileNode node) {
        fileToFileNode.put(path, node);
    }

    private static void removeFileToDocument(String path) {
        fileToDocument.remove(path);
    }

    private static void removeFileToFileNode(String path) {
        fileToFileNode.remove(path);
    }

    public void repaintAll() {
        treemodel.nodeStructureChanged(root);
        this.repaint();
    }

    public static DefinitionInfo[] getDefinitionInfos(String[] types) {
        Vector start = Explorer.getDefinitionInfoVectorProject(null);
        Vector infos = new Vector();
        int m = start.size();
        for (int i = 0; i < m; ++i) {
            if (types.length != 0 && !((DefinitionInfo)start.elementAt(i)).isOfType(types)) continue;
            infos.addElement(start.elementAt(i));
        }
        m = infos.size();
        DefinitionInfo[] result = new DefinitionInfo[m];
        for (int i = 0; i < m; ++i) {
            result[i] = (DefinitionInfo)infos.elementAt(i);
        }
        return result;
    }

    public static DefinitionInfo[] getDefinitionInfos() {
        Vector infos = Explorer.getDefinitionInfoVectorProject(null);
        int m = infos.size();
        DefinitionInfo[] result = new DefinitionInfo[m];
        for (int i = 0; i < m; ++i) {
            result[i] = (DefinitionInfo)infos.elementAt(i);
        }
        return result;
    }

    public static DefinitionInfo[] getDefinitionInfos(File file, String[] types) {
        Vector start = Explorer.getDefinitionInfoVectorProject(Explorer.findProjectContainingFile(file));
        Vector infos = new Vector();
        int m = start.size();
        for (int i = 0; i < m; ++i) {
            if (types.length != 0 && !((DefinitionInfo)start.elementAt(i)).isOfType(types)) continue;
            infos.addElement(start.elementAt(i));
        }
        m = infos.size();
        DefinitionInfo[] result = new DefinitionInfo[m];
        for (int i = 0; i < m; ++i) {
            result[i] = (DefinitionInfo)infos.elementAt(i);
        }
        return result;
    }

    public static DefinitionInfo[] getDefintionInfos(File file) {
        Vector infos = Explorer.getDefinitionInfoVectorProject(Explorer.findProjectContainingFile(file));
        int m = infos.size();
        DefinitionInfo[] result = new DefinitionInfo[m];
        for (int i = 0; i < m; ++i) {
            result[i] = (DefinitionInfo)infos.elementAt(i);
        }
        return result;
    }

    private static Vector getDefinitionInfoVectorProject(ProjectNode project) {
        Enumeration<TreeNode> enumeration = project == null ? root.depthFirstEnumeration() : project.depthFirstEnumeration();
        Vector<DefinitionInfo> nodes = new Vector<DefinitionInfo>();
        while (enumeration.hasMoreElements()) {
            TreeNode object = enumeration.nextElement();
            if (!(object instanceof DefinitionNode)) continue;
            DefinitionNode node = (DefinitionNode)object;
            nodes.addElement(new DefinitionInfo(node.getType(), node.getText()));
        }
        return nodes;
    }

    private static ProjectNode findProjectContainingFile(File file) {
        int m = root.getChildCount();
        for (int i = 0; i < m; ++i) {
            Enumeration<TreeNode> enumeration = ((ProjectNode)root.getChildAt(i)).breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                TreeNode object = enumeration.nextElement();
                if (!(object instanceof FileNode) || !Util.FileEqual(file, ((FileNode)object).getFile())) continue;
                return (ProjectNode)root.getChildAt(i);
            }
        }
        return null;
    }

    public static void addProject() {
        JFileChooser chooser = new JFileChooser(Interactions.currentDirectory);
        chooser.setFileSelectionMode(1);
        chooser.setDialogType(0);
        chooser.setDialogTitle("Choose the project directory");
        if (chooser.showOpenDialog(null) == 0) {
            Explorer.addProject(chooser.getSelectedFile());
        }
    }

    public static synchronized void addProject(File directory) {
        FileFilter filter = FileExtensions.getFilter();
        if (!directory.isDirectory()) {
            return;
        }
        ProjectNode project = new ProjectNode(directory.getName(), directory);
        if (SwingUtilities.isEventDispatchThread()) {
            treemodel.insertNodeInto(project, root, treemodel.getChildCount(root));
        } else {
            Explorer.insertNode(project, root, treemodel.getChildCount(root));
        }
        Object[] children = directory.listFiles(filter);
        Arrays.sort(children);
        Thread thread = new Thread((File[])children, project, filter){
            private final /* synthetic */ File[] val$children;
            private final /* synthetic */ ProjectNode val$project;
            private final /* synthetic */ FileFilter val$filter;
            {
                this.val$children = val$children;
                this.val$project = val$project;
                this.val$filter = val$filter;
            }

            public void run() {
                for (int i = 0; i < this.val$children.length && !this.isInterrupted(); ++i) {
                    if (this.val$children[i].isFile()) {
                        Explorer.addFileNode(i, this.val$children[i], this.val$project);
                        continue;
                    }
                    if (!this.val$children[i].isDirectory()) continue;
                    Explorer.addDirectoryNode(i, this.val$children[i], this.val$project, this.val$filter);
                }
                try {
                    Runnable expand = new Runnable(this){
                        private final /* synthetic */ 2 this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public void run() {
                            Explorer.access$300().expandRow(0);
                        }
                    };
                    SwingUtilities.invokeAndWait(expand);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        thread.setPriority(1);
        project.setFillThread(thread);
        thread.start();
    }

    private static synchronized void populateFileNode(CodeDocument document, final FileNode node) {
        final TreeSet definitions = new TreeSet();
        Parser parser = document.getParser();
        parser.buildDefinitionsList(definitions);
        Runnable updateTree = new Runnable(){

            public void run() {
                node.updateDefinitionTypes(definitions, treemodel);
            }
        };
        SwingUtilities.invokeLater(updateTree);
    }

    public static void refreshFileNodeContent(final File file, final CodeDocument document) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                FileNode node = (FileNode)fileToFileNode.get(Util.getCanonicalFileName(file));
                if (node != null) {
                    Explorer.populateFileNode(document, node);
                }
            }
        });
        thread.start();
    }

    public static void linkNodeToDocument(CodeDocument document) {
        File file = document.getFile();
        if (file != null) {
            Explorer.addFileToDocument(Util.getCanonicalFileName(file), document);
        }
    }

    public static void unlinkNodeFromDocument(CodeDocument document) {
        File file = document.getFile();
        if (file != null) {
            Explorer.removeFileToDocument(Util.getCanonicalFileName(file));
        }
    }

    public static void relinkNodeToDocument(CodeDocument document, File oldfile, File newfile) {
        if (oldfile != null) {
            Explorer.removeFileToDocument(Util.getCanonicalFileName(oldfile));
        }
        if (newfile != null) {
            Explorer.addFileToDocument(Util.getCanonicalFileName(newfile), document);
        }
    }

    private static void insertNode(final DefaultMutableTreeNode child, final DefaultMutableTreeNode parent, final int index) {
        Runnable insert = new Runnable(){

            public void run() {
                treemodel.insertNodeInto(child, parent, index);
            }
        };
        try {
            SwingUtilities.invokeAndWait(insert);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private static void removeChilds(final MutableTreeNode node) {
        Runnable insert = new Runnable(){

            public void run() {
                while (node.getChildCount() > 0) {
                    treemodel.removeNodeFromParent((MutableTreeNode)treemodel.getChild(node, 0));
                }
            }
        };
        try {
            SwingUtilities.invokeAndWait(insert);
        }
        catch (InterruptedException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    private static synchronized void addFileNode(int i, File file, DefaultMutableTreeNode parent) {
        Parser parser = FileExtensions.createParser(file, false);
        if (parser == null) {
            return;
        }
        FileNode child = new FileNode(file.getName(), file, new TreeSet());
        MessageHandler.say("Analyzing " + file.getName());
        Explorer.insertNode(child, parent, i);
        Explorer.addFileToFileNode(Util.getCanonicalFileName(file), child);
        new CodeDocument(parser, file);
    }

    public static synchronized void refreshFileNode(File file) {
        if (fileToFileNode.get(Util.getCanonicalFileName(file)) != null && fileToDocument.get(Util.getCanonicalFileName(file)) == null) {
            MessageHandler.say("Analyzing " + file.getName());
            Parser parser = FileExtensions.createParser(file, false);
            new CodeDocument(parser, file);
        }
    }

    private static int findIndex(DefaultMutableTreeNode parent, File file) {
        int i;
        int m = parent.getChildCount();
        for (i = 0; i < m && file.getName().compareTo(((ExplorerNode)parent.getChildAt(i)).getText()) > 0; ++i) {
        }
        return i;
    }

    private static void addFileToDirectoryNode(DefaultMutableTreeNode parent, File file) {
        Parser parser = FileExtensions.createParser(file, false);
        if (parser == null) {
            return;
        }
        FileNode child = new FileNode(file.getName(), file, new TreeSet());
        treemodel.insertNodeInto(child, parent, Explorer.findIndex(parent, file));
        Explorer.addFileToFileNode(Util.getCanonicalFileName(file), child);
        CodeDocument document = new CodeDocument(parser, file);
    }

    private static synchronized void addDirectoryNode(int i, File directory, DefaultMutableTreeNode parent, FileFilter filter) {
        DirectoryNode child = new DirectoryNode(directory.getName(), directory);
        Explorer.insertNode(child, parent, i);
        Object[] children = directory.listFiles(filter);
        Arrays.sort(children);
        for (int j = 0; j < children.length; ++j) {
            if (((File)children[j]).isFile()) {
                Explorer.addFileNode(j, (File)children[j], child);
                continue;
            }
            if (!((File)children[j]).isDirectory()) continue;
            Explorer.addDirectoryNode(j, (File)children[j], child, filter);
        }
    }

    private static void addDirectoryNodeToDirectoryNode(DefaultMutableTreeNode parent, File directory) {
        treemodel.insertNodeInto(new DirectoryNode(directory.getName(), directory), parent, Explorer.findIndex(parent, directory));
    }

    private void checkpopup(MouseEvent ev) {
        if (ev.isPopupTrigger()) {
            tree.clearSelection();
            tree.addSelectionPath(tree.getClosestPathForLocation(ev.getX(), ev.getY()));
            final Object node = tree.getLastSelectedPathComponent();
            if (node != null) {
                if (node instanceof FileNode) {
                    JPopupMenu popup = new JPopupMenu();
                    popup.add(new JMenuItem(new AbstractAction("Open"){

                        public void actionPerformed(ActionEvent ev) {
                            Explorer.this.openFileNode((FileNode)node);
                        }
                    }));
                    popup.add(new JMenuItem(new AbstractAction("Delete"){

                        public void actionPerformed(ActionEvent ev) {
                            Explorer.this.deleteFile((FileNode)node);
                        }
                    }));
                    popup.add(new JMenuItem(new AbstractAction("Copy"){

                        public void actionPerformed(ActionEvent ev) {
                            copynode = (ExplorerNode)node;
                        }
                    }));
                    popup.add(new JMenuItem(new AbstractAction("Rename"){

                        public void actionPerformed(ActionEvent ev) {
                            Explorer.renameNode((ExplorerNode)node);
                        }
                    }));
                    popup.show(tree, ev.getX(), ev.getY());
                } else if (node instanceof DirectoryNode) {
                    JPopupMenu popup = new JPopupMenu();
                    popup.add(new JMenuItem(new AbstractAction("New Folder"){

                        public void actionPerformed(ActionEvent ev) {
                            Explorer.this.createDirectory((DirectoryNode)node);
                        }
                    }));
                    FileExtensions.addCreateFilePopups(popup, (DirectoryNode)node);
                    popup.add(new JMenuItem(new AbstractAction("Rename"){

                        public void actionPerformed(ActionEvent ev) {
                            Explorer.renameNode((ExplorerNode)node);
                        }
                    }));
                    popup.add(new JMenuItem(new AbstractAction("Delete Folder"){

                        public void actionPerformed(ActionEvent ev) {
                            Explorer.this.deleteDirectory((DirectoryNode)node);
                        }
                    }));
                    popup.add(new JMenuItem(new AbstractAction("Copy"){

                        public void actionPerformed(ActionEvent ev) {
                            copynode = (ExplorerNode)node;
                        }
                    }));
                    if (copynode != null) {
                        popup.add(new JMenuItem(new AbstractAction("Paste"){

                            public void actionPerformed(ActionEvent ev) {
                                Explorer.this.paste((DirectoryNode)node);
                            }
                        }));
                    }
                    popup.show(tree, ev.getX(), ev.getY());
                } else if (node instanceof ProjectNode) {
                    JPopupMenu popup = new JPopupMenu();
                    popup.add(new JMenuItem(Mode.getAction("findandreplace")));
                    popup.add(new JMenuItem(new AbstractAction("Remove Project"){

                        public void actionPerformed(ActionEvent ev) {
                            Explorer.this.removeProject((ProjectNode)node);
                        }
                    }));
                    popup.add(new JMenuItem(new AbstractAction("New Folder"){

                        public void actionPerformed(ActionEvent ev) {
                            Explorer.this.createDirectory((ProjectNode)node);
                        }
                    }));
                    FileExtensions.addCreateFilePopups(popup, (ProjectNode)node);
                    popup.show(tree, ev.getX(), ev.getY());
                } else if (!(node instanceof DefinitionTypeNode)) {
                    if (node instanceof DefinitionNode) {
                        JPopupMenu popup = new JPopupMenu();
                        popup.add(new JMenuItem(new AbstractAction("Open"){

                            public void actionPerformed(ActionEvent ev) {
                                Explorer.this.openDefinitionNode((DefinitionNode)node);
                            }
                        }));
                        popup.add(new JMenuItem(new AbstractAction("Rename"){

                            public void actionPerformed(ActionEvent ev) {
                                Explorer.renameDefinitionNode((DefinitionNode)node);
                            }
                        }));
                        popup.show(tree, ev.getX(), ev.getY());
                    } else {
                        JPopupMenu popup = new JPopupMenu();
                        popup.add(new JMenuItem(Mode.getAction("findandreplace")));
                        popup.add(new JMenuItem(Mode.getAction("addproject")));
                        popup.show(tree, ev.getX(), ev.getY());
                    }
                }
            }
        } else if (ev.getClickCount() == 1) {
            tree.clearSelection();
            tree.addSelectionPath(tree.getClosestPathForLocation(ev.getX(), ev.getY()));
            Object node = tree.getLastSelectedPathComponent();
            if (node instanceof ProjectNode && Configuration.clickProjectSetCurrentDirectory) {
                Interactions.setCurrentDirectory(((ProjectNode)node).getDirectory());
            }
        } else if (ev.getClickCount() == 2) {
            tree.clearSelection();
            tree.addSelectionPath(tree.getClosestPathForLocation(ev.getX(), ev.getY()));
            Object node = tree.getLastSelectedPathComponent();
            if (node instanceof FileNode) {
                this.openFileNode((FileNode)node);
            } else if (node instanceof DefinitionNode) {
                this.openDefinitionNode((DefinitionNode)node);
            }
        }
    }

    private static void renameDefinitionNode(final DefinitionNode node) {
        final JDialog dialog = new JDialog();
        final String oldtext = node.getText();
        JPanel panel = new JPanel();
        JPanel options = new JPanel();
        JPanel buttons = new JPanel();
        Box box = Box.createVerticalBox();
        final JTextField field = new JTextField();
        final JRadioButton replaceOpen = new JRadioButton("Rename uses of definition in open documents");
        final JRadioButton replaceAll = new JRadioButton("Rename uses of definition in all files of project");
        JRadioButton replaceNone = new JRadioButton("Do not rename uses of definition");
        ButtonGroup buttongroup = new ButtonGroup();
        JButton ok = new JButton(new AbstractAction("Ok"){

            public void actionPerformed(ActionEvent ev) {
                if (field.getText().length() > 0) {
                    CodeDocument document = (CodeDocument)fileToDocument.get(Util.getCanonicalFileName(node.getFile()));
                    if (document == null) {
                        Parser parser = FileExtensions.createParser(node.getFile(), false);
                        if (parser == null) {
                            dialog.setVisible(false);
                            dialog.dispose();
                            return;
                        }
                        document = new CodeDocument(parser, node.getFile());
                    }
                    CodeElement element = document.getElementAt(node.getLocation());
                    if (node.getText().compareTo(element.getString(document)) == 0) {
                        document.replace(element.begin(), element.end() - element.begin(), field.getText());
                        if (document.getCodeEditor() != null) {
                            document.getCodeEditor().repaintVisible();
                        } else {
                            document.saveFile(node.getFile());
                        }
                        node.setUserObject(field.getText());
                        Explorer.repositionNode(node);
                    } else {
                        dialog.setVisible(false);
                        dialog.dispose();
                        return;
                    }
                }
                if (replaceOpen.isSelected() || replaceAll.isSelected()) {
                    Explorer.replaceUsesOfDefinitions(replaceAll.isSelected(), Explorer.findProjectContaining(node), oldtext, field.getText());
                }
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        JButton cancel = new JButton(new AbstractAction("Cancel"){

            public void actionPerformed(ActionEvent ev) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        buttongroup.add(replaceOpen);
        buttongroup.add(replaceAll);
        buttongroup.add(replaceNone);
        BoxLayout boxlayout = new BoxLayout(options, 1);
        options.setLayout(boxlayout);
        options.add(replaceOpen);
        options.add(replaceAll);
        options.add(replaceNone);
        replaceNone.setSelected(true);
        buttons.add(ok);
        buttons.add(cancel);
        field.setText(node.getText());
        field.setMaximumSize(new Dimension(300, 50));
        box.add(field);
        box.add(Box.createVerticalGlue());
        panel.setLayout(new BorderLayout());
        panel.add((Component)box, "Center");
        panel.add((Component)options, "East");
        panel.add((Component)buttons, "South");
        dialog.setTitle("Rename definition");
        dialog.setModal(true);
        dialog.setContentPane(panel);
        dialog.setSize(450, 150);
        dialog.setLocation(100, 200);
        dialog.setVisible(true);
    }

    private static void replaceUsesOfDefinitions(boolean all, ProjectNode project, String olddef, String newdef) {
        if (project == null) {
            return;
        }
        if (all) {
            File[] files = Explorer.getFilesInProject(project);
            for (int i = 0; i < files.length; ++i) {
                CodeDocument document = (CodeDocument)fileToDocument.get(Util.getCanonicalFileName(files[i]));
                if (document == null) {
                    Parser parser = FileExtensions.createParser(files[i], false);
                    if (parser == null) continue;
                    document = new CodeDocument(parser, files[i]);
                }
                Explorer.replaceUsesOfDefinitionInDocument(document, olddef, newdef);
            }
        } else {
            CodeDocument[] documents = WorkArea.getDocuments();
            for (int i = 0; i < documents.length; ++i) {
                Explorer.replaceUsesOfDefinitionInDocument(documents[i], olddef, newdef);
            }
        }
    }

    private static void replaceUsesOfDefinitionInDocument(CodeDocument document, String olddef, String newdef) {
        CodeDocument.UpdateBuffer updatebuffer = document.createUpdateBuffer();
        CodeElementVector elements = document.getElements();
        int m = elements.size();
        for (int j = 0; j < m; ++j) {
            if (!(elements.codeElementAt(j) instanceof CodeStructureElement)) continue;
            ((CodeStructureElement)elements.codeElementAt(j)).replaceUsedDefinition(document, updatebuffer, olddef, newdef);
        }
        updatebuffer.doUpdate();
        if (document.getCodeEditor() == null) {
            if (document.isModified() && document.getFile() != null) {
                document.saveFile(document.getFile());
            }
        } else {
            document.getCodeEditor().repaintVisible();
        }
    }

    private static ProjectNode findProjectContaining(ExplorerNode node) {
        DefaultMutableTreeNode parent;
        for (parent = (DefaultMutableTreeNode)node.getParent(); parent != null && !(parent instanceof ProjectNode); parent = (DefaultMutableTreeNode)parent.getParent()) {
        }
        return (ProjectNode)parent;
    }

    /*
     * WARNING - void declaration
     */
    private static void renameNode(ExplorerNode node) {
        File file;
        if (node instanceof FileNode) {
            file = ((FileNode)node).getFile();
        } else if (node instanceof DirectoryNode) {
            file = ((DirectoryNode)node).getDirectory();
        } else {
            return;
        }
        String newname = (String)JOptionPane.showInputDialog(null, "Rename to ", "Renaming", 3, null, null, node.getText());
        if (newname != null) {
            void var1_1;
            File newfile = new File(var1_1.getParentFile(), newname);
            if (var1_1.renameTo(newfile)) {
                Explorer.changeFileForNode(node, newfile);
                Explorer.repositionNode(node);
                WorkArea.refreshTitles();
            } else {
                MessageHandler.warn("Could not rename node");
            }
        }
    }

    private static void changeFileForNode(ExplorerNode node, File file) {
        if (node instanceof FileNode) {
            FileNode filenode = (FileNode)node;
            File oldfile = filenode.getFile();
            filenode.setFile(file);
            CodeDocument document = (CodeDocument)fileToDocument.get(Util.getCanonicalFileName(oldfile));
            if (document != null) {
                document.setFile(file);
                Explorer.removeFileToDocument(Util.getCanonicalFileName(oldfile));
                Explorer.addFileToDocument(Util.getCanonicalFileName(file), document);
            }
            Explorer.removeFileToFileNode(Util.getCanonicalFileName(oldfile));
            Explorer.addFileToFileNode(Util.getCanonicalFileName(file), filenode);
        } else if (node instanceof DirectoryNode) {
            DirectoryNode directorynode = (DirectoryNode)node;
            File oldfile = directorynode.getDirectory();
            directorynode.setDirectory(file);
            int m = directorynode.getChildCount();
            for (int i = 0; i < m; ++i) {
                ExplorerNode enode = (ExplorerNode)directorynode.getChildAt(i);
                if (enode instanceof FileNode) {
                    Explorer.changeFileForNode(enode, Util.renameFileInDir(((FileNode)enode).getFile(), file));
                    continue;
                }
                if (!(enode instanceof DirectoryNode)) continue;
                Explorer.changeFileForNode(enode, Util.renameFileInDir(((DirectoryNode)enode).getDirectory(), file));
            }
        }
    }

    private static void repositionNode(ExplorerNode node) {
        ExplorerNode parent = (ExplorerNode)node.getParent();
        if (parent != null) {
            int i;
            treemodel.removeNodeFromParent(node);
            int m = parent.getChildCount();
            for (i = 0; i < m && ((ExplorerNode)parent.getChildAt(i)).compareTo(node) <= 0; ++i) {
            }
            treemodel.insertNodeInto(node, parent, i);
        }
    }

    private void createDirectory(DirectoryNode node) {
        String newdir = JOptionPane.showInputDialog("Folder name ?");
        if (newdir != null) {
            File directory = node.getDirectory();
            File newdirectory = new File(directory, newdir);
            if (newdirectory.mkdir()) {
                Explorer.addDirectoryNodeToDirectoryNode(node, newdirectory);
            } else {
                MessageHandler.warn("Creation directory failed");
            }
        }
    }

    private void createDirectory(ProjectNode node) {
        String newdir = JOptionPane.showInputDialog("Folder name ?");
        if (newdir != null) {
            File directory = node.getDirectory();
            File newdirectory = new File(directory, newdir);
            if (newdirectory.mkdir()) {
                Explorer.addDirectoryNodeToDirectoryNode(node, newdirectory);
            } else {
                MessageHandler.warn("Creation directory failed");
            }
        }
    }

    public static void createFile(DirectoryNode node, String extension) {
        String newfile = JOptionPane.showInputDialog("File name  (without extension) ?");
        if (newfile != null) {
            newfile = newfile + "." + extension;
            File directory = node.getDirectory();
            File file = new File(directory, newfile);
            try {
                if (file.createNewFile()) {
                    WorkArea.addPane(CodePane.createCodePane(FileExtensions.createParser(file, true), file));
                    Explorer.addFileToDirectoryNode(node, file);
                } else {
                    MessageHandler.warn("Error creating file");
                }
            }
            catch (IOException e) {
                MessageHandler.warn("Error creating file");
            }
        }
    }

    public static void createFile(ProjectNode node, String extension) {
        String newfile = JOptionPane.showInputDialog("File name (no extension) ?");
        if (newfile != null) {
            newfile = newfile + "." + extension;
            File directory = node.getDirectory();
            File file = new File(directory, newfile);
            try {
                if (file.createNewFile()) {
                    WorkArea.addPane(CodePane.createCodePane(new LispParser(true), file));
                    Explorer.addFileToDirectoryNode(node, file);
                } else {
                    MessageHandler.warn("Failed creating the file");
                }
            }
            catch (IOException e) {
                MessageHandler.warn("Failed creating the file");
            }
        }
    }

    private void deleteFile(FileNode node) {
        File file = node.getFile();
        if (file.delete()) {
            treemodel.removeNodeFromParent(node);
            Explorer.removeFileToDocument(Util.getCanonicalFileName(file));
            Explorer.removeFileToFileNode(Util.getCanonicalFileName(file));
            WorkArea.removeCodePanes(file);
        } else {
            MessageHandler.warn("Error removing file");
        }
    }

    private void deleteDirectory(DirectoryNode node) {
        int i;
        File directory = node.getDirectory();
        ExplorerNode[] children = new ExplorerNode[node.getChildCount()];
        for (i = 0; i < node.getChildCount(); ++i) {
            children[i] = (ExplorerNode)node.getChildAt(i);
        }
        for (i = 0; i < children.length; ++i) {
            if (children[i] instanceof FileNode) {
                this.deleteFile((FileNode)children[i]);
                continue;
            }
            if (!(children[i] instanceof DirectoryNode)) continue;
            this.deleteDirectory((DirectoryNode)children[i]);
        }
        if (directory.delete()) {
            treemodel.removeNodeFromParent(node);
        } else {
            MessageHandler.warn("Failed to delete the directory");
        }
    }

    private void removeProject(ProjectNode project) {
        project.stopProcessing();
        for (int i = 0; i < project.getChildCount(); ++i) {
            TreeNode node = project.getChildAt(i);
            if (node instanceof DirectoryNode) {
                this.removeProjectDirectory((DirectoryNode)node);
            } else if (node instanceof FileNode) {
                this.removeProjectFile((FileNode)node);
            }
            treemodel.removeNodeFromParent((ExplorerNode)node);
        }
        treemodel.removeNodeFromParent(project);
    }

    private void removeProjectDirectory(DirectoryNode directory) {
        for (int i = 0; i < directory.getChildCount(); ++i) {
            TreeNode node = directory.getChildAt(i);
            if (node instanceof DirectoryNode) {
                this.removeProjectDirectory((DirectoryNode)node);
            } else if (node instanceof FileNode) {
                this.removeProjectFile((FileNode)node);
            }
            treemodel.removeNodeFromParent((ExplorerNode)node);
        }
    }

    private void removeProjectFile(FileNode node) {
        Explorer.removeFileToDocument(Util.getCanonicalFileName(node.getFile()));
        Explorer.removeFileToFileNode(Util.getCanonicalFileName(node.getFile()));
    }

    private void copyDirectoryNodeToDirectoryNode(DirectoryNode source, DirectoryNode node) {
        if (node.isNodeAncestor(source) || source == node) {
            MessageHandler.warn("You cannot copy a directory to itself or to a subdirectory of itself");
            return;
        }
        File destination = node.getDirectory();
        String str = source.getDirectory().getName();
        int nr = 0;
        File newdirectory = new File(destination, str);
        while (newdirectory.exists()) {
            newdirectory = new File(newdirectory, str + nr);
            ++nr;
        }
        if (newdirectory.mkdir()) {
            DirectoryNode destinationnode = new DirectoryNode(newdirectory.getName(), newdirectory);
            treemodel.insertNodeInto(destinationnode, node, Explorer.findIndex(node, newdirectory));
            int m = source.getChildCount();
            for (int i = 0; i < m; ++i) {
                MessageHandler.say("Copy " + ((ExplorerNode)source.getChildAt(i)).getText() + " to " + destination.getName());
                if (source.getChildAt(i) instanceof FileNode) {
                    this.copyFileToDirectoryNode(((FileNode)source.getChildAt(i)).getFile(), destinationnode);
                    continue;
                }
                if (!(source.getChildAt(i) instanceof DirectoryNode)) continue;
                this.copyDirectoryNodeToDirectoryNode((DirectoryNode)source.getChildAt(i), destinationnode);
            }
        } else {
            MessageHandler.warn("Failed to create directory during paste directory");
        }
    }

    private void paste(DirectoryNode destination) {
        if (copynode != null) {
            if (copynode instanceof FileNode) {
                this.copyFileToDirectoryNode(((FileNode)copynode).getFile(), destination);
            } else if (copynode instanceof DirectoryNode) {
                this.copyDirectoryNodeToDirectoryNode((DirectoryNode)copynode, destination);
            }
            copynode = null;
        }
    }

    private void copyFileToDirectoryNode(File file, DirectoryNode node) {
        File directory = node.getDirectory();
        String str = file.getName();
        File newfile = new File(directory, str);
        int nr = 0;
        while (newfile.exists()) {
            newfile = new File(directory, str + nr);
            ++nr;
        }
        try {
            if (newfile.createNewFile()) {
                int c;
                BufferedInputStream reader = new BufferedInputStream(new FileInputStream(file));
                BufferedOutputStream writer = new BufferedOutputStream(new FileOutputStream(newfile));
                while ((c = reader.read()) != -1) {
                    writer.write(c);
                }
                writer.close();
                Explorer.addFileToDirectoryNode(node, newfile);
            } else {
                MessageHandler.warn("Failed creating file during paste");
            }
        }
        catch (FileNotFoundException e) {
            MessageHandler.warn("Source file did not exist anymore");
        }
        catch (IOException e) {
            MessageHandler.warn("IOException during paste");
        }
    }

    private void openFileNode(FileNode node) {
        File file = node.getFile();
        Object object = fileToDocument.get(Util.getCanonicalFileName(file));
        if (object == null) {
            Main.setMousePointer(3);
            Parser parser = FileExtensions.createParser(file, true);
            if (parser == null) {
                return;
            }
            CodePane pane = CodePane.createCodePane(parser, file);
            CodeDocument document = pane.getEditor().getDocument();
            WorkArea.addPane(pane);
            Main.setCurrent(pane.getEditor());
            Main.setMousePointer(Cursor.getDefaultCursor());
        } else {
            CodeDocument document = (CodeDocument)object;
            Main.setCurrent(document.getCodeEditor());
        }
    }

    public static void checkDocumentInExplorer(CodeDocument document, File file) {
        String path = Util.getCanonicalFileName(file);
        FileNode filenode = (FileNode)fileToFileNode.get(path);
        if (filenode == null) {
            ExplorerNode node = Explorer.findNodeContaining(file);
            if (node != null) {
                filenode = new FileNode(file.getName(), file, new TreeSet());
                treemodel.insertNodeInto(filenode, node, Explorer.findIndex(node, file));
                Explorer.addFileToDocument(path, document);
                Explorer.addFileToFileNode(path, filenode);
                Explorer.refreshFileNodeContent(file, document);
            }
        } else if (fileToDocument.get(path) == null) {
            Explorer.addFileToDocument(path, document);
        }
    }

    public static ProjectNode[] getProjects() {
        Vector<TreeNode> projects = new Vector<TreeNode>();
        int m = root.getChildCount();
        for (int i = 0; i < m; ++i) {
            if (!(root.getChildAt(i) instanceof ProjectNode)) continue;
            projects.addElement(root.getChildAt(i));
        }
        m = projects.size();
        ProjectNode[] result = new ProjectNode[m];
        for (int i = 0; i < m; ++i) {
            result[i] = (ProjectNode)projects.elementAt(i);
        }
        return result;
    }

    public static File[] getFilesInProject(ProjectNode project) {
        if (project == null) {
            return new File[0];
        }
        Vector<File> files = new Vector<File>();
        int m = project.getChildCount();
        for (int i = 0; i < m; ++i) {
            TreeNode node = project.getChildAt(i);
            if (node instanceof DirectoryNode) {
                Explorer.getFilesInProjectDirectory((DirectoryNode)node, files);
                continue;
            }
            if (!(node instanceof FileNode)) continue;
            files.addElement(((FileNode)node).getFile());
        }
        m = files.size();
        File[] result = new File[m];
        for (int i = 0; i < m; ++i) {
            result[i] = (File)files.elementAt(i);
        }
        return result;
    }

    private static void getFilesInProjectDirectory(DirectoryNode node, Vector files) {
        int m = node.getChildCount();
        for (int i = 0; i < m; ++i) {
            TreeNode child = node.getChildAt(i);
            if (!(child instanceof FileNode)) continue;
            files.addElement(((FileNode)child).getFile());
        }
    }

    private static ExplorerNode findNodeContaining(File file) {
        int m = root.getChildCount();
        for (int i = 0; i < m; ++i) {
            ExplorerNode node = Explorer.findNodeContaining((ProjectNode)root.getChildAt(i), file);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    private static ExplorerNode findNodeContaining(ProjectNode project, File file) {
        int m = project.getChildCount();
        for (int i = 0; i < m; ++i) {
            TreeNode child = project.getChildAt(i);
            if (child instanceof DirectoryNode) {
                ExplorerNode node = Explorer.findNodeContaining((DirectoryNode)child, file);
                if (node == null) continue;
                return node;
            }
            if (!(child instanceof FileNode) || Util.getCanonicalFileName(((FileNode)child).getFile()).compareTo(Util.getCanonicalFileName(file)) != 0) continue;
            return (ExplorerNode)child;
        }
        if (Explorer.directoryContains(project.getDirectory(), file)) {
            return project;
        }
        return null;
    }

    private static ExplorerNode findNodeContaining(DirectoryNode directory, File file) {
        int m = directory.getChildCount();
        for (int i = 0; i < m; ++i) {
            ExplorerNode node;
            TreeNode child = directory.getChildAt(i);
            if (!(child instanceof DirectoryNode) || (node = Explorer.findNodeContaining((DirectoryNode)child, file)) == null) continue;
            return node;
        }
        if (Explorer.directoryContains(directory.getDirectory(), file)) {
            return directory;
        }
        return null;
    }

    private static boolean directoryContains(File directory, File file) {
        return Util.getCanonicalFileName(file).startsWith(Util.getCanonicalFileName(directory));
    }

    private void openDefinitionNode(DefinitionNode node) {
        FileNode filenode = node.getFileNode();
        File file = filenode.getFile();
        Object object = fileToDocument.get(Util.getCanonicalFileName(file));
        if (object == null) {
            this.openFileNode(filenode);
        } else {
            CodeDocument document = (CodeDocument)object;
            Main.setCurrent(document.getCodeEditor());
            document.getCodeEditor().cursor.setCursor(node.getLocation());
        }
    }

    public void mouseExited(MouseEvent ev) {
    }

    public void mouseReleased(MouseEvent ev) {
        this.checkpopup(ev);
    }

    public void mousePressed(MouseEvent ev) {
        this.checkpopup(ev);
    }

    public void mouseClicked(MouseEvent ev) {
        this.checkpopup(ev);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void saveState(Writer writer) {
        XMLConfigClass cls = new XMLConfigClass(this.getClass().getName());
        int m = root.getChildCount();
        for (int i = 0; i < m; ++i) {
            if (!(root.getChildAt(i) instanceof ProjectNode)) continue;
            ProjectNode project = (ProjectNode)root.getChildAt(i);
            File directory = project.getDirectory();
            XMLConfigObject fileobject = new XMLConfigObject(directory.getClass().getName());
            fileobject.addArgument(OsSystem.correctPathName(Util.getCanonicalFileName(directory)));
            XMLConfigMethod method = new XMLConfigMethod("addProject");
            method.addArgument(fileobject);
            cls.addMethod(method);
        }
        cls.serialize(writer);
    }

    static /* synthetic */ JTree access$300() {
        return tree;
    }

    static {
        fileToDocument = new TreeMap();
        fileToFileNode = new TreeMap();
    }

    private class ExplorerTreeModel
    extends DefaultTreeModel {
        private ExplorerTreeModel(DefaultMutableTreeNode root) {
            super(root);
            this.asksAllowsChildren = false;
        }
    }
}

