/*
 * Decompiled with CFR 0.152.
 */
package IDE.Configuration;

import IDE.Configuration.AbstractXMLConfig;
import IDE.Configuration.XMLConfigClass;
import IDE.Configuration.XMLConfigField;
import IDE.Configuration.XMLConfigMethod;
import IDE.Configuration.XMLConfigObject;
import IDE.Messaging.MessageHandler;
import java.io.IOException;
import java.io.Reader;

public class XMLConfigReader {
    private int peekvalue;
    private Reader reader;

    public XMLConfigReader(Reader reader) {
        this.reader = reader;
        this.peekvalue = -2;
    }

    public XMLConfigClass readXMLConfigClass() {
        Object object = this.readXMLConfigObject();
        if (object instanceof XMLConfigClass) {
            return (XMLConfigClass)object;
        }
        return null;
    }

    private Object readXMLConfigObject() {
        Tag tag = this.readTag();
        if (tag == null) {
            return null;
        }
        if (tag.endtag) {
            return tag;
        }
        if ("class".compareTo(tag.type) == 0) {
            return this.readClass(tag);
        }
        if ("method".compareTo(tag.type) == 0) {
            return this.readMethod(tag);
        }
        if ("field".compareTo(tag.type) == 0) {
            return this.readField(tag);
        }
        if ("object".compareTo(tag.type) == 0) {
            return this.readObject(tag);
        }
        if ("argument".compareTo(tag.type) == 0) {
            return this.readArgument(tag);
        }
        return null;
    }

    public AbstractXMLConfig readClass(Tag tag) {
        XMLConfigClass cls = new XMLConfigClass(tag.name);
        Object object = this.readXMLConfigObject();
        while (object instanceof XMLConfigMethod || object instanceof XMLConfigField) {
            if (object instanceof XMLConfigMethod) {
                cls.addMethod((XMLConfigMethod)object);
            } else if (object instanceof XMLConfigField) {
                cls.addField((XMLConfigField)object);
            }
            object = this.readXMLConfigObject();
        }
        if (object == null) {
            return null;
        }
        if (object instanceof Tag && ((Tag)object).endtag && ((Tag)object).type.compareTo("class") == 0) {
            return cls;
        }
        return null;
    }

    public AbstractXMLConfig readMethod(Tag tag) {
        XMLConfigMethod method = new XMLConfigMethod(tag.name);
        Object object = this.readXMLConfigObject();
        while (object instanceof XMLConfigObject || object instanceof Integer || object instanceof Long || object instanceof Double || object instanceof Boolean || object instanceof String || object instanceof Character) {
            if (object instanceof XMLConfigObject) {
                method.addArgument((XMLConfigObject)object);
            } else if (object instanceof Integer) {
                method.addArgument((Integer)object);
            } else if (object instanceof Long) {
                method.addArgument((Long)object);
            } else if (object instanceof Double) {
                method.addArgument((Double)object);
            } else if (object instanceof Boolean) {
                method.addArgument((Boolean)object);
            } else if (object instanceof Character) {
                method.addArgument(((Character)object).charValue());
            } else if (object instanceof String) {
                method.addArgument((String)object);
            }
            object = this.readXMLConfigObject();
        }
        if (object == null) {
            return null;
        }
        if (object instanceof Tag && ((Tag)object).endtag && ((Tag)object).type.compareTo("method") == 0) {
            return method;
        }
        return null;
    }

    public AbstractXMLConfig readField(Tag tag) {
        XMLConfigField field;
        block15: {
            field = new XMLConfigField(tag.name);
            Object value = this.readElementContent();
            if (value instanceof String) {
                try {
                    int ivalue = Integer.parseInt((String)value);
                    field.setValue(ivalue);
                }
                catch (NumberFormatException e1) {
                    try {
                        long lvalue = Long.parseLong((String)value);
                        field.setValue(lvalue);
                    }
                    catch (NumberFormatException e2) {
                        try {
                            double dvalue = Double.parseDouble((String)value);
                            field.setValue(dvalue);
                        }
                        catch (NumberFormatException e3) {
                            if ("true".compareTo(value) == 0) {
                                field.setValue(true);
                                break block15;
                            }
                            if ("false".compareTo(value) == 0) {
                                field.setValue(false);
                                break block15;
                            }
                            field.setValue(this.stripString((String)value));
                        }
                    }
                }
            } else if (value instanceof Character) {
                field.setValue(((Character)value).charValue());
            } else if (value instanceof XMLConfigObject) {
                field.setValue((XMLConfigObject)value);
            } else {
                return null;
            }
        }
        Object endtag = this.readXMLConfigObject();
        if (endtag instanceof Tag && ((Tag)endtag).endtag && ((Tag)endtag).type.compareTo("field") == 0) {
            return field;
        }
        return null;
    }

    public AbstractXMLConfig readObject(Tag tag) {
        XMLConfigObject object = new XMLConfigObject(tag.name);
        Object argument = this.readXMLConfigObject();
        while (argument instanceof XMLConfigObject || argument instanceof Integer || argument instanceof Long || argument instanceof Double || argument instanceof Boolean || argument instanceof String || argument instanceof Character) {
            if (argument instanceof XMLConfigObject) {
                object.addArgument((XMLConfigObject)argument);
            } else if (argument instanceof Integer) {
                object.addArgument((Integer)argument);
            } else if (argument instanceof Long) {
                object.addArgument((Long)argument);
            } else if (argument instanceof Double) {
                object.addArgument((Double)argument);
            } else if (argument instanceof Boolean) {
                object.addArgument((Boolean)argument);
            } else if (argument instanceof Character) {
                object.addArgument(((Character)argument).charValue());
            } else if (argument instanceof String) {
                object.addArgument((String)argument);
            }
            argument = this.readXMLConfigObject();
        }
        if (argument == null) {
            return null;
        }
        if (argument instanceof Tag && ((Tag)argument).endtag && ((Tag)argument).type.compareTo("object") == 0) {
            return object;
        }
        return null;
    }

    public Object readArgument(Tag tag) {
        Object object = this.readElementContent();
        Object endtag = this.readXMLConfigObject();
        if (endtag instanceof Tag && ((Tag)endtag).endtag && ((Tag)endtag).type.compareTo("argument") == 0) {
            if (object instanceof String) {
                try {
                    return new Integer(Integer.parseInt((String)object));
                }
                catch (NumberFormatException e1) {
                    try {
                        return new Long(Long.parseLong((String)object));
                    }
                    catch (NumberFormatException e2) {
                        try {
                            return new Double(Double.parseDouble((String)object));
                        }
                        catch (NumberFormatException e3) {
                            if ("true".compareTo(object) == 0) {
                                return new Boolean(true);
                            }
                            if ("false".compareTo(object) == 0) {
                                return new Boolean(false);
                            }
                            return this.stripString((String)object);
                        }
                    }
                }
            }
            if (object instanceof Character) {
                return object;
            }
            if (object instanceof XMLConfigObject) {
                return object;
            }
            return null;
        }
        return null;
    }

    private String stripString(String string) {
        if (string.length() < 2) {
            return string;
        }
        return string.substring(1, string.length() - 1);
    }

    private Object readElementContent() {
        StringBuffer buffer = new StringBuffer();
        int c = -1;
        while ((c = this.peek()) != -1 && this.isWhiteSpace(c) && c != 60) {
            buffer.append((char)c);
            this.next();
        }
        if (c == 60) {
            return this.readXMLConfigObject();
        }
        if (c == 39) {
            buffer = new StringBuffer();
            this.next();
            while ((c = this.next()) != -1 && c != 39) {
                buffer.append((char)c);
            }
            try {
                return new Character((char)Integer.parseInt(buffer.toString()));
            }
            catch (NumberFormatException e) {
                MessageHandler.report("Error parsing character " + e.getMessage(), e);
                return new Character('\u0000');
            }
        }
        if (c == 34) {
            buffer.append('\"');
            this.next();
            while ((c = this.peek()) != -1 && c != 34) {
                if (c == 92) {
                    this.next();
                    c = this.peek();
                    buffer.append((char)c);
                    this.next();
                    continue;
                }
                buffer.append((char)c);
                this.next();
            }
            buffer.append('\"');
            this.next();
            return buffer.toString();
        }
        while ((c = this.peek()) != -1 && c != 60) {
            buffer.append((char)c);
            this.next();
        }
        return buffer.toString();
    }

    private Tag readTag() {
        int c = this.nextNonWhite();
        if (c == 60) {
            c = this.peekNonWhite();
            if (c == 47) {
                return this.readEndTag();
            }
            return this.readBeginTag();
        }
        return null;
    }

    private Tag readEndTag() {
        StringBuffer type = new StringBuffer();
        this.next();
        int c = this.readWord(type);
        if (c == 62) {
            Tag tag = new Tag();
            tag.type = type.toString();
            tag.endtag = true;
            return tag;
        }
        return null;
    }

    private Tag readBeginTag() {
        StringBuffer type = new StringBuffer();
        StringBuffer name = new StringBuffer();
        StringBuffer value = new StringBuffer();
        int c = this.readWord(type);
        if (this.isWhiteSpace(c)) {
            c = this.nextNonWhite();
            if (c == 58) {
                c = this.readWord(name);
                if ("name".compareTo(name.toString()) == 0) {
                    if (this.isWhiteSpace(c)) {
                        c = this.nextNonWhite();
                    }
                    if (c == 61) {
                        c = this.readString(value);
                        if (this.isWhiteSpace(c)) {
                            c = this.nextNonWhite();
                        }
                        if (c == 62) {
                            Tag tag = new Tag();
                            tag.type = type.toString();
                            tag.name = value.toString();
                            tag.endtag = false;
                            return tag;
                        }
                        return null;
                    }
                    return null;
                }
                return null;
            }
            return null;
        }
        if (c == 62) {
            Tag tag = new Tag();
            tag.type = type.toString();
            tag.name = "";
            tag.endtag = false;
            return tag;
        }
        return null;
    }

    private int readString(StringBuffer string) {
        int c = this.nextNonWhite();
        if (c == 34) {
            while ((c = this.next()) != -1 && c != 34) {
                if (c == 92) {
                    c = this.next();
                    if (c == -1) continue;
                    string.append((char)c);
                    continue;
                }
                string.append((char)c);
            }
            if (c == 34) {
                return this.next();
            }
            return c;
        }
        return -1;
    }

    private int nextNonWhite() {
        try {
            if (this.peekvalue == -2) {
                int c;
                while ((c = this.reader.read()) != -1 && this.isWhiteSpace(c)) {
                }
                return c;
            }
            int c = this.peekvalue;
            this.peekvalue = -2;
            return c;
        }
        catch (IOException e) {
            return -1;
        }
    }

    private int readWord(StringBuffer word) {
        int c = this.nextNonWhite();
        while (c != -1 && !this.isWhiteSpace(c) && c != 60 && c != 62 && c != 58 && c != 34 && c != 61) {
            word.append((char)c);
            c = this.next();
        }
        return c;
    }

    private int peekNonWhite() {
        try {
            if (this.peekvalue == -2) {
                int c;
                while ((c = this.reader.read()) != -1 && this.isWhiteSpace(c)) {
                }
                this.peekvalue = c;
                return c;
            }
            return this.peekvalue;
        }
        catch (IOException e) {
            return -1;
        }
    }

    private int next() {
        try {
            if (this.peekvalue == -2) {
                return this.reader.read();
            }
            int c = this.peekvalue;
            this.peekvalue = -2;
            return c;
        }
        catch (IOException e) {
            return -1;
        }
    }

    private int peek() {
        try {
            if (this.peekvalue == -2) {
                this.peekvalue = this.reader.read();
                return this.peekvalue;
            }
            return this.peekvalue;
        }
        catch (IOException e) {
            return -1;
        }
    }

    private boolean isWhiteSpace(int c) {
        return c == 32 || c == 10 || c == 9 || c == 13;
    }

    private class Tag {
        private String type;
        private String name;
        private boolean endtag = false;

        private Tag() {
        }
    }
}

