/*
 * Decompiled with CFR 0.152.
 */
package IDE.Configuration;

import IDE.Configuration.AbstractXMLConfig;
import IDE.Messaging.MessageHandler;
import IDE.Utilities.Util;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.Vector;

public class XMLConfigObject
extends AbstractXMLConfig {
    private String name;
    private Vector arguments = new Vector();

    public XMLConfigObject(String name) {
        this.name = name;
    }

    public void addArgument(int arg) {
        this.arguments.addElement(new Integer(arg));
    }

    public void addArgument(long arg) {
        this.arguments.addElement(new Long(arg));
    }

    public void addArgument(double arg) {
        this.arguments.addElement(new Double(arg));
    }

    public void addArgument(boolean arg) {
        this.arguments.addElement(new Boolean(arg));
    }

    public void addArgument(String arg) {
        this.arguments.addElement(arg);
    }

    public void addArgument(XMLConfigObject arg) {
        this.arguments.addElement(arg);
    }

    public void serialize(Writer writer) {
        try {
            writer.write("<object :name=\"" + Util.normalize(this.name) + "\">");
            int m = this.arguments.size();
            for (int i = 0; i < m; ++i) {
                writer.write("\n");
                writer.write("<argument>");
                if (this.arguments.elementAt(i) instanceof Integer) {
                    writer.write(((Integer)this.arguments.elementAt(i)).toString());
                } else if (this.arguments.elementAt(i) instanceof Long) {
                    writer.write(((Long)this.arguments.elementAt(i)).toString());
                } else if (this.arguments.elementAt(i) instanceof Double) {
                    writer.write(((Double)this.arguments.elementAt(i)).toString());
                } else if (this.arguments.elementAt(i) instanceof Boolean) {
                    writer.write(((Boolean)this.arguments.elementAt(i)).toString());
                } else if (this.arguments.elementAt(i) instanceof String) {
                    writer.write("\"" + Util.normalize((String)this.arguments.elementAt(i)) + "\"");
                } else if (this.arguments.elementAt(i) instanceof Character) {
                    writer.write("'" + ((Character)this.arguments.elementAt(i)).charValue() + "'");
                } else if (this.arguments.elementAt(i) instanceof XMLConfigObject) {
                    ((XMLConfigObject)this.arguments.elementAt(i)).serialize(writer);
                }
                writer.write("</argument>");
            }
            writer.write("</object>");
        }
        catch (IOException e) {
            MessageHandler.report("Error writing XMLConfigObject", e);
        }
    }

    public Object createObject() {
        Object result = null;
        try {
            int m = this.arguments.size();
            Class<?> cls = Class.forName(this.name);
            Object[] args = new Object[m];
            for (int i = 0; i < m; ++i) {
                Object arg = this.arguments.elementAt(i);
                if (arg instanceof Integer) {
                    args[i] = arg;
                    continue;
                }
                if (arg instanceof Long) {
                    args[i] = arg;
                    continue;
                }
                if (arg instanceof Character) {
                    args[i] = arg;
                    continue;
                }
                if (arg instanceof Double) {
                    args[i] = arg;
                    continue;
                }
                if (arg instanceof Boolean) {
                    args[i] = arg;
                    continue;
                }
                if (arg instanceof String) {
                    args[i] = arg;
                    continue;
                }
                if (!(arg instanceof XMLConfigObject)) continue;
                args[i] = ((XMLConfigObject)arg).createObject();
            }
            result = this.callConstructor(cls, args);
        }
        catch (ClassNotFoundException e) {
            errorDuringConfig = true;
            MessageHandler.report("Class not found for object creation during load configuration " + this.name, e);
        }
        return result;
    }

    private Object callConstructor(Class cls, Object[] args) {
        Object result = null;
        Constructor<?>[] constructors = cls.getDeclaredConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            try {
                if (constructors[i].getParameterTypes().length != args.length) continue;
                result = constructors[i].newInstance(args);
                return result;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        errorDuringConfig = true;
        MessageHandler.warn("Failed to create object of class " + cls.getName() + " during load configuration");
        return null;
    }
}

