/*
 * Decompiled with CFR 0.152.
 */
package IDE.Configuration;

import IDE.Configuration.AbstractXMLConfig;
import IDE.Configuration.XMLConfigObject;
import IDE.Messaging.MessageHandler;
import IDE.Utilities.Util;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Vector;

public class XMLConfigMethod
extends AbstractXMLConfig {
    private String name;
    private Vector arguments = new Vector();

    public XMLConfigMethod(String name) {
        this.name = name;
    }

    public void addArgument(int arg) {
        this.arguments.addElement(new Integer(arg));
    }

    public void addArgument(long arg) {
        this.arguments.addElement(new Long(arg));
    }

    public void addArgument(double arg) {
        this.arguments.addElement(new Double(arg));
    }

    public void addArgument(boolean arg) {
        this.arguments.addElement(new Boolean(arg));
    }

    public void addArgument(char arg) {
        this.arguments.addElement(new Character(arg));
    }

    public void addArgument(String arg) {
        this.arguments.addElement(arg);
    }

    public void addArgument(XMLConfigObject arg) {
        this.arguments.addElement(arg);
    }

    public void serialize(Writer writer) {
        try {
            writer.write("<method :name=\"" + Util.normalize(this.name) + "\">");
            int m = this.arguments.size();
            for (int i = 0; i < m; ++i) {
                writer.write("\n");
                writer.write("<argument>");
                if (this.arguments.elementAt(i) instanceof Integer) {
                    writer.write(((Integer)this.arguments.elementAt(i)).toString());
                } else if (this.arguments.elementAt(i) instanceof Long) {
                    writer.write(((Long)this.arguments.elementAt(i)).toString());
                } else if (this.arguments.elementAt(i) instanceof Double) {
                    writer.write(((Double)this.arguments.elementAt(i)).toString());
                } else if (this.arguments.elementAt(i) instanceof Boolean) {
                    writer.write(((Boolean)this.arguments.elementAt(i)).toString());
                } else if (this.arguments.elementAt(i) instanceof String) {
                    writer.write("\"" + Util.normalize((String)this.arguments.elementAt(i)) + "\"");
                } else if (this.arguments.elementAt(i) instanceof Character) {
                    writer.write("'" + ((Character)this.arguments.elementAt(i)).charValue() + "'");
                } else if (this.arguments.elementAt(i) instanceof XMLConfigObject) {
                    ((XMLConfigObject)this.arguments.elementAt(i)).serialize(writer);
                }
                writer.write("</argument>");
            }
            writer.write("</method>");
        }
        catch (IOException e) {
            MessageHandler.report("Error writing XMLConfigMethod", e);
        }
    }

    public void configure(Class cls) {
        int m = this.arguments.size();
        Object[] args = new Object[m];
        for (int i = 0; i < m; ++i) {
            Object arg = this.arguments.elementAt(i);
            if (arg instanceof Integer) {
                args[i] = arg;
                continue;
            }
            if (arg instanceof Long) {
                args[i] = arg;
                continue;
            }
            if (arg instanceof Double) {
                args[i] = arg;
                continue;
            }
            if (arg instanceof Boolean) {
                args[i] = arg;
                continue;
            }
            if (arg instanceof String) {
                args[i] = arg;
                continue;
            }
            if (arg instanceof Character) {
                args[i] = arg;
                continue;
            }
            if (!(arg instanceof XMLConfigObject)) continue;
            args[i] = ((XMLConfigObject)arg).createObject();
        }
        this.callMethod(cls, this.name, args);
    }

    private Object callMethod(Class cls, String name, Object[] args) {
        Object result = null;
        Method[] methods = cls.getDeclaredMethods();
        Exception ex = null;
        for (int i = 0; i < methods.length; ++i) {
            try {
                if (methods[i].getName().compareTo(name) != 0 || methods[i].getParameterTypes().length != args.length) continue;
                result = methods[i].invoke(null, args);
                return result;
            }
            catch (Exception e) {
                ex = e;
            }
        }
        errorDuringConfig = true;
        MessageHandler.report("Fail to call static method=" + name + " of class=" + cls.getName() + " during load configuration", ex);
        return result;
    }
}

