/*
 * Decompiled with CFR 0.152.
 */
package IDE.Configuration;

import IDE.Configuration.AbstractXMLConfig;
import IDE.Configuration.XMLConfigObject;
import IDE.Messaging.MessageHandler;
import IDE.Utilities.Util;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;

public class XMLConfigField
extends AbstractXMLConfig {
    String name;
    Object value = null;

    public XMLConfigField(String name) {
        this.name = name;
    }

    public XMLConfigField(String name, int value) {
        this.name = name;
        this.value = new Integer(value);
    }

    public XMLConfigField(String name, long value) {
        this.name = name;
        this.value = new Long(value);
    }

    public XMLConfigField(String name, char value) {
        this.name = name;
        this.value = new Character(value);
    }

    public XMLConfigField(String name, double value) {
        this.name = name;
        this.value = new Double(value);
    }

    public XMLConfigField(String name, boolean value) {
        this.name = name;
        this.value = new Boolean(value);
    }

    public XMLConfigField(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public XMLConfigField(String name, XMLConfigObject value) {
        this.name = name;
        this.value = value;
    }

    public void setValue(int value) {
        this.value = new Integer(value);
    }

    public void setValue(long value) {
        this.value = new Long(value);
    }

    public void setValue(char value) {
        this.value = new Character(value);
    }

    public void setValue(double value) {
        this.value = new Double(value);
    }

    public void setValue(boolean value) {
        this.value = new Boolean(value);
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setValue(XMLConfigObject value) {
        this.value = value;
    }

    public void serialize(Writer writer) {
        try {
            writer.write("<field :name=\"" + Util.normalize(this.name) + "\">");
            if (this.value instanceof Integer) {
                writer.write(((Integer)this.value).toString());
            } else if (this.value instanceof Long) {
                writer.write(((Long)this.value).toString());
            } else if (this.value instanceof Double) {
                writer.write(((Double)this.value).toString());
            } else if (this.value instanceof Boolean) {
                writer.write(((Boolean)this.value).toString());
            } else if (this.value instanceof String) {
                writer.write("\"" + Util.normalize((String)this.value) + "\"");
            } else if (this.value instanceof Character) {
                writer.write("'" + ((Character)this.value).charValue() + "'");
            } else if (this.value instanceof XMLConfigObject) {
                writer.write("\n");
                ((XMLConfigObject)this.value).serialize(writer);
                writer.write("\n");
            }
            writer.write("</field>");
        }
        catch (IOException e) {
            MessageHandler.report("Error writing XMLConfigField", e);
        }
    }

    public void configure(Class cls) {
        try {
            Field field = cls.getField(this.name);
            if (this.value instanceof Integer) {
                field.setInt(null, (Integer)this.value);
            } else if (this.value instanceof Long) {
                field.setLong(null, (Long)this.value);
            } else if (this.value instanceof Double) {
                field.setDouble(null, (Double)this.value);
            } else if (this.value instanceof String) {
                field.set(null, (String)this.value);
            } else if (this.value instanceof Character) {
                field.setChar(null, ((Character)this.value).charValue());
            } else if (this.value instanceof Boolean) {
                field.setBoolean(null, (Boolean)this.value);
            } else if (this.value instanceof XMLConfigObject) {
                field.set(null, ((XMLConfigObject)this.value).createObject());
            }
        }
        catch (NoSuchFieldException e) {
            errorDuringConfig = true;
            MessageHandler.report("Undefined field value during load configuration ", e);
        }
        catch (SecurityException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }
}

